/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.ApplicativeError;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compression.Compression$;
import fs2.compression.DeflateParams$;
import java.io.Serializable;
import org.http4s.ContentCoding;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.GZip$EmptyBodyException$;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.NotGiven$;

public final class GZip$
implements Serializable {
    private static final NonEmptyList<ContentCoding> supportedCompressions;
    private static final GZip$EmptyBodyException$ EmptyBodyException;
    public static final GZip$ MODULE$;

    private GZip$() {
    }

    static {
        MODULE$ = new GZip$();
        supportedCompressions = NonEmptyList$.MODULE$.of((Object)ContentCoding$.MODULE$.gzip(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ContentCoding[]{ContentCoding$.MODULE$.deflate()}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GZip$.class);
    }

    public <F> Client<F> apply(int bufferSize, Client<F> client, Async<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> {
            Request reqWithEncoding = this.addHeaders((Request)req);
            Resource responseResource = client.run(reqWithEncoding);
            return responseResource.map((Function1 & Serializable)actualResponse -> this.decompress(bufferSize, (Response)actualResponse, F));
        }, F);
    }

    public int apply$default$1() {
        return 32768;
    }

    private <F> Request<F> addHeaders(Request<F> req) {
        Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Accept$minusEncoding$.MODULE$.headerSemigroupInstance(), Accept$minusEncoding$.MODULE$.headerInstance()));
        return option instanceof Some ? req : (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Accept$minusEncoding$.MODULE$.apply(supportedCompressions), Accept$minusEncoding$.MODULE$.headerInstance())}));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F> Response<F> decompress(int bufferSize, Response<F> response, Async<F> F) {
        Response response2;
        block4: {
            Content.minusEncoding minusEncoding2;
            block6: {
                block5: {
                    Option option = Headers$.MODULE$.get$extension(response.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusEncoding$.MODULE$.headerInstance()));
                    if (!(option instanceof Some)) break block4;
                    Content.minusEncoding header2 = minusEncoding2 = (Content.minusEncoding)((Some)option).value();
                    ContentCoding contentCoding = header2.contentCoding();
                    ContentCoding contentCoding2 = ContentCoding$.MODULE$.gzip();
                    if (!(contentCoding == null ? contentCoding2 != null : !contentCoding.equals(contentCoding2))) break block5;
                    ContentCoding contentCoding3 = header2.contentCoding();
                    ContentCoding contentCoding4 = ContentCoding$.MODULE$.x$minusgzip();
                    if (contentCoding3 != null ? !contentCoding3.equals(contentCoding4) : contentCoding4 != null) break block6;
                }
                Function1 & Serializable gunzip = (Function1 & Serializable)_$4 -> _$4.through(Compression$.MODULE$.apply(Compression$.MODULE$.forSync((Sync)F)).gunzip(bufferSize)).flatMap((Function1 & Serializable)_$5 -> _$5.content(), NotGiven$.MODULE$.value());
                response2 = (Response)response.filterHeaders((Function1 & Serializable)header -> this.nonCompressionHeader((Header.Raw)header)).pipeBodyThrough(this.decompressWith(gunzip, F));
                return response2;
            }
            Content.minusEncoding header3 = minusEncoding2;
            ContentCoding contentCoding = header3.contentCoding();
            ContentCoding contentCoding5 = ContentCoding$.MODULE$.deflate();
            if (!(contentCoding != null ? !contentCoding.equals(contentCoding5) : contentCoding5 != null)) {
                Function1 deflate = Compression$.MODULE$.apply(Compression$.MODULE$.forSync(F)).deflate(DeflateParams$.MODULE$.apply(bufferSize, DeflateParams$.MODULE$.apply$default$2(), DeflateParams$.MODULE$.apply$default$3(), DeflateParams$.MODULE$.apply$default$4(), DeflateParams$.MODULE$.apply$default$5()));
                response2 = (Response)response.filterHeaders((Function1 & Serializable)header -> this.nonCompressionHeader((Header.Raw)header)).pipeBodyThrough(this.decompressWith(deflate, F));
                return response2;
            }
        }
        response2 = response;
        return response2;
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> decompressWith(Function1<Stream<F, Object>, Stream<F, Object>> decompressor, Async<F> F) {
        return (Function1 & Serializable)_$7 -> {
            Stream stream = Stream$.MODULE$.InvariantOps(_$7);
            Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            Pull pull = Pull$.MODULE$.StreamPullOps(Stream.ToPull$.MODULE$.peek1$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Pull pull;
                Option option = x$1;
                if (None$.MODULE$.equals(option)) {
                    pull = Pull$.MODULE$.raiseError((Throwable)GZip$EmptyBodyException$.MODULE$, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F));
                } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Stream fullStream = (Stream)tuple2._2();
                    pull = Pull$.MODULE$.output1((Object)fullStream);
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            }));
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).through(decompressor).handleErrorWith((Function1 & Serializable)x$1 -> {
                Stream stream;
                Throwable throwable = x$1;
                if (GZip$EmptyBodyException$.MODULE$.equals(throwable)) {
                    stream = Stream$.MODULE$.empty();
                } else {
                    Throwable error = throwable;
                    stream = Stream$.MODULE$.raiseError(error, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F));
                }
                return stream;
            });
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nonCompressionHeader(Header.Raw header) {
        CIString cIString = header.name();
        CIString cIString2 = package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Encoding"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        if (cIString == null) {
            if (cIString2 == null) return false;
        } else if (cIString.equals(cIString2)) return false;
        CIString cIString3 = header.name();
        CIString cIString4 = package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Length"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        if (cIString3 == null) {
            if (cIString4 == null) return false;
            return true;
        } else if (cIString3.equals(cIString4)) return false;
        return true;
    }
}

