/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Unique;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.ResponseCookie;
import org.http4s.Uri;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Location;
import org.http4s.headers.Location$;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class FollowRedirect$
implements Serializable {
    private static final Key<List<Uri>> redirectUrisKey;
    public static final FollowRedirect$ MODULE$;

    private FollowRedirect$() {
    }

    static {
        MODULE$ = new FollowRedirect$();
        redirectUrisKey = (Key)((SyncIO)Key$.MODULE$.newKey((Functor)SyncIO$.MODULE$.syncForSyncIO(), (Unique)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FollowRedirect$.class);
    }

    public <F> Client<F> apply(int maxRedirects, Function1<CIString, Object> sensitiveHeaderFilter, Client<F> client, GenConcurrent<F, Throwable> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> Hotswap$.MODULE$.create(F).flatMap((Function1 & Serializable)x$1 -> {
            Hotswap hotswap;
            Hotswap hotswap2 = hotswap = x$1;
            return cats.effect.package$.MODULE$.Resource().eval(this.redirectLoop$1(maxRedirects, (Function1)sensitiveHeaderFilter, client, F, (Request)req, 0, hotswap2));
        }), F);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return Headers$.MODULE$.SensitiveHeaders();
    }

    private <F> Option<Method> methodForRedirect(Request<F> req, Response<F> resp) {
        int n = resp.status().code();
        switch (n) {
            case 301: 
            case 302: {
                Method method = req.method();
                Method method2 = Method$.MODULE$.POST();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                    return Some$.MODULE$.apply((Object)Method$.MODULE$.GET());
                }
                Method m = method;
                return Some$.MODULE$.apply((Object)m);
            }
            case 303: {
                Method method = req.method();
                Method method4 = Method$.MODULE$.HEAD();
                Method method5 = method;
                if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                    return Some$.MODULE$.apply((Object)Method$.MODULE$.HEAD());
                }
                return Some$.MODULE$.apply((Object)Method$.MODULE$.GET());
            }
            case 307: 
            case 308: {
                return Some$.MODULE$.apply((Object)req.method());
            }
        }
        return None$.MODULE$;
    }

    public <F> List<Uri> getRedirectUris(Response<F> response) {
        return (List)response.attributes().lookup(redirectUrisKey).getOrElse(this::getRedirectUris$$anonfun$1);
    }

    private final Option $anonfun$1(Request req$1) {
        return req$1.uri().scheme();
    }

    private final Option $anonfun$2(Request req$2) {
        return req$2.uri().authority();
    }

    private final Option $anonfun$3(Request req$3) {
        return req$3.uri().fragment();
    }

    private final /* synthetic */ List stripSensitiveHeaders$1$$anonfun$1(Function1 sensitiveHeaderFilter$3, List hs) {
        return Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)hs.filterNot((Function1 & Serializable)h -> BoxesRunTime.unboxToBoolean((Object)sensitiveHeaderFilter$3.apply((Object)h.name()))), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h))}));
    }

    private final Request stripSensitiveHeaders$1(Function1 sensitiveHeaderFilter$1, Uri nextUri$1, Request req) {
        Option option = req.uri().authority();
        Option option2 = nextUri$1.authority();
        if (option == null ? option2 != null : !option.equals(option2)) {
            return (Request)req.transformHeaders((Function1 & Serializable)v1 -> new Headers(this.stripSensitiveHeaders$1$$anonfun$1(sensitiveHeaderFilter$1, v1 == null ? null : ((Headers)v1).headers())));
        }
        return req;
    }

    private final Request propagateCookies$1(List cookies$1, Uri nextUri$2, Request req) {
        Option option = req.uri().authority();
        Option option2 = nextUri$2.authority();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            return (Request)cookies$1.foldLeft((Object)req, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Request nextReq = (Request)tuple2._1();
                    ResponseCookie cookie = (ResponseCookie)tuple2._2();
                    return nextReq.addCookie(cookie.name(), cookie.content());
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return req;
    }

    private final Request clearBodyFromGetHead$1(Method method$1, Request req) {
        block6: {
            block3: {
                Method method;
                Method method2;
                block5: {
                    Method method3;
                    block4: {
                        Method method4;
                        Method method5;
                        block2: {
                            method3 = method$1;
                            method5 = Method$.MODULE$.GET();
                            method4 = method3;
                            if (method5 != null) break block2;
                            if (method4 == null) break block3;
                            break block4;
                        }
                        if (method5.equals(method4)) break block3;
                    }
                    method2 = Method$.MODULE$.HEAD();
                    method = method3;
                    if (method2 != null) break block5;
                    if (method == null) break block3;
                    break block6;
                }
                if (!method2.equals(method)) break block6;
            }
            return (Request)req.withEmptyBody();
        }
        return req;
    }

    private final Request nextRequest$1(Function1 sensitiveHeaderFilter$2, Request req, Uri uri, Method method, List cookies) {
        Option option = uri.scheme().orElse(() -> this.$anonfun$1(req));
        Option option2 = uri.authority().orElse(() -> this.$anonfun$2(req));
        Option option3 = uri.fragment().orElse(() -> this.$anonfun$3(req));
        Uri.Path path = uri.copy$default$3();
        Query query = uri.copy$default$4();
        Uri nextUri = uri.copy(option, option2, path, query, option3);
        return this.clearBodyFromGetHead$1(method, this.propagateCookies$1(cookies, nextUri, this.stripSensitiveHeaders$1(sensitiveHeaderFilter$2, nextUri, req)).withMethod(method).withUri(nextUri));
    }

    private final Object redirectLoop$1(int maxRedirects$1, Function1 sensitiveHeaderFilter$5, Client client$1, GenConcurrent F$1, Request req, int redirects, Hotswap hotswap) {
        Object object = package.all$.MODULE$.catsSyntaxApplyOps(hotswap.clear());
        return ApplyOps$.MODULE$.$times$greater$extension(object, package.all$.MODULE$.toFlatMapOps(hotswap.swap(client$1.run(req)), (FlatMap)F$1).flatMap((Function1 & Serializable)resp -> {
            Option l = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.singleHeaders(Location$.MODULE$.headerInstance()));
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.methodForRedirect((Request)req, (Response)resp), (Object)l);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Method method = (Method)((Some)option).value();
                    if (option2 instanceof Some) {
                        Location loc = (Location)((Some)option2).value();
                        if (redirects < maxRedirects$1) {
                            Request nextReq = this.nextRequest$1(sensitiveHeaderFilter$5, req, loc.uri(), method, resp.cookies());
                            return package.all$.MODULE$.toFunctorOps(this.redirectLoop$1(maxRedirects$1, sensitiveHeaderFilter$5, client$1, F$1, nextReq, redirects + 1, hotswap), (Functor)F$1).map((Function1 & Serializable)res -> (Response)res.withAttribute(redirectUrisKey, this.getRedirectUris((Response)res).$plus$colon((Object)nextReq.uri())));
                        }
                    }
                }
            }
            Response response = (Response)package.all$.MODULE$.catsSyntaxApplicativeId(resp);
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)response, (Applicative)F$1);
        }), (Apply)F$1);
    }

    private final List getRedirectUris$$anonfun$1() {
        return package$.MODULE$.Nil();
    }
}

