/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Unique;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry$minusAfter$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$
implements Serializable {
    private static final SelfAwareStructuredLogger<SyncIO> logger;
    private static final Key AttemptCountKey;
    public static final Retry$ MODULE$;

    private Retry$() {
    }

    static {
        MODULE$ = new Retry$();
        logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.client.middleware.Retry");
        AttemptCountKey = (Key)((SyncIO)Key$.MODULE$.newKey((Functor)SyncIO$.MODULE$.syncForSyncIO(), (Unique)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Retry$.class);
    }

    public Key<Object> AttemptCountKey() {
        return AttemptCountKey;
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, Client<F> client, GenTemporal<F, Throwable> F) {
        return this.create(policy, redactHeaderWhen, this.create$default$3(), client, F);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> Client<F> create(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, boolean logRetries, Client<F> client, GenTemporal<F, Throwable> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> Hotswap$.MODULE$.create((GenConcurrent)F).flatMap((Function1 & Serializable)hotswap -> Resource$.MODULE$.eval(this.retryLoop$1(client, F, policy, logRetries, (Function1)redactHeaderWhen, (Request)req, 1, (Hotswap)hotswap))), F);
    }

    public <F> Function1<CIString, Object> create$default$2() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public boolean create$default$3() {
        return true;
    }

    private final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.mkString$extension(request.headers(), ",", redactWhen);
        String uri = request.uri().renderString();
        Method method = request.method();
        return new StringBuilder(21).append("method=").append(method).append(" uri=").append(uri).append(" headers=").append(headers).toString();
    }

    private static final Object $anonfun$2(GenTemporal F$3) {
        FiniteDuration finiteDuration = (FiniteDuration)package.all$.MODULE$.catsSyntaxApplicativeId((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds());
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)finiteDuration, (Applicative)F$3);
    }

    private final Object nextAttempt$1$$anonfun$2(Request req$1, int attempts$1, Hotswap hotswap$1, Client client$2, GenTemporal F$5, Function3 policy$2, boolean logRetries$2, Function1 redactHeaderWhen$2) {
        return this.retryLoop$1(client$2, F$5, policy$2, logRetries$2, redactHeaderWhen$2, req$1, attempts$1 + 1, hotswap$1);
    }

    private final Object nextAttempt$1(GenTemporal F$1, Client client$1, Function3 policy$1, boolean logRetries$1, Function1 redactHeaderWhen$1, Request req, int attempts, FiniteDuration duration, Option retryHeader, Hotswap hotswap) {
        Object headerDuration = retryHeader.map((Function1 & Serializable)h -> {
            Either either = h.retry();
            if (either instanceof Left) {
                HttpDate date = (HttpDate)((Left)either).value();
                return package.all$.MODULE$.toFunctorOps(F$1.realTime(), (Functor)F$1).map((Function1 & Serializable)_$3 -> date.toDuration().$minus(_$3));
            }
            if (either instanceof Right) {
                long secs = BoxesRunTime.unboxToLong((Object)((Right)either).value());
                FiniteDuration finiteDuration = (FiniteDuration)package.all$.MODULE$.catsSyntaxApplicativeId((Object)new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(secs)).seconds());
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)finiteDuration, (Applicative)F$1);
            }
            throw new MatchError((Object)either);
        }).getOrElse(() -> Retry$.$anonfun$2(F$1));
        Object sleepDuration = package.all$.MODULE$.toFunctorOps(headerDuration, (Functor)F$1).map((Function1 & Serializable)_$4 -> _$4.max(duration));
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFlatMapOps(sleepDuration, (FlatMap)F$1).flatMap((Function1 & Serializable)_$5 -> F$1.sleep((Duration)_$5)), (FlatMap)F$1);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.nextAttempt$1$$anonfun$2(req, attempts, hotswap, client$1, F$1, policy$1, logRetries$1, redactHeaderWhen$1), (FlatMap)F$1);
    }

    private final String retryLoop$1$$anonfun$2$$anonfun$1(Request req$3, Function1 redactHeaderWhen$5, int attempts$4, Response response$1, FiniteDuration duration$2) {
        return new StringBuilder(63).append("Request ").append(this.showRequest$1(req$3, redactHeaderWhen$5)).append(" has failed on attempt #").append(attempts$4).append(" with reason ").append(response$1.status()).append(". Retrying after ").append(duration$2).append(".").toString();
    }

    private static final String retryLoop$1$$anonfun$2$$anonfun$2(int attempts$5, FiniteDuration duration$3) {
        return new StringBuilder(56).append("Request threw an exception on attempt #").append(attempts$5).append(". Retrying after ").append(duration$3).toString();
    }

    private final String retryLoop$1$$anonfun$2$$anonfun$3(Request req$4, Function1 redactHeaderWhen$6, int attempts$6) {
        return new StringBuilder(52).append("Request ").append(this.showRequest$1(req$4, redactHeaderWhen$6)).append(" threw an exception on attempt #").append(attempts$6).append(". Giving up.").toString();
    }

    private final Object retryLoop$1(Client client$3, GenTemporal F$6, Function3 policy$3, boolean logRetries$3, Function1 redactHeaderWhen$3, Request req, int attempts, Hotswap hotswap) {
        Object object = package.all$.MODULE$.catsSyntaxApplyOps(hotswap.clear());
        return ApplyOps$.MODULE$.$times$greater$extension(object, package.all$.MODULE$.toFlatMapOps(hotswap.swap(client$3.run((Request)req.withAttribute(this.AttemptCountKey(), (Object)BoxesRunTime.boxToInteger((int)attempts))).map((Function1 & Serializable)_$6 -> (Response)_$6.withAttribute(MODULE$.AttemptCountKey(), (Object)BoxesRunTime.boxToInteger((int)attempts))).attempt((ApplicativeError)F$6)), (FlatMap)F$6).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Response response = (Response)((Right)either).value();
                Option option = (Option)policy$3.apply((Object)req, (Object)package$.MODULE$.Right().apply((Object)response), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    FiniteDuration duration = (FiniteDuration)((Some)option).value();
                    if (logRetries$3) {
                        ((SyncIO)logger.info(() -> this.retryLoop$1$$anonfun$2$$anonfun$1(req, redactHeaderWhen$3, attempts, response, duration))).unsafeRunSync();
                    }
                    return this.nextAttempt$1(F$6, client$3, policy$3, logRetries$3, redactHeaderWhen$3, req, attempts, duration, Headers$.MODULE$.get$extension(response.headers(), Header.Select$.MODULE$.singleHeaders(Retry$minusAfter$.MODULE$.headerInstance())), hotswap);
                }
                if (None$.MODULE$.equals(option)) {
                    return F$6.pure((Object)response);
                }
                throw new MatchError((Object)option);
            }
            if (either instanceof Left) {
                Throwable e = (Throwable)((Left)either).value();
                Option option = (Option)policy$3.apply((Object)req, (Object)package$.MODULE$.Left().apply((Object)e), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    FiniteDuration duration = (FiniteDuration)((Some)option).value();
                    if (logRetries$3) {
                        ((SyncIO)logger.info(e, () -> Retry$.retryLoop$1$$anonfun$2$$anonfun$2(attempts, duration))).unsafeRunSync();
                    }
                    return this.nextAttempt$1(F$6, client$3, policy$3, logRetries$3, redactHeaderWhen$3, req, attempts, duration, (Option)None$.MODULE$, hotswap);
                }
                if (None$.MODULE$.equals(option)) {
                    if (logRetries$3) {
                        ((SyncIO)logger.info(e, () -> this.retryLoop$1$$anonfun$2$$anonfun$3(req, redactHeaderWhen$3, attempts))).unsafeRunSync();
                    }
                    return F$6.raiseError((Object)e);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)either);
        }), (Apply)F$6);
    }
}

