/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.oauth1;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.package;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.client.oauth1.ProtocolParameter;
import org.http4s.client.oauth1.SignatureAlgorithm$;
import org.http4s.crypto.Algorithm;
import org.http4s.crypto.Hmac;
import org.http4s.crypto.Hmac$;
import org.http4s.crypto.HmacAlgorithm;
import org.http4s.crypto.SecretKey;
import org.http4s.crypto.SecretKeySpec;
import org.http4s.crypto.SecretKeySpec$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.util.Either;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public interface SignatureAlgorithm {
    public static SignatureAlgorithm unsafeFromMethod(ProtocolParameter.SignatureMethod signatureMethod) {
        return SignatureAlgorithm$.MODULE$.unsafeFromMethod(signatureMethod);
    }

    public String name();

    public static Object generate$(SignatureAlgorithm $this, String input, String secretKey, MonadError evidence$1) {
        return $this.generate(input, secretKey, evidence$1);
    }

    default public <F> Object generate(String input, String secretKey, MonadError<F, Throwable> evidence$1) {
        return package.MonadThrow$.MODULE$.apply(evidence$1).catchNonFatal(() -> this.generate$$anonfun$1(input, secretKey), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static String generate$(SignatureAlgorithm $this, String input, String secretKey) {
        return $this.generate(input, secretKey);
    }

    default public String generate(String input, String secretKey) {
        return (String)((SyncIO)this.generate(input, secretKey, (MonadError)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    public static Object generateHMAC$(SignatureAlgorithm $this, String input, HmacAlgorithm algorithm, String secretKey, MonadError evidence$1, Hmac evidence$2) {
        return $this.generateHMAC(input, algorithm, secretKey, evidence$1, evidence$2);
    }

    default public <F> Object generateHMAC(String input, HmacAlgorithm algorithm, String secretKey, MonadError<F, Throwable> evidence$1, Hmac<F> evidence$2) {
        Either either = package.all$.MODULE$.catsSyntaxEither(ByteVector$.MODULE$.encodeUtf8(secretKey));
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(EitherOps$.MODULE$.liftTo$extension(either, evidence$1), evidence$1).map((Function1 & Serializable)keyData -> {
            SecretKeySpec sk = SecretKeySpec$.MODULE$.apply(keyData, (Algorithm)algorithm);
            return Tuple2$.MODULE$.apply(keyData, (Object)sk);
        }), evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ByteVector keyData = (ByteVector)tuple2._1();
                SecretKeySpec sk = (SecretKeySpec)tuple2._2();
                Either either = package.all$.MODULE$.catsSyntaxEither(ByteVector$.MODULE$.encodeUtf8(input));
                return package.all$.MODULE$.toFlatMapOps(EitherOps$.MODULE$.liftTo$extension(either, (ApplicativeError)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)data -> package.all$.MODULE$.toFunctorOps(Hmac$.MODULE$.apply(evidence$2).digest((SecretKey)sk, data), (Functor)evidence$1).map((Function1 & Serializable)digest -> digest.toBase64()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String generate$$anonfun$1(String input$1, String secretKey$1) {
        return this.generate(input$1, secretKey$1);
    }
}

