/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.JavaNetClientBuilder$;
import org.http4s.internal.BackendBuilder;
import org.http4s.internal.CollectionCompat$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;

public abstract class JavaNetClientBuilder<F>
implements BackendBuilder<F, Client<F>> {
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final Option proxy;
    private final Option hostnameVerifier;
    private final Option sslSocketFactory;
    private final Sync F;

    public static <F, SourceBreakingDummy> JavaNetClientBuilder<F> apply(Async<F> async) {
        return JavaNetClientBuilder$.MODULE$.apply(async);
    }

    public static <F> JavaNetClientBuilder<F> apply(Sync<F> sync) {
        return JavaNetClientBuilder$.MODULE$.apply(sync);
    }

    public JavaNetClientBuilder(Duration connectTimeout, Duration readTimeout, Option<Proxy> proxy, Option<HostnameVerifier> hostnameVerifier, Option<SSLSocketFactory> sslSocketFactory, Sync<F> F) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
        this.hostnameVerifier = hostnameVerifier;
        this.sslSocketFactory = sslSocketFactory;
        this.F = F;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public Option<Proxy> proxy() {
        return this.proxy;
    }

    public Option<HostnameVerifier> hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Option<SSLSocketFactory> sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public Sync<F> F() {
        return this.F;
    }

    private JavaNetClientBuilder<F> copy(Duration connectTimeout, Duration readTimeout, Option<Proxy> proxy, Option<HostnameVerifier> hostnameVerifier, Option<SSLSocketFactory> sslSocketFactory) {
        return new JavaNetClientBuilder<F>(connectTimeout, readTimeout, proxy, hostnameVerifier, sslSocketFactory, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(connectTimeout$1, readTimeout$1, (Option<Proxy>)proxy$1, (Option<HostnameVerifier>)hostnameVerifier$1, (Option<SSLSocketFactory>)sslSocketFactory$1, $outer.F());
            }
        };
    }

    private Duration copy$default$1() {
        return this.connectTimeout();
    }

    private Duration copy$default$2() {
        return this.readTimeout();
    }

    private Option<Proxy> copy$default$3() {
        return this.proxy();
    }

    private Option<HostnameVerifier> copy$default$4() {
        return this.hostnameVerifier();
    }

    private Option<SSLSocketFactory> copy$default$5() {
        return this.sslSocketFactory();
    }

    public JavaNetClientBuilder<F> withConnectTimeout(Duration connectTimeout) {
        return this.copy(connectTimeout, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public JavaNetClientBuilder<F> withReadTimeout(Duration readTimeout) {
        return this.copy(this.copy$default$1(), readTimeout, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public JavaNetClientBuilder<F> withProxyOption(Option<Proxy> proxy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), proxy, this.copy$default$4(), this.copy$default$5());
    }

    public JavaNetClientBuilder<F> withProxy(Proxy proxy) {
        return this.withProxyOption((Option<Proxy>)Some$.MODULE$.apply((Object)proxy));
    }

    public JavaNetClientBuilder<F> withoutProxy() {
        return this.withProxyOption((Option<Proxy>)None$.MODULE$);
    }

    public JavaNetClientBuilder<F> withHostnameVerifierOption(Option<HostnameVerifier> hostnameVerifier) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), hostnameVerifier, this.copy$default$5());
    }

    public JavaNetClientBuilder<F> withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        return this.withHostnameVerifierOption((Option<HostnameVerifier>)Some$.MODULE$.apply((Object)hostnameVerifier));
    }

    public JavaNetClientBuilder<F> withoutHostnameVerifier() {
        return this.withHostnameVerifierOption((Option<HostnameVerifier>)None$.MODULE$);
    }

    public JavaNetClientBuilder<F> withSslSocketFactoryOption(Option<SSLSocketFactory> sslSocketFactory) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), sslSocketFactory);
    }

    public JavaNetClientBuilder<F> withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return this.withSslSocketFactoryOption((Option<SSLSocketFactory>)Some$.MODULE$.apply((Object)sslSocketFactory));
    }

    public JavaNetClientBuilder<F> withoutSslSocketFactory() {
        return this.withSslSocketFactoryOption((Option<SSLSocketFactory>)None$.MODULE$);
    }

    public Client<F> create() {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> package$.MODULE$.Resource().eval(this.F().delay(() -> JavaNetClientBuilder.create$$anonfun$1$$anonfun$1(req))).flatMap((Function1 & Serializable)url -> package$.MODULE$.Resource().make(this.openConnection((URL)url, this.F()), (Function1 & Serializable)conn -> {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.F().delay((Function0 & Serializable)() -> {
                JavaNetClientBuilder.create$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(conn);
                return BoxedUnit.UNIT;
            }), this.F());
            return ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)new Serializable((HttpURLConnection)conn, this){
                private final HttpURLConnection conn$16;
                private final /* synthetic */ JavaNetClientBuilder $outer;
                {
                    this.conn$16 = conn$40;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return throwable instanceof IOException;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof IOException) {
                        return this.$outer.F().delay((Function0 & Serializable)() -> {
                            this.applyOrElse$$anonfun$1();
                            return BoxedUnit.UNIT;
                        });
                    }
                    return function1.apply((Object)x);
                }

                private final void applyOrElse$$anonfun$1() {
                    Option$.MODULE$.apply((Object)this.conn$16.getErrorStream()).foreach((Function1)((JProcedure1 & Serializable)JavaNetClientBuilder::org$http4s$client$JavaNetClientBuilder$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(), org$http4s$client$JavaNetClientBuilder$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1(java.io.InputStream )}, serializedLambda);
                }
            }, this.F());
        }, this.F()).flatMap((Function1 & Serializable)conn -> package$.MODULE$.Resource().eval(this.respond$1((Request)req, (HttpURLConnection)conn)).map((Function1 & Serializable)resp -> resp))), this.F());
    }

    public Resource<F, Client<F>> resource() {
        return package$.MODULE$.Resource().eval(this.F().delay(this::resource$$anonfun$1));
    }

    private F fetchResponse(Request<F> req, HttpURLConnection conn) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.writeBody(req, conn), this.F()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return package.all$.MODULE$.toFlatMapOps(this.F().blocking(() -> JavaNetClientBuilder.fetchResponse$$anonfun$1$$anonfun$1(conn)), this.F()).flatMap((Function1 & Serializable)code -> this.fetchResponse$$anonfun$1$$anonfun$2(conn, BoxesRunTime.unboxToInt((Object)code)));
        });
    }

    private int timeoutMillis(Duration d) {
        FiniteDuration d2;
        Duration duration = d;
        if (duration instanceof FiniteDuration && (d2 = (FiniteDuration)duration).$greater((Object)Duration$.MODULE$.Zero())) {
            return (int)BoxesRunTime.unboxToLong((Object)package.all$.MODULE$.catsSyntaxOrder(package.all$.MODULE$.catsSyntaxOrder((Object)BoxesRunTime.boxToLong((long)d2.toMillis()), (Order)Eq$.MODULE$.catsKernelInstancesForLong()).max((Object)BoxesRunTime.boxToLong((long)0L)), (Order)Eq$.MODULE$.catsKernelInstancesForLong()).min((Object)BoxesRunTime.boxToLong((long)Integer.MAX_VALUE)));
        }
        return 0;
    }

    private F openConnection(URL url, Sync<F> F) {
        Option<Proxy> option = this.proxy();
        if (option instanceof Some) {
            Proxy p = (Proxy)((Some)option).value();
            return (F)F.delay(() -> JavaNetClientBuilder.openConnection$$anonfun$1(url, p));
        }
        if (None$.MODULE$.equals(option)) {
            return (F)F.delay(() -> JavaNetClientBuilder.openConnection$$anonfun$2(url));
        }
        throw new MatchError(option);
    }

    private F writeBody(Request<F> req, HttpURLConnection conn) {
        long len;
        if (req.isChunked()) {
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.F().delay((Function0 & Serializable)() -> {
                JavaNetClientBuilder.writeBody$$anonfun$1(conn);
                return BoxedUnit.UNIT;
            }));
            Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.F().delay((Function0 & Serializable)() -> {
                JavaNetClientBuilder.writeBody$$anonfun$2(conn);
                return BoxedUnit.UNIT;
            }), this.F()));
            return (F)ApplyOps$.MODULE$.$times$greater$extension(object2, req.body().through(fs2.io.package$.MODULE$.writeOutputStream(this.F().delay(() -> JavaNetClientBuilder.writeBody$$anonfun$3(conn)), false, this.F())).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(this.F()))).drain(), this.F());
        }
        Option option = req.contentLength();
        if (option instanceof Some && (len = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L) {
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.F().delay((Function0 & Serializable)() -> {
                JavaNetClientBuilder.writeBody$$anonfun$4(conn);
                return BoxedUnit.UNIT;
            }));
            Object object3 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.F().delay((Function0 & Serializable)() -> {
                JavaNetClientBuilder.writeBody$$anonfun$5(conn, len);
                return BoxedUnit.UNIT;
            }), this.F()));
            return (F)ApplyOps$.MODULE$.$times$greater$extension(object3, req.body().through(fs2.io.package$.MODULE$.writeOutputStream(this.F().delay(() -> JavaNetClientBuilder.writeBody$$anonfun$6(conn)), false, this.F())).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(this.F()))).drain(), this.F());
        }
        return (F)this.F().delay((Function0 & Serializable)() -> {
            JavaNetClientBuilder.writeBody$$anonfun$7(conn);
            return BoxedUnit.UNIT;
        });
    }

    private Stream<F, Object> readBody(HttpURLConnection conn) {
        return Stream$.MODULE$.eval(this.inputStream$1(conn)).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                InputStream in = (InputStream)((Some)option).value();
                return fs2.io.package$.MODULE$.readInputStream(this.F().pure((Object)in), 4096, false, this.F());
            }
            if (None$.MODULE$.equals(option)) {
                return Stream$.MODULE$.empty();
            }
            throw new MatchError((Object)option);
        }, NotGiven$.MODULE$.value());
    }

    private F configureSsl(HttpURLConnection conn) {
        HttpURLConnection httpURLConnection = conn;
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection connSsl = (HttpsURLConnection)httpURLConnection;
            return (F)package.all$.MODULE$.toFlatMapOps(this.hostnameVerifier().fold(this::configureSsl$$anonfun$1, (Function1 & Serializable)hv -> this.F().delay((Function0 & Serializable)() -> {
                JavaNetClientBuilder.configureSsl$$anonfun$2$$anonfun$1(connSsl, hv);
                return BoxedUnit.UNIT;
            })), this.F()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFunctorOps(this.sslSocketFactory().fold(this::configureSsl$$anonfun$3$$anonfun$1, (Function1 & Serializable)sslf -> this.F().delay((Function0 & Serializable)() -> {
                    JavaNetClientBuilder.configureSsl$$anonfun$3$$anonfun$2$$anonfun$1(connSsl, sslf);
                    return BoxedUnit.UNIT;
                })), this.F()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }
        return (F)this.F().unit();
    }

    private final void respond$1$$anonfun$1$$anonfun$1(HttpURLConnection conn$2) {
        conn$2.setConnectTimeout(this.timeoutMillis(this.connectTimeout()));
    }

    private final void respond$1$$anonfun$1$$anonfun$2$$anonfun$1(HttpURLConnection conn$4) {
        conn$4.setReadTimeout(this.timeoutMillis(this.readTimeout()));
    }

    private static final void respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(HttpURLConnection conn$6, Request req$4) {
        conn$6.setRequestMethod(req$4.method().renderString());
    }

    private static final void respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Request req$7, HttpURLConnection conn$8) {
        Headers$.MODULE$.foreach$extension(req$7.headers(), (Function1)(JProcedure1 & Serializable)x$1 -> {
            Header.Raw raw = x$1;
            if (raw != null) {
                Header.Raw raw2 = Header.Raw$.MODULE$.unapply(raw);
                CIString cIString = raw2._1();
                String string = raw2._2();
                CIString name = cIString;
                String value = string;
                conn$8.setRequestProperty(name.toString(), value);
                return;
            }
            throw new MatchError((Object)raw);
        });
    }

    private static final void respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(HttpURLConnection conn$11) {
        conn$11.setInstanceFollowRedirects(false);
    }

    private static final void respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(HttpURLConnection conn$13) {
        conn$13.setDoInput(true);
    }

    private final Object respond$1(Request req$5, HttpURLConnection conn) {
        return package.all$.MODULE$.toFlatMapOps(this.configureSsl(conn), this.F()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return package.all$.MODULE$.toFlatMapOps(this.F().delay((Function0 & Serializable)() -> {
                this.respond$1$$anonfun$1$$anonfun$1(conn);
                return BoxedUnit.UNIT;
            }), this.F()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFlatMapOps(this.F().delay((Function0 & Serializable)() -> {
                    this.respond$1$$anonfun$1$$anonfun$2$$anonfun$1(conn);
                    return BoxedUnit.UNIT;
                }), this.F()).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return package.all$.MODULE$.toFlatMapOps(this.F().delay((Function0 & Serializable)() -> {
                        JavaNetClientBuilder.respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(conn, req$5);
                        return BoxedUnit.UNIT;
                    }), this.F()).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return package.all$.MODULE$.toFlatMapOps(this.F().delay((Function0 & Serializable)() -> {
                            JavaNetClientBuilder.respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(req$5, conn);
                            return BoxedUnit.UNIT;
                        }), this.F()).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return package.all$.MODULE$.toFlatMapOps(this.F().delay((Function0 & Serializable)() -> {
                                JavaNetClientBuilder.respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(conn);
                                return BoxedUnit.UNIT;
                            }), this.F()).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return package.all$.MODULE$.toFlatMapOps(this.F().delay((Function0 & Serializable)() -> {
                                    JavaNetClientBuilder.respond$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(conn);
                                    return BoxedUnit.UNIT;
                                }), this.F()).flatMap((Function1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return package.all$.MODULE$.toFunctorOps(this.fetchResponse(req$5, conn), this.F()).map((Function1 & Serializable)resp -> resp);
                                });
                            });
                        });
                    });
                });
            });
        });
    }

    private static final URL create$$anonfun$1$$anonfun$1(Request req$11) {
        return new URL(req$11.uri().toString());
    }

    private static final void create$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(HttpURLConnection conn$15) {
        conn$15.getInputStream().close();
    }

    public static final /* synthetic */ void org$http4s$client$JavaNetClientBuilder$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1(InputStream _$2) {
        _$2.close();
    }

    private final Client resource$$anonfun$1() {
        return this.create();
    }

    private static final int fetchResponse$$anonfun$1$$anonfun$1(HttpURLConnection conn$18) {
        return conn$18.getResponseCode();
    }

    private static final List fetchResponse$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(HttpURLConnection conn$21) {
        return Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)((IterableOnceOps)((IterableOps)CollectionCompat$.MODULE$.CollectionConverters().MapHasAsScala(conn$21.getHeaderFields()).asScala().filter((Function1 & Serializable)_$3 -> _$3._1() != null)).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                java.util.List vs = (java.util.List)tuple2._2();
                return (Buffer)CollectionCompat$.MODULE$.CollectionConverters().ListHasAsScala(vs).asScala().map((Function1 & Serializable)_$4 -> Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply(k), _$4));
            }
            throw new MatchError((Object)tuple2);
        })).toList(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h))}));
    }

    private final /* synthetic */ Response fetchResponse$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(HttpURLConnection conn$22, Status status$1, List headers) {
        Stream<F, Object> stream = this.readBody(conn$22);
        HttpVersion httpVersion = Response$.MODULE$.apply$default$2();
        Vault vault = Response$.MODULE$.apply$default$5();
        return Response$.MODULE$.apply(status$1, httpVersion, headers, stream, vault);
    }

    private final /* synthetic */ Object fetchResponse$$anonfun$1$$anonfun$2(HttpURLConnection conn$19, int code) {
        return package.all$.MODULE$.toFlatMapOps(this.F().fromEither(Status$.MODULE$.fromInt(code)), this.F()).flatMap((Function1 & Serializable)status -> package.all$.MODULE$.toFunctorOps(this.F().blocking((Function0 & Serializable)() -> new Headers(JavaNetClientBuilder.fetchResponse$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(conn$19))), this.F()).map((Function1 & Serializable)headers -> this.fetchResponse$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(conn$19, (Status)status, headers == null ? null : ((Headers)headers).headers())));
    }

    private static final HttpURLConnection openConnection$$anonfun$1(URL url$1, Proxy p$1) {
        return (HttpURLConnection)url$1.openConnection(p$1);
    }

    private static final HttpURLConnection openConnection$$anonfun$2(URL url$2) {
        return (HttpURLConnection)url$2.openConnection();
    }

    private static final void writeBody$$anonfun$1(HttpURLConnection conn$23) {
        conn$23.setDoOutput(true);
    }

    private static final void writeBody$$anonfun$2(HttpURLConnection conn$24) {
        conn$24.setChunkedStreamingMode(4096);
    }

    private static final OutputStream writeBody$$anonfun$3(HttpURLConnection conn$25) {
        return conn$25.getOutputStream();
    }

    private static final void writeBody$$anonfun$4(HttpURLConnection conn$26) {
        conn$26.setDoOutput(true);
    }

    private static final void writeBody$$anonfun$5(HttpURLConnection conn$27, long len$1) {
        conn$27.setFixedLengthStreamingMode(len$1);
    }

    private static final OutputStream writeBody$$anonfun$6(HttpURLConnection conn$28) {
        return conn$28.getOutputStream();
    }

    private static final void writeBody$$anonfun$7(HttpURLConnection conn$29) {
        conn$29.setDoOutput(false);
    }

    private static final Option inputStream$1$$anonfun$1(HttpURLConnection conn$31) {
        return Option$.MODULE$.apply((Object)conn$31.getInputStream());
    }

    private final Object inputStream$1(HttpURLConnection conn$30) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.F().delay(() -> JavaNetClientBuilder.inputStream$1$$anonfun$1(conn$30)), this.F());
        return ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)new Serializable(conn$30, this){
            private final HttpURLConnection conn$32;
            private final /* synthetic */ JavaNetClientBuilder $outer;
            {
                this.conn$32 = conn$49;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof IOException && this.conn$32.getResponseCode() > 0;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof IOException && this.conn$32.getResponseCode() > 0) {
                    return this.$outer.F().delay(this::applyOrElse$$anonfun$2);
                }
                return function1.apply((Object)x);
            }

            private final Option applyOrElse$$anonfun$2() {
                return Option$.MODULE$.apply((Object)this.conn$32.getErrorStream());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$2()}, serializedLambda);
            }
        }, this.F());
    }

    private final Object configureSsl$$anonfun$1() {
        return this.F().unit();
    }

    private static final void configureSsl$$anonfun$2$$anonfun$1(HttpsURLConnection connSsl$2, HostnameVerifier hv$1) {
        connSsl$2.setHostnameVerifier(hv$1);
    }

    private final Object configureSsl$$anonfun$3$$anonfun$1() {
        return this.F().unit();
    }

    private static final void configureSsl$$anonfun$3$$anonfun$2$$anonfun$1(HttpsURLConnection connSsl$5, SSLSocketFactory sslf$1) {
        connSsl$5.setSSLSocketFactory(sslf$1);
    }
}

