/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.Semigroupal;
import cats.effect.SyncIO;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.Message;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.NotGiven$;

public final class RequestLogger$
implements Serializable {
    private static final SelfAwareStructuredLogger<SyncIO> logger;
    private static final String defaultRequestColor;
    public static final RequestLogger$ MODULE$;

    private RequestLogger$() {
    }

    static {
        MODULE$ = new RequestLogger$();
        logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.client.middleware.RequestLogger");
        defaultRequestColor = "\u001b[34m";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RequestLogger$.class);
    }

    private <F> Object defaultLogAction(String s, Sync<F> evidence$1) {
        return ((SyncIO)logger.info(() -> RequestLogger$.defaultLogAction$$anonfun$1(s))).to(evidence$1);
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> evidence$1) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> Logger$.MODULE$.logMessage(request, logHeaders, logBody, redactHeadersWhen, (Function1<String, Object>)((Function1)logAction.getOrElse(() -> RequestLogger$.apply$$anonfun$1$$anonfun$1(evidence$1))), evidence$1), evidence$1);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<Object>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> evidence$1) {
        return this.impl(client, true, (Function1 & Serializable)request -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)request, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse(() -> RequestLogger$.logBodyText$$anonfun$1$$anonfun$1(evidence$1)), (Monad)evidence$1), evidence$1);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, Object>> logAction, Function1<Request<F>, Object> requestToText, Async<F> evidence$1) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> {
            Function1 log = (Function1)logAction.getOrElse(() -> RequestLogger$.$anonfun$1(evidence$1));
            return package.all$.MODULE$.toFlatMapOps(requestToText.apply(request), (FlatMap)evidence$1).flatMap(log);
        }, evidence$1);
    }

    public boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Request<F>, Object> logMessage, Async<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> {
            if (!logBody) {
                Resource resource = (Resource)package.all$.MODULE$.catsSyntaxApplyOps((Object)cats.effect.package$.MODULE$.Resource().eval(logMessage.apply(req)));
                return (Resource)ApplyOps$.MODULE$.$times$greater$extension((Object)resource, client.run((Request)req), (Apply)Resource$.MODULE$.catsEffectAsyncForResource(F));
            }
            return cats.effect.package$.MODULE$.Resource().suspend(package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(F.ref((Object)BoxesRunTime.boxToBoolean((boolean)false)), F.ref((Object)package$.MODULE$.Vector().empty()))).mapN((Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Ref hasLogged = (Ref)tuple2._1();
                    Ref vec = (Ref)tuple2._2();
                    Stream newBody = Stream$.MODULE$.eval(vec.get()).flatMap((Function1 & Serializable)v -> Stream$.MODULE$.emits((Seq)v), NotGiven$.MODULE$.value()).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    Object object = package.all$.MODULE$.catsSyntaxIfM(hasLogged.getAndSet((Object)BoxesRunTime.boxToBoolean((boolean)true)), (FlatMap)F);
                    Object logOnceAtEnd = IfMOps$.MODULE$.ifM$extension(object, () -> RequestLogger$.$anonfun$3(F), () -> RequestLogger$.$anonfun$4(logMessage, req, newBody, F), (FlatMap)F);
                    Function1 & Serializable logPipe = (Function1 & Serializable)_$6 -> {
                        Stream stream = Stream$.MODULE$.InvariantOps(_$6);
                        return Stream.InvariantOps$.MODULE$.observe$extension(stream, (Function1 & Serializable)_$7 -> _$7.chunks().flatMap((Function1 & Serializable)s -> Stream$.MODULE$.exec(vec.update((Function1 & Serializable)_$8 -> (Vector)_$8.$colon$plus(s))), NotGiven$.MODULE$.value()), (GenConcurrent)F).onFinalizeWeak(logOnceAtEnd, (Applicative)F);
                    };
                    Resource resp = client.run((Request)req.pipeBodyThrough((Function1)logPipe));
                    return resp.map((Function1 & Serializable)_$9 -> (Response)_$9.pipeBodyThrough((Function1 & Serializable)_$10 -> _$10.onFinalizeWeak(logOnceAtEnd, (Applicative)F))).onFinalize(logOnceAtEnd, (Applicative)F);
                }
                throw new MatchError((Object)tuple2);
            }, (Functor)F, (Semigroupal)F));
        }, F);
    }

    public String defaultRequestColor() {
        return defaultRequestColor;
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, String color, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> F) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable)request -> {
            Object object;
            String methodColor = request.method().isSafe() ? color : "\u001b[33m";
            String prelude = new StringBuilder(14).append(request.httpVersion()).append(" ").append(methodColor).append(request.method()).append("\u001b[0m").append(color).append(" ").append("\u001b[1m").append(request.uri()).append("\u001b[0m").append(color).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)request, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)request, logBody, (GenConcurrent)F);
            if (option instanceof Some) {
                Object textF = ((Some)option).value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)F).map((Function1 & Serializable)text -> new StringBuilder(7).append("body=\"").append((String)text).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = cats.effect.package$.MODULE$.Sync().apply((Sync)F).pure((Object)"");
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)F).map((Function1 & Serializable)body -> new StringBuilder(4).append(color).append(prelude).append(this.spaced$1(headers)).append(this.spaced$1((String)body)).append("\u001b[0m").toString());
        }, F);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> String colored$default$4() {
        return this.defaultRequestColor();
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    private static final String defaultLogAction$$anonfun$1(String s$1) {
        return s$1;
    }

    private static final Function1 apply$$anonfun$1$$anonfun$1(Async evidence$1$2) {
        return (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$1$2);
    }

    private static final Function1 logBodyText$$anonfun$1$$anonfun$1(Async evidence$1$5) {
        return (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$1$5);
    }

    private static final Function1 $anonfun$1(Async evidence$1$8) {
        return (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$1$8);
    }

    private static final Object $anonfun$3(Async F$3) {
        return F$3.unit();
    }

    private static final String $anonfun$4$$anonfun$1$$anonfun$1() {
        return "Error logging request body";
    }

    private static final Object $anonfun$4(Function1 logMessage$3, Request req$2, Stream newBody$1, Async F$4) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(logMessage$3.apply((Object)req$2.withBodyStream(newBody$1)), (ApplicativeError)F$4);
        return ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable t = throwable = x$1;
            return ((SyncIO)logger.error(t, RequestLogger$::$anonfun$4$$anonfun$1$$anonfun$1)).to((Sync)F$4);
        }, (ApplicativeError)F$4);
    }

    private final String spaced$1(String x) {
        if (x.isEmpty()) {
            return x;
        }
        return new StringBuilder(1).append(" ").append(x).toString();
    }
}

