/*
 * Copyright 2021 http4s.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.http4s.crypto

private[http4s] sealed trait HmacKeyGen[F[_]] {
  def generateKey[A <: HmacAlgorithm](algorithm: A): F[SecretKey[A]]
}

private[crypto] trait UnsealedHmacKeyGen[F[_]] extends HmacKeyGen[F]

private[http4s] object HmacKeyGen extends HmacKeyGenCompanionPlatform {

  def apply[F[_]](implicit hkg: HmacKeyGen[F]): hkg.type = hkg

}
