/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.ApplicativeError$;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.NonEmptyList$;
import cats.effect.Clock;
import cats.effect.Clock$;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.ExitCase;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.ResourceLike;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.Timer;
import cats.effect.Timer$;
import cats.effect.concurrent.Ref;
import cats.kernel.Eq;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.SignallingRef;
import fs2.concurrent.SignallingRef$;
import fs2.internal.FreeC;
import fs2.io.tcp.Socket;
import fs2.io.tcp.SocketGroup;
import fs2.io.tcp.SocketOptionMapping;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSParameters$;
import io.chrisdavenport.keypool.Reusable;
import io.chrisdavenport.vault.Vault;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIHostName;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.HttpVersion;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ClientHelpers$ {
    public static ClientHelpers$ MODULE$;

    static {
        new ClientHelpers$();
    }

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request, Option<TLSContext> tlsContextOpt, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$1, Timer<F> evidence$2, ContextShift<F> evidence$3) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, sg, additionalSocketOptions, evidence$1, evidence$2, evidence$3);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext> tlsContextOpt, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$4, Timer<F> evidence$5, ContextShift<F> evidence$6) {
        return Resource$.MODULE$.liftF(this.getAddress(requestKey, (Sync<F>)evidence$4), evidence$4).flatMap((Function1 & Serializable & scala.Serializable)address -> {
            InetSocketAddress x$1 = address;
            List x$2 = additionalSocketOptions;
            boolean x$3 = sg.client$default$2();
            int x$4 = sg.client$default$3();
            int x$5 = sg.client$default$4();
            boolean x$6 = sg.client$default$5();
            boolean x$7 = sg.client$default$6();
            return sg.client(x$1, x$3, x$4, x$5, x$6, x$7, x$2, evidence$4, evidence$6).flatMap((Function1 & Serializable & scala.Serializable)initSocket -> ((ResourceLike)(package.all$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https()) ? tlsContextOpt.fold((Function0 & Serializable & scala.Serializable)() -> (Resource)ApplicativeError$.MODULE$.apply((ApplicativeError)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)).raiseError((Object)new Throwable("EmberClient Not Configured for Https")), (Function1 & Serializable & scala.Serializable)tlsContext -> {
                Some x$8 = new Some((Object)new .colon.colon((Object)new SNIHostName(address.getHostName()), (List)Nil$.MODULE$));
                Option x$9 = TLSParameters$.MODULE$.apply$default$1();
                Option x$10 = TLSParameters$.MODULE$.apply$default$2();
                Option x$11 = TLSParameters$.MODULE$.apply$default$3();
                Option x$12 = TLSParameters$.MODULE$.apply$default$4();
                Option x$13 = TLSParameters$.MODULE$.apply$default$5();
                Option x$14 = TLSParameters$.MODULE$.apply$default$6();
                Option x$15 = TLSParameters$.MODULE$.apply$default$7();
                Option x$16 = TLSParameters$.MODULE$.apply$default$9();
                boolean x$17 = TLSParameters$.MODULE$.apply$default$10();
                boolean x$18 = TLSParameters$.MODULE$.apply$default$11();
                boolean x$19 = TLSParameters$.MODULE$.apply$default$12();
                Option x$20 = TLSParameters$.MODULE$.apply$default$13();
                return (Resource)package.all$.MODULE$.toFunctorOps((Object)tlsContext.client(initSocket, TLSParameters$.MODULE$.apply(x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option)x$8, x$16, x$17, x$18, x$19, x$20), (Option)tlsContext.client$default$3(), evidence$4, evidence$6), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)).widen();
            }) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(initSocket), (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$4)))).map((Function1 & Serializable & scala.Serializable)socket -> new RequestKeySocket(socket, requestKey), (Applicative)evidence$4));
        });
    }

    public <F> Resource<F, Response<F>> request(Request<F> request, RequestKeySocket<F> requestKeySocket, Ref<F, Reusable> reuseable, int chunkSize, int maxResponseHeaderSize, Duration timeout, Option<User.minusAgent> userAgent, Concurrent<F> evidence$7, ContextShift<F> evidence$8, Timer<F> evidence$9) {
        Timer RT = Timer.TimerOps$.MODULE$.mapK$extension(Timer$.MODULE$.TimerOps(Timer$.MODULE$.apply(evidence$9)), Resource$.MODULE$.liftK(evidence$7));
        return Resource$.MODULE$.liftF(this.preprocessRequest(request, userAgent, (Monad<F>)evidence$7, (Clock<F>)Clock$.MODULE$.extractFromTimer(evidence$9)), evidence$7).flatMap((Function1 & Serializable & scala.Serializable)processedReq -> ClientHelpers$.writeRead$1(processedReq, timeout, requestKeySocket, RT, evidence$7, maxResponseHeaderSize, chunkSize, evidence$9).flatMap((Function1 & Serializable & scala.Serializable)resp -> MODULE$.postProcessResponse((Request)processedReq, (Response)resp, reuseable, evidence$7)));
    }

    public <F> F preprocessRequest(Request<F> req, Option<User.minusAgent> userAgent, Monad<F> evidence$10, Clock<F> evidence$11) {
        Connection connection = (Connection)Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)Connection$.MODULE$).fold((Function0 & Serializable & scala.Serializable)() -> new Connection(NonEmptyList$.MODULE$.of((Object)CIString$.MODULE$.apply("keep-alive"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new CIString[0]))), (Function1 & Serializable & scala.Serializable)x -> (Connection)Predef$.MODULE$.identity(x));
        Option userAgentHeader = Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)User$minusAgent$.MODULE$).orElse((Function0 & Serializable & scala.Serializable)() -> userAgent);
        return (F)package.all$.MODULE$.toFunctorOps(Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)Date$.MODULE$).fold((Function0 & Serializable & scala.Serializable)() -> package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current((Functor)evidence$10, evidence$11), (Functor)evidence$10).map((Function1 & Serializable & scala.Serializable)x$2 -> new Date(x$2)), (Function1 & Serializable & scala.Serializable)x$3 -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(x$3), (Applicative)evidence$10)), evidence$10).map((Function1 & Serializable & scala.Serializable)date -> (Request)req.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{date, connection})).putHeaders(Option$.MODULE$.option2Iterable(userAgentHeader).toSeq()));
    }

    public <F> Resource<F, Response<F>> postProcessResponse(Request<F> req, Response<F> resp, Ref<F, Reusable> canBeReused, Concurrent<F> evidence$12) {
        FreeC x$1 = Stream$.MODULE$.onFinalizeCaseWeak$extension(resp.body(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            ExitCase exitCase = x0$1;
            if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                boolean requestClose = Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)Connection$.MODULE$).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.hasClose()));
                boolean responseClose = Headers$.MODULE$.get$extension0(resp.headers(), (HeaderKey.Extractable)Connection$.MODULE$).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.hasClose()));
                object = requestClose || responseClose ? Applicative$.MODULE$.apply((Applicative)evidence$12).unit() : canBeReused.set((Object)Reusable.Reuse$.MODULE$);
            } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                object = Applicative$.MODULE$.apply((Applicative)evidence$12).unit();
            } else if (exitCase instanceof ExitCase.Error) {
                object = Applicative$.MODULE$.apply((Applicative)evidence$12).unit();
            } else {
                throw new MatchError((Object)exitCase);
            }
            return object;
        }, evidence$12);
        Status x$2 = resp.copy$default$1();
        HttpVersion x$3 = resp.copy$default$2();
        List x$4 = resp.copy$default$3();
        Vault x$5 = resp.copy$default$5();
        Response out = resp.copy(x$2, x$3, x$4, x$1, x$5);
        return Resource$.MODULE$.pure((Object)out, evidence$12);
    }

    private <F> F getAddress(RequestKey requestKey, Sync<F> evidence$13) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) {
            throw new MatchError((Object)requestKey2);
        }
        Uri.Scheme s = requestKey2.scheme();
        Uri.Authority auth = requestKey2.authority();
        int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Uri.Scheme scheme = s;
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null) ? 443 : 80;
        }));
        String host = auth.host().value();
        Object object = Sync$.MODULE$.apply(evidence$13).delay((Function0 & Serializable & scala.Serializable)() -> new InetSocketAddress(host, port));
        return (F)object;
    }

    private static final Resource writeRequestToSocket$1(Request req, Socket socket, Option timeout, Concurrent evidence$7$1) {
        return (Resource)Stream$.MODULE$.compile$extension(Stream$.MODULE$.through$extension(Encoder$.MODULE$.reqToBytes(req, Encoder$.MODULE$.reqToBytes$default$2(), (Sync)evidence$7$1), socket.writes(timeout)), Stream.Compiler$.MODULE$.syncInstance((Sync)evidence$7$1)).resource(Stream.Compiler$.MODULE$.resourceInstance((Sync)evidence$7$1)).drain();
    }

    private static final Resource onNoTimeout$1(Request req, Socket socket, Concurrent evidence$7$1, int maxResponseHeaderSize$1, int chunkSize$1) {
        return (Resource)FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps((Object)ClientHelpers$.writeRequestToSocket$1(req, socket, (Option)None$.MODULE$, evidence$7$1), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$7$1)), (Function0 & Serializable & scala.Serializable)() -> Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, socket.reads(chunkSize$1, (Option)None$.MODULE$), evidence$7$1), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$7$1));
    }

    public static final /* synthetic */ Resource $anonfun$request$5(FiniteDuration fin$1, long start$1, int maxResponseHeaderSize$1, Socket socket$2, SignallingRef timeoutSignal$1, int chunkSize$1, Concurrent evidence$7$1, Timer evidence$9$1, long sent) {
        FiniteDuration remains = fin$1.$minus(new package.DurationLong(package$.MODULE$.DurationLong(sent - start$1)).millis());
        return Parser.Response$.MODULE$.parser(maxResponseHeaderSize$1, Util$.MODULE$.readWithTimeout(socket$2, start$1, remains, timeoutSignal$1.get(), chunkSize$1, (ApplicativeError)evidence$7$1, Clock$.MODULE$.extractFromTimer(evidence$9$1)), evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)resp -> Resource$.MODULE$.liftF(package.all$.MODULE$.toFunctorOps(timeoutSignal$1.set((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Functor)evidence$7$1).void(), (Applicative)evidence$7$1).map((Function1 & Serializable & scala.Serializable)_ -> resp, (Applicative)evidence$7$1));
    }

    public static final /* synthetic */ Resource $anonfun$request$2(Request req$1, Socket socket$2, FiniteDuration fin$1, Concurrent evidence$7$1, Timer RT$1, int maxResponseHeaderSize$1, int chunkSize$1, Timer evidence$9$1, long start) {
        return ClientHelpers$.writeRequestToSocket$1(req$1, socket$2, Option$.MODULE$.apply((Object)fin$1), evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> Resource$.MODULE$.liftF(SignallingRef$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), evidence$7$1), (Applicative)evidence$7$1).flatMap((Function1 & Serializable & scala.Serializable)timeoutSignal -> ((ResourceLike)RT$1.clock().realTime(TimeUnit.MILLISECONDS)).flatMap((Function1 & Serializable & scala.Serializable)sent -> ClientHelpers$.$anonfun$request$5(fin$1, start, maxResponseHeaderSize$1, socket$2, timeoutSignal, chunkSize$1, evidence$7$1, evidence$9$1, BoxesRunTime.unboxToLong((Object)sent)))));
    }

    private static final Resource onTimeout$1(Request req, Socket socket, FiniteDuration fin, Timer RT$1, Concurrent evidence$7$1, int maxResponseHeaderSize$1, int chunkSize$1, Timer evidence$9$1) {
        return ((ResourceLike)RT$1.clock().realTime(TimeUnit.MILLISECONDS)).flatMap((Function1 & Serializable & scala.Serializable)start -> ClientHelpers$.$anonfun$request$2(req, socket, fin, evidence$7$1, RT$1, maxResponseHeaderSize$1, chunkSize$1, evidence$9$1, BoxesRunTime.unboxToLong((Object)start)));
    }

    private static final Resource writeRead$1(Request req, Duration timeout$1, RequestKeySocket requestKeySocket$1, Timer RT$1, Concurrent evidence$7$1, int maxResponseHeaderSize$1, int chunkSize$1, Timer evidence$9$1) {
        Resource resource;
        Duration duration = timeout$1;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            resource = ClientHelpers$.onTimeout$1(req, requestKeySocket$1.socket(), finiteDuration, RT$1, evidence$7$1, maxResponseHeaderSize$1, chunkSize$1, evidence$9$1);
        } else {
            resource = ClientHelpers$.onNoTimeout$1(req, requestKeySocket$1.socket(), evidence$7$1, maxResponseHeaderSize$1, chunkSize$1);
        }
        return resource;
    }

    private ClientHelpers$() {
        MODULE$ = this;
    }
}

