/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Monad;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Clock;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.kernel.Eq;
import cats.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.Host$;
import com.comcast.ip4s.Hostname;
import com.comcast.ip4s.IDN;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSParameters$;
import java.io.Serializable;
import java.net.SocketException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SNIHostName;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.EmberConnection;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.client.RequestKeySocket$;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.typelevel.ci.CIString;
import org.typelevel.keypool.KeyPool;
import org.typelevel.keypool.Managed;
import org.typelevel.keypool.Reusable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ClientHelpers$
implements Serializable {
    public static final ClientHelpers$ MODULE$ = new ClientHelpers$();

    private ClientHelpers$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClientHelpers$.class);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request, Option<TLSContext<F>> tlsContextOpt, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, Sync<F> evidence$1) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, sg, additionalSocketOptions, evidence$1);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext<F>> tlsContextOpt, SocketGroup<F> sg, List<SocketOption> additionalSocketOptions, Sync<F> evidence$2) {
        return Resource$.MODULE$.eval(this.getAddress(requestKey, evidence$2)).flatMap((Function1 & Serializable)address -> sg.client(address, additionalSocketOptions).flatMap((Function1 & Serializable)initSocket -> {
            Resource resource;
            if (package.all$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https())) {
                resource = (Resource)tlsContextOpt.fold(() -> this.requestKeyToSocketWithKey$$anonfun$2$$anonfun$1$$anonfun$1(evidence$2), (Function1 & Serializable)tlsContext -> {
                    Option option = this.extractHostname(address.host()).map((Function1 & Serializable)_$4 -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SNIHostName[]{_$4})));
                    Option option2 = TLSParameters$.MODULE$.apply$default$1();
                    Option option3 = TLSParameters$.MODULE$.apply$default$2();
                    Option option4 = TLSParameters$.MODULE$.apply$default$3();
                    Option option5 = TLSParameters$.MODULE$.apply$default$4();
                    Option option6 = TLSParameters$.MODULE$.apply$default$5();
                    Option option7 = TLSParameters$.MODULE$.apply$default$6();
                    Option option8 = TLSParameters$.MODULE$.apply$default$7();
                    Option option9 = TLSParameters$.MODULE$.apply$default$9();
                    boolean bl = TLSParameters$.MODULE$.apply$default$10();
                    boolean bl2 = TLSParameters$.MODULE$.apply$default$11();
                    boolean bl3 = TLSParameters$.MODULE$.apply$default$12();
                    Option option10 = TLSParameters$.MODULE$.apply$default$13();
                    return (Resource)package.all$.MODULE$.toFunctorOps((Object)tlsContext.client(initSocket, TLSParameters$.MODULE$.apply(option2, option3, option4, option5, option6, option7, option8, option, option9, bl, bl2, bl3, option10), tlsContext.client$default$3()), (Functor)Resource$.MODULE$.catsEffectSyncForResource(evidence$2)).widen();
                });
            } else {
                Socket socket2 = (Socket)package.all$.MODULE$.catsSyntaxApplicativeId(initSocket);
                resource = (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)socket2, (Applicative)Resource$.MODULE$.catsEffectSyncForResource(evidence$2));
            }
            return resource.map((Function1 & Serializable)socket -> RequestKeySocket$.MODULE$.apply(socket, requestKey));
        }));
    }

    private Option<SNIHostName> extractHostname(Host from) {
        Option option;
        block3: {
            Host host;
            Host host2 = from;
            while (true) {
                if ((host = host2) instanceof Hostname) {
                    Hostname hostname = (Hostname)host;
                    SNIHostName sNIHostName = (SNIHostName)package.all$.MODULE$.catsSyntaxOptionId((Object)new SNIHostName(hostname.normalized().toString()));
                    option = OptionIdOps$.MODULE$.some$extension((Object)sNIHostName);
                    break block3;
                }
                if (host instanceof IpAddress) {
                    IpAddress address = (IpAddress)host;
                    SNIHostName sNIHostName = (SNIHostName)package.all$.MODULE$.catsSyntaxOptionId((Object)new SNIHostName(address.toString()));
                    option = OptionIdOps$.MODULE$.some$extension((Object)sNIHostName);
                    break block3;
                }
                if (!(host instanceof IDN)) break;
                IDN idn = (IDN)host;
                host2 = idn.hostname();
            }
            throw new MatchError((Object)host);
        }
        return option;
    }

    public <F> Object request(Request<F> request, EmberConnection<F> connection, int chunkSize, int maxResponseHeaderSize, Duration idleTimeout, Duration timeout, Option<User.minusAgent> userAgent, Async<F> evidence$3) {
        return package.all$.MODULE$.toFlatMapOps(this.preprocessRequest(request, userAgent, (Monad<F>)evidence$3, (Clock<F>)evidence$3), evidence$3).flatMap((Function1 & Serializable)processedReq -> package.all$.MODULE$.toFunctorOps(this.writeRead$3(connection, chunkSize, maxResponseHeaderSize, idleTimeout, timeout, evidence$3, (Request)processedReq), (Functor)evidence$3).map((Function1 & Serializable)res -> res));
    }

    public <F> Object preprocessRequest(Request<F> req, Option<User.minusAgent> userAgent, Monad<F> evidence$4, Clock<F> evidence$5) {
        Connection connection = (Connection)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).fold(this::$anonfun$1, (Function1 & Serializable)x -> (Connection)Predef$.MODULE$.identity(x));
        Option userAgentHeader = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(User$minusAgent$.MODULE$.headerInstance())).orElse(() -> this.$anonfun$3(userAgent));
        return package.all$.MODULE$.toFunctorOps(Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Date$.MODULE$.headerInstance())).fold(() -> this.preprocessRequest$$anonfun$1(evidence$4, evidence$5), (Function1 & Serializable)_$10 -> {
            Date date = (Date)package.all$.MODULE$.catsSyntaxApplicativeId(_$10);
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)date, (Applicative)evidence$4);
        }), evidence$4).map((Function1 & Serializable)date -> (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance())})).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.foldablesToRaw((Object)userAgentHeader, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, User$minusAgent$.MODULE$.headerInstance()))})));
    }

    public <F> Object postProcessResponse(Request<F> req, Response<F> resp, Object drain, Ref<F, byte[]> nextBytes, Ref<F, Reusable> canBeReused, GenConcurrent<F, Throwable> F) {
        return package.all$.MODULE$.toFlatMapOps(drain, F).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                byte[] bytes = (byte[])((Some)option).value();
                boolean requestClose = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$12 -> _$12.hasClose());
                boolean responseClose = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$13 -> _$13.hasClose());
                if (requestClose || responseClose) {
                    object = F.unit();
                } else {
                    Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(nextBytes.set((Object)bytes), (FlatMap)F);
                    object = FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.postProcessResponse$$anonfun$2$$anonfun$1(canBeReused), (FlatMap)F);
                }
            } else if (None$.MODULE$.equals(option)) {
                object = F.unit();
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private <F> Object getAddress(RequestKey requestKey, Sync<F> evidence$6) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) {
            throw new MatchError((Object)requestKey2);
        }
        RequestKey requestKey3 = RequestKey$.MODULE$.unapply(requestKey2);
        Uri.Scheme scheme = requestKey3._1();
        Uri.Authority authority = requestKey3._2();
        Uri.Scheme s = scheme;
        Uri.Authority auth = authority;
        int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse(() -> this.$anonfun$4(s)));
        String host = auth.host().value();
        return Sync$.MODULE$.apply(evidence$6).delay(() -> this.getAddress$$anonfun$1(port, host));
    }

    public <F> Resource<F, Managed<F, EmberConnection<F>>> getValidManaged(KeyPool<F, RequestKey, EmberConnection<F>> pool, Request<F> request, Sync<F> evidence$7) {
        return pool.take((Object)RequestKey$.MODULE$.fromRequest(request)).flatMap((Function1 & Serializable)managed -> {
            Resource resource = (Resource)package.all$.MODULE$.catsSyntaxIfM((Object)Resource$.MODULE$.eval(((EmberConnection)managed.value()).keySocket().socket().isOpen()), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$7));
            return (Resource)IfMOps$.MODULE$.ifM$extension((Object)resource, () -> this.getValidManaged$$anonfun$2$$anonfun$1(evidence$7, managed), () -> this.getValidManaged$$anonfun$4$$anonfun$3(pool, request, evidence$7, managed), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$7));
        });
    }

    private final Resource requestKeyToSocketWithKey$$anonfun$2$$anonfun$1$$anonfun$1(Sync evidence$2$3) {
        return (Resource)package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)Resource$.MODULE$.catsEffectSyncForResource(evidence$2$3)).raiseError((Object)new Throwable("EmberClient Not Configured for Https"));
    }

    private final Object writeRequestToSocket$3(Duration idleTimeout$3, Async evidence$3$3, Request req, Socket socket) {
        return Encoder$.MODULE$.reqToBytes(req, Encoder$.MODULE$.reqToBytes$default$2()).through((Function1 & Serializable)_$7 -> _$7.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout$3, (GenTemporal)evidence$3$3))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)evidence$3$3))).drain();
    }

    private final Object writeRead$2$$anonfun$2(EmberConnection connection$2, int chunkSize$2, int maxResponseHeaderSize$2, Duration idleTimeout$5, Duration timeout$2, Async evidence$3$5) {
        return package.all$.MODULE$.toFlatMapOps(connection$2.nextBytes().getAndSet((Object)Array$.MODULE$.emptyByteArray()), (FlatMap)evidence$3$5).flatMap((Function1 & Serializable)head -> {
            Object parse = Parser.Response$.MODULE$.parser(maxResponseHeaderSize$2, head, Util$.MODULE$.timeoutMaybe(connection$2.keySocket().socket().read(chunkSize$2), idleTimeout$5, (GenTemporal)evidence$3$5), (GenConcurrent)evidence$3$5);
            return Util$.MODULE$.timeoutToMaybe(parse, timeout$2, package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)evidence$3$5).raiseError((Object)new TimeoutException("Timed Out on EmberClient Header Receive Timeout: " + timeout$2)), (GenTemporal)evidence$3$5);
        });
    }

    private final Object writeRead$3(EmberConnection connection$1, int chunkSize$1, int maxResponseHeaderSize$1, Duration idleTimeout$4, Duration timeout$1, Async evidence$3$4, Request req) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.writeRequestToSocket$3(idleTimeout$4, evidence$3$4, req, connection$1.keySocket().socket()), (FlatMap)evidence$3$4);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.writeRead$2$$anonfun$2(connection$1, chunkSize$1, maxResponseHeaderSize$1, idleTimeout$4, timeout$1, evidence$3$4), (FlatMap)evidence$3$4);
    }

    private final Connection $anonfun$1() {
        return Connection$.MODULE$.apply(NonEmptyList$.MODULE$.of((Object)org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep-alive"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])));
    }

    private final Option $anonfun$3(Option userAgent$1) {
        return userAgent$1;
    }

    private final Object preprocessRequest$$anonfun$1(Monad evidence$4$1, Clock evidence$5$1) {
        return package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current((Functor)evidence$4$1, evidence$5$1), (Functor)evidence$4$1).map((Function1 & Serializable)_$9 -> Date$.MODULE$.apply(_$9));
    }

    private final Object postProcessResponse$$anonfun$2$$anonfun$1(Ref canBeReused$2) {
        return canBeReused$2.set((Object)Reusable.Reuse$.MODULE$);
    }

    private final int $anonfun$4(Uri.Scheme s$1) {
        Uri.Scheme scheme = s$1;
        Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
        return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null) ? 443 : 80;
    }

    private final SocketAddress getAddress$$anonfun$1(int port$1, String host$1) {
        return SocketAddress$.MODULE$.apply((Host)Host$.MODULE$.fromString(host$1).get(), (Port)Port$.MODULE$.fromInt(port$1).get());
    }

    private final Resource getValidManaged$$anonfun$2$$anonfun$1(Sync evidence$7$2, Managed managed$1) {
        Managed managed = (Managed)package.all$.MODULE$.catsSyntaxApplicativeId((Object)managed$1);
        return (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)managed, (Applicative)Resource$.MODULE$.catsEffectSyncForResource(evidence$7$2));
    }

    private final Resource getValidManaged$$anonfun$3$$anonfun$2$$anonfun$1(KeyPool pool$3, Request request$3, Sync evidence$7$4) {
        return this.getValidManaged(pool$3, request$3, evidence$7$4);
    }

    private final Resource getValidManaged$$anonfun$4$$anonfun$3(KeyPool pool$2, Request request$2, Sync evidence$7$3, Managed managed$2) {
        Resource resource;
        if (managed$2.isReused()) {
            Resource resource2 = (Resource)package.all$.MODULE$.catsSyntaxFlatMapOps((Object)Resource$.MODULE$.eval(managed$2.canBeReused().set((Object)Reusable.DontReuse$.MODULE$)), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$7$3));
            resource = (Resource)FlatMapOps$.MODULE$.$greater$greater$extension((Object)resource2, () -> this.getValidManaged$$anonfun$3$$anonfun$2$$anonfun$1(pool$2, request$2, evidence$7$3), (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(evidence$7$3));
        } else {
            resource = Resource$.MODULE$.eval(Sync$.MODULE$.apply(evidence$7$3).raiseError((Object)new SocketException("Fresh connection from pool was not open")));
        }
        return resource;
    }
}

