/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.client.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.effect.Clock;
import cats.effect.Clock$;
import cats.effect.Concurrent;
import cats.effect.Concurrent$;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.Timer;
import cats.effect.concurrent.Ref;
import cats.effect.syntax.ConcurrentOps$;
import cats.kernel.Eq;
import cats.package;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.tcp.Socket;
import fs2.io.tcp.SocketGroup;
import fs2.io.tcp.SocketOptionMapping;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSParameters$;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SNIHostName;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.ember.client.EmberConnection;
import org.http4s.ember.client.RequestKeySocket;
import org.http4s.ember.client.RequestKeySocket$;
import org.http4s.ember.client.internal.ClientHelpers$RetryLogic$;
import org.http4s.ember.core.EmberException;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.keypool.KeyPool;
import org.typelevel.keypool.Managed;
import org.typelevel.keypool.Reusable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ClientHelpers$
implements Serializable {
    public static final ClientHelpers$RetryLogic$ RetryLogic;
    public static final ClientHelpers$ MODULE$;

    private ClientHelpers$() {
    }

    static {
        MODULE$ = new ClientHelpers$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClientHelpers$.class);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestToSocketWithKey(Request<F> request, Option<TLSContext> tlsContextOpt, boolean enableEndpointValidation, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$1, ContextShift<F> evidence$2) {
        RequestKey requestKey = RequestKey$.MODULE$.fromRequest(request);
        return this.requestKeyToSocketWithKey(requestKey, tlsContextOpt, enableEndpointValidation, sg, additionalSocketOptions, evidence$1, evidence$2);
    }

    public <F> Resource<F, RequestKeySocket<F>> requestKeyToSocketWithKey(RequestKey requestKey, Option<TLSContext> tlsContextOpt, boolean enableEndpointValidation, SocketGroup sg, List<SocketOptionMapping<?>> additionalSocketOptions, Concurrent<F> evidence$3, ContextShift<F> evidence$4) {
        return Resource$.MODULE$.eval(this.getAddress(requestKey, (Sync<F>)evidence$3), evidence$3).flatMap((Function1 & Serializable)address -> sg.client(address, sg.client$default$2(), sg.client$default$3(), sg.client$default$4(), sg.client$default$5(), sg.client$default$6(), additionalSocketOptions, evidence$3, evidence$4).flatMap((Function1 & Serializable)initSocket -> {
            Resource resource;
            if (package.all$.MODULE$.catsSyntaxEq((Object)requestKey.scheme(), (Eq)Uri.Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq((Object)Uri.Scheme$.MODULE$.https())) {
                resource = (Resource)tlsContextOpt.fold(() -> this.requestKeyToSocketWithKey$$anonfun$2$$anonfun$1$$anonfun$1(evidence$3), (Function1 & Serializable)tlsContext -> {
                    Some some = Some$.MODULE$.apply(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SNIHostName[]{new SNIHostName(address.getHostName())})));
                    None$ none$ = enableEndpointValidation ? Some$.MODULE$.apply((Object)"HTTPS") : None$.MODULE$;
                    Option option = TLSParameters$.MODULE$.apply$default$1();
                    Option option2 = TLSParameters$.MODULE$.apply$default$2();
                    Option option3 = TLSParameters$.MODULE$.apply$default$3();
                    Option option4 = TLSParameters$.MODULE$.apply$default$4();
                    Option option5 = TLSParameters$.MODULE$.apply$default$6();
                    Option option6 = TLSParameters$.MODULE$.apply$default$7();
                    Option option7 = TLSParameters$.MODULE$.apply$default$9();
                    boolean bl = TLSParameters$.MODULE$.apply$default$10();
                    boolean bl2 = TLSParameters$.MODULE$.apply$default$11();
                    boolean bl3 = TLSParameters$.MODULE$.apply$default$12();
                    Option option8 = TLSParameters$.MODULE$.apply$default$13();
                    return (Resource)package.all$.MODULE$.toFunctorOps((Object)tlsContext.client(initSocket, TLSParameters$.MODULE$.apply(option, option2, option3, option4, (Option)none$, option5, option6, (Option)some, option7, bl, bl2, bl3, option8), (Option)tlsContext.client$default$3(), evidence$3, evidence$4), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$3)).widen();
                });
            } else {
                Socket socket2 = (Socket)package.all$.MODULE$.catsSyntaxApplicativeId(initSocket);
                resource = (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)socket2, (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$3));
            }
            return resource.map((Function1 & Serializable)socket -> RequestKeySocket$.MODULE$.apply(socket, requestKey), (Applicative)evidence$3);
        }));
    }

    public <F> Object request(Request<F> request, EmberConnection<F> connection, int chunkSize, int maxResponseHeaderSize, Duration idleTimeout, Duration timeout, Option<User.minusAgent> userAgent, Concurrent<F> evidence$5, Timer<F> evidence$6) {
        Object object = package.all$.MODULE$.catsSyntaxMonadError(package.all$.MODULE$.toFlatMapOps(this.preprocessRequest(request, userAgent, (Monad<F>)evidence$5, (Clock<F>)Clock$.MODULE$.extractFromTimer(evidence$6)), evidence$5).flatMap((Function1 & Serializable)processedReq -> package.all$.MODULE$.toFunctorOps(this.writeRead$6(connection, chunkSize, maxResponseHeaderSize, idleTimeout, timeout, evidence$5, evidence$6, (Request)processedReq), (Functor)evidence$5).map((Function1 & Serializable)res -> res)), evidence$5);
        return MonadErrorOps$.MODULE$.adaptError$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                boolean bl;
                Throwable throwable = x;
                if (throwable instanceof EmberException.EmptyStream) {
                    EmberException.EmptyStream e = (EmberException.EmptyStream)throwable;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Object object;
                Throwable throwable = x;
                if (throwable instanceof EmberException.EmptyStream) {
                    EmberException.EmptyStream e = (EmberException.EmptyStream)throwable;
                    object = new ClosedChannelException(e){
                        {
                            this.initCause((Throwable)e$1);
                        }

                        public String getMessage() {
                            return "Remote Disconnect: Received zero bytes after sending request";
                        }
                    };
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }, evidence$5);
    }

    public <F> Object preprocessRequest(Request<F> req, Option<User.minusAgent> userAgent, Monad<F> evidence$7, Clock<F> evidence$8) {
        Connection connection = (Connection)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).fold(this::$anonfun$1, (Function1 & Serializable)x -> (Connection)Predef$.MODULE$.identity(x));
        Option userAgentHeader = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(User$minusAgent$.MODULE$.headerInstance())).orElse(() -> this.$anonfun$3(userAgent));
        return package.all$.MODULE$.toFunctorOps(Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Date$.MODULE$.headerInstance())).fold(() -> this.preprocessRequest$$anonfun$1(evidence$7, evidence$8), (Function1 & Serializable)_$8 -> {
            Date date = (Date)package.all$.MODULE$.catsSyntaxApplicativeId(_$8);
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)date, (Applicative)evidence$7);
        }), evidence$7).map((Function1 & Serializable)date -> (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance())})).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.foldablesToRaw((Object)userAgentHeader, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.modelledHeadersToRaw(h, User$minusAgent$.MODULE$.headerInstance()))})));
    }

    public <F> Object postProcessResponse(Request<F> req, Response<F> resp, Object drain, Ref<F, byte[]> nextBytes, Ref<F, Reusable> canBeReused, Concurrent<F> F) {
        return package.all$.MODULE$.toFlatMapOps(drain, F).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                byte[] bytes = (byte[])((Some)option).value();
                boolean requestClose = Util$.MODULE$.connectionFor(req.httpVersion(), req.headers()).hasClose();
                boolean responseClose = Util$.MODULE$.connectionFor(resp.httpVersion(), resp.headers()).hasClose();
                if (requestClose || responseClose) {
                    object = F.unit();
                } else {
                    Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(nextBytes.set((Object)bytes), (FlatMap)F);
                    object = FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.postProcessResponse$$anonfun$2$$anonfun$1(canBeReused), (FlatMap)F);
                }
            } else if (None$.MODULE$.equals(option)) {
                object = F.unit();
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private <F> Object getAddress(RequestKey requestKey, Sync<F> evidence$9) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) {
            throw new MatchError((Object)requestKey2);
        }
        RequestKey requestKey3 = RequestKey$.MODULE$.unapply(requestKey2);
        Uri.Scheme scheme = requestKey3._1();
        Uri.Authority authority = requestKey3._2();
        Uri.Scheme s = scheme;
        Uri.Authority auth = authority;
        int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse(() -> this.$anonfun$4(s)));
        String host = auth.host().value();
        return Sync$.MODULE$.apply(evidence$9).delay(() -> this.getAddress$$anonfun$1(port, host));
    }

    public <F> Resource<F, Managed<F, EmberConnection<F>>> getValidManaged(KeyPool<F, RequestKey, EmberConnection<F>> pool, Request<F> request, Sync<F> evidence$10) {
        return pool.take((Object)RequestKey$.MODULE$.fromRequest(request)).flatMap((Function1 & Serializable)managed -> {
            Resource resource = (Resource)package.all$.MODULE$.catsSyntaxIfM((Object)Resource$.MODULE$.eval(((EmberConnection)managed.value()).keySocket().socket().isOpen(), (Applicative)evidence$10), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$10));
            return (Resource)IfMOps$.MODULE$.ifM$extension((Object)resource, () -> this.getValidManaged$$anonfun$2$$anonfun$1(evidence$10, managed), () -> this.getValidManaged$$anonfun$4$$anonfun$3(pool, request, evidence$10, managed), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$10));
        });
    }

    private final Resource requestKeyToSocketWithKey$$anonfun$2$$anonfun$1$$anonfun$1(Concurrent evidence$3$3) {
        return (Resource)package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$3$3)).raiseError((Object)new Throwable("EmberClient Not Configured for Https"));
    }

    private final Object writeRequestToSocket$1(Concurrent evidence$5$1, Request req, Socket socket, Option timeout) {
        FreeC freeC = Encoder$.MODULE$.reqToBytes(req, Encoder$.MODULE$.reqToBytes$default$2(), (ApplicativeError)evidence$5$1);
        FreeC freeC2 = Stream$.MODULE$.through$extension(freeC, socket.writes(timeout));
        return Stream$.MODULE$.compile$extension(freeC2, Stream.Compiler$.MODULE$.syncInstance((Sync)evidence$5$1)).drain();
    }

    private final Object writeRead$1$$anonfun$1$$anonfun$1$$anonfun$1(Object parse$1) {
        return parse$1;
    }

    private final Object writeRead$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Concurrent evidence$5$6, FiniteDuration duration$1) {
        return package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)evidence$5$6).raiseError((Object)new TimeoutException("Timed Out on EmberClient Header Receive Timeout: " + duration$1));
    }

    private final Object writeRead$5$$anonfun$5(EmberConnection connection$2, int chunkSize$2, int maxResponseHeaderSize$2, Duration idleTimeout$2, Duration timeout$2, Concurrent evidence$5$3, Timer evidence$6$2) {
        return package.all$.MODULE$.toFlatMapOps(connection$2.nextBytes().getAndSet((Object)Array$.MODULE$.emptyByteArray()), (FlatMap)evidence$5$3).flatMap((Function1 & Serializable)head -> {
            Option finiteDuration = Util$.MODULE$.durationToFinite(timeout$2);
            Object parse = Parser.Response$.MODULE$.parser(maxResponseHeaderSize$2, head, connection$2.keySocket().socket().read(chunkSize$2, Util$.MODULE$.durationToFinite(idleTimeout$2)), evidence$5$3);
            return finiteDuration.fold(() -> this.writeRead$1$$anonfun$1$$anonfun$1$$anonfun$1(parse), (Function1 & Serializable)duration -> {
                Object object = cats.effect.implicits.package$.MODULE$.catsEffectSyntaxConcurrent(parse);
                return ConcurrentOps$.MODULE$.timeoutTo$extension(object, duration, Concurrent$.MODULE$.apply(evidence$5$3).defer(() -> this.writeRead$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(evidence$5$3, duration)), evidence$5$3, evidence$6$2);
            });
        });
    }

    private final Object writeRead$6(EmberConnection connection$1, int chunkSize$1, int maxResponseHeaderSize$1, Duration idleTimeout$1, Duration timeout$1, Concurrent evidence$5$2, Timer evidence$6$1, Request req) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.writeRequestToSocket$1(evidence$5$2, req, connection$1.keySocket().socket(), Util$.MODULE$.durationToFinite(idleTimeout$1)), (FlatMap)evidence$5$2);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.writeRead$5$$anonfun$5(connection$1, chunkSize$1, maxResponseHeaderSize$1, idleTimeout$1, timeout$1, evidence$5$2, evidence$6$1), (FlatMap)evidence$5$2);
    }

    private final Connection $anonfun$1() {
        return Connection$.MODULE$.apply(NonEmptyList$.MODULE$.of((Object)package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep-alive"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])));
    }

    private final Option $anonfun$3(Option userAgent$1) {
        return userAgent$1;
    }

    private final Object preprocessRequest$$anonfun$1(Monad evidence$7$1, Clock evidence$8$1) {
        return package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current((Functor)evidence$7$1, evidence$8$1), (Functor)evidence$7$1).map((Function1 & Serializable)_$7 -> Date$.MODULE$.apply(_$7));
    }

    private final Object postProcessResponse$$anonfun$2$$anonfun$1(Ref canBeReused$2) {
        return canBeReused$2.set((Object)Reusable.Reuse$.MODULE$);
    }

    private final int $anonfun$4(Uri.Scheme s$1) {
        Uri.Scheme scheme = s$1;
        Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
        return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null) ? 443 : 80;
    }

    private final InetSocketAddress getAddress$$anonfun$1(int port$1, String host$1) {
        return new InetSocketAddress(host$1, port$1);
    }

    private final Resource getValidManaged$$anonfun$2$$anonfun$1(Sync evidence$10$2, Managed managed$1) {
        Managed managed = (Managed)package.all$.MODULE$.catsSyntaxApplicativeId((Object)managed$1);
        return (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)managed, (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$10$2));
    }

    private final Resource getValidManaged$$anonfun$3$$anonfun$2$$anonfun$1(KeyPool pool$3, Request request$3, Sync evidence$10$4) {
        return this.getValidManaged(pool$3, request$3, evidence$10$4);
    }

    private final Resource getValidManaged$$anonfun$4$$anonfun$3(KeyPool pool$2, Request request$2, Sync evidence$10$3, Managed managed$2) {
        Resource resource;
        if (managed$2.isReused()) {
            Resource resource2 = (Resource)package.all$.MODULE$.catsSyntaxFlatMapOps((Object)Resource$.MODULE$.eval(managed$2.canBeReused().set((Object)Reusable.DontReuse$.MODULE$), (Applicative)evidence$10$3), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$10$3));
            resource = (Resource)FlatMapOps$.MODULE$.$greater$greater$extension((Object)resource2, () -> this.getValidManaged$$anonfun$3$$anonfun$2$$anonfun$1(pool$2, request$2, evidence$10$3), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)evidence$10$3));
        } else {
            resource = Resource$.MODULE$.eval(Sync$.MODULE$.apply(evidence$10$3).raiseError((Object)new SocketException("Fresh connection from pool was not open")), (Applicative)evidence$10$3);
        }
        return resource;
    }
}

