/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.MonadError;
import cats.Semigroupal$;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.FoldableOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import fs2.concurrent.Signal;
import fs2.concurrent.Signal$;
import fs2.concurrent.SignallingRef$;
import fs2.io.net.Socket;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Protocol;
import org.http4s.Protocol$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.crypto.Hash$;
import org.http4s.crypto.HashAlgorithm;
import org.http4s.ember.core.Util$;
import org.http4s.ember.server.internal.ServerHelpers$;
import org.http4s.ember.server.internal.WebSocketHelpers;
import org.http4s.ember.server.internal.WebSocketHelpers$BothClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$BrokenPipeError$;
import org.http4s.ember.server.internal.WebSocketHelpers$EndpointClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$KeyNotFound$;
import org.http4s.ember.server.internal.WebSocketHelpers$Open$;
import org.http4s.ember.server.internal.WebSocketHelpers$UpgradeRequired$;
import org.http4s.ember.server.internal.WebSocketHelpers$VersionNotFound$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Sec;
import org.http4s.headers.Sec$minusWebSocket$minusAccept$;
import org.http4s.headers.Sec$minusWebSocket$minusKey$;
import org.http4s.headers.Sec$minusWebSocket$minusVersion$;
import org.http4s.headers.Upgrade;
import org.http4s.headers.Upgrade$;
import org.http4s.syntax.package;
import org.http4s.websocket.FrameTranscoder;
import org.http4s.websocket.Rfc6455$;
import org.http4s.websocket.WebSocket;
import org.http4s.websocket.WebSocketCombinedPipe;
import org.http4s.websocket.WebSocketContext;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketSeparatePipe;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.log4cats.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class WebSocketHelpers$ {
    public static WebSocketHelpers$ MODULE$;
    private final long supportedWebSocketVersion;
    private final CIString upgradeCi;
    private final Protocol webSocketProtocol;
    private final Connection connectionUpgrade;
    private final Upgrade upgradeWebSocket;
    private final ByteVector magic;

    static {
        new WebSocketHelpers$();
    }

    public <F> F upgrade(Socket<F> socket, Request<F> req, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, Function1<Throwable, F> errorHandler, Logger<F> logger, Async<F> F) {
        Object object;
        Either<WebSocketHelpers.ClientHandshakeError, String> either = this.clientHandshake(req);
        if (either instanceof Right) {
            Right right = (Right)either;
            String key = (String)right.value();
            object = ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(this.serverHandshake(key, (MonadError<F, Throwable>)F), F).map((Function1 & Serializable & scala.Serializable)hashBytes -> {
                Sec.minusWebSocket.minusAccept secWebSocketAccept = new Sec.minusWebSocket.minusAccept(hashBytes);
                List headers = Headers$.MODULE$.$plus$plus$extension(ctx.headers(), Headers$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)WebSocketHelpers$.MODULE$.connectionUpgrade, Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)WebSocketHelpers$.MODULE$.upgradeWebSocket, Upgrade$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)secWebSocketAccept, Sec$minusWebSocket$minusAccept$.MODULE$.headerInstance())})));
                return (Response)Response$.MODULE$.apply(Status$.MODULE$.SwitchingProtocols(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withHeaders(headers);
            }), F), errorHandler, F);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            WebSocketHelpers.ClientHandshakeError error = (WebSocketHelpers.ClientHandshakeError)left.value();
            object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(error.status(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withEntity((Object)error.message(), EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1()))), F);
        } else {
            throw new MatchError(either);
        }
        Object wsResponse = object;
        Object handler = package.all$.MODULE$.toFlatMapOps(wsResponse, F).flatMap((Function1 & Serializable & scala.Serializable)response -> package.all$.MODULE$.toFlatMapOps(ServerHelpers$.MODULE$.send(socket, new Some((Object)req), response, idleTimeout, onWriteFailure, F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)_ -> {
            Status status = response.status();
            Status status2 = Status$.MODULE$.SwitchingProtocols();
            return !(status != null ? !status.equals(status2) : status2 != null) ? MODULE$.runConnection(socket, ctx, buffer, receiveBufferSize, idleTimeout, F) : F.unit();
        }));
        return (F)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(handler, F), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            IOException iOException;
            Throwable throwable = x0$1;
            Object object = throwable instanceof IOException && WebSocketHelpers$BrokenPipeError$.MODULE$.unapply(iOException = (IOException)throwable) ? logger.trace((Throwable)iOException, (Function0 & Serializable & scala.Serializable)() -> "WebSocket connection abruptly terminated by client") : logger.error(throwable, (Function0 & Serializable & scala.Serializable)() -> "WebSocket connection terminated with exception");
            return object;
        }, F);
    }

    private <F> F runConnection(Socket<F> socket, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, Async<F> F) {
        Object read = Util$.MODULE$.timeoutMaybe(socket.read(receiveBufferSize), idleTimeout, F);
        FrameTranscoder frameTranscoder = new FrameTranscoder(false);
        Stream incoming = Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)buffer, ClassTag$.MODULE$.Byte())).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.readStream(read));
        return (F)package.all$.MODULE$.toFlatMapOps(SignallingRef$.MODULE$.apply((Object)WebSocketHelpers$Open$.MODULE$, F), F).flatMap((Function1 & Serializable & scala.Serializable)close -> {
            Tuple2 tuple2;
            WebSocket webSocket = ctx.webSocket();
            if (webSocket instanceof WebSocketCombinedPipe) {
                WebSocketCombinedPipe webSocketCombinedPipe = (WebSocketCombinedPipe)webSocket;
                Function1 receiveSend = webSocketCombinedPipe.receiveSend();
                Object onClose = webSocketCombinedPipe.onClose();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)incoming.through(MODULE$.decodeFrames(frameTranscoder, F)).through(MODULE$.handleIncomingFrames((Function1)(Function1 & Serializable & scala.Serializable)s -> WebSocketHelpers$.write$1(s, socket, idleTimeout, F), frameTranscoder, (Ref)close, (GenConcurrent)F)).through(receiveSend).through(MODULE$.encodeFrames(frameTranscoder)).through((Function1 & Serializable & scala.Serializable)s -> WebSocketHelpers$.write$1(s, socket, idleTimeout, F))), onClose);
            } else if (webSocket instanceof WebSocketSeparatePipe) {
                WebSocketSeparatePipe webSocketSeparatePipe = (WebSocketSeparatePipe)webSocket;
                Stream send = webSocketSeparatePipe.send();
                Function1 receive = webSocketSeparatePipe.receive();
                Object onClose = webSocketSeparatePipe.onClose();
                Object closeFrame = package.all$.MODULE$.toFlatMapOps(close.get(), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    WebSocketHelpers.Close close = x0$1;
                    Object object = WebSocketHelpers$Open$.MODULE$.equals(close) ? package.all$.MODULE$.toFlatMapOps(F.fromEither(WebSocketFrame.Close$.MODULE$.apply(1000)), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)frame -> package.all$.MODULE$.toFunctorOps(close.update((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        WebSocketHelpers.Close close = x0$2;
                        WebSocketHelpers.Close close2 = WebSocketHelpers$Open$.MODULE$.equals(close) ? WebSocketHelpers$EndpointClosed$.MODULE$ : WebSocketHelpers$BothClosed$.MODULE$;
                        return close2;
                    }), (Functor)F).map((Function1 & Serializable & scala.Serializable)_ -> Stream$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WebSocketFrame.Close[]{frame})))) : F.pure((Object)Stream$.MODULE$.empty());
                    return object;
                });
                Stream sendWithClose = send.$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.eval(closeFrame).flatten(Predef$.MODULE$.$conforms()));
                Stream writer = sendWithClose.through(MODULE$.encodeFrames(frameTranscoder)).through((Function1 & Serializable & scala.Serializable)s -> WebSocketHelpers$.write$1(s, socket, idleTimeout, F));
                Stream reader = incoming.through(MODULE$.decodeFrames(frameTranscoder, F)).through(MODULE$.handleIncomingFrames((Function1)(Function1 & Serializable & scala.Serializable)s -> WebSocketHelpers$.write$1(s, socket, idleTimeout, F), frameTranscoder, (Ref)close, (GenConcurrent)F)).through(receive);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reader.concurrently(writer, (GenConcurrent)F)), onClose);
            } else {
                throw new MatchError((Object)webSocket);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Stream stream = (Stream)tuple22._1();
            Object onClose = tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)stream, onClose);
            Tuple2 tuple24 = tuple23;
            Stream stream2 = (Stream)tuple24._1();
            Object onClose2 = tuple24._2();
            return stream2.interruptWhen(Signal.SignalOps$.MODULE$.map$extension(Signal$.MODULE$.SignalOps((Signal)close), (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WebSocketHelpers$.$anonfun$runConnection$13(x$2)), (Functor)F), (GenConcurrent)F).onFinalize(onClose2, (Applicative)F).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)F))).drain();
        });
    }

    private <F> Function1<Stream<F, WebSocketFrame>, Stream<F, WebSocketFrame>> handleIncomingFrames(Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write, FrameTranscoder frameTranscoder, Ref<F, WebSocketHelpers.Close> closeState, GenConcurrent<F, Throwable> F) {
        return (Function1 & Serializable & scala.Serializable)stream -> stream.evalMapFilter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            WebSocketFrame webSocketFrame = x0$1;
            if (webSocketFrame instanceof WebSocketFrame.Ping) {
                WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
                ByteVector data = ping.data();
                object = package.all$.MODULE$.toFunctorOps(this.writeFrame$1((WebSocketFrame)new WebSocketFrame.Pong(data), frameTranscoder, write, F), (Functor)F).as((Object)OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)ping)));
            } else if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
                object = package.all$.MODULE$.toFlatMapOps(closeState.get(), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    WebSocketHelpers.Close close = x0$2;
                    Object object = WebSocketHelpers$Open$.MODULE$.equals(close) ? package.all$.MODULE$.toFlatMapOps(F.fromEither(WebSocketFrame.Close$.MODULE$.apply(close.closeCode())), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)frame -> package.all$.MODULE$.toFlatMapOps(this.writeFrame$1((WebSocketFrame)frame, frameTranscoder, write, F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)_2 -> package.all$.MODULE$.toFunctorOps(closeState.set((Object)WebSocketHelpers$BothClosed$.MODULE$), (Functor)F).map((Function1 & Serializable & scala.Serializable)_ -> None$.MODULE$))) : F.pure((Object)None$.MODULE$);
                    return object;
                });
            } else {
                object = F.pure((Object)new Some((Object)webSocketFrame));
            }
            return object;
        });
    }

    private <F> Function1<Stream<F, WebSocketFrame>, Stream<F, Object>> encodeFrames(FrameTranscoder frameTranscoder) {
        return (Function1 & Serializable & scala.Serializable)stream -> stream.flatMap((Function1 & Serializable & scala.Serializable)frame -> {
            Chunk[] chunks = (Chunk[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frameTranscoder.frameToBuffer(frame))).map((Function1 & Serializable & scala.Serializable)buffer -> {
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                return Chunk$.MODULE$.array((Object)bytes, ClassTag$.MODULE$.Byte());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Chunk.class)));
            return Stream$.MODULE$.iterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])chunks)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Stream$.MODULE$.chunk(x$3), NotGiven$.MODULE$.default());
        }, NotGiven$.MODULE$.default());
    }

    private <F> Function1<Stream<F, Object>, Stream<F, WebSocketFrame>> decodeFrames(FrameTranscoder frameTranscoder, Async<F> F) {
        return (Function1 & Serializable & scala.Serializable)stream -> Pull.StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(WebSocketHelpers$.go$1(stream, Array$.MODULE$.emptyByteArray(), F, frameTranscoder).void()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private <F> Either<WebSocketHelpers.ClientHandshakeError, String> clientHandshake(Request<F> req) {
        var7_2 = Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance()));
        var5_5 /* !! */  = var7_2 instanceof Some != false && (header = (Connection)(var8_3 = (Some)var7_2).value()).hasUpgrade() != false ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        connection = var5_5 /* !! */ ;
        var11_7 = Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Upgrade$.MODULE$.headerInstance()));
        var4_10 /* !! */  = var11_7 instanceof Some != false && FoldableOps$.MODULE$.contains_$extension(package.all$.MODULE$.catsSyntaxFoldOps((Object)(header = (Upgrade)(var12_8 = (Some)var11_7).value()).values(), (Foldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()), (Object)this.webSocketProtocol, Protocol$.MODULE$.catsEqInstance(), (Foldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()) != false ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        upgrade = var4_10 /* !! */ ;
        var15_12 = false;
        var16_13 = null;
        var17_14 = Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusVersion$.MODULE$.headerInstance()));
        if (!(var17_14 instanceof Some)) ** GOTO lbl-1000
        var15_12 = true;
        var16_13 = (Some)var17_14;
        header = (Sec.minusWebSocket.minusVersion)var16_13.value();
        if (header.version() == this.supportedWebSocketVersion) {
            var3_16 = EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()));
        } else if (var15_12) {
            header = (Sec.minusWebSocket.minusVersion)var16_13.value();
            var3_16 = scala.package$.MODULE$.Left().apply((Object)new WebSocketHelpers.UnsupportedVersion(this.supportedWebSocketVersion, header.version()));
        } else if (None$.MODULE$.equals(var17_14)) {
            var3_16 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$VersionNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)var17_14);
        }
        version = var3_16;
        var21_19 = Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()));
        if (var21_19 instanceof Some) {
            var22_20 = (Some)var21_19;
            header = (Sec.minusWebSocket.minusKey)var22_20.value();
            var2_22 = scala.package$.MODULE$.Right().apply((Object)package.all$.MODULE$.http4sHeaderSyntax((Object)header, Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()).value());
        } else if (None$.MODULE$.equals(var21_19)) {
            var2_22 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$KeyNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)var21_19);
        }
        key = var2_22;
        return (Either)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4((Object)connection, (Object)upgrade, (Object)version, (Object)key)).mapN((Function4)(Function4 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$clientHandshake$1(scala.runtime.BoxedUnit scala.runtime.BoxedUnit scala.runtime.BoxedUnit java.lang.String ), (Lscala/runtime/BoxedUnit;Lscala/runtime/BoxedUnit;Lscala/runtime/BoxedUnit;Ljava/lang/String;)Ljava/lang/String;)(), (Functor)Invariant$.MODULE$.catsMonadErrorForEither(), Semigroupal$.MODULE$.catsSemigroupalForEither());
    }

    private <F> F serverHandshake(String value2, MonadError<F, Throwable> F) {
        return (F)package.all$.MODULE$.toFlatMapOps(EitherOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxEither(ByteVector$.MODULE$.encodeAscii(value2)), F), F).flatMap((Function1 & Serializable & scala.Serializable)value -> Hash$.MODULE$.apply(Hash$.MODULE$.forApplicativeThrow((ApplicativeError)F)).digest((HashAlgorithm)HashAlgorithm.SHA1$.MODULE$, value.$plus$plus(WebSocketHelpers$.MODULE$.magic)));
    }

    private <F> Stream<F, Object> readStream(F read) {
        return Stream$.MODULE$.eval(read).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Stream stream;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Chunk bytes = (Chunk)some.value();
                stream = Stream$.MODULE$.chunk(bytes).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.readStream(read));
            } else if (None$.MODULE$.equals(option)) {
                stream = Stream$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return stream;
        }, NotGiven$.MODULE$.default());
    }

    private static final Stream write$1(Stream s, Socket socket$2, Duration idleTimeout$2, Async F$2) {
        return s.chunks().foreach((Function1 & Serializable & scala.Serializable)c -> Util$.MODULE$.timeoutMaybe(socket$2.write(c), idleTimeout$2, (GenTemporal)F$2));
    }

    public static final /* synthetic */ boolean $anonfun$runConnection$13(WebSocketHelpers.Close x$2) {
        WebSocketHelpers.Close close = x$2;
        WebSocketHelpers$BothClosed$ webSocketHelpers$BothClosed$ = WebSocketHelpers$BothClosed$.MODULE$;
        return !(close != null ? !close.equals(webSocketHelpers$BothClosed$) : webSocketHelpers$BothClosed$ != null);
    }

    private final Object writeFrame$1(WebSocketFrame frame, FrameTranscoder frameTranscoder$2, Function1 write$2, GenConcurrent F$3) {
        return Stream$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WebSocketFrame[]{frame})).through(this.encodeFrames(frameTranscoder$2)).through(write$2).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(F$3))).drain();
    }

    private static final Pull go$1(Stream rest, byte[] acc, Async F$4, FrameTranscoder frameTranscoder$4) {
        return Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Pull pull;
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk chunk = (Chunk)tuple2._1();
                Stream next = (Stream)tuple2._2();
                byte[] buffer = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(acc)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])chunk.toArray(ClassTag$.MODULE$.Byte()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
                pull = Pull$.MODULE$.eval(F$4.delay((Function0 & Serializable & scala.Serializable)() -> frameTranscoder$4.bufferToFrame(byteBuffer))).flatMap((Function1 & Serializable & scala.Serializable)value -> {
                    Pull pull;
                    if (value != null) {
                        byte[] remaining = new byte[byteBuffer.remaining()];
                        byteBuffer.get(remaining);
                        pull = Pull$.MODULE$.output1(value).$greater$greater((Function0 & Serializable & scala.Serializable)() -> WebSocketHelpers$.go$1(next, remaining, F$4, frameTranscoder$4));
                    } else {
                        pull = WebSocketHelpers$.go$1(next, buffer, F$4, frameTranscoder$4);
                    }
                    return pull;
                });
            } else if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.raiseError((Throwable)new WebSocketHelpers.EndOfStreamError(), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$4));
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    public static final /* synthetic */ String $anonfun$clientHandshake$1(BoxedUnit x0$1, BoxedUnit x1$1, BoxedUnit x2$1, String x3$1) {
        String key;
        Tuple4 tuple4 = new Tuple4((Object)x0$1, (Object)x1$1, (Object)x2$1, (Object)x3$1);
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String string = key = (String)tuple4._4();
        return string;
    }

    private WebSocketHelpers$() {
        MODULE$ = this;
        this.supportedWebSocketVersion = 13L;
        this.upgradeCi = package$.MODULE$.CIStringSyntax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upgrade"}))).ci((Seq)Nil$.MODULE$);
        this.webSocketProtocol = new Protocol(package$.MODULE$.CIStringSyntax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"websocket"}))).ci((Seq)Nil$.MODULE$), (Option)None$.MODULE$);
        this.connectionUpgrade = new Connection(NonEmptyList$.MODULE$.of((Object)this.upgradeCi, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new CIString[0])));
        this.upgradeWebSocket = Upgrade$.MODULE$.apply(this.webSocketProtocol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Protocol[0]));
        this.magic = ByteVector$.MODULE$.view(Rfc6455$.MODULE$.handshakeMagicBytes());
    }
}

