/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.MonadError;
import cats.Semigroupal$;
import cats.UnorderedFoldable;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.package;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.UnorderedFoldableOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import fs2.concurrent.Signal;
import fs2.concurrent.Signal$;
import fs2.concurrent.SignallingRef$;
import fs2.io.net.Socket;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Protocol;
import org.http4s.Protocol$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.crypto.Hash$;
import org.http4s.crypto.HashAlgorithm;
import org.http4s.ember.core.Util$;
import org.http4s.ember.server.internal.ServerHelpers$;
import org.http4s.ember.server.internal.WebSocketHelpers;
import org.http4s.ember.server.internal.WebSocketHelpers$BothClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$BrokenPipeError$;
import org.http4s.ember.server.internal.WebSocketHelpers$EndpointClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$KeyNotFound$;
import org.http4s.ember.server.internal.WebSocketHelpers$Open$;
import org.http4s.ember.server.internal.WebSocketHelpers$UpgradeRequired$;
import org.http4s.ember.server.internal.WebSocketHelpers$VersionNotFound$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Sec;
import org.http4s.headers.Sec$minusWebSocket$minusAccept$;
import org.http4s.headers.Sec$minusWebSocket$minusKey$;
import org.http4s.headers.Sec$minusWebSocket$minusVersion$;
import org.http4s.headers.Upgrade;
import org.http4s.headers.Upgrade$;
import org.http4s.syntax.package;
import org.http4s.websocket.FrameTranscoder;
import org.http4s.websocket.Rfc6455$;
import org.http4s.websocket.WebSocket;
import org.http4s.websocket.WebSocketCombinedPipe;
import org.http4s.websocket.WebSocketContext;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketSeparatePipe;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.log4cats.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class WebSocketHelpers$ {
    public static final WebSocketHelpers$ MODULE$ = new WebSocketHelpers$();
    private static final long supportedWebSocketVersion = 13L;
    private static final CIString upgradeCi = package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"upgrade"}))).ci((Seq)Nil$.MODULE$);
    private static final Protocol webSocketProtocol = new Protocol(package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"websocket"}))).ci((Seq)Nil$.MODULE$), (Option)None$.MODULE$);
    private static final Connection connectionUpgrade = new Connection(NonEmptyList$.MODULE$.of((Object)upgradeCi, (Seq)Nil$.MODULE$));
    private static final Upgrade upgradeWebSocket = Upgrade$.MODULE$.apply(webSocketProtocol, (Seq)Nil$.MODULE$);
    private static final FrameTranscoder nonClientTranscoder = new FrameTranscoder(false);
    private static final ByteVector magic = ByteVector$.MODULE$.view(Rfc6455$.MODULE$.handshakeMagicBytes());

    public <F> F upgrade(Socket<F> socket, Request<F> req, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, Function1<Throwable, F> errorHandler, Logger<F> logger, GenTemporal<F, Throwable> F) {
        Object object;
        Either<WebSocketHelpers.ClientHandshakeError, String> either = this.clientHandshake(req);
        if (either instanceof Right) {
            Right right = (Right)either;
            String key = (String)right.value();
            object = ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(this.serverHandshake(key, (MonadError<F, Throwable>)F), F).map((Function1 & Serializable)hashBytes -> {
                Sec.minusWebSocket.minusAccept secWebSocketAccept = new Sec.minusWebSocket.minusAccept(hashBytes);
                List headers = Headers$.MODULE$.$plus$plus$extension(ctx.headers(), Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connectionUpgrade, Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)upgradeWebSocket, Upgrade$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)secWebSocketAccept, Sec$minusWebSocket$minusAccept$.MODULE$.headerInstance())})));
                return (Response)Response$.MODULE$.apply(Status$.MODULE$.SwitchingProtocols(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withHeaders(headers);
            }), F), errorHandler, F);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            WebSocketHelpers.ClientHandshakeError error = (WebSocketHelpers.ClientHandshakeError)left.value();
            object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(error.status(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withEntity((Object)error.message(), EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1()))), F);
        } else {
            throw new MatchError(either);
        }
        Object wsResponse = object;
        Object handler = package.all$.MODULE$.toFlatMapOps(wsResponse, F).flatMap((Function1 & Serializable)response -> package.all$.MODULE$.toFlatMapOps(ServerHelpers$.MODULE$.send(socket, new Some((Object)req), response, idleTimeout, onWriteFailure, F), (FlatMap)F).flatMap((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            Status status = response.status();
            Status status2 = Status$.MODULE$.SwitchingProtocols();
            if (!(status != null ? !status.equals(status2) : status2 != null)) {
                return MODULE$.runConnection(socket, ctx, buffer, receiveBufferSize, idleTimeout, F);
            }
            return F.unit();
        }));
        return (F)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(handler, F), (Function1 & Serializable)x0$1 -> {
            IOException iOException;
            Throwable throwable = x0$1;
            if (throwable instanceof IOException && WebSocketHelpers$BrokenPipeError$.MODULE$.unapply(iOException = (IOException)throwable)) {
                return logger.trace((Throwable)iOException, (Function0 & Serializable)() -> "WebSocket connection abruptly terminated by client");
            }
            if (throwable instanceof WebSocketHelpers.EndOfStreamError) {
                WebSocketHelpers.EndOfStreamError endOfStreamError = (WebSocketHelpers.EndOfStreamError)throwable;
                return logger.trace((Throwable)endOfStreamError, (Function0 & Serializable)() -> "WebSocket connection abruptly terminated by client");
            }
            return logger.error(throwable, (Function0 & Serializable)() -> "WebSocket connection terminated with exception");
        }, F);
    }

    private <F> F runConnection(Socket<F> socket, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, GenTemporal<F, Throwable> F) {
        Object read = Util$.MODULE$.timeoutMaybe(socket.read(receiveBufferSize), idleTimeout, F);
        Stream incoming = Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)buffer, (ClassTag)ClassTag$.MODULE$.Byte())).$plus$plus((Function0 & Serializable)() -> MODULE$.readStream(read));
        return (F)package.all$.MODULE$.toFlatMapOps(SignallingRef$.MODULE$.apply((Object)WebSocketHelpers$Open$.MODULE$, F), F).flatMap((Function1 & Serializable)close -> {
            Tuple2 tuple2;
            WebSocket webSocket = ctx.webSocket();
            if (webSocket instanceof WebSocketCombinedPipe) {
                WebSocketCombinedPipe webSocketCombinedPipe = (WebSocketCombinedPipe)webSocket;
                Function1 receiveSend = webSocketCombinedPipe.receiveSend();
                Object onClose = webSocketCombinedPipe.onClose();
                Function1 & Serializable intersect = (Function1 & Serializable)frame -> this.writeFrame$1((WebSocketFrame)frame, socket, idleTimeout, F);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)incoming.through(MODULE$.decodeFrames((ApplicativeError)F)).evalMapFilter((Function1 & Serializable)frame -> MODULE$.handleIncomingFrame((Function1)intersect, (Ref)close, (WebSocketFrame)frame, (GenConcurrent)F)).through(receiveSend).foreach((Function1 & Serializable)frame -> this.writeFrame$1((WebSocketFrame)frame, socket, idleTimeout, F))), onClose);
            } else if (webSocket instanceof WebSocketSeparatePipe) {
                WebSocketSeparatePipe webSocketSeparatePipe = (WebSocketSeparatePipe)webSocket;
                Stream send = webSocketSeparatePipe.send();
                Function1 receive = webSocketSeparatePipe.receive();
                Object onClose = webSocketSeparatePipe.onClose();
                Object sendClosingFrame = package.all$.MODULE$.toFlatMapOps(close.get(), (FlatMap)F).flatMap((Function1 & Serializable)x0$1 -> {
                    WebSocketHelpers.Close close = x0$1;
                    if (WebSocketHelpers$Open$.MODULE$.equals(close)) {
                        return package.all$.MODULE$.toFlatMapOps(F.fromEither(WebSocketFrame.Close$.MODULE$.apply(1000)), (FlatMap)F).flatMap((Function1 & Serializable)frame -> package.all$.MODULE$.toFlatMapOps(close.update((Function1 & Serializable)x0$2 -> {
                            WebSocketHelpers.Close close = x0$2;
                            if (WebSocketHelpers$Open$.MODULE$.equals(close)) {
                                return WebSocketHelpers$EndpointClosed$.MODULE$;
                            }
                            return WebSocketHelpers$BothClosed$.MODULE$;
                        }), (FlatMap)F).flatMap((Function1 & Serializable)x$4 -> {
                            BoxedUnit boxedUnit = x$4;
                            return this.writeFrame$1((WebSocketFrame)frame, socket, idleTimeout, F);
                        }));
                    }
                    return F.unit();
                });
                Stream writer = send.foreach((Function1 & Serializable)frame -> this.writeFrame$1((WebSocketFrame)frame, socket, idleTimeout, F)).$plus$plus((Function0 & Serializable)() -> Stream$.MODULE$.exec(sendClosingFrame));
                Function1 & Serializable intersect = (Function1 & Serializable)frame -> this.writeFrame$1((WebSocketFrame)frame, socket, idleTimeout, F);
                Stream reader = incoming.through(MODULE$.decodeFrames((ApplicativeError)F)).evalMapFilter((Function1 & Serializable)frame -> MODULE$.handleIncomingFrame((Function1)intersect, (Ref)close, (WebSocketFrame)frame, (GenConcurrent)F)).through(receive);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reader.concurrently(writer, (GenConcurrent)F)), onClose);
            } else {
                throw new MatchError((Object)webSocket);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Stream stream = (Stream)tuple22._1();
            Object onClose = tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)stream, onClose);
            Stream stream2 = (Stream)tuple23._1();
            Object onClose2 = tuple23._2();
            return stream2.interruptWhen(Signal.SignalOps$.MODULE$.map$extension(Signal$.MODULE$.SignalOps((Signal)close), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)WebSocketHelpers$.$anonfun$runConnection$15(x$6)), (Functor)F), (GenConcurrent)F).onFinalize(onClose2, (Applicative)F).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)F))).drain();
        });
    }

    private <F> F handleIncomingFrame(Function1<WebSocketFrame, F> writeFrame, Ref<F, WebSocketHelpers.Close> closeState, WebSocketFrame frame, GenConcurrent<F, Throwable> F) {
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebSocketFrame.Ping) {
            WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
            ByteVector data = ping.data();
            return (F)package.all$.MODULE$.toFunctorOps(writeFrame.apply((Object)new WebSocketFrame.Pong(data)), F).as((Object)OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)ping)));
        }
        if (webSocketFrame instanceof WebSocketFrame.Close) {
            return (F)package.all$.MODULE$.toFlatMapOps(closeState.get(), F).flatMap((Function1 & Serializable)x0$1 -> {
                WebSocketHelpers.Close close = x0$1;
                if (WebSocketHelpers$Open$.MODULE$.equals(close)) {
                    return package.all$.MODULE$.toFlatMapOps(F.fromEither(WebSocketFrame.Close$.MODULE$.apply(1000)), (FlatMap)F).flatMap((Function1 & Serializable)frame -> package.all$.MODULE$.toFlatMapOps(writeFrame.apply(frame), (FlatMap)F).flatMap((Function1 & Serializable)x$8 -> {
                        BoxedUnit boxedUnit = x$8;
                        return package.all$.MODULE$.toFunctorOps(closeState.set((Object)WebSocketHelpers$BothClosed$.MODULE$), (Functor)F).map((Function1 & Serializable)x$7 -> {
                            BoxedUnit boxedUnit = x$7;
                            return None$.MODULE$;
                        });
                    }));
                }
                return F.pure((Object)None$.MODULE$);
            });
        }
        return (F)F.pure((Object)new Some((Object)webSocketFrame));
    }

    private List<Chunk<Object>> frameToBytes(WebSocketFrame frame) {
        return Predef$.MODULE$.wrapRefArray((Object[])nonClientTranscoder.frameToBuffer(frame)).toList().map((Function1 & Serializable)buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return Chunk$.MODULE$.array((Object)bytes, (ClassTag)ClassTag$.MODULE$.Byte());
        });
    }

    private <F> Function1<Stream<F, Object>, Stream<F, WebSocketFrame>> decodeFrames(ApplicativeError<F, Throwable> F) {
        return (Function1 & Serializable)stream -> Pull.StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(WebSocketHelpers$.go$1(stream, Array$.MODULE$.emptyByteArray(), F).void()));
    }

    /*
     * Unable to fully structure code
     */
    private <F> Either<WebSocketHelpers.ClientHandshakeError, String> clientHandshake(Request<F> req) {
        var7_2 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance()));
        connection = var7_2 instanceof Some != false && (header = (Connection)(var8_3 = (Some)var7_2).value()).hasUpgrade() != false ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        var11_6 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Upgrade$.MODULE$.headerInstance()));
        upgrade = var11_6 instanceof Some != false && UnorderedFoldableOps$.MODULE$.contains_$extension(package.all$.MODULE$.catsSyntaxUnorderedFoldableOps((Object)(header = (Upgrade)(var12_7 = (Some)var11_6).value()).values(), (UnorderedFoldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyListBinCompat1()), (Object)WebSocketHelpers$.webSocketProtocol, Protocol$.MODULE$.catsEqInstance(), (UnorderedFoldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyListBinCompat1()) != false ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        var15_10 = false;
        var16_11 = null;
        var17_12 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusVersion$.MODULE$.headerInstance()));
        if (!(var17_12 instanceof Some)) ** GOTO lbl-1000
        var15_10 = true;
        var16_11 = (Some)var17_12;
        header = (Sec.minusWebSocket.minusVersion)var16_11.value();
        if (header.version() == WebSocketHelpers$.supportedWebSocketVersion) {
            v0 = EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()));
        } else if (var15_10) {
            header = (Sec.minusWebSocket.minusVersion)var16_11.value();
            v0 = scala.package$.MODULE$.Left().apply((Object)new WebSocketHelpers.UnsupportedVersion(WebSocketHelpers$.supportedWebSocketVersion, header.version()));
        } else if (None$.MODULE$.equals(var17_12)) {
            v0 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$VersionNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)var17_12);
        }
        version = v0;
        var21_16 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()));
        if (var21_16 instanceof Some) {
            var22_17 = (Some)var21_16;
            header = (Sec.minusWebSocket.minusKey)var22_17.value();
            v1 = scala.package$.MODULE$.Right().apply((Object)package.all$.MODULE$.http4sHeaderSyntax((Object)header, Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()).value());
        } else if (None$.MODULE$.equals(var21_16)) {
            v1 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$KeyNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)var21_16);
        }
        key = v1;
        return (Either)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4((Object)connection, (Object)upgrade, (Object)version, (Object)key)).mapN((Function4)(Function4 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$clientHandshake$1(scala.runtime.BoxedUnit scala.runtime.BoxedUnit scala.runtime.BoxedUnit java.lang.String ), (Lscala/runtime/BoxedUnit;Lscala/runtime/BoxedUnit;Lscala/runtime/BoxedUnit;Ljava/lang/String;)Ljava/lang/String;)(), (Functor)Invariant$.MODULE$.catsMonadErrorForEither(), Semigroupal$.MODULE$.catsSemigroupalForEither());
    }

    private <F> F serverHandshake(String value2, MonadError<F, Throwable> F) {
        return (F)package.all$.MODULE$.toFlatMapOps(EitherOps$.MODULE$.liftTo$extension(package.all$.MODULE$.catsSyntaxEither(ByteVector$.MODULE$.encodeAscii(value2)), F), F).flatMap((Function1 & Serializable)value -> Hash$.MODULE$.apply(Hash$.MODULE$.forApplicativeThrow((ApplicativeError)F)).digest((HashAlgorithm)HashAlgorithm.SHA1$.MODULE$, value.$plus$plus(magic)));
    }

    private <F> Stream<F, Object> readStream(F read) {
        return Stream$.MODULE$.eval(read).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Chunk bytes = (Chunk)some.value();
                return Stream$.MODULE$.chunk(bytes).$plus$plus((Function0 & Serializable)() -> MODULE$.readStream(read));
            }
            if (None$.MODULE$.equals(option)) {
                return Stream$.MODULE$.empty();
            }
            throw new MatchError((Object)option);
        }, NotGiven$.MODULE$.default());
    }

    private final Object writeFrame$1(WebSocketFrame frame, Socket socket$2, Duration idleTimeout$2, GenTemporal F$2) {
        return package.all$.MODULE$.toFoldableOps(this.frameToBytes(frame), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket$2.write(c), idleTimeout$2, F$2), (Applicative)F$2);
    }

    public static final /* synthetic */ boolean $anonfun$runConnection$15(WebSocketHelpers.Close x$6) {
        WebSocketHelpers.Close close = x$6;
        WebSocketHelpers$BothClosed$ webSocketHelpers$BothClosed$ = WebSocketHelpers$BothClosed$.MODULE$;
        return !(close != null ? !close.equals(webSocketHelpers$BothClosed$) : webSocketHelpers$BothClosed$ != null);
    }

    private static final Pull go$1(Stream rest, byte[] acc, ApplicativeError F$4) {
        return Stream.ToPull$.MODULE$.uncons$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk chunk = (Chunk)tuple2._1();
                Stream next = (Stream)tuple2._2();
                return ((Pull)package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)Pull$.MODULE$.monadErrorInstance()).catchNonFatal((Function0 & Serializable)() -> {
                    byte[] buffer = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(acc), chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte()), (ClassTag)ClassTag$.MODULE$.Byte());
                    ArrayBuffer frames = ArrayBuffer$.MODULE$.empty();
                    ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
                    WebSocketFrame frame = nonClientTranscoder.bufferToFrame(byteBuffer);
                    while (frame != null) {
                        frames.$plus$eq((Object)frame);
                        byteBuffer = byteBuffer.slice();
                        frame = nonClientTranscoder.bufferToFrame(byteBuffer);
                    }
                    if (frames.nonEmpty()) {
                        byte[] remaining = new byte[byteBuffer.remaining()];
                        byteBuffer.get(remaining);
                        return new Tuple2((Object)new Some((Object)Chunk$.MODULE$.array(frames.toArray(ClassTag$.MODULE$.apply(WebSocketFrame.class)), ClassTag$.MODULE$.apply(WebSocketFrame.class))), (Object)remaining);
                    }
                    return new Tuple2((Object)None$.MODULE$, (Object)buffer);
                }, (.less.colon.less)$less$colon$less$.MODULE$.refl())).flatMap((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        byte[] remaining = (byte[])tuple2._2();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk frames = (Chunk)some.value();
                            return Pull$.MODULE$.output(frames).$greater$greater((Function0 & Serializable)() -> WebSocketHelpers$.go$1(next, remaining, F$4));
                        }
                    }
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        byte[] remaining = (byte[])tuple2._2();
                        if (None$.MODULE$.equals(option)) {
                            return WebSocketHelpers$.go$1(next, remaining, F$4);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.raiseError((Throwable)new WebSocketHelpers.EndOfStreamError(), RaiseThrowable$.MODULE$.fromApplicativeError(F$4));
            }
            throw new MatchError((Object)option);
        });
    }

    public static final /* synthetic */ String $anonfun$clientHandshake$1(BoxedUnit x0$1, BoxedUnit x1$1, BoxedUnit x2$1, String x3$1) {
        Tuple4 tuple4 = new Tuple4((Object)x0$1, (Object)x1$1, (Object)x2$1, (Object)x3$1);
        if (tuple4 != null) {
            String key = (String)tuple4._4();
            return key;
        }
        throw new MatchError((Object)tuple4);
    }

    private WebSocketHelpers$() {
    }
}

