/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.Apply;
import cats.Defer;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.package$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfFOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSLogger;
import fs2.io.net.tls.TLSLogger$Disabled$;
import fs2.io.net.tls.TLSParameters;
import fs2.io.net.tls.TLSSocket;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLSession;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.ember.core.EmberException;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.ember.core.h2.H2Frame;
import org.http4s.ember.core.h2.H2Keys$;
import org.http4s.ember.core.h2.H2Server$;
import org.http4s.ember.core.h2.H2TLS$;
import org.http4s.ember.server.internal.ServerHelpersPlatform;
import org.http4s.ember.server.internal.Shutdown;
import org.http4s.ember.server.internal.WebSocketHelpers$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Date;
import org.http4s.headers.Date$;
import org.http4s.server.SecureSession;
import org.http4s.server.package;
import org.http4s.websocket.WebSocketContext;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.SelfAwareLogger;
import org.typelevel.vault.InsertKey;
import org.typelevel.vault.Key;
import org.typelevel.vault.LookupKey;
import org.typelevel.vault.Vault$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class ServerHelpers$
implements ServerHelpersPlatform {
    public static final ServerHelpers$ MODULE$ = new ServerHelpers$();
    private static final Response<Nothing$> serverFailure;

    static {
        ServerHelpersPlatform.$init$(MODULE$);
        serverFailure = (Response)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.zero(), Content$minusLength$.MODULE$.headerInstance())}));
    }

    @Override
    public Option<SecureSession> parseSSLSession(SSLSession session) {
        return ServerHelpersPlatform.parseSSLSession$(this, session);
    }

    private Response<Nothing$> serverFailure() {
        return serverFailure;
    }

    public <F> Stream<F, Nothing$> server(Option<Host> host, Port port, List<SocketOption> additionalSocketOptions, SocketGroup<F> sg, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Deferred<F, Either<Throwable, SocketAddress<IpAddress>>> ready, Shutdown<F> shutdown, PartialFunction<Throwable, F> connectionErrorHandler, Function1<Throwable, F> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Function1<Throwable, F> requestLineParseErrorHandler, Async<F> F) {
        Stream server = Stream$.MODULE$.resource(sg.serverResource(host, (Option)new Some((Object)port), additionalSocketOptions), F).attempt().evalTap((Function1 & Serializable)e -> ready.complete((Object)e.map((Function1 & Serializable)x$1 -> (SocketAddress)x$1._1()))).rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), RaiseThrowable$.MODULE$.fromApplicativeError(F)).flatMap((Function1 & Serializable)x$2 -> (Stream)x$2._2(), NotGiven$.MODULE$.default());
        return this.serverInternal(server, httpApp, tlsInfoOpt, shutdown, connectionErrorHandler, errorHandler, onWriteFailure, maxConnections, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, true, webSocketKey, enableHttp2, requestLineParseErrorHandler, F);
    }

    public <F> Stream<F, Nothing$> unixSocketServer(UnixSockets<F> unixSockets, UnixSocketAddress unixSocketAddress, boolean deleteIfExists, boolean deleteOnClose, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Deferred<F, Either<Throwable, SocketAddress<IpAddress>>> ready, Shutdown<F> shutdown, PartialFunction<Throwable, F> connectionErrorHandler, Function1<Throwable, F> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Function1<Throwable, F> requestLineParseErrorHandler, Async<F> evidence$1) {
        Stream server = Stream$.MODULE$.eval(ready.complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)new SocketAddress((Host)Ipv4Address$.MODULE$.fromBytes(0, 0, 0, 0), (Port)Port$.MODULE$.fromInt(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString("0"))).get())))).drain().$plus$plus((Function0 & Serializable)() -> unixSockets.server(unixSocketAddress, deleteIfExists, deleteOnClose));
        return this.serverInternal(server, httpApp, tlsInfoOpt, shutdown, connectionErrorHandler, errorHandler, onWriteFailure, maxConnections, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, false, webSocketKey, enableHttp2, requestLineParseErrorHandler, evidence$1);
    }

    public <F> Stream<F, Nothing$> serverInternal(Stream<F, Socket<F>> server, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Shutdown<F> shutdown, PartialFunction<Throwable, F> connectionErrorHandler, Function1<Throwable, F> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, boolean createRequestVault, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Function1<Throwable, F> requestLineParseErrorHandler, Async<F> evidence$2) {
        Stream streams = server.interruptWhen(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(shutdown.signal(), evidence$2), evidence$2)).map((Function1 & Serializable)connect -> {
            Stream handler = shutdown.trackConnection().$greater$greater((Function0 & Serializable)() -> Stream$.MODULE$.resource(MODULE$.upgradeSocket((Socket)connect, tlsInfoOpt, logger, enableHttp2, (MonadError)evidence$2), (MonadCancel)evidence$2).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Some some;
                    String string;
                    Socket socket = (Socket)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some && "h2".equals(string = (String)(some = (Some)option).value())) {
                        return Stream$.MODULE$.exec(H2Server$.MODULE$.requireConnectionPreface(socket, (MonadError)evidence$2)).$plus$plus((Function0 & Serializable)() -> Stream$.MODULE$.resource(H2Server$.MODULE$.fromSocket(socket, httpApp, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger, H2Server$.MODULE$.fromSocket$default$5(), H2Server$.MODULE$.fromSocket$default$6(), evidence$2), (MonadCancel)evidence$2).drain());
                    }
                }
                if (tuple2 != null) {
                    Socket socket = (Socket)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some) {
                        return MODULE$.runConnection(socket, logger, idleTimeout, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, httpApp, errorHandler, onWriteFailure, createRequestVault, webSocketKey, ByteVector$.MODULE$.empty(), enableHttp2, requestLineParseErrorHandler, evidence$2).drain();
                    }
                }
                if (tuple2 != null) {
                    Socket socket = (Socket)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (None$.MODULE$.equals(option)) {
                        boolean bl = enableHttp2;
                        if (bl) {
                            return Stream$.MODULE$.eval(H2Server$.MODULE$.checkConnectionPreface(socket, (MonadError)evidence$2)).flatMap((Function1 & Serializable)x0$2 -> {
                                Either either = x0$2;
                                if (either instanceof Left) {
                                    Left left = (Left)either;
                                    ByteVector bv = (ByteVector)left.value();
                                    return MODULE$.runConnection(socket, logger, idleTimeout, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, httpApp, errorHandler, onWriteFailure, createRequestVault, webSocketKey, bv, enableHttp2, requestLineParseErrorHandler, evidence$2).drain();
                                }
                                if (either instanceof Right) {
                                    return Stream$.MODULE$.resource(H2Server$.MODULE$.fromSocket(socket, httpApp, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger, H2Server$.MODULE$.fromSocket$default$5(), H2Server$.MODULE$.fromSocket$default$6(), evidence$2), (MonadCancel)evidence$2).drain();
                                }
                                throw new MatchError((Object)either);
                            }, NotGiven$.MODULE$.default());
                        }
                        if (!bl) {
                            return MODULE$.runConnection(socket, logger, idleTimeout, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, httpApp, errorHandler, onWriteFailure, createRequestVault, webSocketKey, ByteVector$.MODULE$.empty(), enableHttp2, requestLineParseErrorHandler, evidence$2).drain();
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                    }
                }
                throw new MatchError((Object)tuple2);
            }, NotGiven$.MODULE$.default()), NotGiven$.MODULE$.default());
            return handler.handleErrorWith((Function1 & Serializable)t -> Stream$.MODULE$.eval(ServerHelpers$.fullConnectionErrorHandler$1(t, connectionErrorHandler, logger)).drain());
        });
        return Stream.NestedStreamOps$.MODULE$.parJoin$extension(Stream$.MODULE$.NestedStreamOps(streams), maxConnections, evidence$2);
    }

    public <F> Resource<F, Tuple2<Socket<F>, Option<String>>> upgradeSocket(Socket<F> socketInit, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Logger<F> logger, boolean enableHttp2, MonadError<F, Throwable> F) {
        return (Resource)tlsInfoOpt.fold((Function0 & Serializable)() -> (Resource)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)new Tuple2((Object)socketInit, (Object)Option$.MODULE$.empty())), (Applicative)Resource$.MODULE$.catsEffectMonadErrorForResource(F)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object;
                TLSContext context = (TLSContext)tuple2._1();
                TLSParameters params = (TLSParameters)tuple2._2();
                TLSParameters newParams = enableHttp2 ? H2TLS$.MODULE$.transform(params) : params;
                Logger logger = logger;
                if (logger instanceof SelfAwareLogger) {
                    SelfAwareLogger selfAwareLogger = (SelfAwareLogger)logger;
                    object = IfFOps$.MODULE$.ifF$extension(package.all$.MODULE$.catsSyntaxIfF(selfAwareLogger.isTraceEnabled()), (Function0 & Serializable)() -> new TLSLogger.Enabled((Function1 & Serializable)s -> logger.trace(s)), (Function0 & Serializable)() -> TLSLogger$Disabled$.MODULE$, (Functor)F);
                } else {
                    object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)new TLSLogger.Enabled((Function1 & Serializable)s -> logger.trace(s))), (Applicative)F);
                }
                return Resource$.MODULE$.eval(object).flatMap((Function1 & Serializable)tlsLogger -> context.serverBuilder(socketInit).withParameters(newParams).withLogger((TLSLogger)tlsLogger).build().evalMap((Function1 & Serializable)tlsSocket -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(tlsSocket.write(Chunk$.MODULE$.empty()), (FlatMap)F), (Function0 & Serializable)() -> ApplicativeErrorOps$.MODULE$.recover$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(tlsSocket.applicationProtocol(), (Functor)F).map((Function1 & Serializable)protocol -> new Tuple2(tlsSocket, (Object)OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId(protocol)))), (ApplicativeError)F), (PartialFunction)new Serializable((TLSSocket)tlsSocket){
                    private static final long serialVersionUID = 0L;
                    private final TLSSocket tlsSocket$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof NoSuchElementException) {
                            return (B1)new Tuple2((Object)this.tlsSocket$1, (Object)Option$.MODULE$.empty());
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable instanceof NoSuchElementException;
                    }
                    {
                        this.tlsSocket$1 = tlsSocket$1;
                    }
                }, (ApplicativeError)F), (FlatMap)F)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <F> F runApp(byte[] head, F read, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, F> errorHandler, Socket<F> socket, boolean createRequestVault, GenTemporal<F, Throwable> F, Defer<F> D) {
        Object parse = Parser.Request$.MODULE$.parser(maxHeaderSize, head, read, F);
        Object parseWithHeaderTimeout = Util$.MODULE$.timeoutToMaybe(parse, requestHeaderReceiveTimeout, D.defer((Function0 & Serializable)() -> F.raiseError((Object)new EmberException.RequestHeadersTimeout(requestHeaderReceiveTimeout))), F);
        return (F)package.all$.MODULE$.toFlatMapOps(parseWithHeaderTimeout, F).flatMap((Function1 & Serializable)tmp -> {
            Tuple2 tuple2 = tmp;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Request req = (Request)tuple2._1();
            Object drain = tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)req, drain);
            Tuple2 tuple22 = (Tuple2)tuple3._1();
            Request req2 = (Request)tuple3._2();
            Object drain2 = tuple3._3();
            return package.all$.MODULE$.toFlatMapOps(createRequestVault ? MODULE$.mkRequestVault(socket, (Applicative)F) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Vault$.MODULE$.empty()), (Applicative)F), (FlatMap)F).flatMap((Function1 & Serializable)requestVault -> package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(httpApp.run().apply((Object)req2.withAttributes(requestVault)), (ApplicativeError)F), errorHandler, (ApplicativeError)F), (ApplicativeError)F), (Function1 & Serializable)x$3 -> (Response)MODULE$.serverFailure().covary(), (ApplicativeError)F), (Functor)F).map((Function1 & Serializable)resp -> new Tuple3((Object)req2, resp, drain2)));
        });
    }

    public <F> F send(Socket<F> socket, Option<Request<F>> request, Response<F> resp, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, GenTemporal<F, Throwable> evidence$3) {
        return (F)ApplicativeErrorOps$.MODULE$.onError$extension(package.all$.MODULE$.catsSyntaxApplicativeError(Encoder$.MODULE$.respToBytes(resp, Encoder$.MODULE$.respToBytes$default$2(), evidence$3).through((Function1 & Serializable)x$7 -> x$7.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout, evidence$3))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(evidence$3))).drain(), evidence$3), (PartialFunction)new Serializable(onWriteFailure, request, resp){
            private static final long serialVersionUID = 0L;
            private final Function3 onWriteFailure$2;
            private final Option request$1;
            private final Response resp$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)this.onWriteFailure$2.apply((Object)this.request$1, (Object)this.resp$1, A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.onWriteFailure$2 = onWriteFailure$2;
                this.request$1 = request$1;
                this.resp$1 = resp$1;
            }
        }, evidence$3);
    }

    public <F> F postProcessResponse(Request<F> req, Response<F> resp, GenConcurrent<F, Throwable> evidence$4, Clock<F> evidence$5) {
        Connection connection = Util$.MODULE$.connectionFor(req.httpVersion(), req.headers());
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current(evidence$4, evidence$5), evidence$4).map((Function1 & Serializable)x$8 -> new Date(x$8)), evidence$4).map((Function1 & Serializable)date -> (Response)resp.withHeaders(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance())})), resp.headers())));
    }

    public <F> Stream<F, Nothing$> runConnection(Socket<F> socket, Logger<F> logger, Duration idleTimeout, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, F> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, F> onWriteFailure, boolean createRequestVault, Key<WebSocketContext<F>> webSocketKey, ByteVector initialBuffer, boolean enableHttp2, Function1<Throwable, F> requestLineParseErrorHandler, Async<F> evidence$6) {
        Kleisli finalApp = enableHttp2 ? H2Server$.MODULE$.h2cUpgradeMiddleware(httpApp, evidence$6) : httpApp;
        Object read = MonadErrorOps$.MODULE$.adaptError$extension(package.all$.MODULE$.catsSyntaxMonadError(Util$.MODULE$.timeoutMaybe(socket.read(receiveBufferSize), idleTimeout, evidence$6), evidence$6), (PartialFunction)new Serializable(idleTimeout){
            private static final long serialVersionUID = 0L;
            private final Duration idleTimeout$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TimeoutException) {
                    return (B1)new EmberException.ReadTimeout(this.idleTimeout$3);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof TimeoutException;
            }
            {
                this.idleTimeout$3 = idleTimeout$3;
            }
        }, evidence$6);
        Stream qual$1 = Stream$.MODULE$.unfoldEval((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)initialBuffer.toArray()), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                byte[] buffer = (byte[])tuple2._1();
                boolean reuse = tuple2._2$mcZ$sp();
                Object initRead = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(buffer)) ? ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)buffer), (Applicative)evidence$6) : (reuse ? package.all$.MODULE$.toFlatMapOps(read, (FlatMap)evidence$6).flatMap((Function1 & Serializable)x0$2 -> {
                    Option option = x0$2;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Chunk chunk = (Chunk)some.value();
                        return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId(chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte())), (Applicative)evidence$6);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return package$.MODULE$.Concurrent().apply((GenConcurrent)evidence$6, DummyImplicit$.MODULE$.dummyImplicit()).raiseError((Object)new EmberException.EmptyStream());
                    }
                    throw new MatchError((Object)option);
                }) : ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Array$.MODULE$.emptyByteArray()), (Applicative)evidence$6));
                Object result = package.all$.MODULE$.toFlatMapOps(initRead, (FlatMap)evidence$6).flatMap((Function1 & Serializable)initBuffer -> MODULE$.runApp((byte[])initBuffer, (Object)read, maxHeaderSize, requestHeaderReceiveTimeout, (Kleisli)finalApp, errorHandler, socket, createRequestVault, (GenTemporal)evidence$6, (Defer)evidence$6));
                return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(result, (ApplicativeError)evidence$6), (ApplicativeError)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)x0$3 -> {
                    Right right;
                    Tuple3 tuple3;
                    Either either = x0$3;
                    if (either instanceof Right && (tuple3 = (Tuple3)(right = (Right)either).value()) != null) {
                        Request req = (Request)tuple3._1();
                        Response resp = (Response)tuple3._2();
                        Object drain = tuple3._3();
                        Option option = resp.attributes().lookup((LookupKey)webSocketKey);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            WebSocketContext ctx = (WebSocketContext)some.value();
                            return package.all$.MODULE$.toFlatMapOps(drain, (FlatMap)evidence$6).flatMap((Function1 & Serializable)x0$4 -> {
                                Option option = x0$4;
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    byte[] buffer = (byte[])some.value();
                                    return package.all$.MODULE$.toFunctorOps(WebSocketHelpers$.MODULE$.upgrade(socket, req, ctx, buffer, receiveBufferSize, idleTimeout, onWriteFailure, errorHandler, logger, evidence$6), (Functor)evidence$6).as((Object)None$.MODULE$);
                                }
                                if (None$.MODULE$.equals(option)) {
                                    return Applicative$.MODULE$.apply((Applicative)evidence$6).pure((Object)None$.MODULE$);
                                }
                                throw new MatchError((Object)option);
                            });
                        }
                        if (None$.MODULE$.equals(option)) {
                            Some some;
                            Tuple2 tuple2;
                            Option option2 = resp.attributes().lookup((LookupKey)H2Keys$.MODULE$.H2cUpgrade());
                            if (None$.MODULE$.equals(option2)) {
                                return package.all$.MODULE$.toFlatMapOps(MODULE$.postProcessResponse((Request)req, (Response)resp, (GenConcurrent)evidence$6, (Clock)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)nextResp -> package.all$.MODULE$.toFlatMapOps(MODULE$.send(socket, (Option)new Some((Object)req), (Response)nextResp, idleTimeout, onWriteFailure, (GenTemporal)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)x$9 -> {
                                    BoxedUnit boxedUnit = x$9;
                                    return package.all$.MODULE$.toFunctorOps(drain, (Functor)evidence$6).map((Function1 & Serializable)nextBuffer -> nextBuffer.map((Function1 & Serializable)buffer -> new Tuple2(nextResp, (Object)new Tuple2(buffer, (Object)BoxesRunTime.boxToBoolean((boolean)true)))));
                                }));
                            }
                            if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
                                H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple2._1();
                                Request newReq = (Request)tuple2._2();
                                return package.all$.MODULE$.toFlatMapOps(MODULE$.postProcessResponse((Request)req, (Response)resp, (GenConcurrent)evidence$6, (Clock)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)nextResp -> package.all$.MODULE$.toFlatMapOps(MODULE$.send(socket, (Option)new Some((Object)req), (Response)nextResp, idleTimeout, onWriteFailure, (GenTemporal)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)x$12 -> {
                                    BoxedUnit boxedUnit = x$12;
                                    return package.all$.MODULE$.toFlatMapOps(H2Server$.MODULE$.requireConnectionPreface(socket, (MonadError)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)x$11 -> {
                                        BoxedUnit boxedUnit = x$11;
                                        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(H2Server$.MODULE$.fromSocket(socket, httpApp, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger, settings, OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)newReq)), evidence$6).use((Function1 & Serializable)x$10 -> package$.MODULE$.Async().apply(evidence$6).never(), (MonadCancel)evidence$6), (Functor)evidence$6).as((Object)None$.MODULE$), (Functor)evidence$6).map((Function1 & Serializable)out -> out);
                                    });
                                }));
                            }
                            throw new MatchError((Object)option2);
                        }
                        throw new MatchError((Object)option);
                    }
                    if (either instanceof Left) {
                        Object object;
                        Left left = (Left)either;
                        Throwable err = (Throwable)left.value();
                        Throwable throwable = err;
                        if (throwable instanceof EmberException.EmptyStream ? true : (throwable instanceof EmberException.RequestHeadersTimeout ? true : throwable instanceof EmberException.ReadTimeout)) {
                            return Applicative$.MODULE$.apply((Applicative)evidence$6).pure((Object)None$.MODULE$);
                        }
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof Parser.Request$.ReqPrelude$.ParsePreludeError) {
                            Parser.Request$.ReqPrelude$.ParsePreludeError parsePreludeError = (Parser.Request$.ReqPrelude$.ParsePreludeError)throwable2;
                            object = requestLineParseErrorHandler.apply((Object)parsePreludeError);
                        } else {
                            object = errorHandler.apply((Object)throwable2);
                        }
                        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.handleError$extension(package.all$.MODULE$.catsSyntaxApplicativeError(object, (ApplicativeError)evidence$6), (Function1 & Serializable)x$13 -> (Response)MODULE$.serverFailure().covary(), (ApplicativeError)evidence$6), (FlatMap)evidence$6).flatMap((Function1 & Serializable)x$14 -> MODULE$.send(socket, (Option)None$.MODULE$, (Response)x$14, idleTimeout, onWriteFailure, (GenTemporal)evidence$6)), (Functor)evidence$6).as((Object)None$.MODULE$);
                    }
                    throw new MatchError((Object)either);
                });
            }
            throw new MatchError((Object)tuple2);
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ServerHelpers$.$anonfun$runConnection$17(x$15));
        boolean x$2 = qual$1.takeWhile$default$2();
        return qual$1.takeWhile((Function1)x$1, x$2).drain().mask();
    }

    private <F> F mkRequestVault(Socket<F> socket, Applicative<F> evidence$7) {
        return (F)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(this.mkConnectionInfo(socket, (Apply<F>)evidence$7), this.mkSecureSession(socket, evidence$7))).mapN((Function2 & Serializable)(x$17, x$18) -> x$17.$plus$plus(x$18), evidence$7, evidence$7);
    }

    private <F> F mkConnectionInfo(Socket<F> socket, Apply<F> evidence$8) {
        return (F)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(socket.localAddress(), socket.remoteAddress())).mapN((Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                SocketAddress local = (SocketAddress)tuple2._1();
                SocketAddress remote = (SocketAddress)tuple2._2();
                return Vault$.MODULE$.empty().insert((InsertKey)Request.Keys$.MODULE$.ConnectionInfo(), (Object)new Request.Connection(local, remote, socket instanceof TLSSocket));
            }
            throw new MatchError((Object)tuple2);
        }, evidence$8, evidence$8);
    }

    private <F> F mkSecureSession(Socket<F> socket, Applicative<F> evidence$9) {
        Socket<F> socket2 = socket;
        if (socket2 instanceof TLSSocket) {
            TLSSocket tLSSocket = (TLSSocket)socket2;
            return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(tLSSocket.session(), evidence$9).map((Function1 & Serializable)x$19 -> MODULE$.parseSSLSession((SSLSession)x$19)), evidence$9).map((Function1 & Serializable)x$20 -> Vault$.MODULE$.empty().insert((InsertKey)package.ServerRequestKeys$.MODULE$.SecureSession(), x$20));
        }
        return (F)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Vault$.MODULE$.empty()), evidence$9);
    }

    private static final Object fullConnectionErrorHandler$1(Throwable t2, PartialFunction connectionErrorHandler$1, Logger logger$1) {
        return connectionErrorHandler$1.applyOrElse((Object)t2, (Function1 & Serializable)t -> logger$1.error(t, (Function0 & Serializable)() -> "Request handler failed with exception"));
    }

    public static final /* synthetic */ boolean $anonfun$runConnection$17(Response x$15) {
        return Headers$.MODULE$.get$extension(x$15.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.hasKeepAlive()));
    }

    private ServerHelpers$() {
    }
}

