/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.Apply;
import cats.Defer;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.package$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSParameters;
import fs2.io.net.tls.TLSSocket;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLSession;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.ember.core.EmberException;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.ember.core.h2.H2Frame;
import org.http4s.ember.core.h2.H2Keys$;
import org.http4s.ember.core.h2.H2Server$;
import org.http4s.ember.core.h2.H2TLS$;
import org.http4s.ember.server.internal.ServerHelpersPlatform;
import org.http4s.ember.server.internal.Shutdown;
import org.http4s.ember.server.internal.WebSocketHelpers$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Date$;
import org.http4s.server.package;
import org.http4s.websocket.WebSocketContext;
import org.typelevel.log4cats.Logger;
import org.typelevel.vault.InsertKey;
import org.typelevel.vault.Key;
import org.typelevel.vault.LookupKey;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.DummyImplicit$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class ServerHelpers$
implements ServerHelpersPlatform,
Serializable {
    private static final Response<Nothing$> serverFailure;
    public static final ServerHelpers$ MODULE$;

    private ServerHelpers$() {
    }

    static {
        MODULE$ = new ServerHelpers$();
        serverFailure = (Response)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.zero(), Content$minusLength$.MODULE$.headerInstance())}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ServerHelpers$.class);
    }

    public <F> Stream<F, Nothing$> server(Option<Host> host, Port port, List<SocketOption> additionalSocketOptions, SocketGroup<F> sg, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Deferred<F, Either<Throwable, SocketAddress<IpAddress>>> ready, Shutdown<F> shutdown, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Async<F> F) {
        Stream server = Stream$.MODULE$.resource(sg.serverResource(host, (Option)Some$.MODULE$.apply((Object)port), additionalSocketOptions), F).attempt().evalTap((Function1 & Serializable)e -> ready.complete((Object)e.map((Function1 & Serializable)_$2 -> (SocketAddress)_$2._1())), F).rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), RaiseThrowable$.MODULE$.fromApplicativeError(F)).flatMap((Function1 & Serializable)_$3 -> (Stream)_$3._2(), NotGiven$.MODULE$.value());
        return this.serverInternal(server, httpApp, tlsInfoOpt, shutdown, errorHandler, onWriteFailure, maxConnections, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, true, webSocketKey, enableHttp2, F);
    }

    public <F> Stream<F, Nothing$> unixSocketServer(UnixSockets<F> unixSockets, UnixSocketAddress unixSocketAddress, boolean deleteIfExists, boolean deleteOnClose, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Deferred<F, Either<Throwable, SocketAddress<IpAddress>>> ready, Shutdown<F> shutdown, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Async<F> evidence$1) {
        Stream server = Stream$.MODULE$.eval(ready.complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)SocketAddress$.MODULE$.apply((Host)Ipv4Address$.MODULE$.fromBytes(0, 0, 0, 0), (Port)Port$.MODULE$.fromInt(0).get())))).drain().$plus$plus(() -> this.$anonfun$3(unixSockets, unixSocketAddress, deleteIfExists, deleteOnClose));
        return this.serverInternal(server, httpApp, tlsInfoOpt, shutdown, errorHandler, onWriteFailure, maxConnections, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, false, webSocketKey, enableHttp2, evidence$1);
    }

    public <F> Stream<F, Nothing$> serverInternal(Stream<F, Socket<F>> server, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Shutdown<F> shutdown, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, boolean createRequestVault, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Async<F> evidence$2) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(shutdown.signal(), evidence$2);
        Stream streams = server.interruptWhen(ApplicativeErrorOps$.MODULE$.attempt$extension(object, evidence$2)).map((Function1 & Serializable)connect -> {
            Stream handler = shutdown.trackConnection().$greater$greater(() -> this.$anonfun$5(httpApp, tlsInfoOpt, errorHandler, onWriteFailure, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, createRequestVault, webSocketKey, enableHttp2, evidence$2, connect), NotGiven$.MODULE$.value());
            return handler.handleErrorWith((Function1 & Serializable)t -> Stream$.MODULE$.eval(logger.error(t, this::$anonfun$4$$anonfun$1$$anonfun$1)).drain());
        });
        Stream stream = Stream$.MODULE$.NestedStreamOps(streams);
        return Stream.NestedStreamOps$.MODULE$.parJoin$extension(stream, maxConnections, evidence$2);
    }

    public <F> Resource<F, Tuple2<Socket<F>, Option<String>>> upgradeSocket(Socket<F> socketInit, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Logger<F> logger, boolean enableHttp2, Monad<F> evidence$3) {
        return (Resource)tlsInfoOpt.fold(() -> this.upgradeSocket$$anonfun$1(socketInit, evidence$3), (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TLSContext context = (TLSContext)tuple2._1();
            TLSParameters params = (TLSParameters)tuple2._2();
            TLSParameters newParams = enableHttp2 ? H2TLS$.MODULE$.transform(params) : params;
            return context.serverBuilder(socketInit).withParameters(newParams).withLogging((Function1 & Serializable)s -> logger.trace(s)).build().evalMap((Function1 & Serializable)tlsSocket -> {
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(tlsSocket.write(Chunk$.MODULE$.empty()), (FlatMap)evidence$3);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.upgradeSocket$$anonfun$2$$anonfun$2$$anonfun$1(evidence$3, tlsSocket), (FlatMap)evidence$3);
            });
        });
    }

    public <F> Object runApp(byte[] head, Object read, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, Object> errorHandler, Socket<F> socket, boolean createRequestVault, GenTemporal<F, Throwable> F, Defer<F> D) {
        Object parse = Parser.Request$.MODULE$.parser(maxHeaderSize, head, read, F);
        Object parseWithHeaderTimeout = Util$.MODULE$.timeoutToMaybe(parse, requestHeaderReceiveTimeout, D.defer(() -> this.$anonfun$6(requestHeaderReceiveTimeout, F)), F);
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(parseWithHeaderTimeout, F).map((Function1 & Serializable)tmp -> {
            Tuple2 tuple2 = tmp;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Request req = (Request)tuple2._1();
            Object drain = tuple2._2();
            Tuple2 $1$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)req, drain);
            Tuple2 $1$2 = (Tuple2)tuple3._1();
            Request req2 = (Request)tuple3._2();
            Object drain2 = tuple3._3();
            return Tuple2$.MODULE$.apply(tmp, (Object)$1$2);
        }), F).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            Tuple2 tmp = (Tuple2)tuple2._1();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            Request req = (Request)tuple22._1();
            Object drain = tuple22._2();
            if (createRequestVault) {
                object = this.mkRequestVault(socket, (Applicative)F);
                return package.all$.MODULE$.toFlatMapOps(object, (FlatMap)F).flatMap((Function1 & Serializable)requestVault -> {
                    Object object = package.all$.MODULE$.catsSyntaxApplicativeError(httpApp.run().apply((Object)req.withAttributes(requestVault)), (ApplicativeError)F);
                    Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, errorHandler, (ApplicativeError)F), (ApplicativeError)F);
                    return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)_$9 -> (Response)serverFailure.covary(), (ApplicativeError)F), (Functor)F).map((Function1 & Serializable)resp -> Tuple3$.MODULE$.apply((Object)req, resp, drain));
                });
            } else {
                Vault vault = (Vault)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Vault$.MODULE$.empty());
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)vault, (Applicative)F);
            }
            return package.all$.MODULE$.toFlatMapOps(object, (FlatMap)F).flatMap((Function1 & Serializable)requestVault -> {
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(httpApp.run().apply((Object)req.withAttributes(requestVault)), (ApplicativeError)F);
                Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, errorHandler, (ApplicativeError)F), (ApplicativeError)F);
                return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)_$9 -> (Response)serverFailure.covary(), (ApplicativeError)F), (Functor)F).map((Function1 & Serializable)resp -> Tuple3$.MODULE$.apply((Object)req, resp, drain));
            });
        });
    }

    public <F> Object send(Socket<F> socket, Option<Request<F>> request, Response<F> resp, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, GenTemporal<F, Throwable> evidence$4) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(Encoder$.MODULE$.respToBytes(resp, Encoder$.MODULE$.respToBytes$default$2()).through((Function1 & Serializable)_$11 -> _$11.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout, evidence$4))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(evidence$4))).drain(), evidence$4);
        return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, evidence$4), evidence$4).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Either either = x$1;
            if (either instanceof Left) {
                Throwable err = (Throwable)((Left)either).value();
                object = onWriteFailure.apply((Object)request, (Object)resp, (Object)err);
                return object;
            } else {
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object2 = ((Right)either).value();
                if (boxedUnit != null ? !boxedUnit.equals(object2) : object2 != null) throw new MatchError((Object)either);
                object = Applicative$.MODULE$.apply((Applicative)evidence$4).unit();
            }
            return object;
        });
    }

    public <F> Object postProcessResponse(Request<F> req, Response<F> resp, GenConcurrent<F, Throwable> evidence$5, Clock<F> evidence$6) {
        Connection connection = Util$.MODULE$.connectionFor(req.httpVersion(), req.headers());
        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current(evidence$5, evidence$6), evidence$5).map((Function1 & Serializable)_$13 -> Date$.MODULE$.apply(_$13)), evidence$5).map((Function1 & Serializable)date -> (Response)resp.withHeaders(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance())})), resp.headers())));
    }

    public <F> Stream<F, Nothing$> runConnection(Socket<F> socket, Logger<F> logger, Duration idleTimeout, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, boolean createRequestVault, Key<WebSocketContext<F>> webSocketKey, ByteVector initialBuffer, boolean enableHttp2, Async<F> evidence$7) {
        Kleisli finalApp = enableHttp2 ? H2Server$.MODULE$.h2cUpgradeMiddleware(httpApp, evidence$7) : httpApp;
        Object object = package.all$.MODULE$.catsSyntaxMonadError(Util$.MODULE$.timeoutMaybe(socket.read(receiveBufferSize), idleTimeout, evidence$7), evidence$7);
        Object read = MonadErrorOps$.MODULE$.adaptError$extension(object, (PartialFunction)new Serializable(idleTimeout){
            private final Duration idleTimeout$7;
            {
                this.idleTimeout$7 = idleTimeout$14;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof TimeoutException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return throwable instanceof TimeoutException ? EmberException.ReadTimeout$.MODULE$.apply(this.idleTimeout$7) : function1.apply((Object)x);
            }
        }, evidence$7);
        byte[] byArray = (byte[])Predef$.MODULE$.ArrowAssoc((Object)initialBuffer.toArray());
        Stream stream = Stream$.MODULE$.unfoldEval((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)byArray, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function1 & Serializable)x$13 -> {
            Object object;
            Tuple2 tuple2 = x$13;
            if (tuple2 != null) {
                byte[] buffer = (byte[])tuple2._1();
                boolean reuse = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                Object object2 = Predef$.MODULE$.byteArrayOps(buffer);
                if (ArrayOps$.MODULE$.nonEmpty$extension(object2)) {
                    byte[] byArray = (byte[])package.all$.MODULE$.catsSyntaxApplicativeId((Object)buffer);
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)byArray, (Applicative)evidence$7);
                } else if (reuse) {
                    object = package.all$.MODULE$.toFlatMapOps(read, (FlatMap)evidence$7).flatMap((Function1 & Serializable)x$1 -> {
                        Object object;
                        Option option = x$1;
                        if (option instanceof Some) {
                            Chunk chunk = (Chunk)((Some)option).value();
                            byte[] byArray = (byte[])package.all$.MODULE$.catsSyntaxApplicativeId(chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)byArray, (Applicative)evidence$7);
                        } else if (None$.MODULE$.equals(option)) {
                            object = package$.MODULE$.Concurrent().apply((GenConcurrent)evidence$7, DummyImplicit$.MODULE$.dummyImplicit()).raiseError((Object)EmberException.EmptyStream$.MODULE$.apply());
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return object;
                    });
                } else {
                    byte[] byArray = (byte[])package.all$.MODULE$.catsSyntaxApplicativeId((Object)Array$.MODULE$.emptyByteArray());
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)byArray, (Applicative)evidence$7);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Object initRead = object;
            Object result = package.all$.MODULE$.toFlatMapOps(initRead, (FlatMap)evidence$7).flatMap((Function1 & Serializable)initBuffer -> this.runApp((byte[])initBuffer, read, maxHeaderSize, requestHeaderReceiveTimeout, (Kleisli)finalApp, errorHandler, socket, createRequestVault, (GenTemporal)evidence$7, (Defer)evidence$7));
            Object object3 = package.all$.MODULE$.catsSyntaxApplicativeError(result, (ApplicativeError)evidence$7);
            return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object3, (ApplicativeError)evidence$7), (FlatMap)evidence$7).flatMap((Function1 & Serializable)x$12 -> {
                Object object;
                Tuple3 tuple3;
                Either either = x$12;
                if (either instanceof Right && (tuple3 = (Tuple3)((Right)either).value()) != null) {
                    Request req = (Request)tuple3._1();
                    Response resp = (Response)tuple3._2();
                    Object drain = tuple3._3();
                    Option option = resp.attributes().lookup((LookupKey)webSocketKey);
                    if (option instanceof Some) {
                        WebSocketContext ctx = (WebSocketContext)((Some)option).value();
                        object = package.all$.MODULE$.toFlatMapOps(drain, (FlatMap)evidence$7).flatMap((Function1 & Serializable)x$1 -> {
                            Object object;
                            Option option = x$1;
                            if (option instanceof Some) {
                                byte[] buffer = (byte[])((Some)option).value();
                                object = package.all$.MODULE$.toFunctorOps(WebSocketHelpers$.MODULE$.upgrade(socket, req, ctx, buffer, receiveBufferSize, idleTimeout, onWriteFailure, errorHandler, logger, evidence$7), (Functor)evidence$7).as((Object)None$.MODULE$);
                            } else if (None$.MODULE$.equals(option)) {
                                object = Applicative$.MODULE$.apply((Applicative)evidence$7).pure((Object)None$.MODULE$);
                            } else {
                                throw new MatchError((Object)option);
                            }
                            return object;
                        });
                        return object;
                    }
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    Option option2 = resp.attributes().lookup((LookupKey)H2Keys$.MODULE$.H2cUpgrade());
                    if (None$.MODULE$.equals(option2)) {
                        object = package.all$.MODULE$.toFlatMapOps(this.postProcessResponse((Request)req, (Response)resp, (GenConcurrent)evidence$7, (Clock)evidence$7), (FlatMap)evidence$7).flatMap((Function1 & Serializable)nextResp -> package.all$.MODULE$.toFlatMapOps(this.send(socket, (Option)Some$.MODULE$.apply((Object)req), (Response)nextResp, idleTimeout, onWriteFailure, (GenTemporal)evidence$7), (FlatMap)evidence$7).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = x$1;
                            return package.all$.MODULE$.toFunctorOps(drain, (Functor)evidence$7).map((Function1 & Serializable)nextBuffer -> nextBuffer.map((Function1 & Serializable)buffer -> Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)req, nextResp), (Object)Tuple2$.MODULE$.apply(buffer, (Object)BoxesRunTime.boxToBoolean((boolean)true)))));
                        }));
                        return object;
                    }
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                    Tuple2 tuple2 = (Tuple2)((Some)option2).value();
                    if (tuple2 == null) throw new MatchError((Object)option2);
                    H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple2._1();
                    Request newReq = (Request)tuple2._2();
                    object = package.all$.MODULE$.toFlatMapOps(this.postProcessResponse((Request)req, (Response)resp, (GenConcurrent)evidence$7, (Clock)evidence$7), (FlatMap)evidence$7).flatMap((Function1 & Serializable)nextResp -> package.all$.MODULE$.toFlatMapOps(this.send(socket, (Option)Some$.MODULE$.apply((Object)req), (Response)nextResp, idleTimeout, onWriteFailure, (GenTemporal)evidence$7), (FlatMap)evidence$7).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = x$12;
                        return package.all$.MODULE$.toFlatMapOps(H2Server$.MODULE$.requireConnectionPreface(socket, (MonadError)evidence$7), (FlatMap)evidence$7).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = x$1;
                            Request request = (Request)package.all$.MODULE$.catsSyntaxOptionId((Object)newReq);
                            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(H2Server$.MODULE$.fromSocket(socket, httpApp, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger, settings, OptionIdOps$.MODULE$.some$extension((Object)request), evidence$7).use((Function1 & Serializable)_$15 -> package$.MODULE$.Async().apply(evidence$7).never(), (MonadCancel)evidence$7), (Functor)evidence$7).as((Object)None$.MODULE$), (Functor)evidence$7).map((Function1 & Serializable)out -> out);
                        });
                    }));
                    return object;
                }
                if (!(either instanceof Left)) throw new MatchError((Object)either);
                Throwable err = (Throwable)((Left)either).value();
                Throwable throwable = err;
                if (!(throwable instanceof EmberException.EmptyStream) || !EmberException.EmptyStream$.MODULE$.unapply((EmberException.EmptyStream)throwable)) {
                    if (throwable instanceof EmberException.RequestHeadersTimeout) {
                        EmberException.RequestHeadersTimeout requestHeadersTimeout = EmberException.RequestHeadersTimeout$.MODULE$.unapply((EmberException.RequestHeadersTimeout)throwable);
                        Duration duration = requestHeadersTimeout._1();
                    } else {
                        if (!(throwable instanceof EmberException.ReadTimeout)) {
                            Throwable err2 = throwable;
                            Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(errorHandler.apply((Object)err2), (ApplicativeError)evidence$7);
                            object = package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)_$16 -> (Response)serverFailure.covary(), (ApplicativeError)evidence$7), (FlatMap)evidence$7).flatMap((Function1 & Serializable)_$17 -> this.send(socket, (Option)None$.MODULE$, (Response)_$17, idleTimeout, onWriteFailure, (GenTemporal)evidence$7)), (Functor)evidence$7).as((Object)None$.MODULE$);
                            return object;
                        }
                        EmberException.ReadTimeout readTimeout = EmberException.ReadTimeout$.MODULE$.unapply((EmberException.ReadTimeout)throwable);
                        Duration duration = readTimeout._1();
                    }
                }
                object = Applicative$.MODULE$.apply((Applicative)evidence$7).pure((Object)None$.MODULE$);
                return object;
            });
        });
        return stream.takeWhile((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Response resp = (Response)tuple2._2();
            return Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$18 -> _$18.hasKeepAlive());
        }, stream.takeWhile$default$2()).drain();
    }

    private <F> Object mkRequestVault(Socket<F> socket, Applicative<F> evidence$8) {
        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(this.mkConnectionInfo(socket, (Apply<F>)evidence$8), this.mkSecureSession(socket, evidence$8))).mapN((Function2 & Serializable)(_$20, _$21) -> _$20.$plus$plus(_$21), evidence$8, evidence$8);
    }

    private <F> Object mkConnectionInfo(Socket<F> socket, Apply<F> evidence$9) {
        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(socket.localAddress(), socket.remoteAddress())).mapN((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SocketAddress local = (SocketAddress)tuple2._1();
            SocketAddress remote = (SocketAddress)tuple2._2();
            return Vault$.MODULE$.empty().insert((InsertKey)Request.Keys$.MODULE$.ConnectionInfo(), (Object)Request.Connection$.MODULE$.apply(local, remote, socket instanceof TLSSocket));
        }, evidence$9, evidence$9);
    }

    private <F> Object mkSecureSession(Socket<F> socket, Applicative<F> evidence$10) {
        Object object;
        Socket<F> socket2 = socket;
        if (socket2 instanceof TLSSocket) {
            TLSSocket socket3 = (TLSSocket)socket2;
            object = package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(socket3.session(), evidence$10).map((Function1 & Serializable)_$24 -> this.parseSSLSession((SSLSession)_$24)), evidence$10).map((Function1 & Serializable)_$25 -> Vault$.MODULE$.empty().insert((InsertKey)package.ServerRequestKeys$.MODULE$.SecureSession(), _$25));
        } else {
            Vault vault = (Vault)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Vault$.MODULE$.empty());
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)vault, evidence$10);
        }
        return object;
    }

    private final Stream $anonfun$3(UnixSockets unixSockets$1, UnixSocketAddress unixSocketAddress$1, boolean deleteIfExists$1, boolean deleteOnClose$1) {
        return unixSockets$1.server(unixSocketAddress$1, deleteIfExists$1, deleteOnClose$1);
    }

    private final Stream $anonfun$5$$anonfun$1$$anonfun$1(Kleisli httpApp$4, Logger logger$4, Async evidence$2$4, Socket socket$1) {
        return Stream$.MODULE$.resource(H2Server$.MODULE$.fromSocket(socket$1, httpApp$4, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger$4, H2Server$.MODULE$.fromSocket$default$5(), H2Server$.MODULE$.fromSocket$default$6(), evidence$2$4), (MonadCancel)evidence$2$4).drain();
    }

    private final Stream $anonfun$5(Kleisli httpApp$2, Option tlsInfoOpt$2, Function1 errorHandler$2, Function3 onWriteFailure$2, int receiveBufferSize$2, int maxHeaderSize$2, Duration requestHeaderReceiveTimeout$2, Duration idleTimeout$2, Logger logger$2, boolean createRequestVault$2, Key webSocketKey$2, boolean enableHttp2$2, Async evidence$2$2, Socket connect$1) {
        return Stream$.MODULE$.resource(this.upgradeSocket((Socket)connect$1, (Option)tlsInfoOpt$2, (Logger)logger$2, enableHttp2$2, (Monad)evidence$2$2), (MonadCancel)evidence$2$2).flatMap((Function1 & Serializable)x$12 -> {
            Stream stream;
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Socket socket = (Socket)tuple2._1();
            Option option = (Option)tuple2._2();
            Socket socket2 = socket;
            if (option instanceof Some) {
                if ("h2".equals(((Some)option).value())) {
                    stream = Stream$.MODULE$.exec(H2Server$.MODULE$.requireConnectionPreface(socket2, (MonadError)evidence$2$2)).$plus$plus(() -> this.$anonfun$5$$anonfun$1$$anonfun$1(httpApp$2, logger$2, evidence$2$2, socket2));
                    return stream;
                } else {
                    Socket socket3 = socket;
                    stream = this.runConnection(socket3, logger$2, idleTimeout$2, receiveBufferSize$2, maxHeaderSize$2, requestHeaderReceiveTimeout$2, httpApp$2, (Function1<Throwable, Object>)errorHandler$2, onWriteFailure$2, createRequestVault$2, webSocketKey$2, ByteVector$.MODULE$.empty(), enableHttp2$2, evidence$2$2).drain();
                }
                return stream;
            } else {
                Socket socket4 = socket;
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
                boolean bl = enableHttp2$2;
                if (bl) {
                    stream = Stream$.MODULE$.eval(H2Server$.MODULE$.checkConnectionPreface(socket4, (MonadError)evidence$2$2)).flatMap((Function1 & Serializable)x$1 -> {
                        Stream stream;
                        Either either = x$1;
                        if (either instanceof Left) {
                            ByteVector bv = (ByteVector)((Left)either).value();
                            stream = this.runConnection(socket4, logger$2, idleTimeout$2, receiveBufferSize$2, maxHeaderSize$2, requestHeaderReceiveTimeout$2, httpApp$2, (Function1<Throwable, Object>)errorHandler$2, onWriteFailure$2, createRequestVault$2, webSocketKey$2, bv, enableHttp2$2, evidence$2$2).drain();
                        } else if (either instanceof Right) {
                            stream = Stream$.MODULE$.resource(H2Server$.MODULE$.fromSocket(socket4, httpApp$2, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger$2, H2Server$.MODULE$.fromSocket$default$5(), H2Server$.MODULE$.fromSocket$default$6(), evidence$2$2), (MonadCancel)evidence$2$2).drain();
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return stream;
                    }, NotGiven$.MODULE$.value());
                    return stream;
                } else {
                    if (bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                    stream = this.runConnection(socket4, logger$2, idleTimeout$2, receiveBufferSize$2, maxHeaderSize$2, requestHeaderReceiveTimeout$2, httpApp$2, (Function1<Throwable, Object>)errorHandler$2, onWriteFailure$2, createRequestVault$2, webSocketKey$2, ByteVector$.MODULE$.empty(), enableHttp2$2, evidence$2$2).drain();
                }
            }
            return stream;
        }, NotGiven$.MODULE$.value());
    }

    private final String $anonfun$4$$anonfun$1$$anonfun$1() {
        return "Request handler failed with exception";
    }

    private final Resource upgradeSocket$$anonfun$1(Socket socketInit$1, Monad evidence$3$1) {
        Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Tuple2$.MODULE$.apply((Object)socketInit$1, (Object)Option$.MODULE$.empty()));
        return (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)tuple2, (Applicative)Resource$.MODULE$.catsEffectMonadForResource(evidence$3$1));
    }

    private final Object upgradeSocket$$anonfun$2$$anonfun$2$$anonfun$1(Monad evidence$3$4, TLSSocket tlsSocket$1) {
        return package.all$.MODULE$.toFunctorOps(tlsSocket$1.applicationProtocol(), (Functor)evidence$3$4).map((Function1 & Serializable)protocol -> {
            String string = (String)package.all$.MODULE$.catsSyntaxOptionId(protocol);
            return Tuple2$.MODULE$.apply((Object)tlsSocket$1, (Object)OptionIdOps$.MODULE$.some$extension((Object)string));
        });
    }

    private final Object $anonfun$6(Duration requestHeaderReceiveTimeout$5, GenTemporal F$1) {
        return F$1.raiseError((Object)EmberException.RequestHeadersTimeout$.MODULE$.apply(requestHeaderReceiveTimeout$5));
    }
}

