/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.MonadError;
import cats.Semigroupal$;
import cats.UnorderedFoldable;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Ref;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.UnorderedFoldableOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Signal;
import fs2.concurrent.Signal$;
import fs2.concurrent.SignallingRef$;
import fs2.io.net.Socket;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Protocol;
import org.http4s.Protocol$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.crypto.Hash$;
import org.http4s.crypto.HashAlgorithm;
import org.http4s.ember.core.Util$;
import org.http4s.ember.server.internal.ServerHelpers$;
import org.http4s.ember.server.internal.WebSocketHelpers;
import org.http4s.ember.server.internal.WebSocketHelpers$BothClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$BrokenPipeError$;
import org.http4s.ember.server.internal.WebSocketHelpers$EndOfStreamError$;
import org.http4s.ember.server.internal.WebSocketHelpers$EndpointClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$KeyNotFound$;
import org.http4s.ember.server.internal.WebSocketHelpers$Open$;
import org.http4s.ember.server.internal.WebSocketHelpers$PeerClosed$;
import org.http4s.ember.server.internal.WebSocketHelpers$UnsupportedVersion$;
import org.http4s.ember.server.internal.WebSocketHelpers$UpgradeRequired$;
import org.http4s.ember.server.internal.WebSocketHelpers$VersionNotFound$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Sec;
import org.http4s.headers.Sec$minusWebSocket$minusAccept$;
import org.http4s.headers.Sec$minusWebSocket$minusKey$;
import org.http4s.headers.Sec$minusWebSocket$minusVersion$;
import org.http4s.headers.Upgrade;
import org.http4s.headers.Upgrade$;
import org.http4s.syntax.package;
import org.http4s.websocket.FrameTranscoder;
import org.http4s.websocket.Rfc6455$;
import org.http4s.websocket.WebSocket;
import org.http4s.websocket.WebSocketCombinedPipe;
import org.http4s.websocket.WebSocketCombinedPipe$;
import org.http4s.websocket.WebSocketContext;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketSeparatePipe;
import org.http4s.websocket.WebSocketSeparatePipe$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.log4cats.Logger;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class WebSocketHelpers$
implements Serializable {
    private static final long supportedWebSocketVersion;
    private static final Protocol webSocketProtocol;
    private static final Connection connectionUpgrade;
    private static final Upgrade upgradeWebSocket;
    private static final FrameTranscoder nonClientTranscoder;
    private static final ByteVector magic;
    public static final WebSocketHelpers$Open$ Open;
    public static final WebSocketHelpers$PeerClosed$ PeerClosed;
    public static final WebSocketHelpers$EndpointClosed$ EndpointClosed;
    public static final WebSocketHelpers$BothClosed$ BothClosed;
    public static final WebSocketHelpers$VersionNotFound$ VersionNotFound;
    public static final WebSocketHelpers$UnsupportedVersion$ UnsupportedVersion;
    public static final WebSocketHelpers$UpgradeRequired$ UpgradeRequired;
    public static final WebSocketHelpers$KeyNotFound$ KeyNotFound;
    public static final WebSocketHelpers$EndOfStreamError$ EndOfStreamError;
    public static final WebSocketHelpers$BrokenPipeError$ BrokenPipeError;
    public static final WebSocketHelpers$ MODULE$;

    private WebSocketHelpers$() {
    }

    static {
        MODULE$ = new WebSocketHelpers$();
        supportedWebSocketVersion = 13L;
        CIString upgradeCi = package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"upgrade"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        webSocketProtocol = Protocol$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"websocket"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), (Option)None$.MODULE$);
        connectionUpgrade = Connection$.MODULE$.apply(NonEmptyList$.MODULE$.of((Object)upgradeCi, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])));
        upgradeWebSocket = Upgrade$.MODULE$.apply(webSocketProtocol, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[0]));
        nonClientTranscoder = new FrameTranscoder(false);
        magic = ByteVector$.MODULE$.view(Rfc6455$.MODULE$.handshakeMagicBytes());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WebSocketHelpers$.class);
    }

    public <F> Object upgrade(Socket<F> socket, Request<F> req, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, Function1<Throwable, Object> errorHandler, Logger<F> logger, Async<F> F) {
        Object object;
        Either<WebSocketHelpers.ClientHandshakeError, String> either = this.clientHandshake(req);
        if (either instanceof Right) {
            String key = (String)((Right)either).value();
            Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(this.serverHandshake(key, (MonadError<F, Throwable>)F), F).map((Function1 & Serializable)hashBytes -> {
                Sec.minusWebSocket.minusAccept secWebSocketAccept = new Sec.minusWebSocket.minusAccept(hashBytes);
                List headers = Headers$.MODULE$.$plus$plus$extension(ctx.headers(), Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connectionUpgrade, Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)upgradeWebSocket, Upgrade$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)secWebSocketAccept, Sec$minusWebSocket$minusAccept$.MODULE$.headerInstance())})));
                return (Response)Response$.MODULE$.apply(Status$.MODULE$.SwitchingProtocols(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withHeaders(headers);
            }), F);
            object = ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object2, errorHandler, F);
        } else if (either instanceof Left) {
            WebSocketHelpers.ClientHandshakeError error = (WebSocketHelpers.ClientHandshakeError)((Left)either).value();
            Response response2 = (Response)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(error.status(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withEntity((Object)error.message(), EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1())));
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)response2, F);
        } else {
            throw new MatchError(either);
        }
        Object wsResponse = object;
        Object handler = package.all$.MODULE$.toFlatMapOps(wsResponse, F).flatMap((Function1 & Serializable)response -> package.all$.MODULE$.toFlatMapOps(ServerHelpers$.MODULE$.send(socket, Some$.MODULE$.apply((Object)req), response, idleTimeout, onWriteFailure, F), (FlatMap)F).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            Status status = response.status();
            Status status2 = Status$.MODULE$.SwitchingProtocols();
            return package.all$.MODULE$.toFunctorOps(!(status != null ? !status.equals(status2) : status2 != null) ? this.runConnection(socket, ctx, buffer, receiveBufferSize, idleTimeout, F) : F.unit(), (Functor)F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
            });
        }));
        Object object3 = package.all$.MODULE$.catsSyntaxApplicativeError(handler, F);
        return ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object3, (Function1 & Serializable)x$1 -> {
            Object object;
            IOException iOException;
            Throwable throwable = x$1;
            if (throwable instanceof IOException && WebSocketHelpers$BrokenPipeError$.MODULE$.unapply(iOException = (IOException)throwable)) {
                IOException e = iOException;
                object = logger.trace((Throwable)e, this::upgrade$$anonfun$1$$anonfun$1);
            } else {
                Throwable e = throwable;
                object = logger.error(e, this::upgrade$$anonfun$1$$anonfun$2);
            }
            return object;
        }, F);
    }

    private <F> Object runConnection(Socket<F> socket, WebSocketContext<F> ctx, byte[] buffer, int receiveBufferSize, Duration idleTimeout, Async<F> F) {
        Object read = Util$.MODULE$.timeoutMaybe(socket.read(receiveBufferSize), idleTimeout, F);
        Stream incoming = Stream$.MODULE$.chunk(Chunk$.MODULE$.array((Object)buffer, ClassTag$.MODULE$.apply(Byte.TYPE))).$plus$plus(() -> this.$anonfun$3(read));
        return package.all$.MODULE$.toFlatMapOps(SignallingRef$.MODULE$.apply((Object)WebSocketHelpers$Open$.MODULE$, F), F).flatMap((Function1 & Serializable)close -> {
            Tuple2 tuple2;
            WebSocket webSocket = ctx.webSocket();
            if (webSocket instanceof WebSocketCombinedPipe) {
                WebSocketCombinedPipe webSocketCombinedPipe = WebSocketCombinedPipe$.MODULE$.unapply((WebSocketCombinedPipe)webSocket);
                Function1 function1 = webSocketCombinedPipe._1();
                Object object = webSocketCombinedPipe._2();
                Function1 receiveSend = function1;
                Object onClose = object;
                Stream stream = (Stream)Predef$.MODULE$.ArrowAssoc((Object)incoming.through(this.decodeFrames(F)).evalMapFilter((Function1 & Serializable)frame2 -> this.handleIncomingFrame((Function1<WebSocketFrame, Object>)(Function1 & Serializable)frame -> this.writeFrame$3(socket, idleTimeout, F, (WebSocketFrame)frame), (Ref)close, (WebSocketFrame)frame2, (GenConcurrent)F)).through(receiveSend).foreach((Function1 & Serializable)frame -> this.writeFrame$3(socket, idleTimeout, F, (WebSocketFrame)frame)));
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stream, onClose);
            } else if (webSocket instanceof WebSocketSeparatePipe) {
                WebSocketSeparatePipe webSocketSeparatePipe = WebSocketSeparatePipe$.MODULE$.unapply((WebSocketSeparatePipe)webSocket);
                Stream stream = webSocketSeparatePipe._1();
                Function1 function1 = webSocketSeparatePipe._2();
                Object object = webSocketSeparatePipe._3();
                Stream send = stream;
                Function1 receive = function1;
                Object onClose = object;
                Object sendClosingFrame = package.all$.MODULE$.toFlatMapOps(close.get(), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                    WebSocketHelpers.Close close = x$1;
                    return WebSocketHelpers$Open$.MODULE$.equals(close) ? package.all$.MODULE$.toFlatMapOps(F.fromEither(WebSocketFrame.Close$.MODULE$.apply(1000)), (FlatMap)F).flatMap((Function1 & Serializable)frame -> package.all$.MODULE$.toFlatMapOps(close.update((Function1 & Serializable)x$1 -> {
                        WebSocketHelpers.Close close = x$1;
                        return WebSocketHelpers$Open$.MODULE$.equals(close) ? WebSocketHelpers$EndpointClosed$.MODULE$ : WebSocketHelpers$BothClosed$.MODULE$;
                    }), (FlatMap)F).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = x$12;
                        return package.all$.MODULE$.toFunctorOps(this.writeFrame$3(socket, idleTimeout, F, (WebSocketFrame)frame), (Functor)F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = x$1;
                        });
                    })) : F.unit();
                });
                Stream writer = send.foreach((Function1 & Serializable)frame -> this.writeFrame$3(socket, idleTimeout, F, (WebSocketFrame)frame)).$plus$plus(() -> this.$anonfun$8(sendClosingFrame));
                Stream reader = incoming.through(this.decodeFrames(F)).evalMapFilter((Function1 & Serializable)frame2 -> this.handleIncomingFrame((Function1<WebSocketFrame, Object>)(Function1 & Serializable)frame -> this.writeFrame$3(socket, idleTimeout, F, (WebSocketFrame)frame), (Ref)close, (WebSocketFrame)frame2, (GenConcurrent)F)).through(receive);
                Stream stream2 = (Stream)Predef$.MODULE$.ArrowAssoc((Object)reader.concurrently(writer, (GenConcurrent)F));
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stream2, onClose);
            } else {
                throw new MatchError((Object)webSocket);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Stream stream = (Stream)tuple22._1();
            Object onClose = tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)stream, onClose);
            Stream stream3 = (Stream)tuple23._1();
            Object onClose2 = tuple23._2();
            Signal signal = Signal$.MODULE$.SignalOps((Signal)close);
            return stream3.interruptWhen(Signal.SignalOps$.MODULE$.map$extension(signal, (Function1 & Serializable)_$3 -> {
                WebSocketHelpers.Close close = _$3;
                WebSocketHelpers$BothClosed$ webSocketHelpers$BothClosed$ = WebSocketHelpers$BothClosed$.MODULE$;
                return !(close != null ? !close.equals(webSocketHelpers$BothClosed$) : webSocketHelpers$BothClosed$ != null);
            }, (Functor)F), (GenConcurrent)F).onFinalize(onClose2, (Applicative)F).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)F))).drain();
        });
    }

    private <F> Object handleIncomingFrame(Function1<WebSocketFrame, Object> writeFrame, Ref<F, WebSocketHelpers.Close> closeState, WebSocketFrame frame, GenConcurrent<F, Throwable> F) {
        Object object;
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebSocketFrame.Ping) {
            ByteVector byteVector;
            WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
            WebSocketFrame.Ping ping2 = WebSocketFrame.Ping$.MODULE$.unapply(ping);
            ByteVector data = byteVector = ping2._1();
            WebSocketFrame.Ping ping3 = ping;
            WebSocketFrame.Ping ping4 = (WebSocketFrame.Ping)package.all$.MODULE$.catsSyntaxOptionId((Object)ping3);
            object = package.all$.MODULE$.toFunctorOps(writeFrame.apply((Object)WebSocketFrame.Pong$.MODULE$.apply(data)), F).as((Object)OptionIdOps$.MODULE$.some$extension((Object)ping4));
        } else if (webSocketFrame instanceof WebSocketFrame.Close) {
            WebSocketFrame.Close close = WebSocketFrame.Close$.MODULE$.unapply((WebSocketFrame.Close)webSocketFrame);
            ByteVector byteVector = close._1();
            WebSocketFrame.Close frame2 = (WebSocketFrame.Close)webSocketFrame;
            object = package.all$.MODULE$.toFlatMapOps(closeState.get(), F).flatMap((Function1 & Serializable)x$1 -> {
                WebSocketHelpers.Close close = x$1;
                return WebSocketHelpers$Open$.MODULE$.equals(close) ? package.all$.MODULE$.toFlatMapOps(F.fromEither(WebSocketFrame.Close$.MODULE$.apply(frame2.closeCode())), (FlatMap)F).flatMap((Function1 & Serializable)frame -> package.all$.MODULE$.toFlatMapOps(writeFrame.apply(frame), (FlatMap)F).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = x$12;
                    return package.all$.MODULE$.toFunctorOps(closeState.set((Object)WebSocketHelpers$BothClosed$.MODULE$), (Functor)F).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return None$.MODULE$;
                    });
                })) : F.pure((Object)None$.MODULE$);
            });
        } else {
            WebSocketFrame x = webSocketFrame;
            object = F.pure((Object)Some$.MODULE$.apply((Object)x));
        }
        return object;
    }

    private List<Chunk<Object>> frameToBytes(WebSocketFrame frame) {
        return Predef$.MODULE$.wrapRefArray((Object[])nonClientTranscoder.frameToBuffer(frame)).toList().map((Function1 & Serializable)buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return Chunk$.MODULE$.array((Object)bytes, ClassTag$.MODULE$.apply(Byte.TYPE));
        });
    }

    private <F> Function1<Stream<F, Object>, Stream<F, WebSocketFrame>> decodeFrames(Async<F> F) {
        return (Function1 & Serializable)stream -> {
            Pull pull = Pull$.MODULE$.StreamPullOps(this.go$1(F, (Stream)stream, Array$.MODULE$.emptyByteArray()).void());
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
        };
    }

    private <F> Either<WebSocketHelpers.ClientHandshakeError, String> clientHandshake(Request<F> req) {
        Left left;
        Left left2;
        Upgrade header;
        NonEmptyList nonEmptyList;
        Connection header2;
        Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance()));
        Left connection = option instanceof Some && (header2 = (Connection)((Some)option).value()).hasUpgrade() ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        Option option2 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Upgrade$.MODULE$.headerInstance()));
        Left upgrade = option2 instanceof Some && UnorderedFoldableOps$.MODULE$.contains_$extension((Object)(nonEmptyList = (NonEmptyList)package.all$.MODULE$.catsSyntaxUnorderedFoldableOps((Object)(header = (Upgrade)((Some)option2).value()).values(), (UnorderedFoldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList())), (Object)webSocketProtocol, Protocol$.MODULE$.catsEqInstance(), (UnorderedFoldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()) ? EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either())) : scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UpgradeRequired$.MODULE$);
        Option option3 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusVersion$.MODULE$.headerInstance()));
        if (option3 instanceof Some) {
            Sec.minusWebSocket.minusVersion minusVersion2 = (Sec.minusWebSocket.minusVersion)((Some)option3).value();
            Sec.minusWebSocket.minusVersion header3 = minusVersion2;
            if (header3.version() == supportedWebSocketVersion) {
                left2 = EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()));
            } else {
                Sec.minusWebSocket.minusVersion header4 = minusVersion2;
                left2 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$UnsupportedVersion$.MODULE$.apply(supportedWebSocketVersion, header4.version()));
            }
        } else if (None$.MODULE$.equals(option3)) {
            left2 = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$VersionNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)option3);
        }
        Left version = left2;
        Option option4 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()));
        if (option4 instanceof Some) {
            Sec.minusWebSocket.minusKey header5 = (Sec.minusWebSocket.minusKey)((Some)option4).value();
            left = scala.package$.MODULE$.Right().apply((Object)package.all$.MODULE$.http4sHeaderSyntax((Object)header5, Sec$minusWebSocket$minusKey$.MODULE$.headerInstance()).value());
        } else if (None$.MODULE$.equals(option4)) {
            left = scala.package$.MODULE$.Left().apply((Object)WebSocketHelpers$KeyNotFound$.MODULE$);
        } else {
            throw new MatchError((Object)option4);
        }
        Left key = left;
        return (Either)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)connection, (Object)upgrade, (Object)version, (Object)key)).mapN((Function4 & Serializable)(x$1, x$2, x$3, x$4) -> {
            Tuple4 tuple4 = Tuple4$.MODULE$.apply(x$1, x$2, x$3, x$4);
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            String key = (String)tuple4._4();
            return key;
        }, (Functor)Invariant$.MODULE$.catsMonadErrorForEither(), Semigroupal$.MODULE$.catsSemigroupalForEither());
    }

    private <F> Object serverHandshake(String value2, MonadError<F, Throwable> F) {
        Either either = package.all$.MODULE$.catsSyntaxEither(ByteVector$.MODULE$.encodeAscii(value2));
        return package.all$.MODULE$.toFlatMapOps(EitherOps$.MODULE$.liftTo$extension(either, F), F).flatMap((Function1 & Serializable)value -> package.all$.MODULE$.toFunctorOps(Hash$.MODULE$.apply(Hash$.MODULE$.forApplicativeThrow((ApplicativeError)F)).digest((HashAlgorithm)HashAlgorithm.SHA1$.MODULE$, value.$plus$plus(magic)), (Functor)F).map((Function1 & Serializable)digest -> digest));
    }

    private <F> Stream<F, Object> readStream(Object read) {
        return Stream$.MODULE$.eval(read).flatMap((Function1 & Serializable)x$1 -> {
            Stream stream;
            Option option = x$1;
            if (option instanceof Some) {
                Chunk bytes = (Chunk)((Some)option).value();
                stream = Stream$.MODULE$.chunk(bytes).$plus$plus(() -> this.readStream$$anonfun$1$$anonfun$1(read));
            } else if (None$.MODULE$.equals(option)) {
                stream = Stream$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return stream;
        }, NotGiven$.MODULE$.value());
    }

    private final String upgrade$$anonfun$1$$anonfun$1() {
        return "WebSocket connection abruptly terminated by client";
    }

    private final String upgrade$$anonfun$1$$anonfun$2() {
        return "WebSocket connection terminated with exception";
    }

    private final Object writeFrame$3(Socket socket$3, Duration idleTimeout$3, Async F$3, WebSocketFrame frame) {
        return package.all$.MODULE$.toFoldableOps(this.frameToBytes(frame), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket$3.write(c), idleTimeout$3, (GenTemporal)F$3), (Applicative)F$3);
    }

    private final Stream $anonfun$3(Object read$1) {
        return this.readStream(read$1);
    }

    private final Stream $anonfun$8(Object sendClosingFrame$1) {
        return Stream$.MODULE$.exec(sendClosingFrame$1);
    }

    private final WebSocketFrame go$1$$anonfun$1$$anonfun$1(ByteBuffer byteBuffer$1) {
        return nonClientTranscoder.bufferToFrame(byteBuffer$1);
    }

    private final Pull go$1$$anonfun$1$$anonfun$2$$anonfun$1(Async F$18, Stream next$2, byte[] remaining$1) {
        return this.go$1(F$18, next$2, remaining$1);
    }

    private final Pull go$1(Async F$16, Stream rest, byte[] acc) {
        Stream stream = Stream$.MODULE$.InvariantOps(rest);
        Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream.ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
            Pull pull;
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Chunk chunk = (Chunk)tuple2._1();
                Stream next = (Stream)tuple2._2();
                Object object = Predef$.MODULE$.byteArrayOps(acc);
                byte[] buffer = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), ClassTag$.MODULE$.apply(Byte.TYPE));
                ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
                pull = Pull$.MODULE$.eval(F$16.delay(() -> this.go$1$$anonfun$1$$anonfun$1(byteBuffer))).flatMap((Function1 & Serializable)value -> {
                    Pull pull;
                    if (value != null) {
                        byte[] remaining = new byte[byteBuffer.remaining()];
                        byteBuffer.get(remaining);
                        pull = Pull$.MODULE$.output1(value).$greater$greater(() -> this.go$1$$anonfun$1$$anonfun$2$$anonfun$1(F$16, next, remaining));
                    } else {
                        pull = this.go$1(F$16, next, buffer);
                    }
                    return pull;
                });
            } else if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.raiseError((Throwable)WebSocketHelpers$EndOfStreamError$.MODULE$.apply(), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$16));
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    private final Stream readStream$$anonfun$1$$anonfun$1(Object read$3) {
        return this.readStream(read$3);
    }
}

