/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.server.internal;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.Apply;
import cats.Defer;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.package$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfFOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.SocketOption;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSLogger;
import fs2.io.net.tls.TLSParameters;
import fs2.io.net.tls.TLSSocket;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLSession;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.ember.core.EmberException;
import org.http4s.ember.core.Encoder$;
import org.http4s.ember.core.Parser;
import org.http4s.ember.core.Util$;
import org.http4s.ember.core.h2.H2Frame;
import org.http4s.ember.core.h2.H2Keys$;
import org.http4s.ember.core.h2.H2Server$;
import org.http4s.ember.core.h2.H2TLS$;
import org.http4s.ember.server.internal.ServerHelpersPlatform;
import org.http4s.ember.server.internal.Shutdown;
import org.http4s.ember.server.internal.WebSocketHelpers$;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Date$;
import org.http4s.server.package;
import org.http4s.websocket.WebSocketContext;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.SelfAwareLogger;
import org.typelevel.vault.InsertKey;
import org.typelevel.vault.Key;
import org.typelevel.vault.LookupKey;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.DummyImplicit$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class ServerHelpers$
implements ServerHelpersPlatform,
Serializable {
    private static final Response<Nothing$> serverFailure;
    public static final Response<Nothing$> org$http4s$ember$server$internal$ServerHelpers$$$badRequest;
    public static final ServerHelpers$ MODULE$;

    private ServerHelpers$() {
    }

    static {
        MODULE$ = new ServerHelpers$();
        serverFailure = (Response)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.zero(), Content$minusLength$.MODULE$.headerInstance())}));
        org$http4s$ember$server$internal$ServerHelpers$$$badRequest = (Response)Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.zero(), Content$minusLength$.MODULE$.headerInstance())}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ServerHelpers$.class);
    }

    public <F> Stream<F, Nothing$> server(Option<Host> host, Port port, List<SocketOption> additionalSocketOptions, SocketGroup<F> sg, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Deferred<F, Either<Throwable, SocketAddress<IpAddress>>> ready, Shutdown<F> shutdown, PartialFunction<Throwable, Object> connectionErrorHandler, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Function1<Throwable, Object> requestLineParseErrorHandler, Function1<EmberException.MessageTooLong, Object> maxHeaderSizeErrorHandler, Async<F> F) {
        Stream server = Stream$.MODULE$.resource(sg.serverResource(host, (Option)Some$.MODULE$.apply((Object)port), additionalSocketOptions), F).attempt().evalTap((Function1 & Serializable)e -> ready.complete((Object)e.map((Function1 & Serializable)_$2 -> (SocketAddress)_$2._1()))).rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), RaiseThrowable$.MODULE$.fromApplicativeError(F)).flatMap((Function1 & Serializable)_$3 -> (Stream)_$3._2(), NotGiven$.MODULE$.value());
        return this.serverInternal(server, httpApp, tlsInfoOpt, shutdown, connectionErrorHandler, errorHandler, onWriteFailure, maxConnections, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, true, webSocketKey, enableHttp2, requestLineParseErrorHandler, maxHeaderSizeErrorHandler, F);
    }

    public <F> Stream<F, Nothing$> unixSocketServer(UnixSockets<F> unixSockets, UnixSocketAddress unixSocketAddress, boolean deleteIfExists, boolean deleteOnClose, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Deferred<F, Either<Throwable, SocketAddress<IpAddress>>> ready, Shutdown<F> shutdown, PartialFunction<Throwable, Object> connectionErrorHandler, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Function1<Throwable, Object> requestLineParseErrorHandler, Function1<EmberException.MessageTooLong, Object> maxHeaderSizeErrorHandler, Async<F> evidence$1) {
        Stream server = Stream$.MODULE$.eval(ready.complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)SocketAddress$.MODULE$.apply((Host)Ipv4Address$.MODULE$.fromBytes(0, 0, 0, 0), (Port)Port$.MODULE$.fromInt(0).get())))).drain().$plus$plus(() -> ServerHelpers$.$anonfun$3(unixSockets, unixSocketAddress, deleteIfExists, deleteOnClose));
        return this.serverInternal(server, httpApp, tlsInfoOpt, shutdown, connectionErrorHandler, errorHandler, onWriteFailure, maxConnections, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, idleTimeout, logger, false, webSocketKey, enableHttp2, requestLineParseErrorHandler, maxHeaderSizeErrorHandler, evidence$1);
    }

    public <F> Stream<F, Nothing$> serverInternal(Stream<F, Socket<F>> server, Kleisli<F, Request<F>, Response<F>> httpApp, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Shutdown<F> shutdown, PartialFunction<Throwable, Object> connectionErrorHandler, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, int maxConnections, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Duration idleTimeout, Logger<F> logger, boolean createRequestVault, Key<WebSocketContext<F>> webSocketKey, boolean enableHttp2, Function1<Throwable, Object> requestLineParseErrorHandler, Function1<EmberException.MessageTooLong, Object> maxHeaderSizeErrorHandler, Async<F> evidence$1) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(shutdown.signal(), evidence$1);
        Stream streams = server.interruptWhen(ApplicativeErrorOps$.MODULE$.attempt$extension(object, evidence$1)).map((Function1 & Serializable)connect -> {
            Stream handler = shutdown.trackConnection().$greater$greater(() -> ServerHelpers$.$anonfun$5(connect, tlsInfoOpt, logger, enableHttp2, evidence$1, httpApp, idleTimeout, receiveBufferSize, maxHeaderSize, requestHeaderReceiveTimeout, errorHandler, onWriteFailure, createRequestVault, webSocketKey, requestLineParseErrorHandler, maxHeaderSizeErrorHandler), NotGiven$.MODULE$.value());
            return handler.handleErrorWith((Function1 & Serializable)t -> Stream$.MODULE$.eval(this.fullConnectionErrorHandler$1(connectionErrorHandler, logger, (Throwable)t)).drain());
        });
        Stream stream = Stream$.MODULE$.NestedStreamOps(streams);
        return Stream.NestedStreamOps$.MODULE$.parJoin$extension(stream, maxConnections, evidence$1);
    }

    public <F> Resource<F, Tuple2<Socket<F>, Option<String>>> upgradeSocket(Socket<F> socketInit, Option<Tuple2<TLSContext<F>, TLSParameters>> tlsInfoOpt, Logger<F> logger, boolean enableHttp2, MonadError<F, Throwable> F) {
        return (Resource)tlsInfoOpt.fold(() -> ServerHelpers$.upgradeSocket$$anonfun$1(socketInit), (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object object;
                TLSContext context = (TLSContext)tuple2._1();
                TLSParameters params = (TLSParameters)tuple2._2();
                TLSParameters newParams = enableHttp2 ? H2TLS$.MODULE$.transform(params) : params;
                Logger logger = logger;
                if (logger instanceof SelfAwareLogger) {
                    SelfAwareLogger l = (SelfAwareLogger)logger;
                    Object object2 = package.all$.MODULE$.catsSyntaxIfF(l.isTraceEnabled());
                    object = IfFOps$.MODULE$.ifF$extension(object2, () -> ServerHelpers$.upgradeSocket$$anonfun$2$$anonfun$1(logger), ServerHelpers$::upgradeSocket$$anonfun$2$$anonfun$2, (Functor)F);
                } else {
                    TLSLogger tLSLogger = (TLSLogger)package.all$.MODULE$.catsSyntaxApplicativeId((Object)TLSLogger.Enabled$.MODULE$.apply((Function1 & Serializable)s -> logger.trace(s)));
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)tLSLogger, (Applicative)F);
                }
                return Resource$.MODULE$.eval(object).flatMap((Function1 & Serializable)tlsLogger -> context.serverBuilder(socketInit).withParameters(newParams).withLogger(tlsLogger).build().evalMap((Function1 & Serializable)tlsSocket -> {
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(tlsSocket.write(Chunk$.MODULE$.empty()), (FlatMap)F);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.upgradeSocket$$anonfun$2$$anonfun$4$$anonfun$1$$anonfun$1(tlsSocket, F), (FlatMap)F);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <F> Object runApp(byte[] head, Object read, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, Object> errorHandler, Socket<F> socket, boolean createRequestVault, GenTemporal<F, Throwable> F, Defer<F> D) {
        Object parse = Parser.Request$.MODULE$.parser(maxHeaderSize, head, read, F);
        Object parseWithHeaderTimeout = Util$.MODULE$.timeoutToMaybe(parse, requestHeaderReceiveTimeout, D.defer(() -> ServerHelpers$.$anonfun$6(F, requestHeaderReceiveTimeout)), F);
        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(parseWithHeaderTimeout, F).map((Function1 & Serializable)tmp -> {
            Tuple2 tuple2 = tmp;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Request req = (Request)tuple2._1();
            Object drain = tuple2._2();
            Tuple2 $1$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)req, drain);
            Tuple2 $1$2 = (Tuple2)tuple3._1();
            Request req2 = (Request)tuple3._2();
            Object drain2 = tuple3._3();
            return Tuple2$.MODULE$.apply(tmp, (Object)$1$2);
        }), F).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Tuple2 tmp = (Tuple2)tuple2._1();
                if (tuple22 != null) {
                    Object object;
                    Request req = (Request)tuple22._1();
                    Object drain = tuple22._2();
                    if (createRequestVault) {
                        object = this.mkRequestVault(socket, (Applicative)F);
                    } else {
                        Vault vault = (Vault)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Vault$.MODULE$.empty());
                        object = ApplicativeIdOps$.MODULE$.pure$extension((Object)vault, (Applicative)F);
                    }
                    return package.all$.MODULE$.toFlatMapOps(object, (FlatMap)F).flatMap((Function1 & Serializable)requestVault -> {
                        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(httpApp.run().apply((Object)req.withAttributes(requestVault)), (ApplicativeError)F);
                        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(Throwable x) {
                                Throwable throwable = x;
                                if (throwable instanceof Parser.HeaderP$.ParseHeadersError) {
                                    Parser.HeaderP$.ParseHeadersError parseHeadersError = Parser.HeaderP$.ParseHeadersError$.MODULE$.unapply((Parser.HeaderP$.ParseHeadersError)throwable);
                                    Throwable throwable2 = parseHeadersError._1();
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(Throwable x, Function1 function1) {
                                Throwable throwable = x;
                                if (throwable instanceof Parser.HeaderP$.ParseHeadersError) {
                                    Parser.HeaderP$.ParseHeadersError parseHeadersError = Parser.HeaderP$.ParseHeadersError$.MODULE$.unapply((Parser.HeaderP$.ParseHeadersError)throwable);
                                    Throwable throwable2 = parseHeadersError._1();
                                    return ServerHelpers$.org$http4s$ember$server$internal$ServerHelpers$$$badRequest.covary();
                                }
                                return function1.apply((Object)x);
                            }
                        }, (ApplicativeError)F), (ApplicativeError)F);
                        Object object3 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object2, errorHandler, (ApplicativeError)F), (ApplicativeError)F);
                        return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object3, (Function1 & Serializable)_$9 -> (Response)serverFailure.covary(), (ApplicativeError)F), (Functor)F).map((Function1 & Serializable)resp -> Tuple3$.MODULE$.apply((Object)req, resp, drain));
                    });
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <F> Object send(Socket<F> socket, Option<Request<F>> request, Response<F> resp, Duration idleTimeout, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, GenTemporal<F, Throwable> evidence$1) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(Encoder$.MODULE$.respToBytes(resp, Encoder$.MODULE$.respToBytes$default$2(), evidence$1).through((Function1 & Serializable)_$11 -> _$11.chunks().foreach((Function1 & Serializable)c -> Util$.MODULE$.timeoutMaybe(socket.write(c), idleTimeout, evidence$1))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(evidence$1))).drain(), evidence$1);
        return ApplicativeErrorOps$.MODULE$.onError$extension(object, (PartialFunction)new Serializable(onWriteFailure, request, resp){
            private final Function3 onWriteFailure$5;
            private final Option request$1;
            private final Response resp$1;
            {
                this.onWriteFailure$5 = onWriteFailure$12;
                this.request$1 = request$2;
                this.resp$1 = resp$3;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable err = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable err = throwable = x;
                return this.onWriteFailure$5.apply((Object)this.request$1, (Object)this.resp$1, (Object)err);
            }
        }, evidence$1);
    }

    public <F> Object postProcessResponse(Request<F> req, Response<F> resp, GenConcurrent<F, Throwable> evidence$1, Clock<F> evidence$2) {
        Connection connection = Util$.MODULE$.connectionFor(req.httpVersion(), req.headers());
        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(HttpDate$.MODULE$.current(evidence$1, evidence$2), evidence$1).map((Function1 & Serializable)_$13 -> Date$.MODULE$.apply(_$13)), evidence$1).map((Function1 & Serializable)date -> (Response)resp.withHeaders(Headers$.MODULE$.$plus$plus$extension(Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(date, Date$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)connection, Connection$.MODULE$.headerInstance())})), resp.headers())));
    }

    public <F> Stream<F, Nothing$> runConnection(Socket<F> socket, Logger<F> logger, Duration idleTimeout, int receiveBufferSize, int maxHeaderSize, Duration requestHeaderReceiveTimeout, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Throwable, Object> errorHandler, Function3<Option<Request<F>>, Response<F>, Throwable, Object> onWriteFailure, boolean createRequestVault, Key<WebSocketContext<F>> webSocketKey, ByteVector initialBuffer, boolean enableHttp2, Function1<Throwable, Object> requestLineParseErrorHandler, Function1<EmberException.MessageTooLong, Object> maxHeaderSizeErrorHandler, Async<F> evidence$1) {
        Kleisli finalApp = enableHttp2 ? H2Server$.MODULE$.h2cUpgradeMiddleware(httpApp, evidence$1) : httpApp;
        Object object = package.all$.MODULE$.catsSyntaxMonadError(Util$.MODULE$.timeoutMaybe(socket.read(receiveBufferSize), idleTimeout, evidence$1), evidence$1);
        Object read = MonadErrorOps$.MODULE$.adaptError$extension(object, (PartialFunction)new Serializable(idleTimeout){
            private final Duration idleTimeout$7;
            {
                this.idleTimeout$7 = idleTimeout$14;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof TimeoutException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof TimeoutException) {
                    return EmberException.ReadTimeout$.MODULE$.apply(this.idleTimeout$7);
                }
                return function1.apply((Object)x);
            }
        }, evidence$1);
        byte[] byArray = (byte[])Predef$.MODULE$.ArrowAssoc((Object)initialBuffer.toArray());
        Stream stream = Stream$.MODULE$.unfoldEval((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)byArray, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function1 & Serializable)x$13 -> {
            Tuple2 tuple2 = x$13;
            if (tuple2 != null) {
                Object object;
                byte[] buffer = (byte[])tuple2._1();
                boolean reuse = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                Object object2 = Predef$.MODULE$.byteArrayOps(buffer);
                if (ArrayOps$.MODULE$.nonEmpty$extension(object2)) {
                    byte[] byArray = (byte[])package.all$.MODULE$.catsSyntaxApplicativeId((Object)buffer);
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)byArray, (Applicative)evidence$1);
                } else if (reuse) {
                    object = package.all$.MODULE$.toFlatMapOps(read, (FlatMap)evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            Chunk chunk = (Chunk)((Some)option).value();
                            byte[] byArray = (byte[])package.all$.MODULE$.catsSyntaxApplicativeId(chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                            return ApplicativeIdOps$.MODULE$.pure$extension((Object)byArray, (Applicative)evidence$1);
                        }
                        if (None$.MODULE$.equals(option)) {
                            return package$.MODULE$.Concurrent().apply((GenConcurrent)evidence$1, DummyImplicit$.MODULE$.dummyImplicit()).raiseError((Object)EmberException.EmptyStream$.MODULE$.apply());
                        }
                        throw new MatchError((Object)option);
                    });
                } else {
                    byte[] byArray = (byte[])package.all$.MODULE$.catsSyntaxApplicativeId((Object)Array$.MODULE$.emptyByteArray());
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)byArray, (Applicative)evidence$1);
                }
                Object initRead = object;
                Object result = package.all$.MODULE$.toFlatMapOps(initRead, (FlatMap)evidence$1).flatMap((Function1 & Serializable)initBuffer -> MODULE$.runApp((byte[])initBuffer, read, maxHeaderSize, requestHeaderReceiveTimeout, (Kleisli)finalApp, errorHandler, socket, createRequestVault, (GenTemporal)evidence$1, (Defer)evidence$1));
                Object object3 = package.all$.MODULE$.catsSyntaxApplicativeError(result, (ApplicativeError)evidence$1);
                return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object3, (ApplicativeError)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    Either either;
                    block14: {
                        Object object;
                        Throwable throwable;
                        block17: {
                            block15: {
                                block16: {
                                    Tuple3 tuple3;
                                    either = x$12;
                                    if (either instanceof Right && (tuple3 = (Tuple3)((Right)either).value()) != null) {
                                        Request req = (Request)tuple3._1();
                                        Response resp = (Response)tuple3._2();
                                        Object drain = tuple3._3();
                                        Option option = resp.attributes().lookup((LookupKey)webSocketKey);
                                        if (option instanceof Some) {
                                            WebSocketContext ctx = (WebSocketContext)((Some)option).value();
                                            return package.all$.MODULE$.toFlatMapOps(drain, (FlatMap)evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                                                Option option = x$1;
                                                if (option instanceof Some) {
                                                    byte[] buffer = (byte[])((Some)option).value();
                                                    return package.all$.MODULE$.toFunctorOps(WebSocketHelpers$.MODULE$.upgrade(socket, req, ctx, buffer, receiveBufferSize, idleTimeout, onWriteFailure, errorHandler, logger, evidence$1), (Functor)evidence$1).as((Object)None$.MODULE$);
                                                }
                                                if (None$.MODULE$.equals(option)) {
                                                    return Applicative$.MODULE$.apply((Applicative)evidence$1).pure((Object)None$.MODULE$);
                                                }
                                                throw new MatchError((Object)option);
                                            });
                                        }
                                        if (None$.MODULE$.equals(option)) {
                                            Tuple2 tuple2;
                                            Option option2 = resp.attributes().lookup((LookupKey)H2Keys$.MODULE$.H2cUpgrade());
                                            if (None$.MODULE$.equals(option2)) {
                                                return package.all$.MODULE$.toFlatMapOps(MODULE$.postProcessResponse((Request)req, (Response)resp, (GenConcurrent)evidence$1, (Clock)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)nextResp -> package.all$.MODULE$.toFlatMapOps(MODULE$.send(socket, (Option)Some$.MODULE$.apply((Object)req), (Response)nextResp, idleTimeout, onWriteFailure, (GenTemporal)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    return package.all$.MODULE$.toFunctorOps(drain, (Functor)evidence$1).map((Function1 & Serializable)nextBuffer -> nextBuffer.map((Function1 & Serializable)buffer -> Tuple2$.MODULE$.apply(nextResp, (Object)Tuple2$.MODULE$.apply(buffer, (Object)BoxesRunTime.boxToBoolean((boolean)true)))));
                                                }));
                                            }
                                            if (option2 instanceof Some && (tuple2 = (Tuple2)((Some)option2).value()) != null) {
                                                H2Frame.Settings.ConnectionSettings settings = (H2Frame.Settings.ConnectionSettings)tuple2._1();
                                                Request newReq = (Request)tuple2._2();
                                                return package.all$.MODULE$.toFlatMapOps(MODULE$.postProcessResponse((Request)req, (Response)resp, (GenConcurrent)evidence$1, (Clock)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)nextResp -> package.all$.MODULE$.toFlatMapOps(MODULE$.send(socket, (Option)Some$.MODULE$.apply((Object)req), (Response)nextResp, idleTimeout, onWriteFailure, (GenTemporal)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    return package.all$.MODULE$.toFlatMapOps(H2Server$.MODULE$.requireConnectionPreface(socket, (MonadError)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        Request request = (Request)package.all$.MODULE$.catsSyntaxOptionId((Object)newReq);
                                                        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(H2Server$.MODULE$.fromSocket(socket, httpApp, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger, settings, OptionIdOps$.MODULE$.some$extension((Object)request), evidence$1).use((Function1 & Serializable)_$15 -> package$.MODULE$.Async().apply(evidence$1).never(), (MonadCancel)evidence$1), (Functor)evidence$1).as((Object)None$.MODULE$), (Functor)evidence$1).map((Function1 & Serializable)out -> out);
                                                    });
                                                }));
                                            }
                                            throw new MatchError((Object)option2);
                                        }
                                        throw new MatchError((Object)option);
                                    }
                                    if (!(either instanceof Left)) break block14;
                                    Throwable err = (Throwable)((Left)either).value();
                                    throwable = err;
                                    if (throwable instanceof EmberException.EmptyStream && EmberException.EmptyStream$.MODULE$.unapply((EmberException.EmptyStream)throwable)) break block15;
                                    if (!(throwable instanceof EmberException.RequestHeadersTimeout)) break block16;
                                    EmberException.RequestHeadersTimeout requestHeadersTimeout = EmberException.RequestHeadersTimeout$.MODULE$.unapply((EmberException.RequestHeadersTimeout)throwable);
                                    Duration duration = requestHeadersTimeout._1();
                                    break block15;
                                }
                                if (!(throwable instanceof EmberException.ReadTimeout)) break block17;
                                EmberException.ReadTimeout readTimeout = EmberException.ReadTimeout$.MODULE$.unapply((EmberException.ReadTimeout)throwable);
                                Duration duration = readTimeout._1();
                            }
                            return Applicative$.MODULE$.apply((Applicative)evidence$1).pure((Object)None$.MODULE$);
                        }
                        Throwable err = throwable;
                        Throwable throwable2 = err;
                        if (throwable2 instanceof Parser.HeaderP$.ParseHeadersError) {
                            Parser.HeaderP$.ParseHeadersError err2 = (Parser.HeaderP$.ParseHeadersError)throwable2;
                            object = requestLineParseErrorHandler.apply((Object)err2);
                        } else if (throwable2 instanceof Parser.Request$.ReqPrelude$.ParsePreludeError) {
                            Parser.Request$.ReqPrelude$.ParsePreludeError err3 = (Parser.Request$.ReqPrelude$.ParsePreludeError)throwable2;
                            object = requestLineParseErrorHandler.apply((Object)err3);
                        } else if (throwable2 instanceof EmberException.MessageTooLong) {
                            EmberException.MessageTooLong err4 = (EmberException.MessageTooLong)throwable2;
                            object = maxHeaderSizeErrorHandler.apply((Object)err4);
                        } else {
                            Throwable err5 = throwable2;
                            object = errorHandler.apply((Object)err5);
                        }
                        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(object, (ApplicativeError)evidence$1);
                        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object2, (Function1 & Serializable)_$16 -> (Response)serverFailure.covary(), (ApplicativeError)evidence$1), (FlatMap)evidence$1).flatMap((Function1 & Serializable)_$17 -> MODULE$.send(socket, (Option)None$.MODULE$, (Response)_$17, idleTimeout, onWriteFailure, (GenTemporal)evidence$1)), (Functor)evidence$1).as((Object)None$.MODULE$);
                    }
                    throw new MatchError((Object)either);
                });
            }
            throw new MatchError((Object)tuple2);
        });
        return stream.takeWhile((Function1 & Serializable)_$18 -> Headers$.MODULE$.get$extension(_$18.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$19 -> _$19.hasKeepAlive()), stream.takeWhile$default$2()).drain().mask();
    }

    private <F> Object mkRequestVault(Socket<F> socket, Applicative<F> evidence$1) {
        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(this.mkConnectionInfo(socket, (Apply<F>)evidence$1), this.mkSecureSession(socket, evidence$1))).mapN((Function2 & Serializable)(_$21, _$22) -> _$21.$plus$plus(_$22), evidence$1, evidence$1);
    }

    private <F> Object mkConnectionInfo(Socket<F> socket, Apply<F> evidence$1) {
        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(socket.localAddress(), socket.remoteAddress())).mapN((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                SocketAddress local = (SocketAddress)tuple2._1();
                SocketAddress remote = (SocketAddress)tuple2._2();
                return Vault$.MODULE$.empty().insert((InsertKey)Request.Keys$.MODULE$.ConnectionInfo(), (Object)Request.Connection$.MODULE$.apply(local, remote, socket instanceof TLSSocket));
            }
            throw new MatchError((Object)tuple2);
        }, evidence$1, evidence$1);
    }

    private <F> Object mkSecureSession(Socket<F> socket, Applicative<F> evidence$1) {
        Socket<F> socket2 = socket;
        if (socket2 instanceof TLSSocket) {
            TLSSocket socket3 = (TLSSocket)socket2;
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(socket3.session(), evidence$1).map((Function1 & Serializable)_$25 -> MODULE$.parseSSLSession((SSLSession)_$25)), evidence$1).map((Function1 & Serializable)_$26 -> Vault$.MODULE$.empty().insert((InsertKey)package.ServerRequestKeys$.MODULE$.SecureSession(), _$26));
        }
        Vault vault = (Vault)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Vault$.MODULE$.empty());
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)vault, evidence$1);
    }

    private static final Stream $anonfun$3(UnixSockets unixSockets$1, UnixSocketAddress unixSocketAddress$1, boolean deleteIfExists$1, boolean deleteOnClose$1) {
        return unixSockets$1.server(unixSocketAddress$1, deleteIfExists$1, deleteOnClose$1);
    }

    private static final String $anonfun$5$$anonfun$1$$anonfun$1() {
        return "Failed to upgrade socket to TLS";
    }

    private static final Stream $anonfun$5$$anonfun$2$$anonfun$1(Socket socket$1, Kleisli httpApp$4, Logger logger$5, Async evidence$1$4) {
        return Stream$.MODULE$.resource(H2Server$.MODULE$.fromSocket(socket$1, httpApp$4, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger$5, H2Server$.MODULE$.fromSocket$default$5(), H2Server$.MODULE$.fromSocket$default$6(), evidence$1$4), (MonadCancel)evidence$1$4).drain();
    }

    private static final Stream $anonfun$5(Socket connect$1, Option tlsInfoOpt$2, Logger logger$2, boolean enableHttp2$2, Async evidence$1$2, Kleisli httpApp$2, Duration idleTimeout$2, int receiveBufferSize$2, int maxHeaderSize$2, Duration requestHeaderReceiveTimeout$2, Function1 errorHandler$2, Function3 onWriteFailure$2, boolean createRequestVault$2, Key webSocketKey$2, Function1 requestLineParseErrorHandler$2, Function1 maxHeaderSizeErrorHandler$2) {
        return Stream$.MODULE$.resource(MODULE$.upgradeSocket((Socket)connect$1, (Option)tlsInfoOpt$2, (Logger)logger$2, enableHttp2$2, (MonadError)evidence$1$2), (MonadCancel)evidence$1$2).handleErrorWith((Function1 & Serializable)err -> Stream$.MODULE$.exec(logger$2.warn(err, ServerHelpers$::$anonfun$5$$anonfun$1$$anonfun$1))).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Socket socket = (Socket)tuple2._1();
                Option option = (Option)tuple2._2();
                Socket socket2 = socket;
                if (option instanceof Some) {
                    if ("h2".equals(((Some)option).value())) {
                        return Stream$.MODULE$.exec(H2Server$.MODULE$.requireConnectionPreface(socket2, (MonadError)evidence$1$2)).$plus$plus(() -> ServerHelpers$.$anonfun$5$$anonfun$2$$anonfun$1(socket2, httpApp$2, logger$2, evidence$1$2));
                    }
                    Socket socket3 = socket;
                    return MODULE$.runConnection(socket3, logger$2, idleTimeout$2, receiveBufferSize$2, maxHeaderSize$2, requestHeaderReceiveTimeout$2, httpApp$2, (Function1<Throwable, Object>)errorHandler$2, onWriteFailure$2, createRequestVault$2, webSocketKey$2, ByteVector$.MODULE$.empty(), enableHttp2$2, (Function1<Throwable, Object>)requestLineParseErrorHandler$2, (Function1<EmberException.MessageTooLong, Object>)maxHeaderSizeErrorHandler$2, evidence$1$2).drain();
                }
                Socket socket4 = socket;
                if (None$.MODULE$.equals(option)) {
                    boolean bl = enableHttp2$2;
                    if (bl) {
                        return Stream$.MODULE$.eval(H2Server$.MODULE$.checkConnectionPreface(socket4, (MonadError)evidence$1$2)).flatMap((Function1 & Serializable)x$1 -> {
                            Either either = x$1;
                            if (either instanceof Left) {
                                ByteVector bv = (ByteVector)((Left)either).value();
                                return MODULE$.runConnection(socket4, logger$2, idleTimeout$2, receiveBufferSize$2, maxHeaderSize$2, requestHeaderReceiveTimeout$2, httpApp$2, (Function1<Throwable, Object>)errorHandler$2, onWriteFailure$2, createRequestVault$2, webSocketKey$2, bv, enableHttp2$2, (Function1<Throwable, Object>)requestLineParseErrorHandler$2, (Function1<EmberException.MessageTooLong, Object>)maxHeaderSizeErrorHandler$2, evidence$1$2).drain();
                            }
                            if (either instanceof Right) {
                                return Stream$.MODULE$.resource(H2Server$.MODULE$.fromSocket(socket4, httpApp$2, H2Frame.Settings$.ConnectionSettings$.MODULE$.default(), logger$2, H2Server$.MODULE$.fromSocket$default$5(), H2Server$.MODULE$.fromSocket$default$6(), evidence$1$2), (MonadCancel)evidence$1$2).drain();
                            }
                            throw new MatchError((Object)either);
                        }, NotGiven$.MODULE$.value());
                    }
                    if (!bl) {
                        return MODULE$.runConnection(socket4, logger$2, idleTimeout$2, receiveBufferSize$2, maxHeaderSize$2, requestHeaderReceiveTimeout$2, httpApp$2, (Function1<Throwable, Object>)errorHandler$2, onWriteFailure$2, createRequestVault$2, webSocketKey$2, ByteVector$.MODULE$.empty(), enableHttp2$2, (Function1<Throwable, Object>)requestLineParseErrorHandler$2, (Function1<EmberException.MessageTooLong, Object>)maxHeaderSizeErrorHandler$2, evidence$1$2).drain();
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
            }
            throw new MatchError((Object)tuple2);
        }, NotGiven$.MODULE$.value());
    }

    private static final String fullConnectionErrorHandler$1$$anonfun$1$$anonfun$1() {
        return "Request handler failed with exception";
    }

    private final Object fullConnectionErrorHandler$1(PartialFunction connectionErrorHandler$2, Logger logger$7, Throwable t2) {
        return connectionErrorHandler$2.applyOrElse((Object)t2, (Function1 & Serializable)t -> logger$7.error(t, ServerHelpers$::fullConnectionErrorHandler$1$$anonfun$1$$anonfun$1));
    }

    private static final Resource upgradeSocket$$anonfun$1(Socket socketInit$1) {
        Tuple2 tuple2 = (Tuple2)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Tuple2$.MODULE$.apply((Object)socketInit$1, (Object)Option$.MODULE$.empty()));
        return (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)tuple2, (Applicative)Resource$.MODULE$.catsEffectMonadForResource());
    }

    private static final TLSLogger upgradeSocket$$anonfun$2$$anonfun$1(Logger logger$10) {
        return TLSLogger.Enabled$.MODULE$.apply((Function1 & Serializable)s -> logger$10.trace(s));
    }

    private static final TLSLogger upgradeSocket$$anonfun$2$$anonfun$2() {
        return TLSLogger.Disabled$.MODULE$;
    }

    private final Object upgradeSocket$$anonfun$2$$anonfun$4$$anonfun$1$$anonfun$1(TLSSocket tlsSocket$1, MonadError F$4) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(tlsSocket$1.applicationProtocol(), (Functor)F$4).map((Function1 & Serializable)protocol -> {
            String string = (String)package.all$.MODULE$.catsSyntaxOptionId(protocol);
            return Tuple2$.MODULE$.apply((Object)tlsSocket$1, (Object)OptionIdOps$.MODULE$.some$extension((Object)string));
        }), (ApplicativeError)F$4);
        return ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(tlsSocket$1){
            private final TLSSocket tlsSocket$3;
            {
                this.tlsSocket$3 = tlsSocket$4;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchElementException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchElementException) {
                    return Tuple2$.MODULE$.apply((Object)this.tlsSocket$3, (Object)Option$.MODULE$.empty());
                }
                return function1.apply((Object)x);
            }
        }, (ApplicativeError)F$4);
    }

    private static final Object $anonfun$6(GenTemporal F$5, Duration requestHeaderReceiveTimeout$5) {
        return F$5.raiseError((Object)EmberException.RequestHeadersTimeout$.MODULE$.apply(requestHeaderReceiveTimeout$5));
    }
}

