/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.netty.server;

import cats.Defer;
import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.std.Dispatcher;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.Executor;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.netty.package$;
import org.http4s.netty.server.Http4sNettyHandler$;
import org.http4s.netty.server.Http4sNettyHandler$InvalidMessageException$;
import org.http4s.netty.server.ServerNettyModelConversion;
import org.http4s.server.websocket.WebSocketBuilder2;
import org.http4s.server.websocket.WebSocketBuilder2$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.vault.Key;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r}bA\u0002\u00180\u0003\u0003\tt\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003E\u0011!y\u0006A!A!\u0002\u0017\u0001\u0007\"\u00028\u0001\t\u0003y\u0007\"C;\u0001\u0001\u0004\u0005\t\u0015)\u0003w\u0011\u0019a\b\u0001)Q\u0005{\"A\u0011q\u0001\u0001!\u0002\u0013\tI\u0001\u0003\u0005\u0002 \u0001\u0001\u000b\u0015BA\u0011\u0011-\t9\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u000b\t\u0013\u0005e\u0002A1A\u0005\u0012\u0005m\u0002\u0002CA%\u0001\u0001\u0006I!!\u0010\t\u000f\u0005-\u0003A\"\u0001\u0002N!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\t\t\u000e\u0001C!\u0003'Dq!a6\u0001\t\u0003\nI\u000eC\u0004\u0002^\u0002!\t%a8\t\u0011\u0005\u001d\b\u0001)C\u0005\u0003SD\u0001\"!<\u0001A\u0013%\u0011q^\u0004\b\u0005\u0007y\u0003\u0012\u0001B\u0003\r\u0019qs\u0006#\u0001\u0003\b!1a.\u0006C\u0001\u0005\u001fA\u0011B!\u0005\u0016\u0005\u0004%IAa\u0005\t\u0011\t\u0015R\u0003)A\u0005\u0005+9\u0001Ba\n\u0016\u0011\u0003\u000b$\u0011\u0006\u0004\t\u0005[)\u0002\u0012Q\u0019\u00030!1aN\u0007C\u0001\u0005'B\u0011B!\u0016\u001b\u0003\u0003%\tEa\u0016\t\u0013\tu#$!A\u0005\u0002\t}\u0003\"\u0003B45\u0005\u0005I\u0011\u0001B5\u0011%\u0011yGGA\u0001\n\u0003\u0012\t\bC\u0005\u0003|i\t\t\u0011\"\u0001\u0003~!I!q\u0011\u000e\u0002\u0002\u0013\u0005#\u0011\u0012\u0005\n\u0005\u0017S\u0012\u0011!C\u0005\u0005\u001b3aAa$\u0016\t\tE\u0005B\u0003BQG\t\u0005\t\u0015!\u0003\u0003$\"Q!1Z\u0012\u0003\u0002\u0003\u0006IA!4\t\u0015\tu7E!A!\u0002\u0013\u0011\t\u0007\u0003\u0006\u0003`\u000e\u0012\t\u0011)A\u0005\u0005CD\u0011bX\u0012\u0003\u0002\u0003\u0006YAa9\t\u0015\t\u00158E!A!\u0002\u0017\u00119\u000f\u0003\u0004oG\u0011\u0005!q\u001e\u0005\t\u0007\u0003\u0019\u0003\u0015!\u0003\u0004\u0004!9\u00111J\u0012\u0005B\r%\u0001b\u0002BX+\u0011\u000511\u0003\u0002\u0013\u0011R$\b\u000fN:OKR$\u0018\u0010S1oI2,'O\u0003\u00021c\u000511/\u001a:wKJT!AM\u001a\u0002\u000b9,G\u000f^=\u000b\u0005Q*\u0014A\u00025uiB$4OC\u00017\u0003\ry'oZ\u000b\u0003qA\u001b\"\u0001A\u001d\u0011\u0005i\u0002U\"A\u001e\u000b\u0005qj\u0014aB2iC:tW\r\u001c\u0006\u0003eyR\u0011aP\u0001\u0003S>L!!Q\u001e\u00039\rC\u0017M\u001c8fY&s'm\\;oI\"\u000bg\u000e\u001a7fe\u0006#\u0017\r\u001d;fe\u0006!A-[:q\u0007\u0001\u00012!\u0012'O\u001b\u00051%BA$I\u0003\r\u0019H\u000f\u001a\u0006\u0003\u0013*\u000ba!\u001a4gK\u000e$(\"A&\u0002\t\r\fGo]\u0005\u0003\u001b\u001a\u0013!\u0002R5ta\u0006$8\r[3s!\ty\u0005\u000b\u0004\u0001\u0005\u000bE\u0003!\u0019\u0001*\u0003\u0003\u0019+\"aU/\u0012\u0005QS\u0006CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&a\u0002(pi\"Lgn\u001a\t\u0003+nK!\u0001\u0018,\u0003\u0007\u0005s\u0017\u0010B\u0003_!\n\u00071K\u0001\u0003`I\u0011\n\u0014!\u0001$\u0011\u0007\u0005\\gJ\u0004\u0002cS:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003M\u000e\u000ba\u0001\u0010:p_Rt\u0014\"A&\n\u0005%S\u0015B\u00016I\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u000b\u0005\u001b\u0018P\\2\u000b\u0005)D\u0015A\u0002\u001fj]&$h\b\u0006\u0002qiR\u0011\u0011o\u001d\t\u0004e\u0002qU\"A\u0018\t\u000b}\u001b\u00019\u00011\t\u000b\t\u001b\u0001\u0019\u0001#\u0002!\u00154XM\u001c;M_>\u00048i\u001c8uKb$\bCA<{\u001b\u0005A(BA=W\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003wb\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002!1\f7\u000f\u001e*fgB|gn]3TK:$\b\u0003B<\u007f\u0003\u0003I!a =\u0003\r\u0019+H/\u001e:f!\r)\u00161A\u0005\u0004\u0003\u000b1&\u0001B+oSR\f\u0001\u0003]3oI&twMU3ta>t7/Z:\u0011\r\u0005-\u0011QCA\r\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003'1\u0016AC2pY2,7\r^5p]&!\u0011qCA\u0007\u0005\u0015\tV/Z;f!\u0011)\u00161D?\n\u0007\u0005uaKA\u0005Gk:\u001cG/[8oa\u0005Q1-Y2iK\u0012$\u0015\r^3\u0011\u0007U\u000b\u0019#C\u0002\u0002&Y\u0013A\u0001T8oO\u0006\u00012-Y2iK\u0012$\u0015\r^3TiJLgn\u001a\t\u0005\u0003W\t\u0019D\u0004\u0003\u0002.\u0005=\u0002C\u00013W\u0013\r\t\tDV\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Eb+\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003{\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007*\u0014!\u00027pOR\u001a\u0018\u0002BA$\u0003\u0003\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0007Q\u0006tG\r\\3\u0015\u0011\u0005=\u0013\u0011NA9\u0003w\u0002b!YA)\u001d\u0006U\u0013bAA*[\nA!+Z:pkJ\u001cW\r\u0005\u0003\u0002X\u0005\u0015TBAA-\u0015\u0011\tY&!\u0018\u0002\t!$H\u000f\u001d\u0006\u0005\u0003?\n\t'A\u0003d_\u0012,7MC\u0002\u0002du\nq\u0001[1oI2,'/\u0003\u0003\u0002h\u0005e#a\u0005#fM\u0006,H\u000e\u001e%uiB\u0014Vm\u001d9p]N,\u0007B\u0002\u001f\f\u0001\u0004\tY\u0007E\u0002;\u0003[J1!a\u001c<\u0005\u001d\u0019\u0005.\u00198oK2Dq!a\u001d\f\u0001\u0004\t)(A\u0004sKF,Xm\u001d;\u0011\t\u0005]\u0013qO\u0005\u0005\u0003s\nIFA\u0006IiR\u0004(+Z9vKN$\bbBA?\u0017\u0001\u0007\u0011\u0011F\u0001\u000bI\u0006$Xm\u0015;sS:<\u0017aC2iC:tW\r\u001c*fC\u0012$b!!\u0001\u0002\u0004\u00065\u0005bBAC\u0019\u0001\u0007\u0011qQ\u0001\u0004GRD\bc\u0001\u001e\u0002\n&\u0019\u00111R\u001e\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\"9\u0011q\u0012\u0007A\u0002\u0005E\u0015aA7tOB!\u00111SAO\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015\u0001\u00027b]\u001eT!!a'\u0002\t)\fg/Y\u0005\u0005\u0003?\u000b)J\u0001\u0004PE*,7\r^\u0001\u0014G\"\fgN\\3m%\u0016\fGmQ8na2,G/\u001a\u000b\u0005\u0003\u0003\t)\u000bC\u0004\u0002\u00066\u0001\r!a\"\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$b!!\u0001\u0002,\u00065\u0006bBAC\u001d\u0001\u0007\u0011q\u0011\u0005\b\u0003_s\u0001\u0019AAY\u0003\u0015\u0019\u0017-^:f!\u0011\t\u0019,a/\u000f\t\u0005U\u0016\u0011\u0018\b\u0004I\u0006]\u0016\"A,\n\u0005)4\u0016\u0002BA_\u0003\u007f\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005)4\u0006f\u0002\b\u0002D\u0006%\u00171\u001a\t\u0005\u0003'\u000b)-\u0003\u0003\u0002H\u0006U%\u0001E*vaB\u0014Xm]:XCJt\u0017N\\4t\u0003\u00151\u0018\r\\;fY\t\ti-\t\u0002\u0002P\u0006YA-\u001a9sK\u000e\fG/[8o\u00031A\u0017M\u001c3mKJ\fE\rZ3e)\u0011\t\t!!6\t\u000f\u0005\u0015u\u00021\u0001\u0002\b\u0006i1\r[1o]\u0016d\u0017i\u0019;jm\u0016$B!!\u0001\u0002\\\"9\u0011Q\u0011\tA\u0002\u0005\u001d\u0015AE;tKJ,e/\u001a8u)JLwmZ3sK\u0012$b!!\u0001\u0002b\u0006\r\bbBAC#\u0001\u0007\u0011q\u0011\u0005\u0007\u0003K\f\u0002\u0019\u0001.\u0002\u0007\u00154H/A\u0006j]&$\b*\u00198eY\u0016\u0014H\u0003BA\u0001\u0003WDq!!\"\u0013\u0001\u0004\t9)A\ftK:$7+[7qY\u0016,%O]8s%\u0016\u001c\bo\u001c8tKR1\u0011\u0011_A|\u0003s\u00042AOAz\u0013\r\t)p\u000f\u0002\u000e\u0007\"\fgN\\3m\rV$XO]3\t\u000f\u0005\u00155\u00031\u0001\u0002\b\"9\u00111`\nA\u0002\u0005u\u0018AB:uCR,8\u000f\u0005\u0003\u0002X\u0005}\u0018\u0002\u0002B\u0001\u00033\u0012!\u0003\u0013;uaJ+7\u000f]8og\u0016\u001cF/\u0019;vg\u0006\u0011\u0002\n\u001e;qiMtU\r\u001e;z\u0011\u0006tG\r\\3s!\t\u0011XcE\u0002\u0016\u0005\u0013\u00012!\u0016B\u0006\u0013\r\u0011iA\u0016\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0015\u0011a\u0006*G\u0007^\u00124'M%ogR\fg\u000e\u001e$pe6\fG\u000f^3s+\t\u0011)\u0002\u0005\u0003\u0003\u0018\t\u0005RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\r\u0019|'/\\1u\u0015\u0011\u0011y\"!'\u0002\tQLW.Z\u0005\u0005\u0005G\u0011IBA\tECR,G+[7f\r>\u0014X.\u0019;uKJ\f\u0001D\u0015$DoI\u001a\u0014'\u00138ti\u0006tGOR8s[\u0006$H/\u001a:!\u0003]IeN^1mS\u0012lUm]:bO\u0016,\u0005pY3qi&|g\u000eE\u0002\u0003,ii\u0011!\u0006\u0002\u0018\u0013:4\u0018\r\\5e\u001b\u0016\u001c8/Y4f\u000bb\u001cW\r\u001d;j_:\u001c\u0012B\u0007B\u0019\u0005o\u00119E!\u0014\u0011\t\u0005M&1G\u0005\u0005\u0005k\tyLA\u0005Fq\u000e,\u0007\u000f^5p]B!!\u0011\bB\"\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012aB2p]R\u0014x\u000e\u001c\u0006\u0004\u0005\u00032\u0016\u0001B;uS2LAA!\u0012\u0003<\taaj\\*uC\u000e\\GK]1dKB\u0019QK!\u0013\n\u0007\t-cKA\u0004Qe>$Wo\u0019;\u0011\t\u0005M&qJ\u0005\u0005\u0005#\nyL\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003*\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0017\u0011\t\u0005M%1L\u0005\u0005\u0003k\t)*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003bA\u0019QKa\u0019\n\u0007\t\u0015dKA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002[\u0005WB\u0011B!\u001c\u001f\u0003\u0003\u0005\rA!\u0019\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\bE\u0003\u0003v\t]$,\u0004\u0002\u0002\u0012%!!\u0011PA\t\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t}$Q\u0011\t\u0004+\n\u0005\u0015b\u0001BB-\n9!i\\8mK\u0006t\u0007\u0002\u0003B7A\u0005\u0005\t\u0019\u0001.\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005E%\u0001E,fEN|7m[3u\u0011\u0006tG\r\\3s+\u0011\u0011\u0019J!'\u0014\u0007\r\u0012)\n\u0005\u0003s\u0001\t]\u0005cA(\u0003\u001a\u00121\u0011k\tb\u0001\u00057+2a\u0015BO\t\u001d\u0011yJ!'C\u0002M\u0013Aa\u0018\u0013%e\u0005)\u0011\r\u001d9G]B9QK!*\u0003*\n]\u0016b\u0001BT-\nIa)\u001e8di&|g.\r\t\u0007\u0005W\u0013\u0019La&\u000e\u0005\t5&\u0002\u0002BX\u0005c\u000b\u0011b^3cg>\u001c7.\u001a;\u000b\u0005A\u001a\u0014\u0002\u0002B[\u0005[\u0013\u0011cV3c'>\u001c7.\u001a;Ck&dG-\u001a:3!\u0019\u0011IL!2\u0003\u0018:!!1\u0018Bb\u001d\u0011\u0011iL!1\u000f\u0007\u0011\u0014y,C\u00017\u0013\t!T'\u0003\u0002kg%!!q\u0019Be\u0005\u001dAE\u000f\u001e9BaBT!A[\u001a\u0002'M,'O^5dK\u0016\u0013(o\u001c:IC:$G.\u001a:\u0011\r\t='q\u001bBL\u001d\u0011\u0011\tN!6\u000f\t\tm&1[\u0005\u0003aMJ1A\u001bBY\u0013\u0011\u0011INa7\u0003'M+'O^5dK\u0016\u0013(o\u001c:IC:$G.\u001a:\u000b\u0007)\u0014\t,\u0001\nnCb<6\u000bU1zY>\fG\rT3oORD\u0017A\u00033jgB\fGo\u00195feB!Q\t\u0014BL!\u0011\t7Na&\u0002\u0003\u0011\u0003bA!;\u0003l\n]U\"\u0001&\n\u0007\t5(JA\u0003EK\u001a,'\u000f\u0006\u0006\u0003r\ne(1 B\u007f\u0005\u007f$bAa=\u0003v\n]\b#\u0002B\u0016G\t]\u0005BB0+\u0001\b\u0011\u0019\u000fC\u0004\u0003f*\u0002\u001dAa:\t\u000f\t\u0005&\u00061\u0001\u0003$\"9!1\u001a\u0016A\u0002\t5\u0007b\u0002BoU\u0001\u0007!\u0011\r\u0005\b\u0005?T\u0003\u0019\u0001Bq\u0003%\u0019wN\u001c<feR,'\u000fE\u0003s\u0007\u000b\u00119*C\u0002\u0004\b=\u0012!dU3sm\u0016\u0014h*\u001a;us6{G-\u001a7D_:4XM]:j_:$\u0002ba\u0003\u0004\u000e\r=1\u0011\u0003\t\bC\u0006E#qSA+\u0011\u0019aD\u00061\u0001\u0002l!9\u00111\u000f\u0017A\u0002\u0005U\u0004bBA?Y\u0001\u0007\u0011\u0011F\u000b\u0005\u0007+\u0019i\u0002\u0006\u0006\u0004\u0018\r-2QGB\u001d\u0007w!Ba!\u0007\u0004&A!!\u000fAB\u000e!\ry5Q\u0004\u0003\u0007#6\u0012\raa\b\u0016\u0007M\u001b\t\u0003B\u0004\u0004$\ru!\u0019A*\u0003\t}#Ce\r\u0005\n\u0007Oi\u0013\u0011!a\u0002\u0007S\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0011\t7na\u0007\t\u000f\r5R\u00061\u0001\u00040\u0005\u0019\u0011\r\u001d9\u0011\u000fU\u0013)k!\r\u00044A1!1\u0016BZ\u00077\u0001bA!/\u0003F\u000em\u0001b\u0002Bf[\u0001\u00071q\u0007\t\u0007\u0005\u001f\u00149na\u0007\t\u000f\tuW\u00061\u0001\u0003b!9!q\\\u0017A\u0002\ru\u0002\u0003B#M\u00077\u0001")
public abstract class Http4sNettyHandler<F>
extends ChannelInboundHandlerAdapter {
    private final Dispatcher<F> disp;
    private final Async<F> F;
    private ExecutionContext eventLoopContext;
    private Future<BoxedUnit> lastResponseSent;
    private final Queue<Function0<Future<BoxedUnit>>> pendingResponses;
    private long cachedDate;
    private String cachedDateString;
    private final Logger logger;

    public static <F> Http4sNettyHandler<F> websocket(Function1<WebSocketBuilder2<F>, Kleisli<F, Request<F>, Response<F>>> app, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, int maxWSPayloadLength, Dispatcher<F> dispatcher, Async<F> evidence$1) {
        return Http4sNettyHandler$.MODULE$.websocket(app, serviceErrorHandler, maxWSPayloadLength, dispatcher, evidence$1);
    }

    public Logger logger() {
        return this.logger;
    }

    public abstract Resource<F, DefaultHttpResponse> handle(Channel var1, HttpRequest var2, String var3);

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block5: {
            Object object;
            long newTick;
            if (this.logger().isTraceEnabled()) {
                this.logger().trace(new StringBuilder(27).append("channelRead: ctx = ").append(ctx).append(", msg = ").append(msg).toString());
            }
            if (this.cachedDate < (newTick = System.currentTimeMillis() / 1000L)) {
                this.cachedDateString = Http4sNettyHandler$.MODULE$.org$http4s$netty$server$Http4sNettyHandler$$RFC7231InstantFormatter().format(Instant.ofEpochSecond(newTick));
                this.cachedDate = newTick;
            }
            if ((object = msg) instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)object;
                Object reqAndCleanup = this.handle(ctx.channel(), httpRequest, this.cachedDateString).allocated(this.F);
                Tuple2 tuple2 = this.disp.unsafeToFutureCancelable(reqAndCleanup);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Future f = (Future)tuple2._1();
                Function0 cancelRequest = (Function0)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)f, (Object)cancelRequest);
                Future f2 = (Future)tuple22._1();
                Function0 cancelRequest2 = (Function0)tuple22._2();
                this.pendingResponses.enqueue((Object)cancelRequest2);
                this.lastResponseSent = this.lastResponseSent.flatMap((Function1 & Serializable)x$4 -> f2.transform((Function1 & Serializable)x0$1 -> {
                    Success success;
                    Tuple2 tuple2;
                    boolean bl = false;
                    Failure failure = null;
                    Try try_ = x0$1;
                    if (try_ instanceof Success && (tuple2 = (Tuple2)(success = (Success)try_).value()) != null) {
                        DefaultHttpResponse response = (DefaultHttpResponse)tuple2._1();
                        Object cleanup = tuple2._2();
                        $this.pendingResponses.dequeue();
                        if ($this.pendingResponses.isEmpty()) {
                            package$.MODULE$.void((Object)ctx.read());
                        }
                        package$.MODULE$.void((Object)ctx.writeAndFlush((Object)response).addListener(x$5 -> $this.disp.unsafeRunAndForget(cleanup)));
                        return new Success((Object)BoxedUnit.UNIT);
                    }
                    if (try_ instanceof Failure) {
                        Option option;
                        bl = true;
                        failure = (Failure)try_;
                        Throwable throwable = failure.exception();
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.logger().warn("Error caught during service handling. Check the configured ServiceErrorHandler.", e);
                            package$.MODULE$.void((Object)this.sendSimpleErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR));
                            return new Failure(e);
                        }
                    }
                    if (bl) {
                        Throwable e = failure.exception();
                        return new Failure(e);
                    }
                    throw new MatchError((Object)try_);
                }, $this.eventLoopContext), this.eventLoopContext);
                return;
            }
            LastHttpContent lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
            Object object2 = object;
            if (!(lastHttpContent != null ? !lastHttpContent.equals(object2) : object2 != null)) {
                return;
            }
            if (!this.logger().isErrorEnabled()) break block5;
            this.logger().error(new StringBuilder(31).append("Invalid message type received, ").append(object.getClass()).toString());
        }
        throw Http4sNettyHandler$InvalidMessageException$.MODULE$;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace(new StringBuilder(27).append("channelReadComplete: ctx = ").append(ctx).toString());
        }
        package$.MODULE$.void((Object)(this.pendingResponses.isEmpty() ? ctx.read() : ctx.fireChannelReadComplete()));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ChannelFuture channelFuture;
        Throwable throwable = cause;
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            this.logger().trace("Benign IO exception caught in Netty", (Throwable)iOException);
            channelFuture = ctx.channel().close();
        } else if (throwable instanceof TooLongFrameException) {
            TooLongFrameException tooLongFrameException = (TooLongFrameException)throwable;
            this.logger().warn("Handling TooLongFrameException", (Throwable)tooLongFrameException);
            channelFuture = this.sendSimpleErrorResponse(ctx, HttpResponseStatus.REQUEST_URI_TOO_LONG);
        } else if (Http4sNettyHandler$InvalidMessageException$.MODULE$.equals(throwable)) {
            channelFuture = this.sendSimpleErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        } else {
            this.logger().error("Exception caught in Netty", throwable);
            channelFuture = ctx.channel().close();
        }
        package$.MODULE$.void((Object)channelFuture);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.initHandler(ctx);
            return;
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.initHandler(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        BoxedUnit boxedUnit;
        Object object = evt;
        if (object instanceof IdleStateEvent && ctx.channel().isOpen()) {
            this.logger().trace("Closing connection due to idle timeout");
            boxedUnit = ctx.close();
        } else {
            super.userEventTriggered(ctx, evt);
            boxedUnit = BoxedUnit.UNIT;
        }
        package$.MODULE$.void((Object)boxedUnit);
    }

    private void initHandler(ChannelHandlerContext ctx) {
        if (this.eventLoopContext == null) {
            this.eventLoopContext = ExecutionContext$.MODULE$.fromExecutor((Executor)ctx.channel().eventLoop());
            ctx.channel().closeFuture().addListener(x$6 -> {
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(new StringBuilder(47).append("Http channel to ").append(ctx.channel().remoteAddress()).append(" closed. Cancelling ").append($this.pendingResponses.length()).append(" responses.").toString());
                }
                $this.pendingResponses.foreach((Function1 & Serializable)x$7 -> (Future)x$7.apply());
            });
            package$.MODULE$.void((Object)ctx.read());
            return;
        }
    }

    private ChannelFuture sendSimpleErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
        return ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public Http4sNettyHandler(Dispatcher<F> disp, Async<F> F) {
        this.disp = disp;
        this.F = F;
        this.lastResponseSent = Future$.MODULE$.unit();
        this.pendingResponses = Queue$.MODULE$.empty();
        this.cachedDate = Long.MIN_VALUE;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.netty.server.Http4sNettyHandler");
    }

    private static class WebsocketHandler<F>
    extends Http4sNettyHandler<F> {
        private final Function1<WebSocketBuilder2<F>, Kleisli<F, Request<F>, Response<F>>> appFn;
        private final Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler;
        private final int maxWSPayloadLength;
        private final Async<F> F;
        private final Defer<F> D;
        private final ServerNettyModelConversion<F> converter;

        @Override
        public Resource<F, DefaultHttpResponse> handle(Channel channel, HttpRequest request, String dateString) {
            return cats.effect.package$.MODULE$.Resource().eval(WebSocketBuilder2$.MODULE$.apply(this.F, this.F)).flatMap((Function1 & Serializable)b -> {
                Function1 app;
                block0: {
                    app = ((Kleisli)$this.appFn.apply(b)).run();
                    if (!this.logger().isTraceEnabled()) break block0;
                    this.logger().trace(new StringBuilder(32).append("Http request received by netty: ").append(request).toString());
                }
                return $this.converter.fromNettyRequest(channel, request).flatMap((Function1 & Serializable)req -> cats.effect.package$.MODULE$.Resource().eval(ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError($this.D.defer((Function0 & Serializable)() -> app.apply(req)), $this.F), (PartialFunction)$this.serviceErrorHandler.apply(req), $this.F)).flatMap((Function1 & Serializable)x$8 -> $this.converter.toNettyResponseWithWebsocket((Key)b.webSocketKey(), (Request)req, (Response)x$8, dateString, $this.maxWSPayloadLength)));
            });
        }

        public WebsocketHandler(Function1<WebSocketBuilder2<F>, Kleisli<F, Request<F>, Response<F>>> appFn, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, int maxWSPayloadLength, Dispatcher<F> dispatcher, Async<F> F, Defer<F> D) {
            this.appFn = appFn;
            this.serviceErrorHandler = serviceErrorHandler;
            this.maxWSPayloadLength = maxWSPayloadLength;
            this.F = F;
            this.D = D;
            super(dispatcher, F);
            this.converter = new ServerNettyModelConversion<F>(F);
        }
    }
}

