/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.netty.server;

import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import com.typesafe.netty.http.HttpStreamsServerHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.timeout.IdleStateHandler;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.netty.package$;
import org.http4s.netty.server.Http4sNettyHandler$;
import org.http4s.netty.server.NegotiationHandler;
import org.http4s.server.websocket.WebSocketBuilder2;
import scala.Function1;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;

public final class NettyPipelineHelpers$ {
    public static final NettyPipelineHelpers$ MODULE$ = new NettyPipelineHelpers$();

    public <F> void buildHttp2Pipeline(ChannelPipeline pipeline, NegotiationHandler.Config config, Function1<WebSocketBuilder2<F>, Kleisli<F, Request<F>, Response<F>>> httpApp, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, Dispatcher<F> dispatcher, Async<F> evidence$1) {
        pipeline.channel().config().setAutoRead(true);
        package$.MODULE$.void((Object)pipeline.addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build(), new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(config, httpApp, serviceErrorHandler, dispatcher, evidence$1){
            private final NegotiationHandler.Config config$1;
            private final Function1 httpApp$1;
            private final Function1 serviceErrorHandler$1;
            private final Dispatcher dispatcher$1;
            private final Async evidence$1$1;

            public void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
                NettyPipelineHelpers$.MODULE$.org$http4s$netty$server$NettyPipelineHelpers$$addHttp4sHandlers(ch.pipeline(), this.config$1, this.httpApp$1, this.serviceErrorHandler$1, this.dispatcher$1, this.evidence$1$1);
            }
            {
                this.config$1 = config$1;
                this.httpApp$1 = httpApp$1;
                this.serviceErrorHandler$1 = serviceErrorHandler$1;
                this.dispatcher$1 = dispatcher$1;
                this.evidence$1$1 = evidence$1$1;
            }
        })}));
    }

    public <F> void buildHttp1Pipeline(ChannelPipeline pipeline, NegotiationHandler.Config config, Function1<WebSocketBuilder2<F>, Kleisli<F, Request<F>, Response<F>>> httpApp, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, Dispatcher<F> dispatcher, Async<F> evidence$2) {
        pipeline.channel().config().setAutoRead(false);
        pipeline.addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder(config.maxInitialLineLength(), config.maxHeaderSize(), config.maxChunkSize()));
        pipeline.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
        this.org$http4s$netty$server$NettyPipelineHelpers$$addHttp4sHandlers(pipeline, config, httpApp, serviceErrorHandler, dispatcher, evidence$2);
        package$.MODULE$.void((Object)BoxedUnit.UNIT);
    }

    public <F> void org$http4s$netty$server$NettyPipelineHelpers$$addHttp4sHandlers(ChannelPipeline pipeline, NegotiationHandler.Config config, Function1<WebSocketBuilder2<F>, Kleisli<F, Request<F>, Response<F>>> httpApp, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, Dispatcher<F> dispatcher, Async<F> evidence$3) {
        if (config.idleTimeout().isFinite() && config.idleTimeout().length() > 0L) {
            package$.MODULE$.void((Object)pipeline.addLast("idle-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, config.idleTimeout().length(), config.idleTimeout().unit())));
        }
        if (config.wsCompression()) {
            package$.MODULE$.void((Object)pipeline.addLast("websocket-compression", (ChannelHandler)new WebSocketServerCompressionHandler()));
        }
        pipeline.addLast("websocket-aggregator", (ChannelHandler)new WebSocketFrameAggregator(config.wsMaxFrameLength()));
        pipeline.addLast("serverStreamsHandler", (ChannelHandler)new HttpStreamsServerHandler());
        package$.MODULE$.void((Object)pipeline.addLast("http4s", Http4sNettyHandler$.MODULE$.websocket(httpApp, serviceErrorHandler, config.wsMaxFrameLength(), dispatcher, evidence$3)));
    }

    private NettyPipelineHelpers$() {
    }
}

