/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.okhttp;

import cats.effect.ConcurrentEffect;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import okhttp3.OkHttpClient;
import org.http4s.client.okhttp.OkHttpBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class OkHttpBuilder$ {
    public static OkHttpBuilder$ MODULE$;
    private final Logger logger;

    static {
        new OkHttpBuilder$();
    }

    public <F> OkHttpBuilder<F> apply(OkHttpClient okHttpClient, ExecutionContext blocker, ConcurrentEffect<F> evidence$1, ContextShift<F> evidence$2) {
        return new OkHttpBuilder<F>(okHttpClient, blocker, (ConcurrentEffect)evidence$1, (ContextShift)evidence$2){};
    }

    public <F> Resource<F, OkHttpBuilder<F>> withDefaultClient(ExecutionContext blocker, ConcurrentEffect<F> evidence$3, ContextShift<F> evidence$4) {
        return this.defaultOkHttpClient(evidence$3).map((Function1 & java.io.Serializable & Serializable)x$4 -> MODULE$.apply((OkHttpClient)x$4, blocker, evidence$3, evidence$4), evidence$3);
    }

    private <F> Resource<F, OkHttpClient> defaultOkHttpClient(ConcurrentEffect<F> F) {
        return Resource$.MODULE$.make(F.delay((Function0 & java.io.Serializable & Serializable)() -> new OkHttpClient()), (Function1 & java.io.Serializable & Serializable)x$5 -> MODULE$.shutdown((OkHttpClient)x$5, (Sync)F), F);
    }

    private <F> F shutdown(OkHttpClient client, Sync<F> F) {
        return (F)F.delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            try {
                client.dispatcher().executorService().shutdown();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    OkHttpBuilder$.MODULE$.logger.warn("Unable to shut down dispatcher when disposing of OkHttp client", t);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            try {
                client.connectionPool().evictAll();
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable3);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    OkHttpBuilder$.MODULE$.logger.warn("Unable to evict connection pool when disposing of OkHttp client", t);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            if (client.cache() != null) {
                try {
                    client.cache().close();
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        OkHttpBuilder$.MODULE$.logger.warn("Unable to close cache when disposing of OkHttp client", t);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }
        });
    }

    private OkHttpBuilder$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.client.okhttp.OkHttpBuilder");
    }
}

