/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.metrics.prometheus;

import cats.Functor;
import cats.Semigroupal;
import cats.arrow.FunctionK;
import cats.data.NonEmptyList;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.syntax.package;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleTimer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Status;
import org.http4s.metrics.MetricsOps;
import org.http4s.metrics.TerminationType;
import org.http4s.metrics.prometheus.AbnormalTermination$;
import org.http4s.metrics.prometheus.AbnormalTermination$Abnormal$;
import org.http4s.metrics.prometheus.AbnormalTermination$Canceled$;
import org.http4s.metrics.prometheus.AbnormalTermination$Error$;
import org.http4s.metrics.prometheus.AbnormalTermination$Timeout$;
import org.http4s.metrics.prometheus.MetricsCollection;
import org.http4s.metrics.prometheus.Phase$;
import org.http4s.metrics.prometheus.Phase$Body$;
import org.http4s.metrics.prometheus.Phase$Headers$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Prometheus$ {
    public static final Prometheus$ MODULE$ = new Prometheus$();
    private static final NonEmptyList<Object> DefaultHistogramBuckets = new NonEmptyList((Object)BoxesRunTime.boxToDouble((double)0.005), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0})));

    public <F> Resource<F, CollectorRegistry> collectorRegistry(Sync<F> F) {
        return Resource$.MODULE$.make(F.delay((Function0 & Serializable)() -> new CollectorRegistry()), (Function1 & Serializable)cr -> F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> cr.clear()), F);
    }

    public <F> Resource<F, MetricsOps<F>> metricsOps(CollectorRegistry registry, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> evidence$1) {
        return this.createMetricsCollection(registry, prefix, responseDurationSecondsHistogramBuckets, evidence$1).map((Function1 & Serializable)metrics -> MODULE$.createMetricsOps((MetricsCollection)metrics, evidence$1), evidence$1);
    }

    public <F> String metricsOps$default$2() {
        return "org_http4s_server";
    }

    public <F> NonEmptyList<Object> metricsOps$default$3() {
        return this.DefaultHistogramBuckets();
    }

    private <F> MetricsOps<F> createMetricsOps(MetricsCollection metrics, Sync<F> F) {
        return new MetricsOps<F>(F, metrics){
            private final Sync F$2;
            private final MetricsCollection metrics$1;

            public <G> MetricsOps<G> mapK(FunctionK<F, G> fk) {
                return MetricsOps.mapK$((MetricsOps)this, fk);
            }

            public F increaseActiveRequests(Option<String> classifier) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Gauge.Child)$this.metrics$1.activeRequests().labels(new String[]{this.label(classifier)})).inc());
            }

            public F decreaseActiveRequests(Option<String> classifier) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Gauge.Child)$this.metrics$1.activeRequests().labels(new String[]{this.label(classifier)})).dec());
            }

            public F recordHeadersTime(Method method, long elapsed, Option<String> classifier) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Histogram.Child)$this.metrics$1.responseDuration().labels(new String[]{this.label(classifier), this.reportMethod(method), Phase$.MODULE$.report(Phase$Headers$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            public F recordTotalTime(Method method, Status status, long elapsed, Option<String> classifier) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    ((Histogram.Child)$this.metrics$1.responseDuration().labels(new String[]{this.label(classifier), this.reportMethod(method), Phase$.MODULE$.report(Phase$Body$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed));
                    ((Counter.Child)$this.metrics$1.requests().labels(new String[]{this.label(classifier), this.reportMethod(method), this.reportStatus(status)})).inc();
                });
            }

            public F recordAbnormalTermination(long elapsed, TerminationType terminationType, Option<String> classifier) {
                F f;
                TerminationType terminationType2 = terminationType;
                if (terminationType2 instanceof TerminationType.Abnormal) {
                    TerminationType.Abnormal abnormal = (TerminationType.Abnormal)terminationType2;
                    Throwable e = abnormal.rootCause();
                    f = this.recordAbnormal(elapsed, classifier, e);
                } else if (terminationType2 instanceof TerminationType.Error) {
                    TerminationType.Error error = (TerminationType.Error)terminationType2;
                    Throwable e = error.rootCause();
                    f = this.recordError(elapsed, classifier, e);
                } else if (TerminationType.Canceled$.MODULE$.equals(terminationType2)) {
                    f = this.recordCanceled(elapsed, classifier);
                } else if (TerminationType.Timeout$.MODULE$.equals(terminationType2)) {
                    f = this.recordTimeout(elapsed, classifier);
                } else {
                    throw new MatchError((Object)terminationType2);
                }
                return f;
            }

            private F recordCanceled(long elapsed, Option<String> classifier) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Histogram.Child)$this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier), AbnormalTermination$.MODULE$.report(AbnormalTermination$Canceled$.MODULE$), this.label((Option<String>)Option$.MODULE$.empty())})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            private F recordAbnormal(long elapsed, Option<String> classifier, Throwable cause) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Histogram.Child)$this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier), AbnormalTermination$.MODULE$.report(AbnormalTermination$Abnormal$.MODULE$), this.label((Option<String>)Option$.MODULE$.apply((Object)cause.getClass().getName()))})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            private F recordError(long elapsed, Option<String> classifier, Throwable cause) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Histogram.Child)$this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier), AbnormalTermination$.MODULE$.report(AbnormalTermination$Error$.MODULE$), this.label((Option<String>)Option$.MODULE$.apply((Object)cause.getClass().getName()))})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            private F recordTimeout(long elapsed, Option<String> classifier) {
                return (F)this.F$2.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Histogram.Child)$this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier), AbnormalTermination$.MODULE$.report(AbnormalTermination$Timeout$.MODULE$), this.label((Option<String>)Option$.MODULE$.empty())})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            private String label(Option<String> value) {
                return (String)value.getOrElse((Function0 & Serializable)() -> "");
            }

            private String reportStatus(Status status) {
                int n = status.code();
                switch (n) {
                    default: 
                }
                return n < 200 ? "1xx" : (n < 300 ? "2xx" : (n < 400 ? "3xx" : (n < 500 ? "4xx" : "5xx")));
            }

            private String reportMethod(Method m) {
                String string;
                Method method = m;
                Method method2 = Method$.MODULE$.GET();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                    string = "get";
                } else {
                    Method method4 = Method$.MODULE$.PUT();
                    Method method5 = method;
                    if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                        string = "put";
                    } else {
                        Method method6 = Method$.MODULE$.POST();
                        Method method7 = method;
                        if (!(method6 != null ? !method6.equals(method7) : method7 != null)) {
                            string = "post";
                        } else {
                            Method method8 = Method$.MODULE$.HEAD();
                            Method method9 = method;
                            if (!(method8 != null ? !method8.equals(method9) : method9 != null)) {
                                string = "head";
                            } else {
                                Method method10 = Method$.MODULE$.MOVE();
                                Method method11 = method;
                                if (!(method10 != null ? !method10.equals(method11) : method11 != null)) {
                                    string = "move";
                                } else {
                                    Method method12 = Method$.MODULE$.OPTIONS();
                                    Method method13 = method;
                                    if (!(method12 != null ? !method12.equals(method13) : method13 != null)) {
                                        string = "options";
                                    } else {
                                        Method method14 = Method$.MODULE$.TRACE();
                                        Method method15 = method;
                                        if (!(method14 != null ? !method14.equals(method15) : method15 != null)) {
                                            string = "trace";
                                        } else {
                                            Method method16 = Method$.MODULE$.CONNECT();
                                            Method method17 = method;
                                            if (!(method16 != null ? !method16.equals(method17) : method17 != null)) {
                                                string = "connect";
                                            } else {
                                                Method method18 = Method$.MODULE$.DELETE();
                                                Method method19 = method;
                                                string = !(method18 != null ? !method18.equals(method19) : method19 != null) ? "delete" : "other";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return string;
            }
            {
                this.F$2 = F$2;
                this.metrics$1 = metrics$1;
                MetricsOps.$init$((MetricsOps)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decreaseActiveRequests$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option ), $anonfun$increaseActiveRequests$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option ), $anonfun$label$1(), $anonfun$recordAbnormal$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option java.lang.Throwable long ), $anonfun$recordCanceled$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option long ), $anonfun$recordError$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option java.lang.Throwable long ), $anonfun$recordHeadersTime$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option org.http4s.Method long ), $anonfun$recordTimeout$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option long ), $anonfun$recordTotalTime$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option org.http4s.Method long org.http4s.Status )}, serializedLambda);
            }
        };
    }

    private <F> Resource<F, MetricsCollection> createMetricsCollection(CollectorRegistry registry, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> evidence$2) {
        Resource<F, Histogram> responseDuration2 = this.registerCollector(((Histogram.Builder)Histogram.build().buckets((double[])responseDurationSecondsHistogramBuckets.toList().toArray((ClassTag)ClassTag$.MODULE$.Double())).name(new StringBuilder(26).append(prefix).append("_").append("response_duration_seconds").toString()).help("Response Duration in seconds.").labelNames(new String[]{"classifier", "method", "phase"})).create(), registry, evidence$2);
        Resource<F, Gauge> activeRequests2 = this.registerCollector(((Gauge.Builder)Gauge.build().name(new StringBuilder(21).append(prefix).append("_").append("active_request_count").toString()).help("Total Active Requests.").labelNames(new String[]{"classifier"})).create(), registry, evidence$2);
        Resource<F, Counter> requests2 = this.registerCollector(((Counter.Builder)Counter.build().name(new StringBuilder(14).append(prefix).append("_").append("request_count").toString()).help("Total Requests.").labelNames(new String[]{"classifier", "method", "status"})).create(), registry, evidence$2);
        Resource<F, Histogram> abnormalTerminations2 = this.registerCollector(((Histogram.Builder)Histogram.build().name(new StringBuilder(22).append(prefix).append("_").append("abnormal_terminations").toString()).help("Total Abnormal Terminations.").labelNames(new String[]{"classifier", "termination_type", "cause"})).create(), registry, evidence$2);
        return (Resource)package.apply$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4(responseDuration2, activeRequests2, requests2, abnormalTerminations2)).mapN((Function4 & Serializable)(responseDuration, activeRequests, requests, abnormalTerminations) -> new MetricsCollection((Histogram)responseDuration, (Gauge)activeRequests, (Counter)requests, (Histogram)abnormalTerminations), (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource(evidence$2), (Semigroupal)Resource$.MODULE$.catsEffectMonadErrorForResource(evidence$2));
    }

    public <F, C extends Collector> Resource<F, C> registerCollector(C collector, CollectorRegistry registry, Sync<F> F) {
        return Resource$.MODULE$.make(F.delay((Function0 & Serializable)() -> collector.register(registry)), (Function1 & Serializable)c -> F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> registry.unregister(c)), F);
    }

    private NonEmptyList<Object> DefaultHistogramBuckets() {
        return DefaultHistogramBuckets;
    }

    private Prometheus$() {
    }
}

