/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.metrics.prometheus;

import cats.Functor;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleTimer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Status;
import org.http4s.metrics.MetricsOps;
import org.http4s.metrics.TerminationType;
import org.http4s.metrics.prometheus.AbnormalTermination$;
import org.http4s.metrics.prometheus.AbnormalTermination$Abnormal$;
import org.http4s.metrics.prometheus.AbnormalTermination$Canceled$;
import org.http4s.metrics.prometheus.AbnormalTermination$Error$;
import org.http4s.metrics.prometheus.AbnormalTermination$Timeout$;
import org.http4s.metrics.prometheus.MetricsCollection;
import org.http4s.metrics.prometheus.MetricsCollection$;
import org.http4s.metrics.prometheus.Phase$;
import org.http4s.metrics.prometheus.Phase$Body$;
import org.http4s.metrics.prometheus.Phase$Headers$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Prometheus$
implements Serializable {
    private static final NonEmptyList<Object> DefaultHistogramBuckets;
    public static final Prometheus$ MODULE$;

    private Prometheus$() {
    }

    static {
        MODULE$ = new Prometheus$();
        DefaultHistogramBuckets = NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.005), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0})));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Prometheus$.class);
    }

    public <F> Resource<F, CollectorRegistry> collectorRegistry(Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.delay(this::collectorRegistry$$anonfun$1), (Function1 & Serializable)cr -> F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.collectorRegistry$$anonfun$3$$anonfun$1(cr))), F);
    }

    public <F> Resource<F, MetricsOps<F>> metricsOps(CollectorRegistry registry, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> evidence$1) {
        return this.createMetricsCollection(registry, prefix, responseDurationSecondsHistogramBuckets, evidence$1).map((Function1 & Serializable)metrics -> this.createMetricsOps((MetricsCollection)metrics, evidence$1));
    }

    public <F> String metricsOps$default$2() {
        return "org_http4s_server";
    }

    public <F> NonEmptyList<Object> metricsOps$default$3() {
        return DefaultHistogramBuckets;
    }

    private <F> MetricsOps<F> createMetricsOps(MetricsCollection metrics, Sync<F> F) {
        return new MetricsOps<F>(metrics, F){
            private final MetricsCollection metrics$1;
            private final Sync F$1;
            {
                this.metrics$1 = metrics$2;
                this.F$1 = F$4;
            }

            public Object increaseActiveRequests(Option classifier) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.increaseActiveRequests$$anonfun$1(classifier)));
            }

            public Object decreaseActiveRequests(Option classifier) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.decreaseActiveRequests$$anonfun$1(classifier)));
            }

            public Object recordHeadersTime(Method method, long elapsed, Option classifier) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.recordHeadersTime$$anonfun$1(method, elapsed, classifier)));
            }

            public Object recordTotalTime(Method method, Status status, long elapsed, Option classifier) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.recordTotalTime$$anonfun$1(method, status, elapsed, classifier)));
            }

            public Object recordAbnormalTermination(long elapsed, TerminationType terminationType, Option classifier) {
                Object object;
                TerminationType terminationType2 = terminationType;
                if (terminationType2 instanceof TerminationType.Abnormal) {
                    Throwable throwable;
                    TerminationType.Abnormal abnormal = TerminationType.Abnormal$.MODULE$.unapply((TerminationType.Abnormal)terminationType2);
                    Throwable e = throwable = abnormal._1();
                    object = this.recordAbnormal(elapsed, classifier, e);
                } else if (terminationType2 instanceof TerminationType.Error) {
                    Throwable throwable;
                    TerminationType.Error error = TerminationType.Error$.MODULE$.unapply((TerminationType.Error)terminationType2);
                    Throwable e = throwable = error._1();
                    object = this.recordError(elapsed, classifier, e);
                } else if (TerminationType.Canceled$.MODULE$.equals(terminationType2)) {
                    object = this.recordCanceled(elapsed, classifier);
                } else if (TerminationType.Timeout$.MODULE$.equals(terminationType2)) {
                    object = this.recordTimeout(elapsed, classifier);
                } else {
                    throw new MatchError((Object)terminationType2);
                }
                return object;
            }

            private Object recordCanceled(long elapsed, Option classifier) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.recordCanceled$$anonfun$1(elapsed, classifier)));
            }

            private Object recordAbnormal(long elapsed, Option classifier, Throwable cause) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.recordAbnormal$$anonfun$1(elapsed, classifier, cause)));
            }

            private Object recordError(long elapsed, Option classifier, Throwable cause) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.recordError$$anonfun$1(elapsed, classifier, cause)));
            }

            private Object recordTimeout(long elapsed, Option classifier) {
                return this.F$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.recordTimeout$$anonfun$1(elapsed, classifier)));
            }

            private String label(Option value) {
                return (String)value.getOrElse(Prometheus$::org$http4s$metrics$prometheus$Prometheus$$anon$1$$_$label$$anonfun$1);
            }

            private String reportStatus(Status status) {
                int fourhundreds;
                int threehundreds;
                int twohundreds;
                int n = status.code();
                int hundreds = n;
                String string = hundreds < 200 ? "1xx" : ((twohundreds = n) < 300 ? "2xx" : ((threehundreds = n) < 400 ? "3xx" : ((fourhundreds = n) < 500 ? "4xx" : "5xx")));
                return string;
            }

            private String reportMethod(Method m) {
                String string;
                Method method = m;
                Method method2 = Method$.MODULE$.GET();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                    string = "get";
                } else {
                    Method method4 = Method$.MODULE$.PUT();
                    Method method5 = method;
                    if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                        string = "put";
                    } else {
                        Method method6 = Method$.MODULE$.POST();
                        Method method7 = method;
                        if (!(method6 != null ? !method6.equals(method7) : method7 != null)) {
                            string = "post";
                        } else {
                            Method method8 = Method$.MODULE$.HEAD();
                            Method method9 = method;
                            if (!(method8 != null ? !method8.equals(method9) : method9 != null)) {
                                string = "head";
                            } else {
                                Method method10 = Method$.MODULE$.MOVE();
                                Method method11 = method;
                                if (!(method10 != null ? !method10.equals(method11) : method11 != null)) {
                                    string = "move";
                                } else {
                                    Method method12 = Method$.MODULE$.OPTIONS();
                                    Method method13 = method;
                                    if (!(method12 != null ? !method12.equals(method13) : method13 != null)) {
                                        string = "options";
                                    } else {
                                        Method method14 = Method$.MODULE$.TRACE();
                                        Method method15 = method;
                                        if (!(method14 != null ? !method14.equals(method15) : method15 != null)) {
                                            string = "trace";
                                        } else {
                                            Method method16 = Method$.MODULE$.CONNECT();
                                            Method method17 = method;
                                            if (!(method16 != null ? !method16.equals(method17) : method17 != null)) {
                                                string = "connect";
                                            } else {
                                                Method method18 = Method$.MODULE$.DELETE();
                                                Method method19 = method;
                                                string = !(method18 != null ? !method18.equals(method19) : method19 != null) ? "delete" : "other";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return string;
            }

            private final void increaseActiveRequests$$anonfun$1(Option classifier$1) {
                ((Gauge.Child)this.metrics$1.activeRequests().labels(new String[]{this.label(classifier$1)})).inc();
            }

            private final void decreaseActiveRequests$$anonfun$1(Option classifier$2) {
                ((Gauge.Child)this.metrics$1.activeRequests().labels(new String[]{this.label(classifier$2)})).dec();
            }

            private final void recordHeadersTime$$anonfun$1(Method method$1, long elapsed$1, Option classifier$3) {
                ((Histogram.Child)this.metrics$1.responseDuration().labels(new String[]{this.label(classifier$3), this.reportMethod(method$1), Phase$.MODULE$.report(Phase$Headers$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$1));
            }

            private final void recordTotalTime$$anonfun$1(Method method$2, Status status$1, long elapsed$2, Option classifier$4) {
                ((Histogram.Child)this.metrics$1.responseDuration().labels(new String[]{this.label(classifier$4), this.reportMethod(method$2), Phase$.MODULE$.report(Phase$Body$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$2));
                ((Counter.Child)this.metrics$1.requests().labels(new String[]{this.label(classifier$4), this.reportMethod(method$2), this.reportStatus(status$1)})).inc();
            }

            private final void recordCanceled$$anonfun$1(long elapsed$3, Option classifier$5) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$5), AbnormalTermination$.MODULE$.report(AbnormalTermination$Canceled$.MODULE$), this.label(Option$.MODULE$.empty())})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$3));
            }

            private final void recordAbnormal$$anonfun$1(long elapsed$4, Option classifier$6, Throwable cause$1) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$6), AbnormalTermination$.MODULE$.report(AbnormalTermination$Abnormal$.MODULE$), this.label(Option$.MODULE$.apply((Object)cause$1.getClass().getName()))})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$4));
            }

            private final void recordError$$anonfun$1(long elapsed$5, Option classifier$7, Throwable cause$2) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$7), AbnormalTermination$.MODULE$.report(AbnormalTermination$Error$.MODULE$), this.label(Option$.MODULE$.apply((Object)cause$2.getClass().getName()))})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$5));
            }

            private final void recordTimeout$$anonfun$1(long elapsed$6, Option classifier$8) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$8), AbnormalTermination$.MODULE$.report(AbnormalTermination$Timeout$.MODULE$), this.label(Option$.MODULE$.empty())})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$6));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{increaseActiveRequests$$anonfun$1(scala.Option ), decreaseActiveRequests$$anonfun$1(scala.Option ), recordHeadersTime$$anonfun$1(org.http4s.Method long scala.Option ), recordTotalTime$$anonfun$1(org.http4s.Method org.http4s.Status long scala.Option ), recordCanceled$$anonfun$1(long scala.Option ), recordAbnormal$$anonfun$1(long scala.Option java.lang.Throwable ), recordError$$anonfun$1(long scala.Option java.lang.Throwable ), recordTimeout$$anonfun$1(long scala.Option ), org$http4s$metrics$prometheus$Prometheus$$anon$1$$_$label$$anonfun$1()}, serializedLambda);
            }
        };
    }

    private <F> Resource<F, MetricsCollection> createMetricsCollection(CollectorRegistry registry, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> evidence$2) {
        Resource<F, Histogram> responseDuration2 = this.registerCollector(((Histogram.Builder)Histogram.build().buckets((double[])Arrays$.MODULE$.seqToArray((Seq)responseDurationSecondsHistogramBuckets.toList(), Double.TYPE)).name(prefix + "_" + "response_duration_seconds").help("Response Duration in seconds.").labelNames(new String[]{"classifier", "method", "phase"})).create(), registry, evidence$2);
        Resource<F, Gauge> activeRequests2 = this.registerCollector(((Gauge.Builder)Gauge.build().name(prefix + "_" + "active_request_count").help("Total Active Requests.").labelNames(new String[]{"classifier"})).create(), registry, evidence$2);
        Resource<F, Counter> requests2 = this.registerCollector(((Counter.Builder)Counter.build().name(prefix + "_" + "request_count").help("Total Requests.").labelNames(new String[]{"classifier", "method", "status"})).create(), registry, evidence$2);
        Resource<F, Histogram> abnormalTerminations2 = this.registerCollector(((Histogram.Builder)Histogram.build().name(prefix + "_" + "abnormal_terminations").help("Total Abnormal Terminations.").labelNames(new String[]{"classifier", "termination_type", "cause"})).create(), registry, evidence$2);
        return (Resource)package.apply$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply(responseDuration2, activeRequests2, requests2, abnormalTerminations2)).mapN((Function4 & Serializable)(responseDuration, activeRequests, requests, abnormalTerminations) -> MetricsCollection$.MODULE$.apply((Histogram)responseDuration, (Gauge)activeRequests, (Counter)requests, (Histogram)abnormalTerminations), (Functor)Resource$.MODULE$.catsEffectSyncForResource(evidence$2), (Semigroupal)Resource$.MODULE$.catsEffectSyncForResource(evidence$2));
    }

    public <F, C extends Collector> Resource<F, C> registerCollector(C collector, CollectorRegistry registry, Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.delay(() -> this.registerCollector$$anonfun$1(collector, registry)), (Function1 & Serializable)c -> F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.registerCollector$$anonfun$3$$anonfun$1(registry, c))), F);
    }

    private final CollectorRegistry collectorRegistry$$anonfun$1() {
        return new CollectorRegistry();
    }

    private final void collectorRegistry$$anonfun$3$$anonfun$1(CollectorRegistry cr$1) {
        cr$1.clear();
    }

    public static final String org$http4s$metrics$prometheus$Prometheus$$anon$1$$_$label$$anonfun$1() {
        return "";
    }

    private final Collector registerCollector$$anonfun$1(Collector collector$1, CollectorRegistry registry$1) {
        return collector$1.register(registry$1);
    }

    private final void registerCollector$$anonfun$3$$anonfun$1(CollectorRegistry registry$3, Collector c$1) {
        registry$3.unregister(c$1);
    }
}

