/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.metrics.prometheus;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleTimer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Status;
import org.http4s.metrics.MetricsOps;
import org.http4s.metrics.TerminationType;
import org.http4s.metrics.prometheus.AbnormalTermination$;
import org.http4s.metrics.prometheus.AbnormalTermination$Abnormal$;
import org.http4s.metrics.prometheus.AbnormalTermination$Canceled$;
import org.http4s.metrics.prometheus.AbnormalTermination$Error$;
import org.http4s.metrics.prometheus.AbnormalTermination$Timeout$;
import org.http4s.metrics.prometheus.MetricsCollection;
import org.http4s.metrics.prometheus.MetricsCollection$;
import org.http4s.metrics.prometheus.Phase$;
import org.http4s.metrics.prometheus.Phase$Body$;
import org.http4s.metrics.prometheus.Phase$Headers$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Prometheus$
implements Serializable {
    private static final NonEmptyList<Object> DefaultHistogramBuckets;
    public static final Prometheus$ MODULE$;

    private Prometheus$() {
    }

    static {
        MODULE$ = new Prometheus$();
        DefaultHistogramBuckets = NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.005), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0})));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Prometheus$.class);
    }

    public <F> Resource<F, CollectorRegistry> collectorRegistry(Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.delay(this::collectorRegistry$$anonfun$1), (Function1 & Serializable)cr -> F.blocking((Function0 & Serializable)() -> {
            this.collectorRegistry$$anonfun$2$$anonfun$1((CollectorRegistry)cr);
            return BoxedUnit.UNIT;
        }), F);
    }

    public <F> Resource<F, MetricsOps<F>> metricsOps(CollectorRegistry registry, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> evidence$1) {
        return this.createMetricsCollection(registry, prefix, responseDurationSecondsHistogramBuckets, evidence$1).map((Function1 & Serializable)metrics -> this.createMetricsOps((MetricsCollection)metrics, Applicative$.MODULE$.apply((Applicative)evidence$1).pure((Object)None$.MODULE$), evidence$1));
    }

    public <F> String metricsOps$default$2() {
        return "org_http4s_server";
    }

    public <F> NonEmptyList<Object> metricsOps$default$3() {
        return DefaultHistogramBuckets;
    }

    public <F> Resource<F, MetricsOps<F>> metricsOpsWithExemplars(CollectorRegistry registry, Object sampleExemplar, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> evidence$2) {
        return this.createMetricsCollection(registry, prefix, responseDurationSecondsHistogramBuckets, evidence$2).map((Function1 & Serializable)metrics -> this.createMetricsOps((MetricsCollection)metrics, package.functor$.MODULE$.toFunctorOps(sampleExemplar, (Functor)evidence$2).map((Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)m -> this.toFlatArray((Map<String, String>)m))), evidence$2));
    }

    public <F> String metricsOpsWithExemplars$default$3() {
        return "org_http4s_server";
    }

    public <F> NonEmptyList<Object> metricsOpsWithExemplars$default$4() {
        return DefaultHistogramBuckets;
    }

    private <F> MetricsOps<F> createMetricsOps(MetricsCollection metrics, Object exemplarLabels, Sync<F> F) {
        return new MetricsOps<F>(metrics, exemplarLabels, F, this){
            private final MetricsCollection metrics$1;
            private final Object exemplarLabels$1;
            private final Sync F$2;
            {
                this.metrics$1 = metrics$2;
                this.exemplarLabels$1 = exemplarLabels$2;
                this.F$2 = F$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object increaseActiveRequests(Option classifier) {
                return this.F$2.delay((Function0 & Serializable)() -> {
                    this.increaseActiveRequests$$anonfun$1(classifier);
                    return BoxedUnit.UNIT;
                });
            }

            public Object decreaseActiveRequests(Option classifier) {
                return this.F$2.delay((Function0 & Serializable)() -> {
                    this.decreaseActiveRequests$$anonfun$1(classifier);
                    return BoxedUnit.UNIT;
                });
            }

            public Object recordHeadersTime(Method method, long elapsed, Option classifier) {
                return package.flatMap$.MODULE$.toFlatMapOps(this.exemplarLabels$1, (FlatMap)this.F$2).flatMap((Function1 & Serializable)exemplarOpt -> this.F$2.delay((Function0 & Serializable)() -> {
                    this.recordHeadersTime$$anonfun$1$$anonfun$1(method, elapsed, classifier, (Option)exemplarOpt);
                    return BoxedUnit.UNIT;
                }));
            }

            public Object recordTotalTime(Method method, Status status, long elapsed, Option classifier) {
                return package.flatMap$.MODULE$.toFlatMapOps(this.exemplarLabels$1, (FlatMap)this.F$2).flatMap((Function1 & Serializable)exemplarOpt -> this.F$2.delay((Function0 & Serializable)() -> {
                    this.recordTotalTime$$anonfun$1$$anonfun$1(method, status, elapsed, classifier, (Option)exemplarOpt);
                    return BoxedUnit.UNIT;
                }));
            }

            public Object recordAbnormalTermination(long elapsed, TerminationType terminationType, Option classifier) {
                TerminationType terminationType2 = terminationType;
                if (terminationType2 instanceof TerminationType.Abnormal) {
                    Throwable throwable;
                    TerminationType.Abnormal abnormal = TerminationType.Abnormal$.MODULE$.unapply((TerminationType.Abnormal)terminationType2);
                    Throwable e = throwable = abnormal._1();
                    return this.recordAbnormal(elapsed, classifier, e);
                }
                if (terminationType2 instanceof TerminationType.Error) {
                    Throwable throwable;
                    TerminationType.Error error = TerminationType.Error$.MODULE$.unapply((TerminationType.Error)terminationType2);
                    Throwable e = throwable = error._1();
                    return this.recordError(elapsed, classifier, e);
                }
                if (TerminationType.Canceled$.MODULE$.equals(terminationType2)) {
                    return this.recordCanceled(elapsed, classifier);
                }
                if (TerminationType.Timeout$.MODULE$.equals(terminationType2)) {
                    return this.recordTimeout(elapsed, classifier);
                }
                throw new MatchError((Object)terminationType2);
            }

            private Object recordCanceled(long elapsed, Option classifier) {
                return package.flatMap$.MODULE$.toFlatMapOps(this.exemplarLabels$1, (FlatMap)this.F$2).flatMap((Function1 & Serializable)exemplarOpt -> this.F$2.delay((Function0 & Serializable)() -> {
                    this.recordCanceled$$anonfun$1$$anonfun$1(elapsed, classifier, (Option)exemplarOpt);
                    return BoxedUnit.UNIT;
                }));
            }

            private Object recordAbnormal(long elapsed, Option classifier, Throwable cause) {
                return package.flatMap$.MODULE$.toFlatMapOps(this.exemplarLabels$1, (FlatMap)this.F$2).flatMap((Function1 & Serializable)exemplarOpt -> this.F$2.delay((Function0 & Serializable)() -> {
                    this.recordAbnormal$$anonfun$1$$anonfun$1(elapsed, classifier, cause, (Option)exemplarOpt);
                    return BoxedUnit.UNIT;
                }));
            }

            private Object recordError(long elapsed, Option classifier, Throwable cause) {
                return package.flatMap$.MODULE$.toFlatMapOps(this.exemplarLabels$1, (FlatMap)this.F$2).flatMap((Function1 & Serializable)exemplarOpt -> this.F$2.delay((Function0 & Serializable)() -> {
                    this.recordError$$anonfun$1$$anonfun$1(elapsed, classifier, cause, (Option)exemplarOpt);
                    return BoxedUnit.UNIT;
                }));
            }

            private Object recordTimeout(long elapsed, Option classifier) {
                return package.flatMap$.MODULE$.toFlatMapOps(this.exemplarLabels$1, (FlatMap)this.F$2).flatMap((Function1 & Serializable)exemplarOpt -> this.F$2.delay((Function0 & Serializable)() -> {
                    this.recordTimeout$$anonfun$1$$anonfun$1(elapsed, classifier, (Option)exemplarOpt);
                    return BoxedUnit.UNIT;
                }));
            }

            private String label(Option value) {
                return (String)value.getOrElse(Prometheus$::org$http4s$metrics$prometheus$Prometheus$$anon$1$$_$label$$anonfun$1);
            }

            private String reportStatus(Status status) {
                int n = status.code();
                int hundreds = n;
                if (hundreds < 200) {
                    return "1xx";
                }
                int twohundreds = n;
                if (twohundreds < 300) {
                    return "2xx";
                }
                int threehundreds = n;
                if (threehundreds < 400) {
                    return "3xx";
                }
                int fourhundreds = n;
                if (fourhundreds < 500) {
                    return "4xx";
                }
                return "5xx";
            }

            private String reportMethod(Method m) {
                Method method = m;
                Method method2 = Method$.MODULE$.GET();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                    return "get";
                }
                Method method4 = Method$.MODULE$.PUT();
                Method method5 = method;
                if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                    return "put";
                }
                Method method6 = Method$.MODULE$.POST();
                Method method7 = method;
                if (!(method6 != null ? !method6.equals(method7) : method7 != null)) {
                    return "post";
                }
                Method method8 = Method$.MODULE$.PATCH();
                Method method9 = method;
                if (!(method8 != null ? !method8.equals(method9) : method9 != null)) {
                    return "patch";
                }
                Method method10 = Method$.MODULE$.HEAD();
                Method method11 = method;
                if (!(method10 != null ? !method10.equals(method11) : method11 != null)) {
                    return "head";
                }
                Method method12 = Method$.MODULE$.MOVE();
                Method method13 = method;
                if (!(method12 != null ? !method12.equals(method13) : method13 != null)) {
                    return "move";
                }
                Method method14 = Method$.MODULE$.OPTIONS();
                Method method15 = method;
                if (!(method14 != null ? !method14.equals(method15) : method15 != null)) {
                    return "options";
                }
                Method method16 = Method$.MODULE$.TRACE();
                Method method17 = method;
                if (!(method16 != null ? !method16.equals(method17) : method17 != null)) {
                    return "trace";
                }
                Method method18 = Method$.MODULE$.CONNECT();
                Method method19 = method;
                if (!(method18 != null ? !method18.equals(method19) : method19 != null)) {
                    return "connect";
                }
                Method method20 = Method$.MODULE$.DELETE();
                Method method21 = method;
                if (!(method20 != null ? !method20.equals(method21) : method21 != null)) {
                    return "delete";
                }
                return "other";
            }

            private final void increaseActiveRequests$$anonfun$1(Option classifier$1) {
                ((Gauge.Child)this.metrics$1.activeRequests().labels(new String[]{this.label(classifier$1)})).inc();
            }

            private final void decreaseActiveRequests$$anonfun$1(Option classifier$2) {
                ((Gauge.Child)this.metrics$1.activeRequests().labels(new String[]{this.label(classifier$2)})).dec();
            }

            private final void recordHeadersTime$$anonfun$1$$anonfun$1(Method method$2, long elapsed$2, Option classifier$4, Option exemplarOpt$1) {
                ((Histogram.Child)this.metrics$1.responseDuration().labels(new String[]{this.label(classifier$4), this.reportMethod(method$2), Phase$.MODULE$.report(Phase$Headers$.MODULE$)})).observeWithExemplar(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$2), (String[])exemplarOpt$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            private final void recordTotalTime$$anonfun$1$$anonfun$1(Method method$4, Status status$2, long elapsed$4, Option classifier$6, Option exemplarOpt$2) {
                ((Histogram.Child)this.metrics$1.responseDuration().labels(new String[]{this.label(classifier$6), this.reportMethod(method$4), Phase$.MODULE$.report(Phase$Body$.MODULE$)})).observeWithExemplar(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$4), (String[])exemplarOpt$2.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                ((Counter.Child)this.metrics$1.requests().labels(new String[]{this.label(classifier$6), this.reportMethod(method$4), this.reportStatus(status$2)})).incWithExemplar((String[])exemplarOpt$2.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            private final void recordCanceled$$anonfun$1$$anonfun$1(long elapsed$6, Option classifier$8, Option exemplarOpt$3) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$8), AbnormalTermination$.MODULE$.report(AbnormalTermination$Canceled$.MODULE$), this.label(Option$.MODULE$.empty())})).observeWithExemplar(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$6), (String[])exemplarOpt$3.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            private final void recordAbnormal$$anonfun$1$$anonfun$1(long elapsed$8, Option classifier$10, Throwable cause$2, Option exemplarOpt$4) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$10), AbnormalTermination$.MODULE$.report(AbnormalTermination$Abnormal$.MODULE$), this.label(Option$.MODULE$.apply((Object)cause$2.getClass().getName()))})).observeWithExemplar(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$8), (String[])exemplarOpt$4.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            private final void recordError$$anonfun$1$$anonfun$1(long elapsed$10, Option classifier$12, Throwable cause$4, Option exemplarOpt$5) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$12), AbnormalTermination$.MODULE$.report(AbnormalTermination$Error$.MODULE$), this.label(Option$.MODULE$.apply((Object)cause$4.getClass().getName()))})).observeWithExemplar(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$10), (String[])exemplarOpt$5.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            private final void recordTimeout$$anonfun$1$$anonfun$1(long elapsed$12, Option classifier$14, Option exemplarOpt$6) {
                ((Histogram.Child)this.metrics$1.abnormalTerminations().labels(new String[]{this.label(classifier$14), AbnormalTermination$.MODULE$.report(AbnormalTermination$Timeout$.MODULE$), this.label(Option$.MODULE$.empty())})).observeWithExemplar(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed$12), (String[])exemplarOpt$6.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{increaseActiveRequests$$anonfun$adapted$1(scala.Option ), decreaseActiveRequests$$anonfun$adapted$1(scala.Option ), recordHeadersTime$$anonfun$1(org.http4s.Method long scala.Option scala.Option ), recordTotalTime$$anonfun$1(org.http4s.Method org.http4s.Status long scala.Option scala.Option ), recordCanceled$$anonfun$1(long scala.Option scala.Option ), recordAbnormal$$anonfun$1(long scala.Option java.lang.Throwable scala.Option ), recordError$$anonfun$1(long scala.Option java.lang.Throwable scala.Option ), recordTimeout$$anonfun$1(long scala.Option scala.Option ), org$http4s$metrics$prometheus$Prometheus$$anon$1$$_$label$$anonfun$1(), recordHeadersTime$$anonfun$1$$anonfun$adapted$1(org.http4s.Method long scala.Option scala.Option ), recordTotalTime$$anonfun$1$$anonfun$adapted$1(org.http4s.Method org.http4s.Status long scala.Option scala.Option ), recordCanceled$$anonfun$1$$anonfun$adapted$1(long scala.Option scala.Option ), recordAbnormal$$anonfun$1$$anonfun$adapted$1(long scala.Option java.lang.Throwable scala.Option ), recordError$$anonfun$1$$anonfun$adapted$1(long scala.Option java.lang.Throwable scala.Option ), recordTimeout$$anonfun$1$$anonfun$adapted$1(long scala.Option scala.Option )}, serializedLambda);
            }
        };
    }

    private <F> Resource<F, MetricsCollection> createMetricsCollection(CollectorRegistry registry, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> evidence$3) {
        Resource<F, Histogram> responseDuration2 = this.registerCollector(((Histogram.Builder)Histogram.build().buckets((double[])Arrays$.MODULE$.seqToArray((Seq)responseDurationSecondsHistogramBuckets.toList(), Double.TYPE)).name(new StringBuilder(26).append(prefix).append("_").append("response_duration_seconds").toString()).help("Response Duration in seconds.").labelNames(new String[]{"classifier", "method", "phase"})).create(), registry, evidence$3);
        Resource<F, Gauge> activeRequests2 = this.registerCollector(((Gauge.Builder)Gauge.build().name(new StringBuilder(21).append(prefix).append("_").append("active_request_count").toString()).help("Total Active Requests.").labelNames(new String[]{"classifier"})).create(), registry, evidence$3);
        Resource<F, Counter> requests2 = this.registerCollector(((Counter.Builder)Counter.build().name(new StringBuilder(14).append(prefix).append("_").append("request_count").toString()).help("Total Requests.").labelNames(new String[]{"classifier", "method", "status"})).create(), registry, evidence$3);
        Resource<F, Histogram> abnormalTerminations2 = this.registerCollector(((Histogram.Builder)Histogram.build().name(new StringBuilder(22).append(prefix).append("_").append("abnormal_terminations").toString()).help("Total Abnormal Terminations.").labelNames(new String[]{"classifier", "termination_type", "cause"})).create(), registry, evidence$3);
        return (Resource)package.apply$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply(responseDuration2, activeRequests2, requests2, abnormalTerminations2)).mapN((Function4 & Serializable)(responseDuration, activeRequests, requests, abnormalTerminations) -> MetricsCollection$.MODULE$.apply((Histogram)responseDuration, (Gauge)activeRequests, (Counter)requests, (Histogram)abnormalTerminations), (Functor)Resource$.MODULE$.catsEffectSyncForResource(evidence$3), (Semigroupal)Resource$.MODULE$.catsEffectSyncForResource(evidence$3));
    }

    public <F, C extends Collector> Resource<F, C> registerCollector(C collector, CollectorRegistry registry, Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.blocking(() -> this.registerCollector$$anonfun$1(collector, registry)), (Function1 & Serializable)c -> F.blocking((Function0 & Serializable)() -> {
            this.registerCollector$$anonfun$2$$anonfun$1(registry, (Collector)c);
            return BoxedUnit.UNIT;
        }), F);
    }

    private String[] toFlatArray(Map<String, String> m) {
        String[] arr = new String[m.size() * 2];
        IntRef i = IntRef.create((int)0);
        m.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n;
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                arr$1[i$1.elem] = key;
                arr$1[i$1.elem + 1] = value;
                i$1.elem = n = i$1.elem + 2;
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return arr;
    }

    private final CollectorRegistry collectorRegistry$$anonfun$1() {
        return new CollectorRegistry();
    }

    private final void collectorRegistry$$anonfun$2$$anonfun$1(CollectorRegistry cr$1) {
        cr$1.clear();
    }

    public static final String org$http4s$metrics$prometheus$Prometheus$$anon$1$$_$label$$anonfun$1() {
        return "";
    }

    private final Collector registerCollector$$anonfun$1(Collector collector$1, CollectorRegistry registry$1) {
        return collector$1.register(registry$1);
    }

    private final void registerCollector$$anonfun$2$$anonfun$1(CollectorRegistry registry$3, Collector c$1) {
        registry$3.unregister(c$1);
    }
}

