/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Functor;
import cats.data.Kleisli;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Handle;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pure;
import fs2.Stream;
import fs2.Stream$;
import fs2.Task;
import fs2.Task$;
import fs2.compress$;
import fs2.interop.cats.package$;
import fs2.pipe$;
import fs2.util.Lub1$;
import fs2.util.RealSupertype$;
import fs2.util.RealType$;
import fs2.util.Sub1$;
import java.io.Serializable;
import javax.xml.bind.DatatypeConverter;
import org.http4s.AttributeMap;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.HttpVersion;
import org.http4s.MaybeResponse;
import org.http4s.MediaType$;
import org.http4s.MessageOps;
import org.http4s.Pass$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Service$;
import org.http4s.Status;
import org.http4s.headers.Accept;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType$;
import org.http4s.server.middleware.GZip;
import org.http4s.server.middleware.GZip$TrailerGen$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GZip$ {
    public static GZip$ MODULE$;
    private final Logger logger;
    private final int GZIP_MAGIC_NUMBER;
    private final long GZIP_LENGTH_MOD;
    private final Chunk<Object> header;

    static {
        new GZip$();
    }

    public Kleisli<Task, Request, MaybeResponse> apply(Kleisli<Task, Request, MaybeResponse> service, int bufferSize, int level) {
        return Service$.MODULE$.lift((Function1 & Serializable & scala.Serializable)req -> {
            Some some;
            Accept.minusEncoding acceptEncoding;
            Option option = req.headers().get((HeaderKey.Extractable)Accept$minusEncoding$.MODULE$);
            Task task = option instanceof Some && ((acceptEncoding = (Accept.minusEncoding)(some = (Some)option).value()).satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip())) ? (Task)service.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Pass$ pass$;
                MaybeResponse maybeResponse = x0$1;
                if (maybeResponse instanceof Response) {
                    Response response;
                    Response response2 = (Response)maybeResponse;
                    if (this.isZippable(response2)) {
                        $this.logger.trace("GZip middleware encoding content");
                        GZip.TrailerGen trailerGen = new GZip.TrailerGen(GZip$TrailerGen$.MODULE$.$lessinit$greater$default$1(), GZip$TrailerGen$.MODULE$.$lessinit$greater$default$2());
                        Stream b = Stream$.MODULE$.chunk(this.header()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream.StreamInvariantOps$.MODULE$.through$extension(Stream$.MODULE$.StreamInvariantOps(Stream.StreamInvariantOps$.MODULE$.through$extension(Stream$.MODULE$.StreamInvariantOps(response2.body()), this.trailer(trailerGen))), compress$.MODULE$.deflate(level, true, bufferSize, compress$.MODULE$.deflate$default$4())), RealSupertype$.MODULE$.apply(RealType$.MODULE$.instance()), Lub1$.MODULE$.id()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.chunk(this.trailerFinish(trailerGen)), RealSupertype$.MODULE$.apply(RealType$.MODULE$.instance()), Lub1$.MODULE$.id());
                        Response qual$1 = (Response)((MessageOps)response2.removeHeader((HeaderKey)Content$minusLength$.MODULE$)).putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Content.minusEncoding(ContentCoding$.MODULE$.gzip())}));
                        Stream x$3 = b;
                        Status x$4 = qual$1.copy$default$1();
                        HttpVersion x$5 = qual$1.copy$default$2();
                        Headers x$6 = qual$1.copy$default$3();
                        AttributeMap x$7 = qual$1.copy$default$5();
                        response = qual$1.copy(x$4, x$5, x$6, x$3, x$7);
                    } else {
                        response = response2;
                    }
                    pass$ = response;
                } else if (Pass$.MODULE$.equals(maybeResponse)) {
                    pass$ = Pass$.MODULE$;
                } else {
                    throw new MatchError((Object)maybeResponse);
                }
                return pass$;
            }, (Functor)package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).apply(req) : (Task)service.apply(req);
            return task;
        });
    }

    public int apply$default$2() {
        return 32768;
    }

    public int apply$default$3() {
        return -1;
    }

    private boolean isZippable(Response resp) {
        Option contentType = resp.headers().get((HeaderKey.Extractable)Content$minusType$.MODULE$);
        return resp.headers().get((HeaderKey.Extractable)Content$minusEncoding$.MODULE$).isEmpty() && (contentType.isEmpty() || ((Content.minusType)contentType.get()).mediaType().compressible() || ((Content.minusType)contentType.get()).mediaType() == MediaType$.MODULE$.application$divoctet$minusstream());
    }

    private int GZIP_MAGIC_NUMBER() {
        return this.GZIP_MAGIC_NUMBER;
    }

    private long GZIP_LENGTH_MOD() {
        return this.GZIP_LENGTH_MOD;
    }

    private Chunk<Object> header() {
        return this.header;
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> trailer(GZip.TrailerGen gen) {
        return pipe$.MODULE$.covary((Function1 & Serializable & scala.Serializable)x$1 -> x$1.pull((Function1 & Serializable & scala.Serializable)x$2 -> x$2.await().flatMap(this.trailerStep(gen)), Sub1$.MODULE$.sub1()));
    }

    private Function1<Tuple2<Chunk<Object>, Handle<Pure, Object>>, Pull<Pure, Object, Handle<Pure, Object>>> trailerStep(GZip.TrailerGen gen) {
        return (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Chunk c = (Chunk)tuple2._1();
            Handle h = (Handle)tuple2._2();
            byte[] chunkArr = (byte[])c.toArray(ClassTag$.MODULE$.Byte());
            gen.crc().update(chunkArr);
            gen.inputLength_$eq(gen.inputLength() + chunkArr.length);
            Pull pull = Pull$.MODULE$.output(c).$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.trailerHandle(gen, (Handle<Pure, Object>)h), RealSupertype$.MODULE$.apply(RealType$.MODULE$.instance()));
            return pull;
        };
    }

    private Pull<Pure, Object, Handle<Pure, Object>> trailerHandle(GZip.TrailerGen gen, Handle<Pure, Object> h) {
        return h.await().flatMap(this.trailerStep(gen));
    }

    private Chunk<Object> trailerFinish(GZip.TrailerGen gen) {
        byte[] byArray;
        if (gen.inputLength() == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = (byte)3;
            byArray = byArray2;
            byArray2[1] = (byte)0;
        } else {
            byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        }
        byte[] extraBytes = byArray;
        return Chunk$.MODULE$.bytes((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(extraBytes)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(DatatypeConverter.parseHexBinary((String)new StringOps(Predef$.MODULE$.augmentString("%08x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)gen.crc().getValue())}))))).reverse())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(DatatypeConverter.parseHexBinary((String)new StringOps(Predef$.MODULE$.augmentString("%08x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((long)gen.inputLength() % this.GZIP_LENGTH_MOD()))}))))).reverse())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
    }

    private GZip$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.middleware.GZip");
        this.GZIP_MAGIC_NUMBER = 35615;
        this.GZIP_LENGTH_MOD = (long)Math.pow(2.0, 32.0);
        this.header = Chunk$.MODULE$.bytes(new byte[]{(byte)this.GZIP_MAGIC_NUMBER(), (byte)(this.GZIP_MAGIC_NUMBER() >> 8), (byte)8, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0});
    }
}

