/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.OptionT$;
import cats.effect.SyncIO;
import cats.kernel.Eq;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.headers.Access;
import org.http4s.headers.Access$minusControl$minusAllow$minusMethods$;
import org.http4s.headers.Access$minusControl$minusMax$minusAge$;
import org.http4s.headers.Access$minusControl$minusRequest$minusMethod$;
import org.http4s.headers.Origin;
import org.http4s.headers.Origin$;
import org.http4s.server.middleware.CORSConfig;
import org.http4s.server.middleware.CORSConfig$;
import org.http4s.server.middleware.CORSPolicy;
import org.http4s.server.middleware.CORSPolicy$AllowCredentials$Deny$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$Reflect$;
import org.http4s.server.middleware.CORSPolicy$AllowOrigin$All$;
import org.http4s.server.middleware.CORSPolicy$ExposeHeaders$None$;
import org.http4s.server.middleware.CORSPolicy$MaxAge$Default$;
import org.http4s.syntax.package;
import org.typelevel.ci.CIString$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

public final class CORS$ {
    public static CORS$ MODULE$;
    private final SelfAwareStructuredLogger<SyncIO> logger;
    private final CORSPolicy policy;
    private final Header.Raw defaultVaryHeader;

    static {
        new CORS$();
    }

    public SelfAwareStructuredLogger<SyncIO> logger() {
        return this.logger;
    }

    public CORSPolicy policy() {
        return this.policy;
    }

    public Header.Raw defaultVaryHeader() {
        return this.defaultVaryHeader;
    }

    public CORSConfig DefaultCORSConfig() {
        return CORSConfig$.MODULE$.default().withAnyOrigin(true).withAllowCredentials(true).withMaxAge(new package.DurationInt(package$.MODULE$.DurationInt(1)).day());
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, CORSConfig config, Applicative<F> F) {
        Object object = config.anyOrigin() && config.allowCredentials() ? ((SyncIO)this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Insecure CORS config detected: `anyOrigin=true` and `allowCredentials=true` are mutually exclusive. `Access-Control-Allow-Credentials` header will not be sent. Change either flag to false to remove this warning.")).unsafeRunSync() : BoxedUnit.UNIT;
        return new Kleisli((Function1 & Serializable & scala.Serializable)req -> {
            Option option;
            Tuple3 tuple3 = new Tuple3((Object)req.method(), (Object)Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Origin$.MODULE$.headerInstance())), (Object)Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Access$minusControl$minusRequest$minusMethod$.MODULE$.headerInstance())));
            if (tuple3 != null) {
                Method method = (Method)tuple3._1();
                Option option2 = (Option)tuple3._2();
                Option option3 = (Option)tuple3._3();
                Method method2 = Method$.MODULE$.OPTIONS();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null) && option2 instanceof Some) {
                    Some some;
                    Access.minusControl.minusRequest.minusMethod acrm;
                    Some some2 = (Some)option2;
                    Origin origin = (Origin)some2.value();
                    if (option3 instanceof Some && CORS$.allowCORS$1(origin, (acrm = (Access.minusControl.minusRequest.minusMethod)(some = (Some)option3).value()).method(), config)) {
                        ((SyncIO)MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Serving OPTIONS with CORS headers for ").append(acrm).append(" ").append(req.uri()).toString())).unsafeRunSync();
                        return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)CORS$.createOptionsResponse$1(origin, acrm, config)), F);
                    }
                }
            }
            if (tuple3 != null && (option = (Option)tuple3._2()) instanceof Some) {
                Some some = (Some)option;
                Origin origin = (Origin)some.value();
                if (CORS$.allowCORS$1(origin, req.method(), config)) {
                    return package.all$.MODULE$.toFunctorOps(http.apply(req), (Functor)F).map((Function1 & Serializable & scala.Serializable)resp -> {
                        ((SyncIO)MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Adding CORS headers to ").append(req.method()).append(" ").append(req.uri()).toString())).unsafeRunSync();
                        return CORS$.corsHeaders$1(origin, req.method(), false, resp, config);
                    });
                }
                ((SyncIO)MODULE$.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("CORS headers were denied for ").append(req.method()).append(" ").append(req.uri()).toString())).unsafeRunSync();
                return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5())), F);
            }
            return http.apply(req);
        });
    }

    public <F, G> CORSConfig apply$default$2() {
        return CORSConfig$.MODULE$.default();
    }

    public <F> Kleisli<?, Request<F>, Response<F>> httpRoutes(Kleisli<?, Request<F>, Response<F>> httpRoutes, Monad<F> evidence$1) {
        return this.apply((Kleisli)httpRoutes, CORSConfig$.MODULE$.default(), (Applicative<F>)OptionT$.MODULE$.catsDataMonadErrorMonadForOptionT(evidence$1));
    }

    public <F> Kleisli<F, Request<F>, Response<F>> httpApp(Kleisli<F, Request<F>, Response<F>> httpApp, Applicative<F> evidence$2) {
        return this.apply(httpApp, CORSConfig$.MODULE$.default(), evidence$2);
    }

    private static final Response createOptionsResponse$1(Origin origin, Access.minusControl.minusRequest.minusMethod acrm, CORSConfig config$1) {
        return CORS$.corsHeaders$1(origin, acrm.method(), true, Response$.MODULE$.apply(Response$.MODULE$.apply$default$1(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), config$1);
    }

    private static final Option methodBasedHeader$1(boolean isPreflight, CORSConfig config$1) {
        if (isPreflight) {
            return config$1.allowedHeaders().map((Function1 & Serializable & scala.Serializable)x$2 -> CORS$.headerFromStrings$1("Access-Control-Allow-Headers", x$2));
        }
        return config$1.exposedHeaders().map((Function1 & Serializable & scala.Serializable)x$3 -> CORS$.headerFromStrings$1("Access-Control-Expose-Headers", x$3));
    }

    private static final Response varyHeader$1(Response response) {
        Option option = Headers$.MODULE$.get$extension1(response.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)Nil$.MODULE$));
        if (None$.MODULE$.equals(option)) {
            return (Response)response.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(MODULE$.defaultVaryHeader())}));
        }
        return response;
    }

    private static final Response allowCredentialsHeader$1(Response resp, CORSConfig config$1) {
        if (!config$1.anyOrigin() && config$1.allowCredentials()) {
            return (Response)resp.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Credentials"), (Object)"true"))}));
        }
        return resp;
    }

    private static final Response corsHeaders$1(Origin origin, Method method, boolean isPreflight, Response resp, CORSConfig config$1) {
        Response withMethodBasedHeader = (Response)CORS$.methodBasedHeader$1(isPreflight, config$1).fold((Function0 & Serializable & scala.Serializable)() -> resp, (Function1 & Serializable & scala.Serializable)h -> (Response)resp.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(h)})));
        return (Response)CORS$.varyHeader$1(CORS$.allowCredentialsHeader$1(withMethodBasedHeader, config$1)).putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)new Access.minusControl.minusAllow.minusMethods((Set)config$1.allowedMethods().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Method[]{method})))), Access$minusControl$minusAllow$minusMethods$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Origin"), (Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin, Origin$.MODULE$.headerInstance()).value())), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Access$minusControl$minusMax$minusAge$.MODULE$.unsafeFromLong(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(config$1.maxAge().toSeconds()), -1L)), Access$minusControl$minusMax$minusAge$.MODULE$.headerInstance())}));
    }

    private static final boolean allowOrigin$1(CORSConfig config$1, Origin origin$1) {
        return config$1.anyOrigin() || BoxesRunTime.unboxToBoolean((Object)config$1.allowedOrigins().apply((Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin$1, Origin$.MODULE$.headerInstance()).value()));
    }

    public static final /* synthetic */ boolean $anonfun$apply$9(Method method$2, Method x$5) {
        return package.all$.MODULE$.catsSyntaxEq((Object)x$5, (Eq)Method$.MODULE$.catsInstancesForHttp4sMethod()).$eq$eq$eq((Object)method$2);
    }

    private static final boolean allowMethod$1(CORSConfig config$1, Method method$2) {
        return config$1.anyMethod() || config$1.allowedMethods().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CORS$.$anonfun$apply$9(method$2, x$5)))));
    }

    private static final boolean allowCORS$1(Origin origin, Method method, CORSConfig config$1) {
        return CORS$.allowOrigin$1(config$1, origin) && CORS$.allowMethod$1(config$1, method);
    }

    private static final Header.Raw headerFromStrings$1(String headerName, Set values) {
        return new Header.Raw(CIString$.MODULE$.apply(headerName), values.mkString("", ", ", ""));
    }

    private CORS$() {
        MODULE$ = this;
        this.logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.server.middleware.CORS");
        this.policy = new CORSPolicy(CORSPolicy$AllowOrigin$All$.MODULE$, CORSPolicy$AllowCredentials$Deny$.MODULE$, CORSPolicy$ExposeHeaders$None$.MODULE$, new CORSPolicy.AllowMethods.In((Set<Method>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Method[]{Method$.MODULE$.GET(), Method$.MODULE$.HEAD(), Method$.MODULE$.PUT(), Method$.MODULE$.PATCH(), Method$.MODULE$.POST(), Method$.MODULE$.DELETE()})))), CORSPolicy$AllowHeaders$Reflect$.MODULE$, CORSPolicy$MaxAge$Default$.MODULE$);
        this.defaultVaryHeader = new Header.Raw(org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)Nil$.MODULE$), "Origin,Access-Control-Request-Method");
    }
}

