/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server;

import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00153Qa\u0002\u0005\u0002\u0002=AQA\u0006\u0001\u0005\u0002]AaA\u0007\u0001!\u0002\u0013Y\u0002\"B\u0011\u0001\r\u0003\u0011\u0003\"B\u0016\u0001\t\u0003a\u0003\"\u0002\u001e\u0001\r\u0003Y\u0004\"B \u0001\t\u0003\u0001%AB*feZ,'O\u0003\u0002\n\u0015\u000511/\u001a:wKJT!a\u0003\u0007\u0002\r!$H\u000f\u001d\u001bt\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0007\t\u00033\u0001i\u0011\u0001C\u0001\u0007Y><w-\u001a:\u0011\u0005qyR\"A\u000f\u000b\u0005ya\u0011!\u00027pOR\u001a\u0018B\u0001\u0011\u001e\u0005\u0019aunZ4fe\u00069\u0011\r\u001a3sKN\u001cX#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013a\u00018fi*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o]\u0001\fC\u0012$'/Z:t\u0013B$4/F\u0001.!\rqSgN\u0007\u0002_)\u0011\u0001'M\u0001\u0005SB$4O\u0003\u00023g\u000591m\\7dCN$(\"\u0001\u001b\u0002\u0007\r|W.\u0003\u00027_\ti1k\\2lKR\fE\r\u001a:fgN\u0004\"A\f\u001d\n\u0005ez#!C%q\u0003\u0012$'/Z:t\u0003!I7oU3dkJ,W#\u0001\u001f\u0011\u0005Ei\u0014B\u0001 \u0013\u0005\u001d\u0011un\u001c7fC:\fqAY1tKV\u0013\u0018.F\u0001B!\t\u00115)D\u0001\u000b\u0013\t!%BA\u0002Ve&\u0004")
public abstract class Server {
    private final Logger logger = LoggerFactory.getLogger(Server.class);

    public abstract InetSocketAddress address();

    public SocketAddress<IpAddress> addressIp4s() {
        return SocketAddress$.MODULE$.fromInetSocketAddress(this.address());
    }

    public abstract boolean isSecure();

    public Uri baseUri() {
        Uri.Ipv4Address ipv4Address;
        Some some = new Some((Object)(this.isSecure() ? Uri.Scheme$.MODULE$.https() : Uri.Scheme$.MODULE$.http()));
        InetAddress inetAddress = this.address().getAddress();
        if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            ipv4Address = new Uri.Ipv4Address(Ipv4Address$.MODULE$.fromInet4Address(inet4Address));
        } else if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            ipv4Address = new Uri.Ipv6Address(Ipv6Address$.MODULE$.fromInet6Address(inet6Address));
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(new StringBuilder(26).append("Unexpected address type ").append(inetAddress.getClass()).append(": ").append(inetAddress).toString());
            }
            ipv4Address = Uri.RegName$.MODULE$.apply(inetAddress.getHostAddress());
        }
        Uri.Ipv4Address x$1 = ipv4Address;
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.address().getPort()));
        Option x$3 = Uri.Authority$.MODULE$.apply$default$1();
        return new Uri((Option)some, (Option)new Some((Object)new Uri.Authority(x$3, (Uri.Host)x$1, (Option)x$2)), Uri.Path$.MODULE$.Root(), Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
    }
}

