/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.arrow.FunctionK;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.syntax.package;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Clock;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.http4s.HeaderKey;
import org.http4s.Headers$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.SameSite;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Cookie$;
import org.http4s.headers.Host;
import org.http4s.headers.Host$;
import org.http4s.headers.Origin$;
import org.http4s.headers.Referer;
import org.http4s.headers.Referer$;
import org.http4s.headers.X;
import org.http4s.headers.X$minusForwarded$minusFor$;
import org.http4s.internal.package$;
import org.http4s.server.middleware.CSRF;
import org.http4s.server.middleware.CSRF$CSRFCheckFailed$;
import org.http4s.server.middleware.CSRF$CookieSettings$;
import org.typelevel.ci.CIString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class CSRF$ {
    public static CSRF$ MODULE$;
    private final String SigningAlgo;
    private final int SHA1ByteLen;
    private final int CSRFTokenLength;
    private final int InitialSeedArraySize;
    private final SecureRandom CachedRandom;
    private volatile byte bitmap$init$0;

    static {
        new CSRF$();
    }

    public <F, G> CSRF.CSRFBuilder<F, G> apply(SecretKey key, Function1<Request<G>, Object> headerCheck, Sync<F> evidence$2, Applicative<G> evidence$3) {
        String x$1 = "csrf-token";
        boolean x$2 = false;
        boolean x$3 = true;
        Some x$4 = new Some((Object)"/");
        Option<String> x$5 = CSRF$CookieSettings$.MODULE$.apply$default$4();
        Option<SameSite> x$6 = CSRF$CookieSettings$.MODULE$.apply$default$6();
        Option<String> x$7 = CSRF$CookieSettings$.MODULE$.apply$default$7();
        return new CSRF.CSRFBuilder<F, G>(CIString$.MODULE$.apply("X-Csrf-Token"), new CSRF.CookieSettings(x$1, x$2, x$3, x$5, (Option<String>)x$4, x$6, x$7), Clock.systemUTC(), new Response(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), true, key, headerCheck, this.checkCSRFDefault(evidence$2), evidence$2, evidence$3);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheck(SecretKey key, String host, Uri.Scheme scheme, Option<Object> port, Sync<F> evidence$4, Applicative<G> evidence$5) {
        return this.apply(key, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.MODULE$.defaultOriginCheck(x$4, host, scheme, (Option<Object>)port)), evidence$4, evidence$5);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheckFormAware(String fieldName, FunctionK<G, F> nt, SecretKey key, String host, Uri.Scheme scheme, Option<Object> port, Sync<F> evidence$6, Sync<G> evidence$7) {
        return this.withDefaultOriginCheck(key, host, scheme, port, Sync$.MODULE$.apply(evidence$6), Applicative$.MODULE$.apply(evidence$7)).withCSRFCheck(this.checkCSRFinHeaderAndForm(fieldName, nt, evidence$7, evidence$6));
    }

    public <F, G> F withGeneratedKey(Function1<Request<G>, Object> headerCheck, Sync<F> evidence$8, Applicative<G> evidence$9) {
        return (F)package.all$.MODULE$.toFunctorOps(this.generateSigningKey(evidence$8), evidence$8).map((Function1 & Serializable & scala.Serializable)k -> MODULE$.apply((SecretKey)k, headerCheck, evidence$8, evidence$9));
    }

    public <F, G> F withKeyBytes(byte[] keyBytes, Function1<Request<G>, Object> headerCheck, Sync<F> evidence$10, Applicative<G> evidence$11) {
        return (F)package.all$.MODULE$.toFunctorOps(this.buildSigningKey(keyBytes, evidence$10), evidence$10).map((Function1 & Serializable & scala.Serializable)k -> MODULE$.apply((SecretKey)k, headerCheck, evidence$10, evidence$11));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, F, F>> checkCSRFDefault(Sync<F> F) {
        return (Function1 & Serializable & scala.Serializable)csrf -> (Function2 & Serializable & scala.Serializable)(r, http) -> csrf.getHeaderToken(r).fold((Function0 & Serializable & scala.Serializable)() -> csrf.onfailureF(), (Function1 & Serializable & scala.Serializable)x$11 -> csrf.checkCSRFToken(r, http, (String)x$11, F));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, F, F>> checkCSRFinHeaderAndForm(String fieldName, FunctionK<G, F> nt, Sync<G> evidence$12, Sync<F> F) {
        return (Function1 & Serializable & scala.Serializable)csrf -> (Function2 & Serializable & scala.Serializable)(r, http) -> package.all$.MODULE$.toFlatMapOps(F.pure(csrf.getHeaderToken(r)), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)fst -> package.all$.MODULE$.toFlatMapOps(fst.isDefined() ? F.pure(fst) : CSRF$.getFormToken$1(r, evidence$12, fieldName, nt, F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)snd -> snd.fold((Function0 & Serializable & scala.Serializable)() -> csrf.onfailureF(), (Function1 & Serializable & scala.Serializable)x$17 -> csrf.checkCSRFToken(r, http, (String)x$17, F))));
    }

    public Object lift(String s) {
        return s;
    }

    public String unlift(Object s) {
        return (String)s;
    }

    public <F> boolean defaultOriginCheck(Request<F> r, String host, Uri.Scheme sc, Option<Object> port) {
        return Headers$.MODULE$.get$extension0(r.headers(), (HeaderKey.Extractable)Origin$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)o -> {
            None$ none$;
            Either either = Uri$.MODULE$.fromString(o.value());
            if (either instanceof Right) {
                Right right = (Right)either;
                Uri uri = (Uri)right.value();
                none$ = new Some((Object)uri);
            } else if (either instanceof Left) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)either);
            }
            return none$;
        }).exists((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$2(host, sc, port, u))) || Headers$.MODULE$.get$extension0(r.headers(), (HeaderKey.Extractable)Referer$.MODULE$).exists((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$4(host, sc, port, u)));
    }

    public <F> boolean proxyOriginCheck(Request<F> r, Host host, X.minusForwarded.minusFor xff) {
        return Headers$.MODULE$.get$extension0(r.headers(), (HeaderKey.Extractable)Host$.MODULE$).contains((Object)host) || Headers$.MODULE$.get$extension0(r.headers(), (HeaderKey.Extractable)X$minusForwarded$minusFor$.MODULE$).contains((Object)xff);
    }

    public String SigningAlgo() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/http4s/http4s/server/src/main/scala/org/http4s/server/middleware/CSRF.scala: 451");
        }
        return this.SigningAlgo;
    }

    public int SHA1ByteLen() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/http4s/http4s/server/src/main/scala/org/http4s/server/middleware/CSRF.scala: 453");
        }
        return this.SHA1ByteLen;
    }

    public int CSRFTokenLength() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/http4s/http4s/server/src/main/scala/org/http4s/server/middleware/CSRF.scala: 454");
        }
        return this.CSRFTokenLength;
    }

    private int InitialSeedArraySize() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/http4s/http4s/server/src/main/scala/org/http4s/server/middleware/CSRF.scala: 463");
        }
        return this.InitialSeedArraySize;
    }

    private SecureRandom CachedRandom() {
        if ((byte)(this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/http4s/http4s/server/src/main/scala/org/http4s/server/middleware/CSRF.scala: 464");
        }
        return this.CachedRandom;
    }

    public <F, G> F cookieFromHeadersF(Request<G> request, String cookieName, Sync<F> F) {
        Object object;
        Option<RequestCookie> option = this.cookieFromHeaders(request, cookieName);
        if (option instanceof Some) {
            Some some = (Some)option;
            RequestCookie e = (RequestCookie)some.value();
            object = F.pure((Object)e);
        } else if (None$.MODULE$.equals(option)) {
            object = F.raiseError((Object)CSRF$CSRFCheckFailed$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return (F)object;
    }

    public <F> Option<RequestCookie> cookieFromHeaders(Request<F> request, String cookieName) {
        return Cookie$.MODULE$.from(request.headers()).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> x$20.values().find((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$cookieFromHeaders$2(cookieName, x$21))));
    }

    public boolean tokensEqual(Object s1, Object s2) {
        return this.isEqual(this.unlift(s1), this.unlift(s2));
    }

    public boolean isEqual(String s1, String s2) {
        return MessageDigest.isEqual(s1.getBytes(StandardCharsets.UTF_8), s2.getBytes(StandardCharsets.UTF_8));
    }

    public String genTokenString() {
        byte[] bytes = new byte[this.CSRFTokenLength()];
        this.CachedRandom().nextBytes(bytes);
        return package$.MODULE$.encodeHexString(bytes);
    }

    public <F> F generateSigningKey(Sync<F> F) {
        return (F)F.delay((Function0 & Serializable & scala.Serializable)() -> KeyGenerator.getInstance(MODULE$.SigningAlgo()).generateKey());
    }

    public <F> F buildSigningKey(byte[] array, Sync<F> F) {
        return (F)F.delay((Function0 & Serializable & scala.Serializable)() -> new SecretKeySpec(array, MODULE$.SigningAlgo()));
    }

    public static final /* synthetic */ Option $anonfun$checkCSRFinHeaderAndForm$5(String fieldName$1, Map x$14) {
        return x$14.get((Object)fieldName$1).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.uncons().map((Function1 & Serializable & scala.Serializable)x$16 -> (String)x$16._1()));
    }

    private static final Object extractToken$1(Request r$2, Sync evidence$12$1, String fieldName$1) {
        return package.all$.MODULE$.toFunctorOps(r$2.attemptAs(UrlForm$.MODULE$.entityDecoder(evidence$12$1, UrlForm$.MODULE$.entityDecoder$default$2())).value(), (Functor)evidence$12$1).map((Function1 & Serializable & scala.Serializable)x$12 -> (Option)x$12.fold((Function1 & Serializable & scala.Serializable)x$13 -> package.all$.MODULE$.none(), (Function1 & Serializable & scala.Serializable)x$14 -> CSRF$.$anonfun$checkCSRFinHeaderAndForm$5(fieldName$1, ((UrlForm)x$14).values())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object getFormToken$1(Request r$2, Sync evidence$12$1, String fieldName$1, FunctionK nt$1, Sync F$6) {
        Option option = Headers$.MODULE$.get$extension0(r$2.headers(), (HeaderKey.Extractable)Content$minusType$.MODULE$);
        if (!(option instanceof Some)) return F$6.pure((Object)package.all$.MODULE$.none());
        Some some = (Some)option;
        Content.minusType minusType2 = (Content.minusType)some.value();
        Option option2 = Content$minusType$.MODULE$.unapply(minusType2);
        if (option2.isEmpty()) return F$6.pure((Object)package.all$.MODULE$.none());
        MediaType mediaType = (MediaType)((Tuple2)option2.get())._1();
        MediaType mediaType2 = MediaType$.MODULE$.application().x$minuswww$minusform$minusurlencoded();
        MediaType mediaType3 = mediaType;
        if (mediaType2 != null) {
            if (!mediaType2.equals(mediaType3)) return F$6.pure((Object)package.all$.MODULE$.none());
            return nt$1.apply(CSRF$.extractToken$1(r$2, evidence$12$1, fieldName$1));
        }
        if (mediaType3 == null) return nt$1.apply(CSRF$.extractToken$1(r$2, evidence$12$1, fieldName$1));
        return F$6.pure((Object)package.all$.MODULE$.none());
    }

    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$3(String host$2, Uri.Host x$18) {
        String string = x$18.value();
        String string2 = host$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$2(String host$2, Uri.Scheme sc$1, Option port$2, Uri u) {
        if (!u.host().exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$3(host$2, x$18)))) return false;
        if (!u.scheme().contains((Object)sc$1)) return false;
        Option option = u.port();
        Option option2 = port$2;
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$5(String host$2, Uri.Host x$19) {
        String string = x$19.value();
        String string2 = host$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$4(String host$2, Uri.Scheme sc$1, Option port$2, Referer u) {
        if (!u.uri().host().exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$5(host$2, x$19)))) return false;
        if (!u.uri().scheme().contains((Object)sc$1)) return false;
        Option option = u.uri().port();
        Option option2 = port$2;
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$cookieFromHeaders$2(String cookieName$2, RequestCookie x$21) {
        String string = x$21.name();
        String string2 = cookieName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    private CSRF$() {
        void var1_1;
        MODULE$ = this;
        this.SigningAlgo = "HmacSHA1";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.SHA1ByteLen = 20;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.CSRFTokenLength = 32;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.InitialSeedArraySize = 20;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        SecureRandom r = new SecureRandom();
        r.nextBytes(new byte[this.InitialSeedArraySize()]);
        this.CachedRandom = var1_1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }
}

