/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.effect.Sync;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest$;
import org.http4s.Challenge;
import org.http4s.ContextRequest;
import org.http4s.Credentials;
import org.http4s.HeaderKey;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.package$;
import org.typelevel.ci.CIString;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DigestAuth$ {
    public static final DigestAuth$ MODULE$ = new DigestAuth$();

    public <F, A> Function1<Kleisli<?, ContextRequest<F, A>, Response<F>>, Kleisli<?, Request<F>, Response<F>>> apply(String realm, Function1<String, F> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$1) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$1);
        return (Function1 & Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$1);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int apply$default$5() {
        return 160;
    }

    public <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challenge(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Sync<F> F) {
        return new Kleisli((Function1 & Serializable)req -> package.all$.MODULE$.toFlatMapOps(MODULE$.checkAuth(realm, store, nonceKeeper, (Request)req, (Applicative)F), (FlatMap)F).flatMap((Function1 & Serializable)x0$1 -> {
            Object object;
            DigestAuth.AuthReply authReply = x0$1;
            if (authReply instanceof DigestAuth.OK) {
                DigestAuth.OK oK = (DigestAuth.OK)authReply;
                Object authInfo = oK.authInfo();
                object = F.pure((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)AuthedRequest$.MODULE$.apply(authInfo, req)));
            } else {
                object = DigestAuth$StaleNonce$.MODULE$.equals(authReply) ? package.all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, true, F), (Functor)F).map((Function1 & Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm)) : package.all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, false, F), (Functor)F).map((Function1 & Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
            }
            return object;
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F, A> F checkAuth(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, Applicative<F> F) {
        Object object;
        boolean bl = false;
        Some some = null;
        Option option = Headers$.MODULE$.get$extension(req.headers(), (HeaderKey.Extractable)Authorization$.MODULE$);
        if (option instanceof Some) {
            Credentials credentials;
            Option option2;
            bl = true;
            some = (Some)option;
            Authorization authorization = (Authorization)some.value();
            if (authorization != null && !(option2 = Authorization$.MODULE$.unapply(authorization)).isEmpty() && (credentials = (Credentials)option2.get()) instanceof Credentials.AuthParams) {
                Credentials.AuthParams authParams = (Credentials.AuthParams)credentials;
                CIString cIString = authParams.authScheme();
                NonEmptyList params = authParams.params();
                CIString cIString2 = AuthScheme$.MODULE$.Digest();
                CIString cIString3 = cIString;
                if (!(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null)) {
                    object = this.checkAuthParams(realm, store, nonceKeeper, req, (NonEmptyList<Tuple2<String, String>>)params, F);
                    return (F)object;
                }
            }
        }
        if (bl) {
            object = F.pure((Object)DigestAuth$NoCredentials$.MODULE$);
            return (F)object;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        object = F.pure((Object)DigestAuth$NoAuthorizationHeader$.MODULE$);
        return (F)object;
    }

    private <F> F getChallengeParams(NonceKeeper nonceKeeper, boolean staleNonce, Sync<F> F) {
        return (F)F.delay((Function0 & Serializable)() -> {
            void var3_3;
            String nonce = nonceKeeper.newNonce();
            Map m = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qop"), (Object)"auth"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonce"), (Object)nonce)}));
            return staleNonce ? (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stale"), (Object)"TRUE")) : var3_3;
        });
    }

    private <F, A> F checkAuthParams(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Applicative<F> F) {
        Object object;
        String nc;
        Map params = paramsNel.toList().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (!((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf((Set)params.keySet())) {
            return (F)F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        String uri = req.uri().toString();
        Option option = params.get((Object)"realm");
        Some some = new Some((Object)realm);
        if (option == null ? some != null : !option.equals(some)) {
            return (F)F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply((Object)"nonce");
        NonceKeeper.Reply reply = nonceKeeper.receiveNonce(nonce, Integer.parseInt(nc = (String)params.apply((Object)"nc"), 16));
        if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
            object = F.pure((Object)DigestAuth$StaleNonce$.MODULE$);
        } else if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
            object = F.pure((Object)DigestAuth$BadNC$.MODULE$);
        } else if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
            object = package.all$.MODULE$.toFunctorOps(store.apply(params.apply((Object)"username")), F).map((Function1 & Serializable)x0$1 -> {
                Some some;
                Tuple2 tuple2;
                DigestAuth.AuthReply<Nothing$> authReply;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    authReply = DigestAuth$UserUnknown$.MODULE$;
                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    String resp;
                    Object authInfo = tuple2._1();
                    String password = (String)tuple2._2();
                    String string = resp = DigestUtil$.MODULE$.computeResponse(method, (String)params.apply((Object)"username"), realm, password, uri, nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"));
                    Object object = params.apply((Object)"response");
                    authReply = !(string != null ? !string.equals(object) : object != null) ? new DigestAuth.OK<Object>(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                return authReply;
            });
        } else {
            throw new MatchError((Object)reply);
        }
        return (F)object;
    }

    private static final Either paramsToChallenge$1(Map params, String realm$1) {
        return EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)new Challenge("Digest", realm$1, params));
    }

    private DigestAuth$() {
    }
}

