/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Functor;
import cats.data.Kleisli;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compression.Compression$;
import fs2.compression.DeflateParams;
import fs2.compression.DeflateParams$;
import fs2.compression.ZLibParams;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.headers.Accept;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType$;
import org.http4s.server.middleware.GZip;
import org.http4s.server.middleware.GZip$TrailerGen$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GZip$ {
    public static final GZip$ MODULE$ = new GZip$();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.http4s.server.middleware.GZip");
    private static final int GZIP_MAGIC_NUMBER = 35615;
    private static final long GZIP_LENGTH_MOD = (long)Math.pow(2.0, 32.0);
    private static final Chunk<Object> header = Chunk$.MODULE$.array((Object)new byte[]{(byte)MODULE$.GZIP_MAGIC_NUMBER(), (byte)(MODULE$.GZIP_MAGIC_NUMBER() >> 8), (byte)8, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0}, (ClassTag)ClassTag$.MODULE$.Byte());

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, int bufferSize, DeflateParams.Level level, Function1<Response<G>, Object> isZippable, Functor<F> evidence$1, Sync<G> evidence$2) {
        return new Kleisli((Function1 & Serializable)req -> {
            Some some;
            Accept.minusEncoding acceptEncoding;
            Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Accept$minusEncoding$.MODULE$.headerSemigroupInstance(), Accept$minusEncoding$.MODULE$.headerInstance()));
            Object object = option instanceof Some && MODULE$.satisfiedByGzip(acceptEncoding = (Accept.minusEncoding)(some = (Some)option).value()) ? package.all$.MODULE$.toFunctorOps(http.apply(req), evidence$1).map((Function1 & Serializable)x$2 -> MODULE$.zipOrPass((Response)x$2, bufferSize, level, (Function1)isZippable, (Sync)evidence$2)) : http.apply(req);
            return object;
        });
    }

    public <F, G> int apply$default$2() {
        return 32768;
    }

    public <F, G> DeflateParams.Level apply$default$3() {
        return DeflateParams.Level$.DEFAULT$.MODULE$;
    }

    public <F, G> Function1<Response<G>, Object> apply$default$4() {
        return (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GZip$.MODULE$.defaultIsZippable(x$1));
    }

    public <F> boolean defaultIsZippable(Response<F> resp) {
        Option contentType = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance()));
        return Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusEncoding$.MODULE$.headerInstance())).isEmpty() && (contentType.isEmpty() || ((Content.minusType)contentType.get()).mediaType().compressible() || ((Content.minusType)contentType.get()).mediaType() == MediaType$.MODULE$.application().octet$minusstream());
    }

    private boolean satisfiedByGzip(Accept.minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    private <F> Response<F> zipOrPass(Response<F> response, int bufferSize, DeflateParams.Level level, Function1<Response<F>, Object> isZippable, Sync<F> evidence$3) {
        Response<F> response2 = response;
        Response<F> response3 = BoxesRunTime.unboxToBoolean((Object)isZippable.apply(response2)) ? this.zipResponse(bufferSize, level, response2, evidence$3) : response2;
        return response3;
    }

    private <F> Response<F> zipResponse(int bufferSize, DeflateParams.Level level, Response<F> resp, Sync<F> evidence$4) {
        logger.trace("GZip middleware encoding content");
        GZip.TrailerGen trailerGen = new GZip.TrailerGen(GZip$TrailerGen$.MODULE$.$lessinit$greater$default$1(), GZip$TrailerGen$.MODULE$.$lessinit$greater$default$2());
        Stream b = Stream$.MODULE$.chunk(this.header()).$plus$plus((Function0 & Serializable)() -> resp.body().through(MODULE$.trailer(trailerGen, bufferSize)).through(Compression$.MODULE$.apply(Compression$.MODULE$.forSync(evidence$4)).deflate(DeflateParams$.MODULE$.apply(bufferSize, (ZLibParams.Header)ZLibParams.Header$.GZIP$.MODULE$, level, DeflateParams$.MODULE$.apply$default$4(), DeflateParams$.MODULE$.apply$default$5())))).$plus$plus((Function0 & Serializable)() -> Stream$.MODULE$.chunk(MODULE$.trailerFinish(trailerGen)));
        Response qual$1 = (Response)resp.removeHeader(Content$minusLength$.MODULE$.headerInstance()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)new Content.minusEncoding(ContentCoding$.MODULE$.gzip()), Content$minusEncoding$.MODULE$.headerInstance())}));
        Stream x$1 = b;
        Status x$2 = qual$1.copy$default$1();
        HttpVersion x$3 = qual$1.copy$default$2();
        List x$4 = qual$1.copy$default$3();
        Vault x$5 = qual$1.copy$default$5();
        return qual$1.copy(x$2, x$3, x$4, x$1, x$5);
    }

    private int GZIP_MAGIC_NUMBER() {
        return GZIP_MAGIC_NUMBER;
    }

    private long GZIP_LENGTH_MOD() {
        return GZIP_LENGTH_MOD;
    }

    private Chunk<Object> header() {
        return header;
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> trailer(GZip.TrailerGen gen, int maxReadLimit) {
        return (Function1 & Serializable)x$3 -> Pull.StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Stream.ToPull$.MODULE$.unconsLimit$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$3)), maxReadLimit).flatMap(MODULE$.trailerStep(gen, maxReadLimit)).void()));
    }

    private <F> Function1<Option<Tuple2<Chunk<Object>, Stream<F, Object>>>, Pull<F, Object, Option<Stream<F, Object>>>> trailerStep(GZip.TrailerGen gen, int maxReadLimit) {
        return (Function1 & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Pull pull;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.pure((Object)None$.MODULE$);
            } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk chunk = (Chunk)tuple2._1();
                Stream stream = (Stream)tuple2._2();
                gen.crc().update((byte[])chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
                gen.inputLength_$eq(gen.inputLength() + chunk.size());
                pull = Pull$.MODULE$.output(chunk).$greater$greater((Function0 & Serializable)() -> Stream.ToPull$.MODULE$.unconsLimit$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream)), maxReadLimit).flatMap(MODULE$.trailerStep(gen, maxReadLimit)));
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        };
    }

    private Chunk<Object> trailerFinish(GZip.TrailerGen gen) {
        return Chunk$.MODULE$.array((Object)ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putInt((int)gen.crc().getValue()).putInt((int)((long)gen.inputLength() % this.GZIP_LENGTH_MOD())).array(), (ClassTag)ClassTag$.MODULE$.Byte());
    }

    private GZip$() {
    }
}

