/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.arrow.FunctionK;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.effect.std.SecureRandom;
import cats.effect.std.SecureRandom$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Media;
import org.http4s.Media$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response$;
import org.http4s.SameSite;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.crypto.Algorithm;
import org.http4s.crypto.Hmac$;
import org.http4s.crypto.HmacAlgorithm;
import org.http4s.crypto.HmacAlgorithm$SHA1$;
import org.http4s.crypto.HmacKeyGen$;
import org.http4s.crypto.SecretKey;
import org.http4s.crypto.SecretKeySpec;
import org.http4s.crypto.SecureEq$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Cookie$;
import org.http4s.headers.Host;
import org.http4s.headers.Host$;
import org.http4s.headers.Referer;
import org.http4s.headers.Referer$;
import org.http4s.headers.X;
import org.http4s.headers.X$minusForwarded$minusFor$;
import org.http4s.server.middleware.CSRF;
import org.http4s.server.middleware.CSRF$CSRFCheckFailed$;
import org.http4s.server.middleware.CSRF$CookieSettings$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.Bases;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class CSRF$ {
    public static final CSRF$ MODULE$ = new CSRF$();
    private static final HmacAlgorithm$SHA1$ SigningAlgorithm = HmacAlgorithm$SHA1$.MODULE$;
    private static final String SigningAlgo = "HmacSHA1";
    private static final int CSRFTokenLength = 32;
    private static final int InitialSeedArraySize = 20;
    private static final SecureRandom<SyncIO> CachedRandom = (SecureRandom)((SyncIO)package.all$.MODULE$.toFlatMapOps(SecureRandom$.MODULE$.javaSecuritySecureRandom(SyncIO$.MODULE$.syncForSyncIO()), (FlatMap)SyncIO$.MODULE$.syncForSyncIO()).flatTap((Function1 & Serializable)x$22 -> (SyncIO)x$22.nextBytes(MODULE$.InitialSeedArraySize()))).unsafeRunSync();

    public <F, G> CSRF.CSRFBuilder<F, G> apply(ByteVector key, Function1<Request<G>, Object> headerCheck, Async<F> evidence$3, Applicative<G> evidence$4) {
        String x$1 = "csrf-token";
        boolean x$2 = false;
        boolean x$3 = true;
        Some x$4 = new Some((Object)"/");
        Option<String> x$5 = CSRF$CookieSettings$.MODULE$.apply$default$4();
        Option<SameSite> x$6 = CSRF$CookieSettings$.MODULE$.apply$default$6();
        Option<String> x$7 = CSRF$CookieSettings$.MODULE$.apply$default$7();
        return new CSRF.CSRFBuilder<F, G>(org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"X-Csrf-Token"}))).ci((Seq)Nil$.MODULE$), new CSRF.CookieSettings("csrf-token", false, true, x$5, (Option<String>)x$4, x$6, x$7), Response$.MODULE$.apply(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), true, (SecretKey<HmacAlgorithm>)new SecretKeySpec(key, (Algorithm)HmacAlgorithm$SHA1$.MODULE$), headerCheck, this.checkCSRFDefault(evidence$3), evidence$3, evidence$4);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheck(ByteVector key, String host, Uri.Scheme scheme, Option<Object> port, Async<F> evidence$5, Applicative<G> evidence$6) {
        return this.apply(key, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.MODULE$.defaultOriginCheck(x$6, host, scheme, (Option<Object>)port)), evidence$5, evidence$6);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheckFormAware(String fieldName, FunctionK<G, F> nt, ByteVector key, String host, Uri.Scheme scheme, Option<Object> port, Async<F> evidence$7, GenConcurrent<G, Throwable> evidence$8) {
        return this.withDefaultOriginCheck(key, host, scheme, port, (Async)package$.MODULE$.Sync().apply(evidence$7), Applicative$.MODULE$.apply(evidence$8)).withCSRFCheck(this.checkCSRFinHeaderAndForm(fieldName, nt, evidence$8, evidence$7));
    }

    public <F, G> F withGeneratedKey(Function1<Request<G>, Object> headerCheck, Async<F> evidence$9, Applicative<G> evidence$10) {
        return (F)package.all$.MODULE$.toFunctorOps(this.generateSigningKey(evidence$9), evidence$9).map((Function1 & Serializable)k -> MODULE$.apply((ByteVector)k, headerCheck, evidence$9, evidence$10));
    }

    public <F, G> F withKeyBytes(byte[] keyBytes, Function1<Request<G>, Object> headerCheck, Async<F> evidence$11, Applicative<G> evidence$12) {
        return (F)package.all$.MODULE$.toFunctorOps(this.buildSigningKey(keyBytes, evidence$11), evidence$11).map((Function1 & Serializable)k -> MODULE$.apply((ByteVector)k, headerCheck, evidence$11, evidence$12));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, F, F>> checkCSRFDefault(Async<F> F) {
        return (Function1 & Serializable)csrf -> (Function2 & Serializable)(r, http) -> csrf.getHeaderToken(r).fold((Function0 & Serializable)() -> csrf.onfailureF(), (Function1 & Serializable)x$13 -> csrf.checkCSRFToken(r, http, (String)x$13, F));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, F, F>> checkCSRFinHeaderAndForm(String fieldName, FunctionK<G, F> nt, GenConcurrent<G, Throwable> evidence$13, Async<F> F) {
        return (Function1 & Serializable)csrf -> (Function2 & Serializable)(r, http) -> package.all$.MODULE$.toFlatMapOps(F.pure(csrf.getHeaderToken(r)), (FlatMap)F).flatMap((Function1 & Serializable)fst -> package.all$.MODULE$.toFlatMapOps(fst.isDefined() ? F.pure(fst) : CSRF$.getFormToken$1(r, evidence$13, fieldName, nt, F), (FlatMap)F).flatMap((Function1 & Serializable)snd -> snd.fold((Function0 & Serializable)() -> csrf.onfailureF(), (Function1 & Serializable)x$19 -> csrf.checkCSRFToken(r, http, (String)x$19, F))));
    }

    public Object lift(String s) {
        return s;
    }

    public String unlift(Object s) {
        return (String)s;
    }

    public <F> boolean defaultOriginCheck(Request<F> r, String host, Uri.Scheme sc, Option<Object> port) {
        return Headers$.MODULE$.get$extension(r.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Origin"}))).ci((Seq)Nil$.MODULE$)).flatMap((Function1 & Serializable)o -> {
            Either either = Uri$.MODULE$.fromString(((Header.Raw)o.head()).value());
            if (either instanceof Right) {
                Right right = (Right)either;
                Uri uri = (Uri)right.value();
                return new Some((Object)uri);
            }
            if (either instanceof Left) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }).exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$2(host, sc, port, u))) || Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(Referer$.MODULE$.headerInstance())).exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$4(host, sc, port, u)));
    }

    public <F> boolean proxyOriginCheck(Request<F> r, Host host, X.minusForwarded.minusFor xff) {
        return Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(Host$.MODULE$.headerInstance())).contains((Object)host) || Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(X$minusForwarded$minusFor$.MODULE$.headerInstance())).contains((Object)xff);
    }

    private HmacAlgorithm$SHA1$ SigningAlgorithm() {
        return SigningAlgorithm;
    }

    public String SigningAlgo() {
        return SigningAlgo;
    }

    public int CSRFTokenLength() {
        return CSRFTokenLength;
    }

    private int InitialSeedArraySize() {
        return InitialSeedArraySize;
    }

    private SecureRandom<SyncIO> CachedRandom() {
        return CachedRandom;
    }

    public <F, G> F cookieFromHeadersF(Request<G> request, String cookieName, Sync<F> F) {
        Option<RequestCookie> option = this.cookieFromHeaders(request, cookieName);
        if (option instanceof Some) {
            Some some = (Some)option;
            RequestCookie e = (RequestCookie)some.value();
            return (F)F.pure((Object)e);
        }
        if (None$.MODULE$.equals(option)) {
            return (F)F.raiseError((Object)CSRF$CSRFCheckFailed$.MODULE$);
        }
        throw new MatchError(option);
    }

    public <F> Option<RequestCookie> cookieFromHeaders(Request<F> request, String cookieName) {
        return Headers$.MODULE$.get$extension(request.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Cookie$.MODULE$.headerSemigroupInstance(), Cookie$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)x$23 -> x$23.values().find((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$cookieFromHeaders$2(cookieName, x$24))));
    }

    public boolean tokensEqual(Object s1, Object s2) {
        return this.isEqual(this.unlift(s1), this.unlift(s2));
    }

    public boolean isEqual(String s1, String s2) {
        return SecureEq$.MODULE$.apply(SecureEq$.MODULE$.secureEqForByteVector()).eqv(SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeUtf8(s1)).unsafeRunSync(), SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeUtf8(s2)).unsafeRunSync());
    }

    public <F> F genTokenString(Sync<F> evidence$14) {
        return (F)((SyncIO)this.CachedRandom().nextBytes(this.CSRFTokenLength())).map((Function1 & Serializable)arr -> ByteVector$.MODULE$.view(arr).toHex((Bases.HexAlphabet)Bases.Alphabets$.HexUppercase$.MODULE$)).to(evidence$14);
    }

    public <F> F generateSigningKey(Async<F> F) {
        return (F)package.all$.MODULE$.toFunctorOps(HmacKeyGen$.MODULE$.apply(HmacKeyGen$.MODULE$.forSync(F)).generateKey((HmacAlgorithm)this.SigningAlgorithm()), F).map((Function1 & Serializable)x0$1 -> {
            SecretKey secretKey = x0$1;
            if (secretKey instanceof SecretKeySpec) {
                SecretKeySpec secretKeySpec = (SecretKeySpec)secretKey;
                ByteVector key = secretKeySpec.key();
                return key;
            }
            throw new MatchError((Object)secretKey);
        });
    }

    public <F> F buildSigningKey(byte[] array, Async<F> F) {
        return (F)package.all$.MODULE$.toFunctorOps(Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow(F)).importKey(ByteVector$.MODULE$.view(array), (HmacAlgorithm)this.SigningAlgorithm()), F).map((Function1 & Serializable)x0$1 -> {
            SecretKey secretKey = x0$1;
            if (secretKey instanceof SecretKeySpec) {
                SecretKeySpec secretKeySpec = (SecretKeySpec)secretKey;
                ByteVector key = secretKeySpec.key();
                return key;
            }
            throw new MatchError((Object)secretKey);
        });
    }

    public static final /* synthetic */ Option $anonfun$checkCSRFinHeaderAndForm$5(String fieldName$1, Map x$16) {
        return x$16.get((Object)fieldName$1).flatMap((Function1 & Serializable)x$17 -> x$17.uncons().map((Function1 & Serializable)x$18 -> (String)x$18._1()));
    }

    private static final Object extractToken$1(Request r$2, GenConcurrent evidence$13$1, String fieldName$1) {
        return package.all$.MODULE$.toFunctorOps(Media.InvariantOps$.MODULE$.attemptAs$extension(Media$.MODULE$.InvariantOps((Media)r$2), UrlForm$.MODULE$.entityDecoder(evidence$13$1, UrlForm$.MODULE$.entityDecoder$default$2())).value(), (Functor)evidence$13$1).map((Function1 & Serializable)x$14 -> (Option)x$14.fold((Function1 & Serializable)x$15 -> package.all$.MODULE$.none(), (Function1 & Serializable)x$16 -> CSRF$.$anonfun$checkCSRFinHeaderAndForm$5(fieldName$1, ((UrlForm)x$16).values())));
    }

    private static final Object getFormToken$1(Request r$2, GenConcurrent evidence$13$1, String fieldName$1, FunctionK nt$1, Async F$8) {
        Some some;
        Content.minusType minusType2;
        Option option = Headers$.MODULE$.get$extension(r$2.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance()));
        if (option instanceof Some && (minusType2 = (Content.minusType)(some = (Some)option).value()) != null) {
            MediaType mediaType = minusType2.mediaType();
            MediaType mediaType2 = MediaType$.MODULE$.application().x$minuswww$minusform$minusurlencoded();
            MediaType mediaType3 = mediaType;
            if (!(mediaType2 != null ? !mediaType2.equals(mediaType3) : mediaType3 != null)) {
                return nt$1.apply(CSRF$.extractToken$1(r$2, evidence$13$1, fieldName$1));
            }
        }
        return F$8.pure((Object)package.all$.MODULE$.none());
    }

    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$3(String host$2, Uri.Host x$20) {
        String string = x$20.value();
        String string2 = host$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$2(String host$2, Uri.Scheme sc$1, Option port$2, Uri u) {
        if (!u.host().exists((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$3(host$2, x$20)))) return false;
        if (!u.scheme().contains((Object)sc$1)) return false;
        Option option = u.port();
        Option option2 = port$2;
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$5(String host$2, Uri.Host x$21) {
        String string = x$21.value();
        String string2 = host$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$4(String host$2, Uri.Scheme sc$1, Option port$2, Referer u) {
        if (!u.uri().host().exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$5(host$2, x$21)))) return false;
        if (!u.uri().scheme().contains((Object)sc$1)) return false;
        Option option = u.uri().port();
        Option option2 = port$2;
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$cookieFromHeaders$2(String cookieName$2, RequestCookie x$24) {
        String string = x$24.name();
        String string2 = cookieName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private CSRF$() {
    }
}

