/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.effect.Clock;
import cats.effect.Clock$;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Timer;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Semaphore;
import cats.syntax.MonadOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.http4s.internal.Random;
import org.http4s.server.middleware.authentication.NonceF;
import org.http4s.server.middleware.authentication.NonceF$;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.NonceKeeperF$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;

public class NonceKeeperF<F> {
    private final Duration staleTimeout;
    private final Duration nonceCleanupInterval;
    private final int bits;
    private final Semaphore<F> semaphore;
    private final Ref<F, Object> lastCleanupMillis;
    private final LinkedHashMap<String, NonceF<F>> nonces;
    private final Random<F> random;
    private final Concurrent<F> F;
    private final Timer<F> t;
    private final Clock clock;

    public static <F> Object apply(Duration duration, Duration duration2, int n, ExecutionContext executionContext, Concurrent<F> concurrent, Timer<F> timer, ContextShift<F> contextShift) {
        return NonceKeeperF$.MODULE$.apply(duration, duration2, n, executionContext, concurrent, timer, contextShift);
    }

    public NonceKeeperF(Duration staleTimeout, Duration nonceCleanupInterval, int bits, Semaphore<F> semaphore, Ref<F, Object> lastCleanupMillis, LinkedHashMap<String, NonceF<F>> nonces, Random<F> random, Concurrent<F> F, Timer<F> t) {
        this.staleTimeout = staleTimeout;
        this.nonceCleanupInterval = nonceCleanupInterval;
        this.bits = bits;
        this.semaphore = semaphore;
        this.lastCleanupMillis = lastCleanupMillis;
        this.nonces = nonces;
        this.random = random;
        this.F = F;
        this.t = t;
        Predef$.MODULE$.require(bits > 0, NonceKeeperF::$init$$$anonfun$1);
        this.clock = Clock$.MODULE$.apply(Clock$.MODULE$.extractFromTimer(t));
    }

    public Clock<F> clock() {
        return this.clock;
    }

    private F unsafeCheckStale() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.clock().monotonic(scala.concurrent.duration.package$.MODULE$.MILLISECONDS()), this.F).flatMap((Function1 & Serializable)nowMillis -> this.unsafeCheckStale$$anonfun$8(BoxesRunTime.unboxToLong((Object)nowMillis)));
    }

    public F newNonce() {
        return (F)this.semaphore.withPermit(package.all$.MODULE$.toFlatMapOps(this.unsafeCheckStale(), this.F).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            Object object = package.all$.MODULE$.catsSyntaxMonad(NonceF$.MODULE$.gen(this.random, this.bits, this.F, this.t));
            return package.all$.MODULE$.toFunctorOps(MonadOps$.MODULE$.iterateUntil$extension(object, this.F, (Function1 & Serializable)n -> this.nonces.get(n.data()) == null), this.F).map((Function1 & Serializable)n -> {
                this.nonces.put(n.data(), (NonceF<F>)n);
                return n.data();
            });
        }));
    }

    public F receiveNonce(String data, int nc) {
        return (F)this.semaphore.withPermit(package.all$.MODULE$.toFlatMapOps(this.unsafeCheckStale(), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            BoxedUnit boxedUnit = x$1;
            NonceF<F> nonceF = this.nonces.get(data);
            if (nonceF == null) {
                object = this.F.pure((Object)NonceKeeper$StaleReply$.MODULE$);
            } else if (nonceF instanceof NonceF) {
                NonceF<F> n = nonceF;
                object = n.nc().modify((Function1 & Serializable)lastNc -> NonceKeeperF.receiveNonce$$anonfun$2$$anonfun$1(nc, BoxesRunTime.unboxToInt((Object)lastNc)));
            } else {
                throw new MatchError(nonceF);
            }
            return package.all$.MODULE$.toFunctorOps(object, this.F).map((Function1 & Serializable)res -> res);
        }));
    }

    private static final String $init$$$anonfun$1() {
        return "Please supply a positive integer for bits.";
    }

    private static final Left unsafeCheckStale$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Iterator it$1) {
        Left$ left$ = package$.MODULE$.Left();
        it$1.remove();
        return left$.apply((Object)it$1);
    }

    private static final Right unsafeCheckStale$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2() {
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final /* synthetic */ Object unsafeCheckStale$$anonfun$6$$anonfun$6(long nowMillis$1, long lastCleanupTime) {
        return package.all$.MODULE$.toFunctorOps(nowMillis$1 - lastCleanupTime > this.nonceCleanupInterval.toMillis() ? package.all$.MODULE$.toFlatMapOps(this.lastCleanupMillis.set((Object)BoxesRunTime.boxToLong((long)nowMillis$1)), this.F).flatMap((Function1 & Serializable)_$3 -> this.F.tailRecM(this.nonces.values().iterator(), (Function1 & Serializable)x$1 -> {
            Iterator iterator = x$1;
            Iterator it = iterator;
            return it.hasNext() && this.staleTimeout.toMillis() > nowMillis$1 - ((NonceF)it.next()).createdMillis() ? this.F.delay(() -> NonceKeeperF.unsafeCheckStale$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(it)) : this.F.delay(NonceKeeperF::unsafeCheckStale$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2);
        })) : this.F.pure((Object)BoxedUnit.UNIT), this.F).map((Function1)(JProcedure1 & Serializable)result -> {});
    }

    private final /* synthetic */ Object unsafeCheckStale$$anonfun$8(long nowMillis) {
        return package.all$.MODULE$.toFlatMapOps(this.lastCleanupMillis.get(), this.F).flatMap((Function1 & Serializable)lastCleanupTime -> this.unsafeCheckStale$$anonfun$6$$anonfun$6(nowMillis, BoxesRunTime.unboxToLong((Object)lastCleanupTime)));
    }

    private static final /* synthetic */ Tuple2 receiveNonce$$anonfun$2$$anonfun$1(int nc$2, int lastNc) {
        return nc$2 > lastNc ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(lastNc + 1)), (Object)NonceKeeper$OKReply$.MODULE$) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lastNc), (Object)NonceKeeper$BadNCReply$.MODULE$);
    }
}

