/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.kernel.Eq;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.headers.Access;
import org.http4s.headers.Access$minusControl$minusRequest$minusMethod$;
import org.http4s.headers.Origin;
import org.http4s.headers.Origin$;
import org.http4s.server.middleware.CORSConfig;
import org.http4s.server.middleware.CORSConfig$;
import org.http4s.server.middleware.CORSPolicy;
import org.http4s.server.middleware.CORSPolicy$AllowCredentials$Deny$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$Reflect$;
import org.http4s.server.middleware.CORSPolicy$AllowMethods$In$;
import org.http4s.server.middleware.CORSPolicy$AllowOrigin$All$;
import org.http4s.server.middleware.CORSPolicy$ExposeHeaders$None$;
import org.http4s.server.middleware.CORSPolicy$MaxAge$Default$;
import org.http4s.syntax.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class CORS$
implements Serializable {
    private static final Logger logger;
    private static final CORSPolicy policy;
    private static final Header.Raw defaultVaryHeader;
    public static final CORS$ MODULE$;

    private CORS$() {
    }

    static {
        MODULE$ = new CORS$();
        logger = LoggerFactory.getLogger((String)"org.http4s.server.middleware.CORS");
        policy = new CORSPolicy(CORSPolicy$AllowOrigin$All$.MODULE$, CORSPolicy$AllowCredentials$Deny$.MODULE$, CORSPolicy$ExposeHeaders$None$.MODULE$, CORSPolicy$AllowMethods$In$.MODULE$.apply((Set<Method>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Method[]{Method$.MODULE$.GET(), Method$.MODULE$.HEAD(), Method$.MODULE$.PUT(), Method$.MODULE$.PATCH(), Method$.MODULE$.POST(), Method$.MODULE$.DELETE()})))), CORSPolicy$AllowHeaders$Reflect$.MODULE$, CORSPolicy$MaxAge$Default$.MODULE$);
        defaultVaryHeader = Header.Raw$.MODULE$.apply(org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), "Origin,Access-Control-Request-Method");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CORS$.class);
    }

    public Logger logger() {
        return logger;
    }

    public CORSPolicy policy() {
        return policy;
    }

    public Header.Raw defaultVaryHeader() {
        return defaultVaryHeader;
    }

    public CORSConfig DefaultCORSConfig() {
        return CORSConfig$.MODULE$.default().withAnyOrigin(true).withAllowCredentials(true).withMaxAge(new package.DurationInt(package$.MODULE$.DurationInt(1)).day());
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, CORSConfig config, Applicative<F> F) {
        Logger Logger_this;
        if (config.anyOrigin() && config.allowCredentials() && (Logger_this = this.logger()).isWarnEnabled()) {
            Logger_this.warn("Insecure CORS config detected: `anyOrigin=true` and `allowCredentials=true` are mutually exclusive. `Access-Control-Allow-Credentials` header will not be sent. Change either flag to false to remove this warning.");
        }
        return Kleisli$.MODULE$.apply((Function1 & Serializable)req -> {
            Object object;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)req.method(), (Object)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Origin$.MODULE$.headerInstance())), (Object)Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Access$minusControl$minusRequest$minusMethod$.MODULE$.headerInstance())));
            if (tuple3 != null) {
                Option option = (Option)tuple3._2();
                Option option2 = (Option)tuple3._3();
                Method method = Method$.MODULE$.OPTIONS();
                Object object2 = tuple3._1();
                if (!(method != null ? !method.equals(object2) : object2 != null) && option instanceof Some) {
                    Access.minusControl.minusRequest.minusMethod acrm;
                    Origin origin = (Origin)((Some)option).value();
                    if (option2 instanceof Some && this.allowCORS$1(config, origin, (acrm = (Access.minusControl.minusRequest.minusMethod)((Some)option2).value()).method())) {
                        Logger Logger_this = this.logger();
                        if (Logger_this.isDebugEnabled()) {
                            Logger_this.debug("Serving OPTIONS with CORS headers for " + acrm + " " + req.uri());
                        }
                        Response response = (Response)package.all$.MODULE$.catsSyntaxApplicativeId((Object)this.createOptionsResponse$1(config, origin, acrm));
                        object = ApplicativeIdOps$.MODULE$.pure$extension((Object)response, F);
                        return object;
                    }
                }
                if (option instanceof Some) {
                    Origin origin = (Origin)((Some)option).value();
                    if (this.allowCORS$1(config, origin, req.method())) {
                        object = package.all$.MODULE$.toFunctorOps(http.apply(req), (Functor)F).map((Function1 & Serializable)resp -> {
                            Logger Logger_this = this.logger();
                            if (Logger_this.isDebugEnabled()) {
                                Logger_this.debug("Adding CORS headers to " + req.method() + " " + req.uri());
                            }
                            return this.corsHeaders$1(config, origin, req.method(), false, (Response)resp);
                        });
                        return object;
                    }
                    Logger Logger_this = this.logger();
                    if (Logger_this.isDebugEnabled()) {
                        Logger_this.debug("CORS headers were denied for " + req.method() + " " + req.uri());
                    }
                    Response response = (Response)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()));
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)response, F);
                    return object;
                }
            }
            object = http.apply(req);
            return object;
        });
    }

    public <F, G> CORSConfig apply$default$2() {
        return CORSConfig$.MODULE$.default();
    }

    public <F> Kleisli<OptionT, Request<F>, Response<F>> httpRoutes(Kleisli<OptionT, Request<F>, Response<F>> httpRoutes, Monad<F> evidence$1) {
        return this.apply((Kleisli)httpRoutes, CORSConfig$.MODULE$.default(), (Applicative<F>)OptionT$.MODULE$.catsDataMonadErrorMonadForOptionT(evidence$1));
    }

    public <F> Kleisli<F, Request<F>, Response<F>> httpApp(Kleisli<F, Request<F>, Response<F>> httpApp, Applicative<F> evidence$2) {
        return this.apply(httpApp, CORSConfig$.MODULE$.default(), evidence$2);
    }

    private final Response createOptionsResponse$1(CORSConfig config$9, Origin origin, Access.minusControl.minusRequest.minusMethod acrm) {
        return this.corsHeaders$1(config$9, origin, acrm.method(), true, Response$.MODULE$.apply(Response$.MODULE$.apply$default$1(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()));
    }

    private final Option methodBasedHeader$3(CORSConfig config$2, boolean isPreflight) {
        return isPreflight ? config$2.allowedHeaders().map((Function1 & Serializable)_$4 -> this.headerFromStrings$1("Access-Control-Allow-Headers", (Set)_$4)) : config$2.exposedHeaders().map((Function1 & Serializable)_$5 -> this.headerFromStrings$1("Access-Control-Expose-Headers", (Set)_$5));
    }

    private final Response varyHeader$1(Response response) {
        Option option = Headers$.MODULE$.get$extension(response.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
        return None$.MODULE$.equals(option) ? (Response)response.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(this.defaultVaryHeader())})) : response;
    }

    private final Response allowCredentialsHeader$1(CORSConfig config$3, Response resp) {
        Response response;
        if (!config$3.anyOrigin() && config$3.allowCredentials()) {
            Object[] objectArray = new Header.ToRaw[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Credentials");
            objectArray[0] = Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"true"));
            response = (Response)resp.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            response = resp;
        }
        return response;
    }

    private final Response $anonfun$1(Response resp$1) {
        return resp$1;
    }

    private final String corsHeaders$2$$anonfun$1(Method method$2) {
        return method$2.renderString();
    }

    private final Response corsHeaders$1(CORSConfig config$4, Origin origin, Method method, boolean isPreflight, Response resp) {
        Response withMethodBasedHeader = (Response)this.methodBasedHeader$3(config$4, isPreflight).fold(() -> this.$anonfun$1(resp), (Function1 & Serializable)h -> (Response)resp.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(h)})));
        Object[] objectArray = new Header.ToRaw[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Methods");
        objectArray[0] = Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, config$4.allowedMethods().fold(() -> this.corsHeaders$2$$anonfun$1(method), (Function1 & Serializable)_$6 -> _$6.mkString("", ", ", ""))));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Origin");
        objectArray[1] = Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin, Origin$.MODULE$.headerInstance()).value()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Max-Age");
        objectArray[2] = Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToLong((long)config$4.maxAge().toSeconds()).toString()));
        return (Response)this.varyHeader$1(this.allowCredentialsHeader$1(config$4, withMethodBasedHeader)).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final boolean allowOrigin$1(CORSConfig config$6, Origin origin$1) {
        return config$6.anyOrigin() || BoxesRunTime.unboxToBoolean((Object)config$6.allowedOrigins().apply((Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin$1, Origin$.MODULE$.headerInstance()).value()));
    }

    private final boolean allowMethod$3(CORSConfig config$7, Method method$3) {
        return config$7.anyMethod() || config$7.allowedMethods().exists((Function1 & Serializable)_$7 -> _$7.exists((Function1 & Serializable)_$8 -> package.all$.MODULE$.catsSyntaxEq(_$8, (Eq)Method$.MODULE$.catsInstancesForHttp4sMethod()).$eq$eq$eq((Object)method$3)));
    }

    private final boolean allowCORS$1(CORSConfig config$5, Origin origin, Method method) {
        return this.allowOrigin$1(config$5, origin) && this.allowMethod$3(config$5, method);
    }

    private final Header.Raw headerFromStrings$1(String headerName, Set values) {
        return Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply(headerName), values.mkString("", ", ", ""));
    }
}

