/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Applicative$;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.arrow.FunctionK;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.syntax.package;
import java.io.Serializable;
import java.security.SecureRandom;
import java.time.Clock;
import javax.crypto.SecretKey;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response$;
import org.http4s.SameSite;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.crypto.Hmac$;
import org.http4s.crypto.HmacAlgorithm;
import org.http4s.crypto.SecureEq$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Cookie$;
import org.http4s.headers.Host;
import org.http4s.headers.Host$;
import org.http4s.headers.Referer$;
import org.http4s.headers.X;
import org.http4s.headers.X$minusForwarded$minusFor$;
import org.http4s.internal.package$;
import org.http4s.server.middleware.CSRF;
import org.http4s.server.middleware.CSRF$CSRFCheckFailed$;
import org.http4s.server.middleware.CSRF$CookieSettings$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector$;

public final class CSRF$
implements Serializable {
    public static final CSRF$CookieSettings$ CookieSettings;
    public static final CSRF$CSRFCheckFailed$ CSRFCheckFailed;
    private static final HmacAlgorithm.SHA1$ SigningAlgorithm;
    private static final String SigningAlgo;
    private static final int SHA1ByteLen;
    private static final int CSRFTokenLength;
    private static final SecureRandom CachedRandom;
    public static final CSRF$ MODULE$;

    private CSRF$() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        MODULE$ = new CSRF$();
        SigningAlgorithm = HmacAlgorithm.SHA1$.MODULE$;
        SigningAlgo = "HmacSHA1";
        SHA1ByteLen = 20;
        CSRFTokenLength = 32;
        int InitialSeedArraySize = 20;
        SecureRandom r = new SecureRandom();
        r.nextBytes(new byte[InitialSeedArraySize]);
        CachedRandom = var1_1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CSRF$.class);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> apply(SecretKey key, Function1<Request<G>, Object> headerCheck, Sync<F> evidence$2, Applicative<G> evidence$3) {
        Some some = Some$.MODULE$.apply((Object)"/");
        Option<String> option = CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$4();
        Option<SameSite> option2 = CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$6();
        Option<String> option3 = CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$7();
        return new CSRF.CSRFBuilder<F, G>(org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"X-Csrf-Token"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CSRF$CookieSettings$.MODULE$.apply("csrf-token", false, true, option, (Option<String>)some, option2, option3), Clock.systemUTC(), Response$.MODULE$.apply(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), true, (org.http4s.crypto.SecretKey<HmacAlgorithm>)((org.http4s.crypto.SecretKey)((SyncIO)Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow((ApplicativeError)SyncIO$.MODULE$.syncIOsyncEffect())).importJavaKey(key)).unsafeRunSync()), headerCheck, this.checkCSRFDefault(evidence$2), evidence$2, evidence$3);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheck(SecretKey key, String host, Uri.Scheme scheme, Option<Object> port, Sync<F> evidence$4, Applicative<G> evidence$5) {
        return this.apply(key, (Function1 & Serializable)_$15 -> this.defaultOriginCheck((Request)_$15, host, scheme, port), evidence$4, evidence$5);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheckFormAware(String fieldName, FunctionK<G, F> nt, SecretKey key, String host, Uri.Scheme scheme, Option<Object> port, Sync<F> evidence$6, Sync<G> evidence$7) {
        return this.withDefaultOriginCheck(key, host, scheme, port, Sync$.MODULE$.apply(evidence$6), Applicative$.MODULE$.apply(evidence$7)).withCSRFCheck(this.checkCSRFinHeaderAndForm(fieldName, nt, evidence$7, evidence$6));
    }

    public <F, G> Object withGeneratedKey(Function1<Request<G>, Object> headerCheck, Sync<F> evidence$8, Applicative<G> evidence$9) {
        return package.all$.MODULE$.toFunctorOps(this.generateSigningKey(evidence$8), evidence$8).map((Function1 & Serializable)k -> this.apply((SecretKey)k, headerCheck, evidence$8, evidence$9));
    }

    public <F, G> Object withKeyBytes(byte[] keyBytes, Function1<Request<G>, Object> headerCheck, Sync<F> evidence$10, Applicative<G> evidence$11) {
        return package.all$.MODULE$.toFunctorOps(this.buildSigningKey(keyBytes, evidence$10), evidence$10).map((Function1 & Serializable)k -> this.apply((SecretKey)k, headerCheck, evidence$10, evidence$11));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> checkCSRFDefault(Sync<F> F) {
        return (Function1 & Serializable)csrf -> (Function2 & Serializable)(r, http) -> csrf.getHeaderToken(r).fold(() -> this.checkCSRFDefault$$anonfun$2$$anonfun$1$$anonfun$1(csrf), (Function1 & Serializable)_$34 -> csrf.checkCSRFToken(r, http, (String)_$34, F));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> checkCSRFinHeaderAndForm(String fieldName, FunctionK<G, F> nt, Sync<G> evidence$12, Sync<F> F) {
        return (Function1 & Serializable)csrf -> (Function2 & Serializable)(r, http) -> package.all$.MODULE$.toFlatMapOps(F.pure(csrf.getHeaderToken(r)), (FlatMap)F).flatMap((Function1 & Serializable)fst -> package.all$.MODULE$.toFlatMapOps(fst.isDefined() ? F.pure(fst) : this.getFormToken$1(fieldName, nt, evidence$12, F, (Request)r), (FlatMap)F).flatMap((Function1 & Serializable)snd -> package.all$.MODULE$.toFunctorOps(snd.fold(() -> this.checkCSRFinHeaderAndForm$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(csrf), (Function1 & Serializable)_$42 -> csrf.checkCSRFToken(r, http, (String)_$42, F)), (Functor)F).map((Function1 & Serializable)tok -> tok)));
    }

    public Object lift(String s) {
        return s;
    }

    public String unlift(Object s) {
        return (String)s;
    }

    public <F> boolean defaultOriginCheck(Request<F> r, String host, Uri.Scheme sc, Option<Object> port) {
        return Headers$.MODULE$.get$extension(r.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Origin"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))).flatMap((Function1 & Serializable)o -> {
            None$ none$;
            Either either = Uri$.MODULE$.fromString(((Header.Raw)o.head()).value());
            if (either instanceof Right) {
                Uri uri = (Uri)((Right)either).value();
                none$ = Some$.MODULE$.apply((Object)uri);
            } else if (either instanceof Left) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)either);
            }
            return none$;
        }).exists((Function1 & Serializable)u -> {
            if (!u.host().exists((Function1 & Serializable)_$44 -> {
                String string = _$44.value();
                String string2 = host;
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) return false;
            if (!u.scheme().contains((Object)sc)) return false;
            Option option = u.port();
            Option option2 = port;
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }) || Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(Referer$.MODULE$.headerInstance())).exists((Function1 & Serializable)u -> {
            if (!u.uri().host().exists((Function1 & Serializable)_$45 -> {
                String string = _$45.value();
                String string2 = host;
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) return false;
            if (!u.uri().scheme().contains((Object)sc)) return false;
            Option option = u.uri().port();
            Option option2 = port;
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        });
    }

    public <F> boolean proxyOriginCheck(Request<F> r, Host host, X.minusForwarded.minusFor xff) {
        return Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(Host$.MODULE$.headerInstance())).contains((Object)host) || Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(X$minusForwarded$minusFor$.MODULE$.headerInstance())).contains((Object)xff);
    }

    public String SigningAlgo() {
        return SigningAlgo;
    }

    public int SHA1ByteLen() {
        return SHA1ByteLen;
    }

    public int CSRFTokenLength() {
        return CSRFTokenLength;
    }

    public <F, G> Object cookieFromHeadersF(Request<G> request, String cookieName, Sync<F> F) {
        Object object;
        Option<RequestCookie> option = this.cookieFromHeaders(request, cookieName);
        if (option instanceof Some) {
            RequestCookie e = (RequestCookie)((Some)option).value();
            object = F.pure((Object)e);
        } else if (None$.MODULE$.equals(option)) {
            object = F.raiseError((Object)CSRF$CSRFCheckFailed$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return object;
    }

    public <F> Option<RequestCookie> cookieFromHeaders(Request<F> request, String cookieName) {
        return Headers$.MODULE$.get$extension(request.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Cookie$.MODULE$.headerSemigroupInstance(), Cookie$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)_$50 -> _$50.values().find((Function1 & Serializable)_$51 -> {
            String string = _$51.name();
            String string2 = cookieName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    public boolean tokensEqual(Object s1, Object s2) {
        return this.isEqual(this.unlift(s1), this.unlift(s2));
    }

    public boolean isEqual(String s1, String s2) {
        return SecureEq$.MODULE$.apply(SecureEq$.MODULE$.secureEqForByteVector()).eqv(SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeUtf8(s1)).unsafeRunSync(), SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeUtf8(s2)).unsafeRunSync());
    }

    public String genTokenString() {
        byte[] bytes = new byte[this.CSRFTokenLength()];
        CachedRandom.nextBytes(bytes);
        return package$.MODULE$.encodeHexString(bytes);
    }

    public <F> Object generateSigningKey(Sync<F> F) {
        return package.all$.MODULE$.toFunctorOps(Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow(F)).generateKey((HmacAlgorithm)SigningAlgorithm), F).map((Function1 & Serializable)_$53 -> _$53.toJava());
    }

    public <F> Object buildSigningKey(byte[] array, Sync<F> F) {
        return package.all$.MODULE$.toFunctorOps(Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow(F)).importKey(ByteVector$.MODULE$.view(array), (HmacAlgorithm)SigningAlgorithm), F).map((Function1 & Serializable)_$55 -> _$55.toJava());
    }

    private final Object checkCSRFDefault$$anonfun$2$$anonfun$1$$anonfun$1(CSRF csrf$2) {
        return csrf$2.onfailureF();
    }

    private final /* synthetic */ Option extractToken$4$$anonfun$4$$anonfun$4(String fieldName$6, Map _$39) {
        return _$39.get((Object)fieldName$6).flatMap((Function1 & Serializable)_$40 -> _$40.uncons().map((Function1 & Serializable)_$41 -> (String)_$41._1()));
    }

    private final Object extractToken$7(String fieldName$2, Sync evidence$12$2, Request r$3) {
        return package.all$.MODULE$.toFunctorOps(r$3.attemptAs(UrlForm$.MODULE$.entityDecoder(evidence$12$2, UrlForm$.MODULE$.entityDecoder$default$2())).value(), (Functor)evidence$12$2).map((Function1 & Serializable)_$37 -> (Option)_$37.fold((Function1 & Serializable)_$38 -> package.all$.MODULE$.none(), (Function1 & Serializable)_$39 -> this.extractToken$4$$anonfun$4$$anonfun$4(fieldName$2, _$39 == null ? null : ((UrlForm)_$39).values())));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Object getFormToken$1(String fieldName$1, FunctionK nt$1, Sync evidence$12$1, Sync F$15, Request r$2) {
        Object object;
        Content.minusType minusType2;
        Option option = Headers$.MODULE$.get$extension(r$2.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance()));
        if (option instanceof Some && (minusType2 = (Content.minusType)((Some)option).value()) != null) {
            Content.minusType minusType3 = Content$minusType$.MODULE$.unapply(minusType2);
            MediaType mediaType = minusType3._1();
            Option option2 = minusType3._2();
            MediaType mediaType2 = MediaType$.MODULE$.application().x$minuswww$minusform$minusurlencoded();
            MediaType mediaType3 = mediaType;
            if (!(mediaType2 != null ? !mediaType2.equals(mediaType3) : mediaType3 != null)) {
                object = nt$1.apply(this.extractToken$7(fieldName$1, evidence$12$1, r$2));
                return object;
            }
        }
        object = F$15.pure((Object)package.all$.MODULE$.none());
        return object;
    }

    private final Object checkCSRFinHeaderAndForm$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(CSRF csrf$7) {
        return csrf$7.onfailureF();
    }
}

