/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.internal.FreeC;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.headers.Accept$minusRanges$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$1$;
import org.http4s.server.staticcontent.FileService$Config$;
import org.http4s.server.staticcontent.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.vault.Vault;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileService$
implements Serializable {
    private static final Logger logger;
    public static final FileService$Config$ Config;
    public static final FileService$ MODULE$;

    private FileService$() {
    }

    static {
        MODULE$ = new FileService$();
        logger = LoggerFactory.getLogger((String)"org.http4s.server.staticcontent.FileService");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileService$.class);
    }

    public <F> Kleisli<OptionT, Request<F>, Response<F>> apply(FileService.Config<F> config, Sync<F> F) {
        Kleisli kleisli;
        LazyRef lazyRef = new LazyRef();
        Try try_ = Try$.MODULE$.apply(() -> this.apply$$anonfun$1(config));
        if (try_ instanceof Success) {
            Path rootPath = (Path)((Success)try_).value();
            kleisli = TranslateUri$.MODULE$.apply(config.pathPrefix(), Kleisli$.MODULE$.apply((Function1 & Serializable)request -> {
                OptionT optionT = (OptionT)package.all$.MODULE$.catsSyntaxApplicativeError((Object)this.resolvedPath$3(F, rootPath, (Request)request, lazyRef).flatMapF((Function1 & Serializable)path -> F.delay(() -> this.apply$$anonfun$5$$anonfun$1$$anonfun$1(path)), (Monad)F).collect((PartialFunction)new Serializable(rootPath){
                    private final Path rootPath$1;
                    {
                        this.rootPath$1 = rootPath$5;
                    }

                    public final boolean isDefinedAt(Path x) {
                        Path path = x;
                        Path path2 = path;
                        return path2.startsWith(this.rootPath$1);
                    }

                    public final Object applyOrElse(Path x, Function1 function1) {
                        Path path = x;
                        Path path2 = path;
                        return path2.startsWith(this.rootPath$1) ? path2.toFile() : function1.apply((Object)x);
                    }
                }, (Functor)F).flatMap((Function1 & Serializable)f -> (OptionT)config.pathCollector().apply(f, (Object)config, request), (Monad)F).semiflatMap((Function1 & Serializable)_$6 -> config.cacheStrategy().cache(request.pathInfo(), _$6, F), (Monad)F), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
                return (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension((Object)optionT, (PartialFunction)new Serializable(F, lazyRef){
                    private final Sync F$1;
                    private final LazyRef BadTraversal$lzy1$1;
                    {
                        this.F$1 = F$12;
                        this.BadTraversal$lzy1$1 = BadTraversal$lzy1$8;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        FileService$BadTraversal$1$ fileService$BadTraversal$1$ = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(this.BadTraversal$lzy1$1);
                        Throwable throwable2 = throwable;
                        return !(fileService$BadTraversal$1$ != null ? !fileService$BadTraversal$1$.equals(throwable2) : throwable2 != null);
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Object object;
                        Throwable throwable = x;
                        FileService$BadTraversal$1$ fileService$BadTraversal$1$ = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(this.BadTraversal$lzy1$1);
                        Throwable throwable2 = throwable;
                        if (!(fileService$BadTraversal$1$ != null ? !fileService$BadTraversal$1$.equals(throwable2) : throwable2 != null)) {
                            boolean bl = OptionT$.MODULE$.some();
                            object = OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)this.F$1);
                        } else {
                            object = function1.apply((Object)x);
                        }
                        return object;
                    }
                }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
            }), OptionT$.MODULE$.catsDataMonoidKForOptionT(F));
        } else if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof NoSuchFileException) {
                Logger Logger_this = logger;
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Could not find root path from FileService config: systemPath = " + config.systemPath() + ", pathPrefix = " + config.pathPrefix() + ". All requests will return none.");
                }
                kleisli = Kleisli$.MODULE$.apply((Function1 & Serializable)_$7 -> OptionT$.MODULE$.none((Applicative)F));
            } else {
                Throwable e = throwable;
                Logger Logger_this = logger;
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Could not resolve root path from FileService config: systemPath = " + config.systemPath() + ", pathPrefix = " + config.pathPrefix() + ". All requests will fail with a 500.", e);
                }
                kleisli = Kleisli$.MODULE$.apply((Function1 & Serializable)_$8 -> {
                    boolean bl = OptionT$.MODULE$.pure();
                    return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)F);
                });
            }
        } else {
            throw new MatchError((Object)try_);
        }
        return kleisli;
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$$filesOnly(File file, FileService.Config<F> config, Request<F> req, Sync<F> F, ContextShift<F> cs) {
        return OptionT$.MODULE$.apply(F.defer(() -> this.filesOnly$$anonfun$1(file, config, req, F, cs)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            long end2 = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F> Object getPartialContentFile(File file, FileService.Config<F> config, Request<F> req, Sync<F> F, ContextShift<F> cs) {
        Option option;
        Object object;
        Range range;
        Option option2 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Range$.MODULE$.headerInstance()));
        if (option2 instanceof Some && (range = (Range)((Some)option2).value()) != null) {
            Range range2 = Range$.MODULE$.unapply(range);
            RangeUnit rangeUnit = range2._1();
            NonEmptyList nonEmptyList = range2._2();
            RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
            RangeUnit rangeUnit3 = rangeUnit;
            if (!(rangeUnit2 != null ? !rangeUnit2.equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList != null) {
                NonEmptyList nonEmptyList2 = NonEmptyList$.MODULE$.unapply(nonEmptyList);
                Range.SubRange subRange = (Range.SubRange)nonEmptyList2._1();
                List list = nonEmptyList2._2();
                if (subRange != null) {
                    Range.SubRange subRange2 = Range.SubRange$.MODULE$.unapply(subRange);
                    long l = subRange2._1();
                    Option option3 = subRange2._2();
                    long s = l;
                    Option e = option3;
                    Nil$ nil$ = scala.package$.MODULE$.Nil();
                    List list2 = list;
                    if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                        if (this.validRange(s, (Option<Object>)e, file.length())) {
                            object = F.defer(() -> this.getPartialContentFile$$anonfun$1(file, config, req, F, cs, s, e));
                            return object;
                        }
                        object = this.nope$1(file, F);
                        return object;
                    }
                }
            }
        }
        if ((option = Headers$.MODULE$.get$extension(req.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Range"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])))) instanceof Some) {
            object = this.nope$1(file, F);
            return object;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        object = F.pure((Object)None$.MODULE$);
        return object;
    }

    private final FileService$BadTraversal$1$ BadTraversal$lzyINIT1$1(LazyRef BadTraversal$lzy1$1) {
        FileService$BadTraversal$1$ fileService$BadTraversal$1$;
        LazyRef lazyRef = BadTraversal$lzy1$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$1$ = (FileService$BadTraversal$1$)(BadTraversal$lzy1$1.initialized() ? BadTraversal$lzy1$1.value() : BadTraversal$lzy1$1.initialize((Object)new FileService$BadTraversal$1$()));
        }
        return fileService$BadTraversal$1$;
    }

    public final FileService$BadTraversal$1$ org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(LazyRef BadTraversal$lzy1$2) {
        return (FileService$BadTraversal$1$)(BadTraversal$lzy1$2.initialized() ? BadTraversal$lzy1$2.value() : this.BadTraversal$lzyINIT1$1(BadTraversal$lzy1$2));
    }

    private final Path apply$$anonfun$1(FileService.Config config$1) {
        return Paths.get(config$1.systemPath(), new String[0]).toRealPath(new LinkOption[0]);
    }

    private final Path resolvedPath$2$$anonfun$2(Path rootPath$3, Vector segments$1, LazyRef BadTraversal$lzy1$5) {
        return (Path)segments$1.foldLeft((Object)rootPath$3, (Function2 & Serializable)(x$1, x$2) -> {
            String string;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                string = (String)tuple2._2();
                if ("".equals(string) || ".".equals(string) || "..".equals(string)) {
                    throw this.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(BadTraversal$lzy1$5);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            String segment = string;
            return path.resolve(segment);
        });
    }

    private final OptionT resolvedPath$3(Sync F$1, Path rootPath$1, Request request$1, LazyRef BadTraversal$lzy1$3) {
        OptionT optionT;
        Vector segments = (Vector)request$1.pathInfo().segments().map((Function1 & Serializable)_$5 -> _$5.decoded(_$5.decoded$default$1(), true, _$5.decoded$default$3()));
        if (request$1.pathInfo().isEmpty()) {
            boolean bl = OptionT$.MODULE$.some();
            optionT = OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)rootPath$1, (Applicative)F$1);
        } else {
            optionT = OptionT$.MODULE$.liftF(F$1.catchNonFatal(() -> this.resolvedPath$2$$anonfun$2(rootPath$1, segments, BadTraversal$lzy1$3), (.less.colon.less)$less$colon$less$.MODULE$.refl()), (Functor)F$1);
        }
        return optionT;
    }

    private final Option apply$$anonfun$5$$anonfun$1$$anonfun$1(Path path$1) {
        return Files.exists(path$1, LinkOption.NOFOLLOW_LINKS) ? Some$.MODULE$.apply((Object)path$1.toRealPath(LinkOption.NOFOLLOW_LINKS)) : None$.MODULE$;
    }

    private final OptionT filesOnly$$anonfun$3$$anonfun$2(File file$2, FileService.Config config$6, Request req$2, Sync F$9, ContextShift cs$2) {
        return StaticFile$.MODULE$.fromFile(file$2, config$6.bufferSize(), config$6.blocker(), (Option)Some$.MODULE$.apply((Object)req$2), StaticFile$.MODULE$.calcETag(F$9), F$9, cs$2).map((Function1 & Serializable)_$10 -> (Response)_$10.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance())})), (Functor)F$9);
    }

    private final Object filesOnly$$anonfun$1(File file$1, FileService.Config config$5, Request req$1, Sync F$8, ContextShift cs$1) {
        return file$1.isDirectory() ? StaticFile$.MODULE$.fromFile(new File(file$1, "index.html"), config$5.blocker(), (Option)Some$.MODULE$.apply((Object)req$1), F$8, cs$1).value() : (!file$1.isFile() ? F$8.pure((Object)None$.MODULE$) : OptionT$.MODULE$.apply(this.getPartialContentFile(file$1, config$5, req$1, F$8, cs$1)).orElse(() -> this.filesOnly$$anonfun$3$$anonfun$2(file$1, config$5, req$1, F$8, cs$1), (Monad)F$8).value());
    }

    private final long nope$2$$anonfun$1(File file$4) {
        return file$4.length();
    }

    private final /* synthetic */ Option nope$3$$anonfun$2(long size) {
        Status status = Status$.MODULE$.RangeNotSatisfiable();
        List list = Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(0L, size - 1L), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)size))), Content$minusRange$.MODULE$.headerInstance())}));
        HttpVersion httpVersion = Response$.MODULE$.apply$default$2();
        FreeC freeC = Response$.MODULE$.apply$default$4();
        Vault vault = Response$.MODULE$.apply$default$5();
        return Some$.MODULE$.apply((Object)Response$.MODULE$.apply(status, httpVersion, list, freeC, vault));
    }

    private final Object nope$1(File file$3, Sync F$10) {
        return package.all$.MODULE$.toFunctorOps(F$10.delay(() -> this.nope$2$$anonfun$1(file$3)), (Functor)F$10).map((Function1 & Serializable)size -> this.nope$3$$anonfun$2(BoxesRunTime.unboxToLong((Object)size)));
    }

    private final long $anonfun$2(long size$1) {
        return size$1 - 1L;
    }

    private final Object getPartialContentFile$$anonfun$1(File file$5, FileService.Config config$7, Request req$3, Sync F$11, ContextShift cs$3, long s$1, Option e$1) {
        long size = file$5.length();
        long start = s$1 >= 0L ? s$1 : scala.math.package$.MODULE$.max(0L, size + s$1);
        long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e$1.getOrElse(() -> this.$anonfun$2(size))));
        return StaticFile$.MODULE$.fromFile(file$5, start, end + 1L, config$7.bufferSize(), config$7.blocker(), (Option)Some$.MODULE$.apply((Object)req$3), StaticFile$.MODULE$.calcETag(F$11), F$11, cs$3).map((Function1 & Serializable)resp -> {
            List hs = Headers$.MODULE$.put$extension(resp.headers(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)size))), Content$minusRange$.MODULE$.headerInstance())}));
            Status status = Status$.MODULE$.PartialContent();
            HttpVersion httpVersion = resp.copy$default$2();
            FreeC freeC = resp.copy$default$4();
            Vault vault = resp.copy$default$5();
            return resp.copy(status, httpVersion, hs, freeC, vault);
        }, (Functor)F$11).value();
    }
}

