/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.effect.kernel.Sync;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest$;
import org.http4s.Challenge;
import org.http4s.Challenge$;
import org.http4s.ContextRequest;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.crypto.Hash;
import org.http4s.crypto.Hash$;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$OK$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.package$;
import org.typelevel.ci.CIString;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DigestAuth$
implements Serializable {
    private static final DigestAuth$OK$ OK;
    private static final DigestAuth$StaleNonce$ StaleNonce;
    private static final DigestAuth$BadNC$ BadNC;
    private static final DigestAuth$WrongResponse$ WrongResponse;
    private static final DigestAuth$BadParameters$ BadParameters;
    private static final DigestAuth$UserUnknown$ UserUnknown;
    private static final DigestAuth$NoCredentials$ NoCredentials;
    private static final DigestAuth$NoAuthorizationHeader$ NoAuthorizationHeader;
    public static final DigestAuth$ MODULE$;

    private DigestAuth$() {
    }

    static {
        MODULE$ = new DigestAuth$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DigestAuth$.class);
    }

    public <F, A> Function1<Kleisli<OptionT, ContextRequest<F, A>, Response<F>>, Kleisli<OptionT, Request<F>, Response<F>>> apply(String realm, Function1<String, Object> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$1) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$1);
        return (Function1 & Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$1);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public int apply$default$5() {
        return 160;
    }

    public <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challenge(String realm, Function1<String, Object> store, NonceKeeper nonceKeeper, Sync<F> F) {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)req -> package.all$.MODULE$.toFlatMapOps(this.checkAuth(realm, store, nonceKeeper, (Request)req, (Hash)Hash$.MODULE$.forApplicativeThrow((ApplicativeError)F), (Monad)F), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            DigestAuth.AuthReply authReply = x$1;
            if (authReply instanceof DigestAuth.OK) {
                Object a;
                DigestAuth.OK oK = DigestAuth$OK$.MODULE$.unapply((DigestAuth.OK)authReply);
                Object authInfo = a = oK._1();
                object = F.pure((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)AuthedRequest$.MODULE$.apply(authInfo, req)));
            } else {
                object = DigestAuth$StaleNonce$.MODULE$.equals(authReply) ? package.all$.MODULE$.toFunctorOps(this.getChallengeParams(nonceKeeper, true, F), (Functor)F).map((Function1 & Serializable)params -> this.paramsToChallenge$1(realm, (Map)params)) : package.all$.MODULE$.toFunctorOps(this.getChallengeParams(nonceKeeper, false, F), (Functor)F).map((Function1 & Serializable)params -> this.paramsToChallenge$1(realm, (Map)params));
            }
            return object;
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F, A> Object checkAuth(String realm, Function1<String, Object> store, NonceKeeper nonceKeeper, Request<F> req, Hash<F> evidence$2, Monad<F> F) {
        Authorization authorization;
        Credentials credentials;
        Object object;
        Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance()));
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            object = F.pure((Object)DigestAuth$NoAuthorizationHeader$.MODULE$);
            return object;
        }
        Authorization authorization2 = (Authorization)((Some)option).value();
        if (authorization2 != null && (credentials = (authorization = Authorization$.MODULE$.unapply(authorization2))._1()) instanceof Credentials.AuthParams) {
            Credentials.AuthParams authParams = Credentials.AuthParams$.MODULE$.unapply((Credentials.AuthParams)credentials);
            CIString cIString = authParams._1();
            NonEmptyList nonEmptyList = authParams._2();
            CIString cIString2 = AuthScheme$.MODULE$.Digest();
            CIString cIString3 = cIString;
            if (!(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null)) {
                NonEmptyList params = nonEmptyList;
                object = this.checkAuthParams(realm, store, nonceKeeper, req, (NonEmptyList<Tuple2<String, String>>)params, evidence$2, F);
                return object;
            }
        }
        object = F.pure((Object)DigestAuth$NoCredentials$.MODULE$);
        return object;
    }

    private <F> Object getChallengeParams(NonceKeeper nonceKeeper, boolean staleNonce, Sync<F> F) {
        return F.delay(() -> this.getChallengeParams$$anonfun$1(nonceKeeper, staleNonce));
    }

    private <F, A> Object checkAuthParams(String realm, Function1<String, Object> store, NonceKeeper nonceKeeper, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Hash<F> evidence$3, Monad<F> F) {
        Object object;
        String nc;
        Map params = paramsNel.toList().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (!((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf((Set)params.keySet())) {
            return F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        String uri = req.uri().toString();
        Option option = params.get((Object)"realm");
        Some some = Some$.MODULE$.apply((Object)realm);
        if (option == null ? some != null : !option.equals(some)) {
            return F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply((Object)"nonce");
        NonceKeeper.Reply reply = nonceKeeper.receiveNonce(nonce, Integer.parseInt(nc = (String)params.apply((Object)"nc"), 16));
        if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
            object = F.pure((Object)DigestAuth$StaleNonce$.MODULE$);
        } else if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
            object = F.pure((Object)DigestAuth$BadNC$.MODULE$);
        } else if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
            object = package.all$.MODULE$.toFlatMapOps(store.apply(params.apply((Object)"username")), F).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Object object;
                Option option = x$1;
                if (None$.MODULE$.equals(option)) {
                    object = F.pure((Object)DigestAuth$UserUnknown$.MODULE$);
                } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Object authInfo = tuple2._1();
                    String password = (String)tuple2._2();
                    object = package.all$.MODULE$.toFunctorOps(DigestUtil$.MODULE$.computeResponse(method, (String)params.apply((Object)"username"), realm, password, uri, nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"), F, evidence$3), (Functor)F).map((Function1 & Serializable)resp -> {
                        String string = resp;
                        Object object = params.apply((Object)"response");
                        return !(string != null ? !string.equals(object) : object != null) ? DigestAuth$OK$.MODULE$.apply(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return object;
            });
        } else {
            throw new MatchError((Object)reply);
        }
        return object;
    }

    private final Either paramsToChallenge$1(String realm$2, Map params) {
        return EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)Challenge$.MODULE$.apply("Digest", realm$2, params));
    }

    private final Map getChallengeParams$$anonfun$1(NonceKeeper nonceKeeper$3, boolean staleNonce$1) {
        Map map;
        String nonce = nonceKeeper$3.newNonce();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"qop");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"auth");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"nonce");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)nonce);
        Map m = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (staleNonce$1) {
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stale");
            map = (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"TRUE"));
        } else {
            map = m;
        }
        return map;
    }
}

