/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.Semigroupal$;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Headers$;
import org.http4s.Http$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.headers.Access;
import org.http4s.headers.Access$minusControl$minusAllow$minusHeaders$;
import org.http4s.headers.Access$minusControl$minusExpose$minusHeaders$;
import org.http4s.headers.Access$minusControl$minusRequest$minusMethod$;
import org.http4s.headers.Origin;
import org.http4s.headers.Origin$;
import org.http4s.server.middleware.CORSPolicy;
import org.http4s.server.middleware.CORSPolicy$;
import org.http4s.server.middleware.CORSPolicy$AllowCredentials$Allow$;
import org.http4s.server.middleware.CORSPolicy$AllowCredentials$Deny$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$All$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$In$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$Reflect$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$Static$;
import org.http4s.server.middleware.CORSPolicy$AllowMethods$All$;
import org.http4s.server.middleware.CORSPolicy$AllowMethods$In$;
import org.http4s.server.middleware.CORSPolicy$AllowOrigin$All$;
import org.http4s.server.middleware.CORSPolicy$AllowOrigin$Match$;
import org.http4s.server.middleware.CORSPolicy$CommonHeaders$;
import org.http4s.server.middleware.CORSPolicy$ExposeHeaders$All$;
import org.http4s.server.middleware.CORSPolicy$ExposeHeaders$In$;
import org.http4s.server.middleware.CORSPolicy$ExposeHeaders$None$;
import org.http4s.server.middleware.CORSPolicy$MaxAge$Default$;
import org.http4s.server.middleware.CORSPolicy$MaxAge$DisableCaching$;
import org.http4s.server.middleware.CORSPolicy$MaxAge$Some$;
import org.http4s.syntax.package;
import org.slf4j.Logger;
import org.typelevel.ci.CIString;
import org.typelevel.ci.CIString$;
import org.typelevel.ci.package$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure3;

public class CORSPolicy {
    private final AllowOrigin allowOrigin;
    private final AllowCredentials allowCredentials;
    private final ExposeHeaders exposeHeaders;
    private final AllowMethods allowMethods;
    private final AllowHeaders allowHeaders;
    private final MaxAge maxAge;

    public static Set wildcardHeadersSet() {
        return CORSPolicy$.MODULE$.wildcardHeadersSet();
    }

    public static Method wildcardMethod() {
        return CORSPolicy$.MODULE$.wildcardMethod();
    }

    public CORSPolicy(AllowOrigin allowOrigin, AllowCredentials allowCredentials, ExposeHeaders exposeHeaders, AllowMethods allowMethods, AllowHeaders allowHeaders, MaxAge maxAge) {
        this.allowOrigin = allowOrigin;
        this.allowCredentials = allowCredentials;
        this.exposeHeaders = exposeHeaders;
        this.allowMethods = allowMethods;
        this.allowHeaders = allowHeaders;
        this.maxAge = maxAge;
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, Applicative<F> evidence$3) {
        return this.applicatively(http, evidence$3);
    }

    private <F, G> Kleisli<F, Request<G>, Response<G>> applicatively(Kleisli<F, Request<G>, Response<G>> http, Applicative<F> evidence$4) {
        return this.impl(http, (Kleisli<F, Request<G>, Response<G>>)Http$.MODULE$.pure(Response$.MODULE$.apply(Status$.MODULE$.Ok(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), evidence$4), (Functor<F>)evidence$4);
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, Functor<F> evidence$5) {
        Logger Logger_this = CORSPolicy$.org$http4s$server$middleware$CORSPolicy$$$logger;
        if (Logger_this.isWarnEnabled()) {
            Logger_this.warn("This CORSPolicy does not return 200 on preflight requests. It's kept for binary compatibility, but it's buggy. If you see this, upgrade to v0.23.3 or greater.");
        }
        return this.impl(http, http, evidence$5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <F, G> Kleisli<F, Request<G>, Response<G>> impl(Kleisli<F, Request<G>, Response<G>> http, Kleisli<F, Request<G>, Response<G>> preflightResponder, Functor<F> evidence$6) {
        Kleisli<F, Request<G>, Response<G>> kleisli;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        None$ none$6;
        AllowCredentials allowCredentials = this.allowCredentials;
        if (CORSPolicy$AllowCredentials$Allow$.MODULE$.equals(allowCredentials)) {
            none$6 = CORSPolicy$CommonHeaders$.MODULE$.someAllowCredentials();
        } else {
            if (!CORSPolicy$AllowCredentials$Deny$.MODULE$.equals(allowCredentials)) throw new MatchError((Object)allowCredentials);
            none$6 = None$.MODULE$;
        }
        None$ allowCredentialsHeader = none$6;
        ExposeHeaders exposeHeaders = this.exposeHeaders;
        if (CORSPolicy$ExposeHeaders$All$.MODULE$.equals(exposeHeaders)) {
            none$5 = CORSPolicy$CommonHeaders$.MODULE$.someExposeHeadersWildcard();
        } else if (exposeHeaders instanceof ExposeHeaders.In) {
            Set<CIString> set;
            ExposeHeaders.In in = CORSPolicy$ExposeHeaders$In$.MODULE$.unapply((ExposeHeaders.In)exposeHeaders);
            Set<CIString> names = set = in._1();
            Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(Header$.MODULE$.apply(Access$minusControl$minusExpose$minusHeaders$.MODULE$.headerInstance()).name(), names.mkString(", ")));
            none$5 = OptionIdOps$.MODULE$.some$extension((Object)raw);
        } else {
            if (!CORSPolicy$ExposeHeaders$None$.MODULE$.equals(exposeHeaders)) throw new MatchError((Object)exposeHeaders);
            none$5 = None$.MODULE$;
        }
        None$ exposeHeadersHeader = none$5;
        AllowMethods allowMethods = this.allowMethods;
        if (CORSPolicy$AllowMethods$All$.MODULE$.equals(allowMethods)) {
            none$4 = None$.MODULE$;
        } else {
            Set<Method> set;
            if (!(allowMethods instanceof AllowMethods.In)) throw new MatchError((Object)allowMethods);
            AllowMethods.In in = CORSPolicy$AllowMethods$In$.MODULE$.unapply((AllowMethods.In)allowMethods);
            Set<Method> methods = set = in._1();
            Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Access-Control-Allow-Methods"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), ((IterableOnceOps)methods.map((Function1 & Serializable)_$19 -> _$19.renderString())).mkString(", ")));
            none$4 = OptionIdOps$.MODULE$.some$extension((Object)raw);
        }
        None$ someAllowMethodsSpecificHeader = none$4;
        MaxAge maxAge = this.maxAge;
        if (maxAge instanceof MaxAge.Some) {
            long l;
            MaxAge.Some some = CORSPolicy$MaxAge$Some$.MODULE$.unapply((MaxAge.Some)maxAge);
            long deltaSeconds = l = some._1();
            Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Access-Control-Max-Age"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), BoxesRunTime.boxToLong((long)deltaSeconds).toString()));
            none$3 = OptionIdOps$.MODULE$.some$extension((Object)raw);
        } else if (CORSPolicy$MaxAge$Default$.MODULE$.equals(maxAge)) {
            none$3 = None$.MODULE$;
        } else {
            if (!CORSPolicy$MaxAge$DisableCaching$.MODULE$.equals(maxAge)) throw new MatchError((Object)maxAge);
            Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Access-Control-Max-Age"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), "-1"));
            none$3 = OptionIdOps$.MODULE$.some$extension((Object)raw);
        }
        None$ maxAgeHeader = none$3;
        AllowOrigin allowOrigin = this.allowOrigin;
        if (allowOrigin instanceof AllowOrigin.Match) {
            AllowOrigin.Match match = CORSPolicy$AllowOrigin$Match$.MODULE$.unapply((AllowOrigin.Match)allowOrigin);
            Function1<Origin, Object> function1 = match._1();
            Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), Header$.MODULE$.apply(Origin$.MODULE$.headerInstance()).name().toString()));
            none$2 = OptionIdOps$.MODULE$.some$extension((Object)raw);
        } else {
            none$2 = None$.MODULE$;
        }
        None$ varyHeaderNonOptions = none$2;
        List list = (List)((IterableOps)this.origin$1().$plus$plus((IterableOnce)this.methods$1())).$plus$plus((IterableOnce)this.headers$1());
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            none$ = None$.MODULE$;
        } else {
            List nonEmpty = list;
            Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), nonEmpty.map((Function1 & Serializable)_$20 -> _$20.toString()).mkString(", ")));
            none$ = OptionIdOps$.MODULE$.some$extension((Object)raw);
        }
        None$ varyHeaderOptions = none$;
        AllowOrigin allowOrigin2 = this.allowOrigin;
        CORSPolicy$AllowOrigin$All$ cORSPolicy$AllowOrigin$All$ = CORSPolicy$AllowOrigin$All$.MODULE$;
        if (!(allowOrigin2 != null ? !allowOrigin2.equals(cORSPolicy$AllowOrigin$All$) : cORSPolicy$AllowOrigin$All$ != null)) {
            AllowCredentials allowCredentials2 = this.allowCredentials;
            CORSPolicy$AllowCredentials$Allow$ cORSPolicy$AllowCredentials$Allow$ = CORSPolicy$AllowCredentials$Allow$.MODULE$;
            if (!(allowCredentials2 != null ? !allowCredentials2.equals(cORSPolicy$AllowCredentials$Allow$) : cORSPolicy$AllowCredentials$Allow$ != null)) {
                Logger Logger_this = CORSPolicy$.org$http4s$server$middleware$CORSPolicy$$$logger;
                if (Logger_this.isWarnEnabled()) {
                    Logger_this.warn("CORS disabled due to insecure config prohibited by spec. Call withCredentials(false) to avoid sharing credential-tainted responses with arbitrary origins, or call withAllowOrigin* method to be explicit who you trust with credential-tainted responses.");
                }
                kleisli = http;
                return kleisli;
            }
        }
        kleisli = Kleisli$.MODULE$.apply(arg_0 -> this.impl$$anonfun$1(http, preflightResponder, evidence$6, (Option)allowCredentialsHeader, (Option)exposeHeadersHeader, (Option)someAllowMethodsSpecificHeader, (Option)maxAgeHeader, (Option)varyHeaderNonOptions, (Option)varyHeaderOptions, arg_0));
        return kleisli;
    }

    public <F> Kleisli<OptionT, Request<F>, Response<F>> httpRoutes(Kleisli<OptionT, Request<F>, Response<F>> httpRoutes, Monad<F> evidence$7) {
        return this.applicatively((Kleisli)httpRoutes, (Applicative<F>)OptionT$.MODULE$.catsDataMonadErrorMonadForOptionT(evidence$7));
    }

    public <F> Kleisli<F, Request<F>, Response<F>> httpApp(Kleisli<F, Request<F>, Response<F>> httpApp, Applicative<F> evidence$8) {
        return this.applicatively(httpApp, evidence$8);
    }

    private CORSPolicy copy(AllowOrigin allowOrigin, AllowCredentials allowCredentials, ExposeHeaders exposeHeaders, AllowMethods allowMethods, AllowHeaders allowHeaders, MaxAge maxAge) {
        return new CORSPolicy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, allowHeaders, maxAge);
    }

    private AllowOrigin copy$default$1() {
        return this.allowOrigin;
    }

    private AllowCredentials copy$default$2() {
        return this.allowCredentials;
    }

    private ExposeHeaders copy$default$3() {
        return this.exposeHeaders;
    }

    private AllowMethods copy$default$4() {
        return this.allowMethods;
    }

    private AllowHeaders copy$default$5() {
        return this.allowHeaders;
    }

    private MaxAge copy$default$6() {
        return this.maxAge;
    }

    public CORSPolicy withAllowOriginAll() {
        return this.copy(CORSPolicy$AllowOrigin$All$.MODULE$, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public CORSPolicy withAllowOriginHeader(Function1<Origin, Object> p) {
        return this.copy(CORSPolicy$AllowOrigin$Match$.MODULE$.apply(p), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public CORSPolicy withAllowOriginHost(Function1<Origin.Host, Object> p) {
        return this.withAllowOriginHeader((Function1<Origin, Object>)(Function1 & Serializable)_$29 -> {
            boolean bl;
            Origin.HostList hostList;
            NonEmptyList nonEmptyList;
            Origin origin = _$29;
            if (origin instanceof Origin.HostList && (nonEmptyList = (hostList = Origin.HostList$.MODULE$.unapply((Origin.HostList)origin))._1()) != null) {
                NonEmptyList nonEmptyList2 = NonEmptyList$.MODULE$.unapply(nonEmptyList);
                Origin.Host host = (Origin.Host)nonEmptyList2._1();
                List list = nonEmptyList2._2();
                Origin.Host h = host;
                bl = BoxesRunTime.unboxToBoolean((Object)p.apply((Object)h));
            } else if (Origin.Null$.MODULE$.equals(origin)) {
                bl = false;
            } else {
                throw new MatchError((Object)origin);
            }
            return bl;
        });
    }

    public CORSPolicy withAllowOriginHostCi(Function1<CIString, Object> p) {
        return this.withAllowOriginHost((Function1<Origin.Host, Object>)p.compose((Function1 & Serializable)host -> CIString$.MODULE$.apply(host.renderString())));
    }

    public CORSPolicy withAllowCredentials(boolean b) {
        Mirror.Singleton singleton = b ? CORSPolicy$AllowCredentials$Allow$.MODULE$ : CORSPolicy$AllowCredentials$Deny$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        AllowHeaders allowHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, (AllowCredentials)singleton, exposeHeaders, allowMethods, allowHeaders, maxAge);
    }

    public CORSPolicy withExposeHeadersAll() {
        CORSPolicy$ExposeHeaders$All$ cORSPolicy$ExposeHeaders$All$ = CORSPolicy$ExposeHeaders$All$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        AllowMethods allowMethods = this.copy$default$4();
        AllowHeaders allowHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, cORSPolicy$ExposeHeaders$All$, allowMethods, allowHeaders, maxAge);
    }

    public CORSPolicy withExposeHeadersIn(Set<CIString> names) {
        ExposeHeaders.In in = CORSPolicy$ExposeHeaders$In$.MODULE$.apply(names);
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        AllowMethods allowMethods = this.copy$default$4();
        AllowHeaders allowHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, in, allowMethods, allowHeaders, maxAge);
    }

    public CORSPolicy withExposeHeadersNone() {
        CORSPolicy$ExposeHeaders$None$ cORSPolicy$ExposeHeaders$None$ = CORSPolicy$ExposeHeaders$None$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        AllowMethods allowMethods = this.copy$default$4();
        AllowHeaders allowHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, cORSPolicy$ExposeHeaders$None$, allowMethods, allowHeaders, maxAge);
    }

    public CORSPolicy withAllowMethodsAll() {
        CORSPolicy$AllowMethods$All$ cORSPolicy$AllowMethods$All$ = CORSPolicy$AllowMethods$All$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowHeaders allowHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, cORSPolicy$AllowMethods$All$, allowHeaders, maxAge);
    }

    public CORSPolicy withAllowMethodsIn(Set<Method> methods) {
        AllowMethods.In in = CORSPolicy$AllowMethods$In$.MODULE$.apply(methods);
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowHeaders allowHeaders = this.copy$default$5();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, in, allowHeaders, maxAge);
    }

    public CORSPolicy withAllowHeadersAll() {
        CORSPolicy$AllowHeaders$All$ cORSPolicy$AllowHeaders$All$ = CORSPolicy$AllowHeaders$All$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, cORSPolicy$AllowHeaders$All$, maxAge);
    }

    public CORSPolicy withAllowHeadersIn(Set<CIString> headers) {
        AllowHeaders.In in = CORSPolicy$AllowHeaders$In$.MODULE$.apply(headers);
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, in, maxAge);
    }

    public CORSPolicy withAllowHeadersReflect() {
        CORSPolicy$AllowHeaders$Reflect$ cORSPolicy$AllowHeaders$Reflect$ = CORSPolicy$AllowHeaders$Reflect$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, cORSPolicy$AllowHeaders$Reflect$, maxAge);
    }

    public CORSPolicy withAllowHeadersStatic(Set<CIString> headers) {
        AllowHeaders.Static static_ = CORSPolicy$AllowHeaders$Static$.MODULE$.apply(headers);
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        MaxAge maxAge = this.copy$default$6();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, static_, maxAge);
    }

    public CORSPolicy withMaxAge(FiniteDuration duration) {
        MaxAge.Some some = duration.$greater$eq((Object)Duration$.MODULE$.Zero()) ? CORSPolicy$MaxAge$Some$.MODULE$.apply(duration.toSeconds()) : CORSPolicy$MaxAge$Some$.MODULE$.apply(0L);
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        AllowHeaders allowHeaders = this.copy$default$5();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, allowHeaders, some);
    }

    public CORSPolicy withMaxAgeDefault() {
        CORSPolicy$MaxAge$Default$ cORSPolicy$MaxAge$Default$ = CORSPolicy$MaxAge$Default$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        AllowHeaders allowHeaders = this.copy$default$5();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, allowHeaders, cORSPolicy$MaxAge$Default$);
    }

    public CORSPolicy withMaxAgeDisableCaching() {
        CORSPolicy$MaxAge$DisableCaching$ cORSPolicy$MaxAge$DisableCaching$ = CORSPolicy$MaxAge$DisableCaching$.MODULE$;
        AllowOrigin allowOrigin = this.copy$default$1();
        AllowCredentials allowCredentials = this.copy$default$2();
        ExposeHeaders exposeHeaders = this.copy$default$3();
        AllowMethods allowMethods = this.copy$default$4();
        AllowHeaders allowHeaders = this.copy$default$5();
        return this.copy(allowOrigin, allowCredentials, exposeHeaders, allowMethods, allowHeaders, cORSPolicy$MaxAge$DisableCaching$);
    }

    private final List origin$1() {
        Nil$ nil$;
        AllowOrigin allowOrigin = this.allowOrigin;
        if (CORSPolicy$AllowOrigin$All$.MODULE$.equals(allowOrigin)) {
            nil$ = scala.package$.MODULE$.Nil();
        } else if (allowOrigin instanceof AllowOrigin.Match) {
            AllowOrigin.Match match = CORSPolicy$AllowOrigin$Match$.MODULE$.unapply((AllowOrigin.Match)allowOrigin);
            Function1<Origin, Object> function1 = match._1();
            nil$ = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[]{Header$.MODULE$.apply(Origin$.MODULE$.headerInstance()).name()}));
        } else {
            throw new MatchError((Object)allowOrigin);
        }
        return nil$;
    }

    private final List methods$1() {
        Nil$ nil$;
        AllowMethods allowMethods = this.allowMethods;
        if (CORSPolicy$AllowMethods$All$.MODULE$.equals(allowMethods)) {
            nil$ = scala.package$.MODULE$.Nil();
        } else if (allowMethods instanceof AllowMethods.In) {
            AllowMethods.In in = CORSPolicy$AllowMethods$In$.MODULE$.unapply((AllowMethods.In)allowMethods);
            Set<Method> set = in._1();
            nil$ = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[]{Header$.MODULE$.apply(Access$minusControl$minusRequest$minusMethod$.MODULE$.headerInstance()).name()}));
        } else {
            throw new MatchError((Object)allowMethods);
        }
        return nil$;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List headers$1() {
        Nil$ nil$;
        AllowHeaders allowHeaders;
        block6: {
            block5: {
                allowHeaders = this.allowHeaders;
                if (CORSPolicy$AllowHeaders$All$.MODULE$.equals(allowHeaders)) break block5;
                if (!(allowHeaders instanceof AllowHeaders.Static)) break block6;
                AllowHeaders.Static static_ = CORSPolicy$AllowHeaders$Static$.MODULE$.unapply((AllowHeaders.Static)allowHeaders);
                Set<CIString> set = static_._1();
            }
            nil$ = scala.package$.MODULE$.Nil();
            return nil$;
        }
        if (allowHeaders instanceof AllowHeaders.In) {
            AllowHeaders.In in = CORSPolicy$AllowHeaders$In$.MODULE$.unapply((AllowHeaders.In)allowHeaders);
            Set<CIString> set = in._1();
        } else if (!CORSPolicy$AllowHeaders$Reflect$.MODULE$.equals(allowHeaders)) throw new MatchError((Object)allowHeaders);
        nil$ = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[]{package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Access-Control-Request-Headers"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))}));
        return nil$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object dispatch$1(Kleisli http$4, Kleisli preflightResponder$2, Functor evidence$6$4, Option allowCredentialsHeader$5, Option exposeHeadersHeader$3, Option someAllowMethodsSpecificHeader$3, Option maxAgeHeader$3, Option varyHeaderNonOptions$8, Option varyHeaderOptions$8, Request req) {
        Object object;
        Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Origin$.MODULE$.headerInstance()));
        if (option instanceof Some) {
            Origin origin = (Origin)((Some)option).value();
            Method method = req.method();
            Method method2 = Method$.MODULE$.OPTIONS();
            Method method3 = method;
            if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                Option option2 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Access$minusControl$minusRequest$minusMethod$.MODULE$.headerInstance()));
                if (option2 instanceof Some) {
                    Set set;
                    Access.minusControl.minusRequest.minusMethod acrm = (Access.minusControl.minusRequest.minusMethod)((Some)option2).value();
                    Option option3 = Headers$.MODULE$.get$extension(req.headers(), package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Access-Control-Request-Headers"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
                    if (option3 instanceof Some) {
                        NonEmptyList acrHeaders = (NonEmptyList)((Some)option3).value();
                        set = (Set)package.all$.MODULE$.toFoldableOps((Object)acrHeaders.map((Function1 & Serializable)_$21 -> {
                            Object object = Predef$.MODULE$.refArrayOps((Object[])_$21.value().split("\\s*,\\s*"));
                            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$22 -> CIString$.MODULE$.apply(_$22), ClassTag$.MODULE$.apply(CIString.class))).toSet();
                        }), (Foldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()).fold((Monoid)Semigroup$.MODULE$.catsKernelBoundedSemilatticeForSet());
                    } else {
                        if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                        set = Predef$.MODULE$.Set().empty();
                    }
                    Set headers = set;
                    object = this.preflight$1(preflightResponder$2, evidence$6$4, allowCredentialsHeader$5, someAllowMethodsSpecificHeader$3, maxAgeHeader$3, varyHeaderNonOptions$8, varyHeaderOptions$8, req, origin, acrm.method(), headers);
                    return object;
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                    object = this.nonPreflight$1(http$4, evidence$6$4, allowCredentialsHeader$5, exposeHeadersHeader$3, varyHeaderNonOptions$8, varyHeaderOptions$8, req, origin);
                }
                return object;
            } else {
                object = this.nonPreflight$1(http$4, evidence$6$4, allowCredentialsHeader$5, exposeHeadersHeader$3, varyHeaderNonOptions$8, varyHeaderOptions$8, req, origin);
            }
            return object;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            object = CORSPolicy.nonCors$1(http$4, evidence$6$4, varyHeaderNonOptions$8, varyHeaderOptions$8, req);
        }
        return object;
    }

    private final Object nonPreflight$1(Kleisli http$2, Functor evidence$6$1, Option allowCredentialsHeader$2, Option exposeHeadersHeader$2, Option varyHeaderNonOptions$1, Option varyHeaderOptions$1, Request req, Origin origin) {
        Builder buff = scala.package$.MODULE$.List().newBuilder();
        this.allowOriginHeader$1(origin).map((Function1 & Serializable)allowOrigin -> {
            buff.$plus$eq(allowOrigin);
            allowCredentialsHeader$2.foreach((Function1 & Serializable)elem -> (Builder)buff.$plus$eq(elem));
            exposeHeadersHeader$2.foreach((Function1 & Serializable)elem -> (Builder)buff.$plus$eq(elem));
            return buff;
        });
        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(http$2.apply((Object)req), evidence$6$1).map((Function1 & Serializable)_$23 -> (Response)_$23.putHeaders((Seq)((List)buff.result()).map((Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h)))), evidence$6$1).map((Function1 & Serializable)resp -> CORSPolicy.varyHeader$1(varyHeaderNonOptions$1, varyHeaderOptions$1, req.method(), resp));
    }

    private final Object preflight$1(Kleisli preflightResponder$1, Functor evidence$6$2, Option allowCredentialsHeader$4, Option someAllowMethodsSpecificHeader$1, Option maxAgeHeader$2, Option varyHeaderNonOptions$3, Option varyHeaderOptions$3, Request req, Origin origin, Method method, Set headers) {
        Builder buff = scala.package$.MODULE$.List().newBuilder();
        package.all$.MODULE$.catsSyntaxTuple3Semigroupal(Tuple3$.MODULE$.apply((Object)this.allowOriginHeader$1(origin), (Object)this.allowMethodsHeader$1(someAllowMethodsSpecificHeader$1, method), (Object)this.allowHeadersHeader$1(headers))).mapN((Function3)(JProcedure3 & Serializable)(x$1, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Header.Raw allowOrigin = (Header.Raw)tuple3._1();
            Header.Raw allowMethods = (Header.Raw)tuple3._2();
            Header.Raw allowHeaders = (Header.Raw)tuple3._3();
            buff.$plus$eq((Object)allowOrigin);
            allowCredentialsHeader$4.foreach((Function1 & Serializable)elem -> (Builder)buff.$plus$eq(elem));
            buff.$plus$eq((Object)allowMethods);
            buff.$plus$eq((Object)allowHeaders);
            maxAgeHeader$2.foreach((Function1 & Serializable)elem -> (Builder)buff.$plus$eq(elem));
        }, (Functor)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption());
        Method method2 = Method$.MODULE$.OPTIONS();
        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(preflightResponder$1.apply((Object)req), evidence$6$2).map((Function1 & Serializable)_$24 -> (Response)_$24.putHeaders((Seq)((List)buff.result()).map((Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h)))), evidence$6$2).map((Function1 & Serializable)resp -> CORSPolicy.varyHeader$1(varyHeaderNonOptions$3, varyHeaderOptions$3, method2, resp));
    }

    private static final Object nonCors$1(Kleisli http$3, Functor evidence$6$3, Option varyHeaderNonOptions$5, Option varyHeaderOptions$5, Request req) {
        return package.all$.MODULE$.toFunctorOps(http$3.apply((Object)req), evidence$6$3).map((Function1 & Serializable)resp -> CORSPolicy.varyHeader$1(varyHeaderNonOptions$5, varyHeaderOptions$5, req.method(), resp));
    }

    private final Option allowOriginHeader$1(Origin origin) {
        None$ none$;
        AllowOrigin allowOrigin = this.allowOrigin;
        if (CORSPolicy$AllowOrigin$All$.MODULE$.equals(allowOrigin)) {
            none$ = CORSPolicy$CommonHeaders$.MODULE$.someAllowOriginWildcard();
        } else if (allowOrigin instanceof AllowOrigin.Match) {
            AllowOrigin.Match match = CORSPolicy$AllowOrigin$Match$.MODULE$.unapply((AllowOrigin.Match)allowOrigin);
            Function1<Origin, Object> function1 = match._1();
            Function1<Origin, Object> p = function1;
            if (BoxesRunTime.unboxToBoolean((Object)p.apply((Object)origin))) {
                Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Access-Control-Allow-Origin"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), package.header$.MODULE$.http4sHeaderSyntax((Object)origin, Origin$.MODULE$.headerInstance()).value()));
                none$ = OptionIdOps$.MODULE$.some$extension((Object)raw);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            throw new MatchError((Object)allowOrigin);
        }
        return none$;
    }

    private final Option allowMethodsHeader$1(Option someAllowMethodsSpecificHeader$2, Method method) {
        Object object;
        AllowMethods allowMethods = this.allowMethods;
        if (CORSPolicy$AllowMethods$All$.MODULE$.equals(allowMethods)) {
            AllowCredentials allowCredentials = this.allowCredentials;
            CORSPolicy$AllowCredentials$Deny$ cORSPolicy$AllowCredentials$Deny$ = CORSPolicy$AllowCredentials$Deny$.MODULE$;
            object = !(allowCredentials == null ? cORSPolicy$AllowCredentials$Deny$ != null : !allowCredentials.equals(cORSPolicy$AllowCredentials$Deny$)) || package.all$.MODULE$.catsSyntaxEq((Object)method, (Eq)Method$.MODULE$.catsInstancesForHttp4sMethod()).$eq$eq$eq((Object)CORSPolicy$.MODULE$.wildcardMethod()) ? CORSPolicy$CommonHeaders$.MODULE$.someAllowMethodsWildcard() : None$.MODULE$;
        } else if (allowMethods instanceof AllowMethods.In) {
            AllowMethods.In in = CORSPolicy$AllowMethods$In$.MODULE$.unapply((AllowMethods.In)allowMethods);
            Set<Method> set = in._1();
            Set<Method> methods = set;
            object = methods.contains((Object)method) ? someAllowMethodsSpecificHeader$2 : None$.MODULE$;
        } else {
            throw new MatchError((Object)allowMethods);
        }
        return object;
    }

    private static final Option someAllowHeadersHeader$2(Set headers) {
        Header.Raw raw = (Header.Raw)package.all$.MODULE$.catsSyntaxOptionId((Object)Header.Raw$.MODULE$.apply(Header$.MODULE$.apply(Access$minusControl$minusAllow$minusHeaders$.MODULE$.headerInstance()).name(), ((IterableOnceOps)headers.map((Function1 & Serializable)_$25 -> _$25.toString())).mkString(", ")));
        return OptionIdOps$.MODULE$.some$extension((Object)raw);
    }

    private final Option allowHeadersHeader$1(Set requestHeaders) {
        Object object;
        AllowHeaders allowHeaders = this.allowHeaders;
        if (CORSPolicy$AllowHeaders$All$.MODULE$.equals(allowHeaders)) {
            AllowCredentials allowCredentials = this.allowCredentials;
            CORSPolicy$AllowCredentials$Deny$ cORSPolicy$AllowCredentials$Deny$ = CORSPolicy$AllowCredentials$Deny$.MODULE$;
            object = !(allowCredentials == null ? cORSPolicy$AllowCredentials$Deny$ != null : !allowCredentials.equals(cORSPolicy$AllowCredentials$Deny$)) || package.all$.MODULE$.catsSyntaxEq((Object)requestHeaders, (Eq)Eq$.MODULE$.catsKernelPartialOrderForSet()).$eq$eq$eq(CORSPolicy$.MODULE$.wildcardHeadersSet()) ? CORSPolicy$CommonHeaders$.MODULE$.someAllowHeadersWildcard() : None$.MODULE$;
        } else if (allowHeaders instanceof AllowHeaders.Static) {
            Set<CIString> set;
            AllowHeaders.Static static_ = CORSPolicy$AllowHeaders$Static$.MODULE$.unapply((AllowHeaders.Static)allowHeaders);
            Set<CIString> allowedHeaders = set = static_._1();
            object = CORSPolicy.someAllowHeadersHeader$2(allowedHeaders);
        } else if (allowHeaders instanceof AllowHeaders.In) {
            AllowHeaders.In in = CORSPolicy$AllowHeaders$In$.MODULE$.unapply((AllowHeaders.In)allowHeaders);
            Set<CIString> set = in._1();
            Set<CIString> allowedHeaders = set;
            object = requestHeaders.$minus$minus(allowedHeaders).isEmpty() ? CORSPolicy.someAllowHeadersHeader$2(allowedHeaders) : None$.MODULE$;
        } else if (CORSPolicy$AllowHeaders$Reflect$.MODULE$.equals(allowHeaders)) {
            object = CORSPolicy.someAllowHeadersHeader$2(requestHeaders);
        } else {
            throw new MatchError((Object)allowHeaders);
        }
        return object;
    }

    private static final Response varyHeader$1(Option varyHeaderNonOptions$7, Option varyHeaderOptions$7, Method method, Response resp) {
        Response response;
        Option option;
        Method method2 = method;
        Method method3 = Method$.MODULE$.OPTIONS();
        Method method4 = method2;
        Option option2 = !(method3 != null ? !method3.equals(method4) : method4 != null) ? varyHeaderOptions$7 : (option = varyHeaderNonOptions$7);
        if (option instanceof Some) {
            Header.ToRaw toRaw;
            Header.Raw vary = (Header.Raw)((Some)option).value();
            Object[] objectArray = new Header.ToRaw[1];
            Option option3 = Headers$.MODULE$.get$extension(resp.headers(), package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
            if (None$.MODULE$.equals(option3)) {
                toRaw = Header.ToRaw$.MODULE$.rawToRaw(vary);
            } else if (option3 instanceof Some) {
                NonEmptyList oldVary = (NonEmptyList)((Some)option3).value();
                toRaw = Header.ToRaw$.MODULE$.rawToRaw(Header.Raw$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), oldVary.map((Function1 & Serializable)_$26 -> _$26.value()).toList().mkString(", ") + ", " + vary.value()));
            } else {
                throw new MatchError((Object)option3);
            }
            objectArray[0] = toRaw;
            response = (Response)resp.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else if (None$.MODULE$.equals(option)) {
            response = resp;
        } else {
            throw new MatchError((Object)option);
        }
        return response;
    }

    private final /* synthetic */ Object impl$$anonfun$1(Kleisli http$5, Kleisli preflightResponder$3, Functor evidence$6$5, Option allowCredentialsHeader$6, Option exposeHeadersHeader$4, Option someAllowMethodsSpecificHeader$4, Option maxAgeHeader$4, Option varyHeaderNonOptions$9, Option varyHeaderOptions$9, Request req) {
        return this.dispatch$1(http$5, preflightResponder$3, evidence$6$5, allowCredentialsHeader$6, exposeHeadersHeader$4, someAllowMethodsSpecificHeader$4, maxAgeHeader$4, varyHeaderNonOptions$9, varyHeaderOptions$9, req);
    }

    public static interface AllowCredentials {
    }

    public static interface AllowHeaders {
    }

    public static interface AllowMethods {
    }

    public static interface AllowOrigin {
    }

    public static interface ExposeHeaders {
    }

    public static interface MaxAge {
    }
}

