/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Functor;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import fs2.Stream;
import fs2.compression.Compression$;
import fs2.compression.DeflateParams;
import fs2.compression.DeflateParams$;
import fs2.compression.ZLibParams;
import java.io.Serializable;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.headers.Accept;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.vault.Vault;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class GZip$
implements Serializable {
    private static final Logger logger;
    public static final GZip$ MODULE$;

    private GZip$() {
    }

    static {
        MODULE$ = new GZip$();
        logger = LoggerFactory.getLogger((String)"org.http4s.server.middleware.GZip");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GZip$.class);
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, int bufferSize, DeflateParams.Level level, Function1<Response<G>, Object> isZippable, Functor<F> evidence$1, Sync<G> evidence$2) {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)req -> {
            Accept.minusEncoding acceptEncoding;
            Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Accept$minusEncoding$.MODULE$.headerSemigroupInstance(), Accept$minusEncoding$.MODULE$.headerInstance()));
            return option instanceof Some && this.satisfiedByGzip(acceptEncoding = (Accept.minusEncoding)((Some)option).value()) ? package.all$.MODULE$.toFunctorOps(http.apply(req), evidence$1).map((Function1 & Serializable)_$4 -> this.zipOrPass((Response)_$4, bufferSize, level, (Function1)isZippable, (Sync)evidence$2)) : http.apply(req);
        });
    }

    public int apply$default$2() {
        return 32768;
    }

    public <F, G> DeflateParams.Level apply$default$3() {
        return DeflateParams.Level$.DEFAULT$.MODULE$;
    }

    public <F, G> Function1<Response<G>, Object> apply$default$4() {
        return (Function1 & Serializable)_$3 -> this.defaultIsZippable((Response)_$3);
    }

    public <F> boolean defaultIsZippable(Response<F> resp) {
        Option contentType = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance()));
        return Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusEncoding$.MODULE$.headerInstance())).isEmpty() && resp.status().isEntityAllowed() && (contentType.isEmpty() || ((Content.minusType)contentType.get()).mediaType().compressible() || ((Content.minusType)contentType.get()).mediaType() == MediaType$.MODULE$.application().octet$minusstream());
    }

    private boolean satisfiedByGzip(Accept.minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    private <F> Response<F> zipOrPass(Response<F> response, int bufferSize, DeflateParams.Level level, Function1<Response<F>, Object> isZippable, Sync<F> evidence$3) {
        Response<F> resp;
        Response<F> response2 = response;
        Response<F> resp2 = response2;
        Response<F> response3 = BoxesRunTime.unboxToBoolean((Object)isZippable.apply(resp2)) ? this.zipResponse(bufferSize, level, resp2, evidence$3) : (resp = response2);
        return response3;
    }

    private <F> Response<F> zipResponse(int bufferSize, DeflateParams.Level level, Response<F> resp, Sync<F> evidence$4) {
        Logger Logger_this = logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("GZip middleware encoding content");
        }
        Response response = (Response)resp.removeHeader(Content$minusLength$.MODULE$.headerInstance()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusEncoding$.MODULE$.apply(ContentCoding$.MODULE$.gzip()), Content$minusEncoding$.MODULE$.headerInstance())}));
        ZLibParams.Header$.GZIP$ gZIP$ = ZLibParams.Header$.GZIP$.MODULE$;
        DeflateParams.Strategy strategy = DeflateParams$.MODULE$.apply$default$4();
        DeflateParams.FlushMode flushMode = DeflateParams$.MODULE$.apply$default$5();
        Stream stream = resp.body().through(Compression$.MODULE$.apply(Compression$.MODULE$.forSync(evidence$4)).gzip((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, DeflateParams$.MODULE$.apply(bufferSize, (ZLibParams.Header)gZIP$, level, strategy, flushMode)));
        Status status = response.copy$default$1();
        HttpVersion httpVersion = response.copy$default$2();
        List list = response.copy$default$3();
        Vault vault = response.copy$default$5();
        return response.copy(status, httpVersion, list, stream, vault);
    }
}

