/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.io.file.BasicFileAttributes;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.headers.Accept$minusRanges$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$1$;
import org.http4s.server.staticcontent.FileService$Config$;
import org.http4s.server.staticcontent.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.vault.Vault;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FileService$
implements Serializable {
    private static final Logger logger;
    public static final FileService$Config$ Config;
    public static final FileService$ MODULE$;

    private FileService$() {
    }

    static {
        MODULE$ = new FileService$();
        logger = LoggerFactory.getLogger((String)"org.http4s.server.staticcontent.FileService");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileService$.class);
    }

    public <F> Kleisli<OptionT, Request<F>, Response<F>> apply(FileService.Config<F> config, Async<F> F) {
        LazyRef lazyRef = new LazyRef();
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(Files$.MODULE$.apply(Files$.MODULE$.forAsync(F)).realPath(Path$.MODULE$.apply(config.systemPath())), F);
        Kleisli kleisli = (Kleisli)package.all$.MODULE$.catsSyntaxFlatten((Object)Kleisli$.MODULE$.liftF((Object)OptionT$.MODULE$.liftF(package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, F), F).map((Function1 & Serializable)x$1 -> {
            Kleisli kleisli;
            Either either = x$1;
            if (either instanceof Right) {
                Path rootPath = (Path)((Right)either).value();
                kleisli = TranslateUri$.MODULE$.apply(config.pathPrefix(), Kleisli$.MODULE$.apply((Function1 & Serializable)request -> {
                    OptionT optionT = (OptionT)package.all$.MODULE$.catsSyntaxApplicativeError((Object)this.resolvedPath$3(F, rootPath, (Request)request, lazyRef).flatMapF((Function1 & Serializable)path -> F.ifM(Files$.MODULE$.apply(Files$.MODULE$.forAsync(F)).exists(path, false), () -> this.apply$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(F, path), () -> this.apply$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2(F)), (Monad)F).collect((PartialFunction)new Serializable(rootPath){
                        private final Path rootPath$1;
                        {
                            this.rootPath$1 = rootPath$5;
                        }

                        public final boolean isDefinedAt(Path x) {
                            Path path = x;
                            Path path2 = path;
                            return path2.startsWith(this.rootPath$1);
                        }

                        public final Object applyOrElse(Path x, Function1 function1) {
                            Path path = x;
                            Path path2 = path;
                            return path2.startsWith(this.rootPath$1) ? path2.toNioPath().toFile() : function1.apply((Object)x);
                        }
                    }, (Functor)F).flatMap((Function1 & Serializable)f -> (OptionT)config.pathCollector().apply(f, (Object)config, request), (Monad)F).semiflatMap((Function1 & Serializable)_$7 -> config.cacheStrategy().cache(request.pathInfo(), _$7, F), (Monad)F), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
                    return (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension((Object)optionT, (PartialFunction)new Serializable(F, lazyRef){
                        private final Async F$1;
                        private final LazyRef BadTraversal$lzy1$1;
                        {
                            this.F$1 = F$15;
                            this.BadTraversal$lzy1$1 = BadTraversal$lzy1$9;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            FileService$BadTraversal$1$ fileService$BadTraversal$1$ = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(this.BadTraversal$lzy1$1);
                            Throwable throwable2 = throwable;
                            return !(fileService$BadTraversal$1$ != null ? !fileService$BadTraversal$1$.equals(throwable2) : throwable2 != null);
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Object object;
                            Throwable throwable = x;
                            FileService$BadTraversal$1$ fileService$BadTraversal$1$ = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(this.BadTraversal$lzy1$1);
                            Throwable throwable2 = throwable;
                            if (!(fileService$BadTraversal$1$ != null ? !fileService$BadTraversal$1$.equals(throwable2) : throwable2 != null)) {
                                boolean bl = OptionT$.MODULE$.some();
                                object = OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)this.F$1);
                            } else {
                                object = function1.apply((Object)x);
                            }
                            return object;
                        }
                    }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
                }), OptionT$.MODULE$.catsDataMonoidKForOptionT((Monad)F));
            } else if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                if (throwable instanceof NoSuchFileException) {
                    Logger Logger_this = logger;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Could not find root path from FileService config: systemPath = " + config.systemPath() + ", pathPrefix = " + config.pathPrefix() + ". All requests will return none.");
                    }
                    kleisli = Kleisli$.MODULE$.apply((Function1 & Serializable)_$8 -> OptionT$.MODULE$.none((Applicative)F));
                } else {
                    Throwable e = throwable;
                    Logger Logger_this = logger;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Could not resolve root path from FileService config: systemPath = " + config.systemPath() + ", pathPrefix = " + config.pathPrefix() + ". All requests will fail with a 500.", e);
                    }
                    kleisli = Kleisli$.MODULE$.apply((Function1 & Serializable)_$9 -> {
                        boolean bl = OptionT$.MODULE$.pure();
                        return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)F);
                    });
                }
            } else {
                throw new MatchError((Object)either);
            }
            return kleisli;
        }), F)), (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F)));
        return (Kleisli)FlattenOps$.MODULE$.flatten$extension((Object)kleisli, (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F)));
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$$filesOnly(Path path, FileService.Config<F> config, Request<F> req, Async<F> F) {
        return OptionT$.MODULE$.apply(package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(Files$.MODULE$.forAsync(F)).getBasicFileAttributes(path), F).flatMap((Function1 & Serializable)attr -> attr.isDirectory() ? StaticFile$.MODULE$.fromPath(path.$div("index.html"), (Option)Some$.MODULE$.apply((Object)req), Files$.MODULE$.forAsync(F), (MonadError)F).value() : (!attr.isRegularFile() ? F.pure((Object)None$.MODULE$) : OptionT$.MODULE$.apply(this.getPartialContentFile(path, config, req, F)).orElse(() -> this.filesOnly$$anonfun$3$$anonfun$2(path, config, req, F), (Monad)F).value())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            long end2 = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    private <F> Object getPartialContentFile(Path file, FileService.Config<F> config, Request<F> req, Async<F> F) {
        return package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(Files$.MODULE$.forAsync(F)).getBasicFileAttributes(file), F).flatMap((Function1 & Serializable)attr -> {
            Option option;
            Object object;
            Range range;
            Option option2 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Range$.MODULE$.headerInstance()));
            if (option2 instanceof Some && (range = (Range)((Some)option2).value()) != null) {
                Range range2 = Range$.MODULE$.unapply(range);
                RangeUnit rangeUnit = range2._1();
                NonEmptyList nonEmptyList = range2._2();
                RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
                RangeUnit rangeUnit3 = rangeUnit;
                if (!(rangeUnit2 != null ? !rangeUnit2.equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList != null) {
                    NonEmptyList nonEmptyList2 = NonEmptyList$.MODULE$.unapply(nonEmptyList);
                    Range.SubRange subRange = (Range.SubRange)nonEmptyList2._1();
                    List list = nonEmptyList2._2();
                    if (subRange != null) {
                        Range.SubRange subRange2 = Range.SubRange$.MODULE$.unapply(subRange);
                        long l = subRange2._1();
                        Option option3 = subRange2._2();
                        long s = l;
                        Option e = option3;
                        Nil$ nil$ = scala.package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                            if (!this.validRange(s, (Option<Object>)e, attr.size())) {
                                object = this.nope$1(F, (BasicFileAttributes)attr);
                                return object;
                            }
                            long size = attr.size();
                            long start = s >= 0L ? s : scala.math.package$.MODULE$.max(0L, size + s);
                            long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e.getOrElse(() -> this.$anonfun$2(size))));
                            object = StaticFile$.MODULE$.fromPath(file, start, end + 1L, config.bufferSize(), (Option)Some$.MODULE$.apply((Object)req), StaticFile$.MODULE$.calculateETag(Files$.MODULE$.forAsync(F), (ApplicativeError)F), Files$.MODULE$.forAsync(F), (MonadError)F).map((Function1 & Serializable)resp -> {
                                List hs = Headers$.MODULE$.put$extension(resp.headers(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)size))), Content$minusRange$.MODULE$.headerInstance())}));
                                Status status = Status$.MODULE$.PartialContent();
                                HttpVersion httpVersion = resp.copy$default$2();
                                Stream stream = resp.copy$default$4();
                                Vault vault = resp.copy$default$5();
                                return resp.copy(status, httpVersion, hs, stream, vault);
                            }, (Functor)F).value();
                            return object;
                        }
                    }
                }
            }
            if ((option = Headers$.MODULE$.get$extension(req.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Range"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])))) instanceof Some) {
                object = this.nope$1(F, (BasicFileAttributes)attr);
                return object;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            object = F.pure((Object)None$.MODULE$);
            return object;
        });
    }

    private final FileService$BadTraversal$1$ BadTraversal$lzyINIT1$1(LazyRef BadTraversal$lzy1$1) {
        FileService$BadTraversal$1$ fileService$BadTraversal$1$;
        LazyRef lazyRef = BadTraversal$lzy1$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$1$ = (FileService$BadTraversal$1$)(BadTraversal$lzy1$1.initialized() ? BadTraversal$lzy1$1.value() : BadTraversal$lzy1$1.initialize((Object)new FileService$BadTraversal$1$()));
        }
        return fileService$BadTraversal$1$;
    }

    public final FileService$BadTraversal$1$ org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(LazyRef BadTraversal$lzy1$2) {
        return (FileService$BadTraversal$1$)(BadTraversal$lzy1$2.initialized() ? BadTraversal$lzy1$2.value() : this.BadTraversal$lzyINIT1$1(BadTraversal$lzy1$2));
    }

    private final Path resolvedPath$2$$anonfun$2(Path rootPath$3, Vector segments$1, LazyRef BadTraversal$lzy1$6) {
        return (Path)segments$1.foldLeft((Object)rootPath$3, (Function2 & Serializable)(x$1, x$2) -> {
            String string;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                string = (String)tuple2._2();
                if ("".equals(string) || ".".equals(string) || "..".equals(string)) {
                    throw this.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(BadTraversal$lzy1$6);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            String segment = string;
            return path.resolve(segment);
        });
    }

    private final OptionT resolvedPath$3(Async F$2, Path rootPath$1, Request request$1, LazyRef BadTraversal$lzy1$4) {
        OptionT optionT;
        Vector segments = (Vector)request$1.pathInfo().segments().map((Function1 & Serializable)_$6 -> _$6.decoded(_$6.decoded$default$1(), true, _$6.decoded$default$3()));
        if (request$1.pathInfo().isEmpty()) {
            boolean bl = OptionT$.MODULE$.some();
            optionT = OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)rootPath$1, (Applicative)F$2);
        } else {
            optionT = OptionT$.MODULE$.liftF(F$2.catchNonFatal(() -> this.resolvedPath$2$$anonfun$2(rootPath$1, segments, BadTraversal$lzy1$4), (.less.colon.less)$less$colon$less$.MODULE$.refl()), (Functor)F$2);
        }
        return optionT;
    }

    private final Object apply$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Async F$5, Path path$1) {
        Path path = (Path)package.all$.MODULE$.catsSyntaxOptionId((Object)path$1.absolute().normalize());
        Option option = (Option)package.all$.MODULE$.catsSyntaxApplicativeId((Object)OptionIdOps$.MODULE$.some$extension((Object)path));
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, (Applicative)F$5);
    }

    private final Object apply$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2(Async F$6) {
        Option option = (Option)package.all$.MODULE$.catsSyntaxApplicativeId((Object)package.all$.MODULE$.none());
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, (Applicative)F$6);
    }

    private final OptionT filesOnly$$anonfun$3$$anonfun$2(Path path$3, FileService.Config config$6, Request req$2, Async F$12) {
        return StaticFile$.MODULE$.fromPath(path$3, config$6.bufferSize(), (Option)Some$.MODULE$.apply((Object)req$2), StaticFile$.MODULE$.calculateETag(Files$.MODULE$.forAsync(F$12), (ApplicativeError)F$12), Files$.MODULE$.forAsync(F$12), (MonadError)F$12).map((Function1 & Serializable)_$11 -> (Response)_$11.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance())})), (Functor)F$12);
    }

    private final Object nope$1(Async F$13, BasicFileAttributes attr$1) {
        Status status = Status$.MODULE$.RangeNotSatisfiable();
        List list = Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(0L, attr$1.size() - 1L), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)attr$1.size()))), Content$minusRange$.MODULE$.headerInstance())}));
        HttpVersion httpVersion = Response$.MODULE$.apply$default$2();
        Stream stream = Response$.MODULE$.apply$default$4();
        Vault vault = Response$.MODULE$.apply$default$5();
        Some some = (Some)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Some$.MODULE$.apply((Object)Response$.MODULE$.apply(status, httpVersion, list, stream, vault)));
        return package.all$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension((Object)some, (Applicative)F$13), (Functor)F$13).widen();
    }

    private final long $anonfun$2(long size$1) {
        return size$1 - 1L;
    }
}

