/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest$;
import org.http4s.Challenge;
import org.http4s.Challenge$;
import org.http4s.ContextRequest;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.crypto.Hash;
import org.http4s.crypto.Hash$;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$Md5HashedAuthStore$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$OK$;
import org.http4s.server.middleware.authentication.DigestAuth$PlainTextAuthStore$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.NonceKeeperF;
import org.http4s.server.middleware.authentication.NonceKeeperF$;
import org.http4s.server.middleware.authentication.package$;
import org.typelevel.ci.CIString;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DigestAuth$
implements Serializable {
    public static final DigestAuth$PlainTextAuthStore$ PlainTextAuthStore;
    public static final DigestAuth$Md5HashedAuthStore$ Md5HashedAuthStore;
    private static final DigestAuth$OK$ OK;
    private static final DigestAuth$StaleNonce$ StaleNonce;
    private static final DigestAuth$BadNC$ BadNC;
    private static final DigestAuth$WrongResponse$ WrongResponse;
    private static final DigestAuth$BadParameters$ BadParameters;
    private static final DigestAuth$UserUnknown$ UserUnknown;
    private static final DigestAuth$NoCredentials$ NoCredentials;
    private static final DigestAuth$NoAuthorizationHeader$ NoAuthorizationHeader;
    public static final DigestAuth$ MODULE$;

    private DigestAuth$() {
    }

    static {
        MODULE$ = new DigestAuth$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DigestAuth$.class);
    }

    public <F, A> Function1<Kleisli<?, ContextRequest<F, A>, Response<F>>, Kleisli<?, Request<F>, Response<F>>> apply(String realm, Function1<String, Object> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$1) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$1);
        return (Function1 & Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$1);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public int apply$default$5() {
        return 160;
    }

    public <F, A> Object applyF(String realm, DigestAuth.AuthStore<F, A> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Async<F> F) {
        return package.all$.MODULE$.toFunctorOps(this.challenge(realm, store, nonceCleanupInterval, nonceStaleTime, nonceBits, F), F).map((Function1 & Serializable)runChallenge -> (Function1 & Serializable)routes -> package$.MODULE$.challenged(runChallenge, routes, F));
    }

    public <F, A> Duration applyF$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration applyF$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public int applyF$default$5() {
        return 160;
    }

    private <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challenge(String realm, Function1<String, Object> store, NonceKeeper nonceKeeper, Sync<F> F) {
        return this.challengeInterop(realm, DigestAuth$PlainTextAuthStore$.MODULE$.apply(store), F.delay(() -> this.challenge$$anonfun$1(nonceKeeper)), (Function2<String, Object, Object>)(Function2 & Serializable)(data, nc) -> this.challenge$$anonfun$2(nonceKeeper, F, (String)data, BoxesRunTime.unboxToInt((Object)nc)), F);
    }

    public <F, A> Object challenge(String realm, DigestAuth.AuthStore<F, A> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Async<F> F) {
        return package.all$.MODULE$.toFunctorOps(NonceKeeperF$.MODULE$.apply(nonceStaleTime, nonceCleanupInterval, nonceBits, F), F).map((Function1 & Serializable)nonceKeeper -> this.challengeInterop(realm, store, nonceKeeper.newNonce(), (Function2<String, Object, Object>)(Function2 & Serializable)(data, nc) -> this.challenge$$anonfun$3$$anonfun$1((NonceKeeperF)nonceKeeper, (String)data, BoxesRunTime.unboxToInt((Object)nc)), (Sync)F));
    }

    public <F, A> Duration challenge$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration challenge$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public int challenge$default$5() {
        return 160;
    }

    private <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challengeInterop(String realm, DigestAuth.AuthStore<F, A> store, Object newNonce, Function2<String, Object, Object> receiveNonce, Sync<F> F) {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)req -> package.all$.MODULE$.toFlatMapOps(this.checkAuth(realm, store, receiveNonce, (Request)req, (Hash)Hash$.MODULE$.forApplicativeThrow((ApplicativeError)F), (Monad)F), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
            DigestAuth.AuthReply authReply = x$1;
            if (authReply instanceof DigestAuth.OK) {
                Object a;
                DigestAuth.OK oK = DigestAuth$OK$.MODULE$.unapply((DigestAuth.OK)authReply);
                Object authInfo = a = oK._1();
                return F.pure((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)AuthedRequest$.MODULE$.apply(authInfo, req)));
            }
            if (DigestAuth$StaleNonce$.MODULE$.equals(authReply)) {
                return package.all$.MODULE$.toFunctorOps(this.getChallengeParams(newNonce, true, (Functor)F), (Functor)F).map((Function1 & Serializable)params -> this.paramsToChallenge$1(realm, (Map)params));
            }
            return package.all$.MODULE$.toFunctorOps(this.getChallengeParams(newNonce, false, (Functor)F), (Functor)F).map((Function1 & Serializable)params -> this.paramsToChallenge$1(realm, (Map)params));
        }));
    }

    private <F, A> Object checkAuth(String realm, DigestAuth.AuthStore<F, A> store, Function2<String, Object, Object> receiveNonce, Request<F> req, Hash<F> evidence$2, Monad<F> F) {
        Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance()));
        if (option instanceof Some) {
            Authorization authorization;
            Credentials credentials;
            Authorization authorization2 = (Authorization)((Some)option).value();
            if (authorization2 != null && (credentials = (authorization = Authorization$.MODULE$.unapply(authorization2))._1()) instanceof Credentials.AuthParams) {
                Credentials.AuthParams authParams = Credentials.AuthParams$.MODULE$.unapply((Credentials.AuthParams)credentials);
                CIString cIString = authParams._1();
                NonEmptyList nonEmptyList = authParams._2();
                CIString cIString2 = AuthScheme$.MODULE$.Digest();
                CIString cIString3 = cIString;
                if (!(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null)) {
                    NonEmptyList params = nonEmptyList;
                    return this.checkAuthParams(realm, store, receiveNonce, req, (NonEmptyList<Tuple2<String, String>>)params, evidence$2, F);
                }
            }
            return F.pure((Object)DigestAuth$NoCredentials$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            return F.pure((Object)DigestAuth$NoAuthorizationHeader$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    private <F> Object getChallengeParams(Object newNonce, boolean staleNonce, Functor<F> F) {
        return package.all$.MODULE$.toFunctorOps(newNonce, F).map((Function1 & Serializable)nonce -> {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"qop");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"auth");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"nonce");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, nonce);
            Map m = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            if (staleNonce) {
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stale");
                return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"TRUE"));
            }
            return m;
        });
    }

    private <F, A> Object checkAuthParams(String realm, DigestAuth.AuthStore<F, A> store, Function2<String, Object, Object> receiveNonce, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Hash<F> evidence$3, Monad<F> F) {
        Map params = paramsNel.toList().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (!((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf((Set)params.keySet())) {
            return F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        if (!params.get((Object)"realm").contains((Object)realm)) {
            return F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply((Object)"nonce");
        String nc = (String)params.apply((Object)"nc");
        return package.all$.MODULE$.toFlatMapOps(receiveNonce.apply((Object)nonce, (Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(nc, 16))), F).flatMap((Function1 & Serializable)x$12 -> {
            NonceKeeper.Reply reply = x$12;
            if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
                return F.pure((Object)DigestAuth$StaleNonce$.MODULE$);
            }
            if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
                return F.pure((Object)DigestAuth$BadNC$.MODULE$);
            }
            if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
                DigestAuth.AuthStore authStore = store;
                if (authStore instanceof DigestAuth.PlainTextAuthStore) {
                    DigestAuth.PlainTextAuthStore authStore2 = (DigestAuth.PlainTextAuthStore)authStore;
                    return package.all$.MODULE$.toFlatMapOps(authStore2.func().apply(params.apply((Object)"username")), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        Option option = x$1;
                        if (None$.MODULE$.equals(option)) {
                            return F.pure((Object)DigestAuth$UserUnknown$.MODULE$);
                        }
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            Object authInfo = tuple2._1();
                            String password = (String)tuple2._2();
                            return package.all$.MODULE$.toFunctorOps(DigestUtil$.MODULE$.computeResponse(method, (String)params.apply((Object)"username"), realm, password, req.uri(), nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"), F, evidence$3), (Functor)F).map((Function1 & Serializable)resp -> {
                                String string = resp;
                                Object object = params.apply((Object)"response");
                                return !(string != null ? !string.equals(object) : object != null) ? DigestAuth$OK$.MODULE$.apply(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                            });
                        }
                        throw new MatchError((Object)option);
                    });
                }
                if (authStore instanceof DigestAuth.Md5HashedAuthStore) {
                    DigestAuth.Md5HashedAuthStore authStore3 = (DigestAuth.Md5HashedAuthStore)authStore;
                    return package.all$.MODULE$.toFlatMapOps(authStore3.func().apply(params.apply((Object)"username")), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        Option option = x$1;
                        if (None$.MODULE$.equals(option)) {
                            return F.pure((Object)DigestAuth$UserUnknown$.MODULE$);
                        }
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            Object authInfo = tuple2._1();
                            String ha1Hash = (String)tuple2._2();
                            return package.all$.MODULE$.toFunctorOps(DigestUtil$.MODULE$.computeHashedResponse(method, ha1Hash, req.uri(), nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"), F, evidence$3), (Functor)F).map((Function1 & Serializable)resp -> {
                                String string = resp;
                                Object object = params.apply((Object)"response");
                                return !(string != null ? !string.equals(object) : object != null) ? DigestAuth$OK$.MODULE$.apply(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                            });
                        }
                        throw new MatchError((Object)option);
                    });
                }
                throw new MatchError((Object)authStore);
            }
            throw new MatchError((Object)reply);
        });
    }

    private final String challenge$$anonfun$1(NonceKeeper nonceKeeper$1) {
        return nonceKeeper$1.newNonce();
    }

    private final NonceKeeper.Reply challenge$$anonfun$2$$anonfun$1(NonceKeeper nonceKeeper$3, String data$1, int nc$1) {
        return nonceKeeper$3.receiveNonce(data$1, nc$1);
    }

    private final /* synthetic */ Object challenge$$anonfun$2(NonceKeeper nonceKeeper$2, Sync F$3, String data, int nc) {
        return F$3.delay(() -> this.challenge$$anonfun$2$$anonfun$1(nonceKeeper$2, data, nc));
    }

    private final /* synthetic */ Object challenge$$anonfun$3$$anonfun$1(NonceKeeperF nonceKeeper$4, String data, int nc) {
        return nonceKeeper$4.receiveNonce(data, nc);
    }

    private final Either paramsToChallenge$1(String realm$3, Map params) {
        return EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)Challenge$.MODULE$.apply("Digest", realm$3, params));
    }
}

