/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.http4s.server.middleware.authentication.Nonce;
import org.http4s.server.middleware.authentication.Nonce$;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import scala.MatchError;
import scala.Predef$;

public class NonceKeeper {
    private final long staleTimeout;
    private final long nonceCleanupInterval;
    private final int bits;
    private final LinkedHashMap<String, Nonce> nonces;
    private long lastCleanup;

    public NonceKeeper(long staleTimeout, long nonceCleanupInterval, int bits) {
        this.staleTimeout = staleTimeout;
        this.nonceCleanupInterval = nonceCleanupInterval;
        this.bits = bits;
        Predef$.MODULE$.require(bits > 0, NonceKeeper::$init$$$anonfun$1);
        this.nonces = new LinkedHashMap();
        this.lastCleanup = System.currentTimeMillis();
    }

    private void checkStale() {
        long d = System.currentTimeMillis();
        if (d - this.lastCleanup > this.nonceCleanupInterval) {
            this.lastCleanup = d;
            Iterator<Nonce> it = this.nonces.values().iterator();
            this.dropStale$1(d, it);
            return;
        }
    }

    public String newNonce() {
        Nonce n = null;
        LinkedHashMap<String, Nonce> linkedHashMap = this.nonces;
        synchronized (linkedHashMap) {
            this.checkStale();
            n = Nonce$.MODULE$.gen(this.bits);
            while (this.nonces.get(n.data()) != null) {
                n = Nonce$.MODULE$.gen(this.bits);
            }
            this.nonces.put(n.data(), n);
        }
        return n.data();
    }

    public Reply receiveNonce(String data, int nc) {
        Reply reply;
        LinkedHashMap<String, Nonce> linkedHashMap = this.nonces;
        synchronized (linkedHashMap) {
            Reply reply2;
            this.checkStale();
            Nonce nonce = this.nonces.get(data);
            if (nonce == null) {
                reply2 = NonceKeeper$StaleReply$.MODULE$;
            } else if (nonce != null) {
                Nonce n = nonce;
                if (nc > n.nc()) {
                    n.nc_$eq(n.nc() + 1);
                    reply2 = NonceKeeper$OKReply$.MODULE$;
                } else {
                    reply2 = NonceKeeper$BadNCReply$.MODULE$;
                }
            } else {
                throw new MatchError((Object)nonce);
            }
            reply = reply2;
        }
        return reply;
    }

    private static final Object $init$$$anonfun$1() {
        return "Please supply a positive integer for bits.";
    }

    private final void dropStale$1(long d$1, Iterator it$1) {
        while (it$1.hasNext() && this.staleTimeout > d$1 - ((Nonce)it$1.next()).created().getTime()) {
            it$1.remove();
        }
    }

    public static abstract class Reply {
    }
}

