/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.arrow.FunctionK;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.effect.std.SecureRandom;
import cats.effect.std.SecureRandom$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Media;
import org.http4s.Media$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response$;
import org.http4s.SameSite;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.crypto.Algorithm;
import org.http4s.crypto.Hmac$;
import org.http4s.crypto.HmacAlgorithm;
import org.http4s.crypto.HmacKeyGen$;
import org.http4s.crypto.SecretKey;
import org.http4s.crypto.SecretKeySpec;
import org.http4s.crypto.SecretKeySpec$;
import org.http4s.crypto.SecureEq$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Cookie$;
import org.http4s.headers.Host;
import org.http4s.headers.Host$;
import org.http4s.headers.Referer$;
import org.http4s.headers.X;
import org.http4s.headers.X$minusForwarded$minusFor$;
import org.http4s.server.middleware.CSRF;
import org.http4s.server.middleware.CSRF$CSRFCheckFailed$;
import org.http4s.server.middleware.CSRF$CookieSettings$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.Bases;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class CSRF$
implements Serializable {
    public static final CSRF$CookieSettings$ CookieSettings;
    public static final CSRF$CSRFCheckFailed$ CSRFCheckFailed;
    private static final HmacAlgorithm.SHA1$ SigningAlgorithm;
    private static final String SigningAlgo;
    private static final int CSRFTokenLength;
    private static final int InitialSeedArraySize;
    private static final SecureRandom<SyncIO> CachedRandom;
    public static final CSRF$ MODULE$;

    private CSRF$() {
    }

    static {
        MODULE$ = new CSRF$();
        SigningAlgorithm = HmacAlgorithm.SHA1$.MODULE$;
        SigningAlgo = "HmacSHA1";
        CSRFTokenLength = 32;
        InitialSeedArraySize = 20;
        CachedRandom = (SecureRandom)((SyncIO)package.all$.MODULE$.toFlatMapOps(SecureRandom$.MODULE$.javaSecuritySecureRandom(SyncIO$.MODULE$.syncForSyncIO()), (FlatMap)SyncIO$.MODULE$.syncForSyncIO()).flatTap((Function1 & Serializable)_$50 -> (SyncIO)_$50.nextBytes(InitialSeedArraySize))).unsafeRunSync();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CSRF$.class);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> apply(ByteVector key, Function1<Request<G>, Object> headerCheck, Async<F> evidence$3, Applicative<G> evidence$4) {
        Some some = Some$.MODULE$.apply((Object)"/");
        Option<String> option = CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$4();
        Option<SameSite> option2 = CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$6();
        Option<String> option3 = CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$7();
        return new CSRF.CSRFBuilder<F, G>(org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"X-Csrf-Token"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CSRF$CookieSettings$.MODULE$.apply("csrf-token", false, true, option, (Option<String>)some, option2, option3), Response$.MODULE$.apply(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), true, (SecretKey<HmacAlgorithm>)SecretKeySpec$.MODULE$.apply(key, (Algorithm)HmacAlgorithm.SHA1$.MODULE$), headerCheck, this.checkCSRFDefault(evidence$3), evidence$3, evidence$4);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheck(ByteVector key, String host, Uri.Scheme scheme, Option<Object> port, Async<F> evidence$5, Applicative<G> evidence$6) {
        return this.apply(key, (Function1 & Serializable)_$18 -> this.defaultOriginCheck((Request)_$18, host, scheme, port), evidence$5, evidence$6);
    }

    public <F, G> CSRF.CSRFBuilder<F, G> withDefaultOriginCheckFormAware(String fieldName, FunctionK<G, F> nt, ByteVector key, String host, Uri.Scheme scheme, Option<Object> port, Async<F> evidence$7, GenConcurrent<G, Throwable> evidence$8) {
        return this.withDefaultOriginCheck(key, host, scheme, port, (Async)package$.MODULE$.Sync().apply(evidence$7), Applicative$.MODULE$.apply(evidence$8)).withCSRFCheck(this.checkCSRFinHeaderAndForm(fieldName, nt, evidence$8, evidence$7));
    }

    public <F, G> Object withGeneratedKey(Function1<Request<G>, Object> headerCheck, Async<F> evidence$9, Applicative<G> evidence$10) {
        return package.all$.MODULE$.toFunctorOps(this.generateSigningKey(evidence$9), evidence$9).map((Function1 & Serializable)k -> this.apply((ByteVector)k, headerCheck, evidence$9, evidence$10));
    }

    public <F, G> Object withKeyBytes(byte[] keyBytes, Function1<Request<G>, Object> headerCheck, Async<F> evidence$11, Applicative<G> evidence$12) {
        return package.all$.MODULE$.toFunctorOps(this.buildSigningKey(keyBytes, evidence$11), evidence$11).map((Function1 & Serializable)k -> this.apply((ByteVector)k, headerCheck, evidence$11, evidence$12));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> checkCSRFDefault(Async<F> F) {
        return (Function1 & Serializable)csrf -> (Function2 & Serializable)(r, http) -> csrf.getHeaderToken(r).fold(() -> this.checkCSRFDefault$$anonfun$1$$anonfun$1$$anonfun$1(csrf), (Function1 & Serializable)_$37 -> csrf.checkCSRFToken(r, http, (String)_$37, F));
    }

    public <F, G> Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> checkCSRFinHeaderAndForm(String fieldName, FunctionK<G, F> nt, GenConcurrent<G, Throwable> evidence$13, Async<F> F) {
        return (Function1 & Serializable)csrf -> (Function2 & Serializable)(r, http) -> package.all$.MODULE$.toFlatMapOps(F.pure(csrf.getHeaderToken(r)), (FlatMap)F).flatMap((Function1 & Serializable)fst -> package.all$.MODULE$.toFlatMapOps(fst.isDefined() ? F.pure(fst) : this.getFormToken$1(fieldName, nt, evidence$13, F, (Request)r), (FlatMap)F).flatMap((Function1 & Serializable)snd -> package.all$.MODULE$.toFunctorOps(snd.fold(() -> this.checkCSRFinHeaderAndForm$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(csrf), (Function1 & Serializable)_$45 -> csrf.checkCSRFToken(r, http, (String)_$45, F)), (Functor)F).map((Function1 & Serializable)tok -> tok)));
    }

    public Object lift(String s) {
        return s;
    }

    public String unlift(Object s) {
        return (String)s;
    }

    public <F> boolean defaultOriginCheck(Request<F> r, String host, Uri.Scheme sc, Option<Object> port) {
        return Headers$.MODULE$.get$extension(r.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Origin"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))).flatMap((Function1 & Serializable)o -> {
            Either either = Uri$.MODULE$.fromString(((Header.Raw)o.head()).value());
            if (either instanceof Right) {
                Uri uri = (Uri)((Right)either).value();
                return Some$.MODULE$.apply((Object)uri);
            }
            if (either instanceof Left) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }).exists((Function1 & Serializable)u -> {
            if (!u.host().exists((Function1 & Serializable)_$47 -> {
                String string = _$47.value();
                String string2 = host;
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) return false;
            if (!u.scheme().contains((Object)sc)) return false;
            Option option = u.port();
            Option option2 = port;
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }) || Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(Referer$.MODULE$.headerInstance())).exists((Function1 & Serializable)u -> {
            if (!u.uri().host().exists((Function1 & Serializable)_$48 -> {
                String string = _$48.value();
                String string2 = host;
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) return false;
            if (!u.uri().scheme().contains((Object)sc)) return false;
            Option option = u.uri().port();
            Option option2 = port;
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        });
    }

    public <F> boolean proxyOriginCheck(Request<F> r, Host host, X.minusForwarded.minusFor xff) {
        return Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(Host$.MODULE$.headerInstance())).contains((Object)host) || Headers$.MODULE$.get$extension(r.headers(), Header.Select$.MODULE$.singleHeaders(X$minusForwarded$minusFor$.MODULE$.headerInstance())).contains((Object)xff);
    }

    public String SigningAlgo() {
        return SigningAlgo;
    }

    public int CSRFTokenLength() {
        return CSRFTokenLength;
    }

    public <F, G> Object cookieFromHeadersF(Request<G> request, String cookieName, Sync<F> F) {
        Option<RequestCookie> option = this.cookieFromHeaders(request, cookieName);
        if (option instanceof Some) {
            RequestCookie e = (RequestCookie)((Some)option).value();
            return F.pure((Object)e);
        }
        if (None$.MODULE$.equals(option)) {
            return F.raiseError((Object)CSRF$CSRFCheckFailed$.MODULE$);
        }
        throw new MatchError(option);
    }

    public <F> Option<RequestCookie> cookieFromHeaders(Request<F> request, String cookieName) {
        return Headers$.MODULE$.get$extension(request.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Cookie$.MODULE$.headerSemigroupInstance(), Cookie$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)_$54 -> _$54.values().find((Function1 & Serializable)_$55 -> {
            String string = _$55.name();
            String string2 = cookieName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    public boolean tokensEqual(Object s1, Object s2) {
        return this.isEqual(this.unlift(s1), this.unlift(s2));
    }

    public boolean isEqual(String s1, String s2) {
        return SecureEq$.MODULE$.apply(SecureEq$.MODULE$.secureEqForByteVector()).eqv(SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeUtf8(s1)).unsafeRunSync(), SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeUtf8(s2)).unsafeRunSync());
    }

    public <F> Object genTokenString(Sync<F> evidence$14) {
        return ((SyncIO)CachedRandom.nextBytes(this.CSRFTokenLength())).map((Function1 & Serializable)arr -> ByteVector$.MODULE$.view(arr).toHex((Bases.HexAlphabet)Bases.Alphabets$.HexUppercase$.MODULE$)).to(evidence$14);
    }

    public <F> Object generateSigningKey(Async<F> F) {
        return package.all$.MODULE$.toFunctorOps(HmacKeyGen$.MODULE$.apply(HmacKeyGen$.MODULE$.forSync(F)).generateKey((HmacAlgorithm)SigningAlgorithm), F).map((Function1 & Serializable)x$1 -> {
            SecretKey secretKey = x$1;
            if (secretKey instanceof SecretKeySpec) {
                SecretKeySpec secretKeySpec = SecretKeySpec$.MODULE$.unapply((SecretKeySpec)secretKey);
                ByteVector byteVector = secretKeySpec._1();
                HmacAlgorithm.SHA1$ sHA1$ = (HmacAlgorithm.SHA1$)secretKeySpec._2();
                ByteVector key = byteVector;
                return key;
            }
            throw new MatchError((Object)secretKey);
        });
    }

    public <F> Object buildSigningKey(byte[] array, Async<F> F) {
        return package.all$.MODULE$.toFunctorOps(Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow(F)).importKey(ByteVector$.MODULE$.view(array), (HmacAlgorithm)SigningAlgorithm), F).map((Function1 & Serializable)x$1 -> {
            SecretKey secretKey = x$1;
            if (secretKey instanceof SecretKeySpec) {
                SecretKeySpec secretKeySpec = SecretKeySpec$.MODULE$.unapply((SecretKeySpec)secretKey);
                ByteVector byteVector = secretKeySpec._1();
                HmacAlgorithm.SHA1$ sHA1$ = (HmacAlgorithm.SHA1$)secretKeySpec._2();
                ByteVector key = byteVector;
                return key;
            }
            throw new MatchError((Object)secretKey);
        });
    }

    private final Object checkCSRFDefault$$anonfun$1$$anonfun$1$$anonfun$1(CSRF csrf$2) {
        return csrf$2.onfailureF();
    }

    private final /* synthetic */ Option extractToken$1$$anonfun$1$$anonfun$2(String fieldName$6, Map _$42) {
        return _$42.get((Object)fieldName$6).flatMap((Function1 & Serializable)_$43 -> _$43.uncons().map((Function1 & Serializable)_$44 -> (String)_$44._1()));
    }

    private final Object extractToken$1(String fieldName$2, GenConcurrent evidence$13$2, Request r$3) {
        Media media = Media$.MODULE$.InvariantOps((Media)r$3);
        return package.all$.MODULE$.toFunctorOps(Media.InvariantOps$.MODULE$.attemptAs$extension(media, UrlForm$.MODULE$.entityDecoder(evidence$13$2, UrlForm$.MODULE$.entityDecoder$default$2())).value(), (Functor)evidence$13$2).map((Function1 & Serializable)_$40 -> (Option)_$40.fold((Function1 & Serializable)_$41 -> package.all$.MODULE$.none(), (Function1 & Serializable)_$42 -> this.extractToken$1$$anonfun$1$$anonfun$2(fieldName$2, _$42 == null ? null : ((UrlForm)_$42).values())));
    }

    private final Object getFormToken$1(String fieldName$1, FunctionK nt$1, GenConcurrent evidence$13$1, Async F$19, Request r$2) {
        Content.minusType minusType2;
        Option option = Headers$.MODULE$.get$extension(r$2.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance()));
        if (option instanceof Some && (minusType2 = (Content.minusType)((Some)option).value()) != null) {
            Content.minusType minusType3 = Content$minusType$.MODULE$.unapply(minusType2);
            MediaType mediaType = minusType3._1();
            Option option2 = minusType3._2();
            MediaType mediaType2 = MediaType$.MODULE$.application().x$minuswww$minusform$minusurlencoded();
            MediaType mediaType3 = mediaType;
            if (!(mediaType2 != null ? !mediaType2.equals(mediaType3) : mediaType3 != null)) {
                return nt$1.apply(this.extractToken$1(fieldName$1, evidence$13$1, r$2));
            }
        }
        return F$19.pure((Object)package.all$.MODULE$.none());
    }

    private final Object checkCSRFinHeaderAndForm$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(CSRF csrf$7) {
        return csrf$7.onfailureF();
    }
}

