/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.http4s.HttpRoutes$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.CacheStrategy;
import org.http4s.server.staticcontent.ResourceServiceBuilder$;
import org.http4s.server.staticcontent.ResourceServiceBuilder$BadTraversal$2$;
import org.typelevel.log4cats.LoggerFactory;
import org.typelevel.log4cats.LoggerFactory$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Vector;
import scala.runtime.LazyRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class ResourceServiceBuilder<F> {
    private final String basePath;
    private final String pathPrefix;
    private final int bufferSize;
    private final CacheStrategy<F> cacheStrategy;
    private final boolean preferGzipped;
    private final Option<ClassLoader> classLoader;
    private final LoggerFactory<F> evidence$1;
    private final SelfAwareStructuredLogger<F> logger;

    public static <F> ResourceServiceBuilder<F> apply(String string, LoggerFactory<F> loggerFactory) {
        return ResourceServiceBuilder$.MODULE$.apply(string, loggerFactory);
    }

    public ResourceServiceBuilder(String basePath, String pathPrefix, int bufferSize, CacheStrategy<F> cacheStrategy, boolean preferGzipped, Option<ClassLoader> classLoader, LoggerFactory<F> evidence$1) {
        this.basePath = basePath;
        this.pathPrefix = pathPrefix;
        this.bufferSize = bufferSize;
        this.cacheStrategy = cacheStrategy;
        this.preferGzipped = preferGzipped;
        this.classLoader = classLoader;
        this.evidence$1 = evidence$1;
        this.logger = (SelfAwareStructuredLogger)LoggerFactory$.MODULE$.apply(evidence$1).getLogger("org.http4s.server.staticcontent.ResourceServiceBuilder");
    }

    private ResourceServiceBuilder<F> copy(String basePath, String pathPrefix, int bufferSize, CacheStrategy<F> cacheStrategy, boolean preferGzipped, Option<ClassLoader> classLoader) {
        return new ResourceServiceBuilder<F>(basePath, pathPrefix, bufferSize, cacheStrategy, preferGzipped, classLoader, this.evidence$1);
    }

    private String copy$default$1() {
        return this.basePath;
    }

    private String copy$default$2() {
        return this.pathPrefix;
    }

    private int copy$default$3() {
        return this.bufferSize;
    }

    private CacheStrategy<F> copy$default$4() {
        return this.cacheStrategy;
    }

    private boolean copy$default$5() {
        return this.preferGzipped;
    }

    private Option<ClassLoader> copy$default$6() {
        return this.classLoader;
    }

    public ResourceServiceBuilder<F> withBasePath(String basePath) {
        return this.copy(basePath, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ResourceServiceBuilder<F> withPathPrefix(String pathPrefix) {
        return this.copy(this.copy$default$1(), pathPrefix, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ResourceServiceBuilder<F> withCacheStrategy(CacheStrategy<F> cacheStrategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), cacheStrategy, this.copy$default$5(), this.copy$default$6());
    }

    public ResourceServiceBuilder<F> withPreferGzipped(boolean preferGzipped) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), preferGzipped, this.copy$default$6());
    }

    public ResourceServiceBuilder<F> withClassLoader(Option<ClassLoader> classLoader) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), classLoader);
    }

    public ResourceServiceBuilder<F> withBufferSize(int bufferSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), bufferSize, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public F toRoutes(Async<F> F) {
        LazyRef lazyRef = new LazyRef();
        String basePath = this.basePath.isEmpty() ? "/" : this.basePath;
        Try try_ = Try$.MODULE$.apply(() -> ResourceServiceBuilder.toRoutes$$anonfun$1(basePath));
        if (try_ instanceof Success) {
            Path rootPath = (Path)((Success)try_).value();
            Kleisli kleisli = (Kleisli)package.all$.MODULE$.catsSyntaxApplicativeId(TranslateUri$.MODULE$.apply(this.pathPrefix, HttpRoutes$.MODULE$.apply((Function1 & Serializable)x$1 -> {
                Request request = x$1;
                Request request2 = request;
                if (request2.pathInfo().nonEmpty()) {
                    Vector segments = (Vector)request2.pathInfo().segments().map((Function1 & Serializable)_$2 -> _$2.decoded(_$2.decoded$default$1(), true, _$2.decoded$default$3()));
                    OptionT optionT = (OptionT)package.all$.MODULE$.catsSyntaxApplicativeError((Object)OptionT$.MODULE$.liftF(F.catchNonFatal(() -> ResourceServiceBuilder.toRoutes$$anonfun$2$$anonfun$1(rootPath, segments, lazyRef), (.less.colon.less)$less$colon$less$.MODULE$.refl()), (Functor)F).collect((PartialFunction)new Serializable(rootPath){
                        private final Path rootPath$3;
                        {
                            this.rootPath$3 = rootPath$4;
                        }

                        public final boolean isDefinedAt(Path x) {
                            Path path = x;
                            Path path2 = path;
                            return path2.startsWith(this.rootPath$3);
                        }

                        public final Object applyOrElse(Path x, Function1 function1) {
                            Path path = x;
                            Path path2 = path;
                            if (path2.startsWith(this.rootPath$3)) {
                                return path2;
                            }
                            return function1.apply((Object)x);
                        }
                    }, (Functor)F).flatMap((Function1 & Serializable)path -> StaticFile$.MODULE$.fromResource(path.toString().replace(File.separatorChar, '/'), (Option)Some$.MODULE$.apply((Object)request2), this.preferGzipped, this.classLoader, (Sync)F), (Monad)F).semiflatMap((Function1 & Serializable)_$3 -> this.cacheStrategy.cache(request2.pathInfo(), (Response<F>)_$3, (GenConcurrent<F, Throwable>)F), (Monad)F), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
                    return (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension((Object)optionT, (PartialFunction)new Serializable(F, lazyRef, this){
                        private final Async F$4;
                        private final LazyRef BadTraversal$lzy1$5;
                        {
                            this.F$4 = F$6;
                            this.BadTraversal$lzy1$5 = BadTraversal$lzy1$7;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            ResourceServiceBuilder$BadTraversal$2$ resourceServiceBuilder$BadTraversal$2$ = ResourceServiceBuilder.org$http4s$server$staticcontent$ResourceServiceBuilder$$_$BadTraversal$1(this.BadTraversal$lzy1$5);
                            Throwable throwable2 = throwable;
                            return !(resourceServiceBuilder$BadTraversal$2$ != null ? !resourceServiceBuilder$BadTraversal$2$.equals(throwable2) : throwable2 != null);
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            ResourceServiceBuilder$BadTraversal$2$ resourceServiceBuilder$BadTraversal$2$ = ResourceServiceBuilder.org$http4s$server$staticcontent$ResourceServiceBuilder$$_$BadTraversal$1(this.BadTraversal$lzy1$5);
                            Throwable throwable2 = throwable;
                            if (!(resourceServiceBuilder$BadTraversal$2$ != null ? !resourceServiceBuilder$BadTraversal$2$.equals(throwable2) : throwable2 != null)) {
                                boolean bl = OptionT$.MODULE$.some();
                                return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)this.F$4);
                            }
                            return function1.apply((Object)x);
                        }
                    }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
                }
                return OptionT$.MODULE$.none((Applicative)F);
            }, F), OptionT$.MODULE$.catsDataMonoidKForOptionT(F)));
            return (F)ApplicativeIdOps$.MODULE$.pure$extension((Object)kleisli, F);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return (F)package.all$.MODULE$.toFunctorOps(this.logger.error(e, () -> this.toRoutes$$anonfun$3(basePath)), F).as((Object)Kleisli$.MODULE$.apply((Function1 & Serializable)_$4 -> {
                boolean bl = OptionT$.MODULE$.pure();
                return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)F);
            }));
        }
        throw new MatchError((Object)try_);
    }

    private static final ResourceServiceBuilder$BadTraversal$2$ BadTraversal$lzyINIT1$1(LazyRef BadTraversal$lzy1$1) {
        ResourceServiceBuilder$BadTraversal$2$ resourceServiceBuilder$BadTraversal$2$;
        LazyRef lazyRef = BadTraversal$lzy1$1;
        synchronized (lazyRef) {
            resourceServiceBuilder$BadTraversal$2$ = (ResourceServiceBuilder$BadTraversal$2$)(BadTraversal$lzy1$1.initialized() ? BadTraversal$lzy1$1.value() : BadTraversal$lzy1$1.initialize((Object)new ResourceServiceBuilder$BadTraversal$2$()));
        }
        return resourceServiceBuilder$BadTraversal$2$;
    }

    public static final ResourceServiceBuilder$BadTraversal$2$ org$http4s$server$staticcontent$ResourceServiceBuilder$$_$BadTraversal$1(LazyRef BadTraversal$lzy1$2) {
        return (ResourceServiceBuilder$BadTraversal$2$)(BadTraversal$lzy1$2.initialized() ? BadTraversal$lzy1$2.value() : ResourceServiceBuilder.BadTraversal$lzyINIT1$1(BadTraversal$lzy1$2));
    }

    private static final Path toRoutes$$anonfun$1(String basePath$1) {
        return Paths.get(basePath$1, new String[0]);
    }

    private static final Path toRoutes$$anonfun$2$$anonfun$1(Path rootPath$2, Vector segments$1, LazyRef BadTraversal$lzy1$4) {
        return (Path)segments$1.foldLeft((Object)rootPath$2, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String string = (String)tuple2._2();
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if ("".equals(string)) throw ResourceServiceBuilder.org$http4s$server$staticcontent$ResourceServiceBuilder$$_$BadTraversal$1(BadTraversal$lzy1$4);
                    break;
                }
                case 46: {
                    if (".".equals(string)) throw ResourceServiceBuilder.org$http4s$server$staticcontent$ResourceServiceBuilder$$_$BadTraversal$1(BadTraversal$lzy1$4);
                    break;
                }
                case 1472: {
                    if (!"..".equals(string)) break;
                    throw ResourceServiceBuilder.org$http4s$server$staticcontent$ResourceServiceBuilder$$_$BadTraversal$1(BadTraversal$lzy1$4);
                }
            }
            Path path = (Path)tuple2._1();
            String segment = string;
            return path.resolve(segment);
        });
    }

    private final String toRoutes$$anonfun$3(String basePath$2) {
        return new StringBuilder(104).append("Could not get root path from ResourceService config: basePath = ").append(basePath$2).append(", pathPrefix = ").append(this.pathPrefix).append(". All requests will fail.").toString();
    }
}

