/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import fs2.compression.Compression;
import fs2.compression.Compression$;
import fs2.compression.DeflateParams;
import fs2.compression.DeflateParams$;
import fs2.compression.ZLibParams;
import java.io.Serializable;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.headers.Accept;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType$;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import org.typelevel.log4cats.LoggerFactory;
import org.typelevel.log4cats.LoggerFactory$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class GZip$
implements Serializable {
    public static final GZip$ MODULE$ = new GZip$();

    private GZip$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GZip$.class);
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, int bufferSize, DeflateParams.Level level, Function1<Response<G>, Object> isZippable, Monad<F> evidence$1, LoggerFactory<F> evidence$2, Compression<G> evidence$3) {
        Logger logger = LoggerFactory$.MODULE$.apply(evidence$2).getLogger("org.http4s.server.middleware.GZip");
        return Kleisli$.MODULE$.apply((Function1 & Serializable)req -> {
            Accept.minusEncoding acceptEncoding;
            Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Accept$minusEncoding$.MODULE$.headerSemigroupInstance(), Accept$minusEncoding$.MODULE$.headerInstance()));
            if (option instanceof Some && MODULE$.satisfiedByGzip(acceptEncoding = (Accept.minusEncoding)((Some)option).value())) {
                return package.all$.MODULE$.toFlatMapOps(http.apply(req), (FlatMap)evidence$1).flatMap((Function1 & Serializable)_$4 -> MODULE$.zipOrPass((Response)_$4, bufferSize, level, isZippable, (Applicative)evidence$1, (Logger)logger, evidence$3));
            }
            return http.apply(req);
        });
    }

    public int apply$default$2() {
        return 32768;
    }

    public <F, G> DeflateParams.Level apply$default$3() {
        return DeflateParams.Level$.DEFAULT$.MODULE$;
    }

    public <F, G> Function1<Response<G>, Object> apply$default$4() {
        return (Function1 & Serializable)_$3 -> MODULE$.defaultIsZippable((Response)_$3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <F> boolean defaultIsZippable(Response<F> resp) {
        Option contentType = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusType$.MODULE$.headerInstance()));
        if (Headers$.MODULE$.contains$extension(resp.headers(), Content$minusEncoding$.MODULE$.headerInstance())) return false;
        if (!resp.status().isEntityAllowed()) return false;
        if (contentType.isEmpty()) return true;
        if (((Content.minusType)contentType.get()).mediaType().compressible()) return true;
        MediaType mediaType = ((Content.minusType)contentType.get()).mediaType();
        MediaType mediaType2 = MediaType$.MODULE$.application().octet$minusstream();
        if (mediaType != null) {
            if (!mediaType.equals(mediaType2)) return false;
            return true;
        }
        if (mediaType2 == null) return true;
        return false;
    }

    private boolean satisfiedByGzip(Accept.minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    private <F, G> Object zipOrPass(Response<G> response, int bufferSize, DeflateParams.Level level, Function1<Response<G>, Object> isZippable, Applicative<F> evidence$1, Logger<F> evidence$2, Compression<G> evidence$3) {
        Response<G> response2 = response;
        Response<G> resp = response2;
        if (BoxesRunTime.unboxToBoolean((Object)isZippable.apply(resp))) {
            return this.zipResponse(bufferSize, level, resp, (Functor<F>)evidence$1, evidence$2, evidence$3);
        }
        Response<G> resp2 = response2;
        Response response3 = (Response)package.all$.MODULE$.catsSyntaxApplicativeId(resp2);
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)response3, evidence$1);
    }

    private <F, G> Object zipResponse(int bufferSize, DeflateParams.Level level, Response<G> resp, Functor<F> evidence$1, Logger<F> evidence$2, Compression<G> evidence$3) {
        Function1 compressPipe = Compression$.MODULE$.apply(evidence$3).gzip((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, DeflateParams$.MODULE$.apply(bufferSize, (ZLibParams.Header)ZLibParams.Header$.GZIP$.MODULE$, level, DeflateParams$.MODULE$.apply$default$4(), DeflateParams$.MODULE$.apply$default$5()));
        return package.all$.MODULE$.toFunctorOps(Logger$.MODULE$.apply(evidence$2).trace(GZip$::zipResponse$$anonfun$1), evidence$1).as((Object)resp.removeHeader(Content$minusLength$.MODULE$.headerInstance()).putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusEncoding$.MODULE$.apply(ContentCoding$.MODULE$.gzip()), Content$minusEncoding$.MODULE$.headerInstance())})).pipeBodyThrough(compressPipe));
    }

    private static final String zipResponse$$anonfun$1() {
        return "GZip middleware encoding content";
    }
}

