/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.session;

import cats.Functor;
import cats.effect.kernel.Async;
import cats.effect.std.MapRef;
import cats.effect.std.Random;
import org.http4s.session.SessionIdentifier;
import org.http4s.session.SessionIdentifier$;
import org.http4s.session.SessionStore$;
import scala.Function1;
import scala.Option;
import scala.Tuple2;

public interface SessionStore<F, A> {
    public static <F, A> Object create(int n, int n2, Async<F> async) {
        return SessionStore$.MODULE$.create(n, n2, async);
    }

    public static <F, A> int create$default$1() {
        return SessionStore$.MODULE$.create$default$1();
    }

    public static <F, A> int create$default$2() {
        return SessionStore$.MODULE$.create$default$2();
    }

    public F createSessionId();

    public F getSession(SessionIdentifier var1);

    public <B> F modifySession(SessionIdentifier var1, Function1<Option<A>, Tuple2<Option<A>, B>> var2);

    public static class MemorySessionStore<F, A>
    implements SessionStore<F, A> {
        private final Random<F> random;
        private final int numBytes;
        private final MapRef<F, SessionIdentifier, Option<A>> access;
        private final Functor<F> evidence$2;

        public MemorySessionStore(Random<F> random, int numBytes, MapRef<F, SessionIdentifier, Option<A>> access, Functor<F> evidence$2) {
            this.random = random;
            this.numBytes = numBytes;
            this.access = access;
            this.evidence$2 = evidence$2;
        }

        @Override
        public F createSessionId() {
            return (F)SessionIdentifier$.MODULE$.create(this.random, this.numBytes, this.evidence$2);
        }

        @Override
        public F getSession(SessionIdentifier id) {
            return (F)this.access.apply((Object)id).get();
        }

        @Override
        public <B> F modifySession(SessionIdentifier id, Function1<Option<A>, Tuple2<Option<A>, B>> f) {
            return (F)this.access.apply((Object)id).modify(f);
        }
    }
}

