/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.nio.ByteBuffer;
import org.http4s.websocket.FrameTranscoder$;
import org.http4s.websocket.WebsocketBits;
import org.http4s.websocket.WebsocketBits$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]r!B\u0001\u0003\u0011\u0003I\u0011a\u0004$sC6,GK]1og\u000e|G-\u001a:\u000b\u0005\r!\u0011!C<fEN|7m[3u\u0015\t)a!\u0001\u0004iiR\u0004Hg\u001d\u0006\u0002\u000f\u0005\u0019qN]4\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\tyaI]1nKR\u0013\u0018M\\:d_\u0012,'o\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00053\u00059q\nU0D\u001f\u0012+U#\u0001\u000e\u0011\u0005=Y\u0012B\u0001\u000f\u0011\u0005\rIe\u000e\u001e\u0005\u0007=-\u0001\u000b\u0011\u0002\u000e\u0002\u0011=\u0003vlQ(E\u000b\u0002Bq\u0001I\u0006C\u0002\u0013%\u0011$\u0001\u0005G\u0013:K5\u000bS#E\u0011\u0019\u00113\u0002)A\u00055\u0005Ia)\u0013(J'\"+E\t\t\u0005\bI-\u0011\r\u0011\"\u0003\u001a\u0003\u0011i\u0015iU&\t\r\u0019Z\u0001\u0015!\u0003\u001b\u0003\u0015i\u0015iU&!\u0011\u001dA3B1A\u0005\ne\ta\u0001T#O\u000fRC\u0005B\u0002\u0016\fA\u0003%!$A\u0004M\u000b:;E\u000b\u0013\u0011\t\u000f1Z!\u0019!C\u00053\u0005)1\tT(T\u000b\"1af\u0003Q\u0001\ni\taa\u0011'P'\u0016\u0003\u0003b\u0002\u0019\f\u0005\u0004%I!G\u0001\u0005!&su\t\u0003\u00043\u0017\u0001\u0006IAG\u0001\u0006!&su\t\t\u0005\bi-\u0011\r\u0011\"\u0003\u001a\u0003\u0011\u0001vJT$\t\rYZ\u0001\u0015!\u0003\u001b\u0003\u0015\u0001vJT$!\r\u0011A4BA\u001d\u0003\u001dQ\u0013\u0018M\\:d_\u0012,WI\u001d:peN\u0011qG\u000f\t\u0003w\rs!\u0001P!\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}B\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\t\u0011\u0005#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011+%!C#yG\u0016\u0004H/[8o\u0015\t\u0011\u0005\u0003\u0003\u0005Ho\t\u0015\r\u0011\"\u0001I\u0003\u001diWm]:bO\u0016,\u0012!\u0013\t\u0003\u0015:s!a\u0013'\u0011\u0005u\u0002\u0012BA'\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\u0003\u0002\u0002\u0003*8\u0005\u0003\u0005\u000b\u0011B%\u0002\u00115,7o]1hK\u0002BQ!F\u001c\u0005\u0002Q#\"!V,\u0011\u0005Y;T\"A\u0006\t\u000b\u001d\u001b\u0006\u0019A%\t\u000be[A\u0011\u0002.\u0002\u0019\u0011,7m\u001c3f\u0005&t\u0017M]=\u0015\u0007m\u000b7\u000eE\u0002\u00109zK!!\u0018\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=y\u0016B\u00011\u0011\u0005\u0011\u0011\u0015\u0010^3\t\u000b\tD\u0006\u0019A2\u0002\u0005%t\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\rq\u0017n\u001c\u0006\u0002Q\u0006!!.\u0019<b\u0013\tQWM\u0001\u0006CsR,')\u001e4gKJDQ\u0001\u001c-A\u0002m\u000bA!\\1tW\")an\u0003C\u0005_\u0006aA.\u001a8hi\"|eMZ:fiR\u0011!\u0004\u001d\u0005\u0006E6\u0004\ra\u0019\u0005\u0006e.!Ia]\u0001\bO\u0016$X*Y:l)\tYF\u000fC\u0003cc\u0002\u00071\rC\u0003w\u0017\u0011%q/\u0001\u0006c_\u0012LH*\u001a8hi\"$\"A\u0007=\t\u000b\t,\b\u0019A2\t\u000bi\\A\u0011B>\u0002\u0019\u001d,G/T:h\u0019\u0016tw\r\u001e5\u0015\u0005ia\b\"\u00022z\u0001\u0004\u0019g\u0001\u0002\u0007\u0003\u0001y\u001c\"! \b\t\u0015\u0005\u0005QP!b\u0001\n\u0003\t\u0019!\u0001\u0005jg\u000ec\u0017.\u001a8u+\t\t)\u0001E\u0002\u0010\u0003\u000fI1!!\u0003\u0011\u0005\u001d\u0011un\u001c7fC:D!\"!\u0004~\u0005\u0003\u0005\u000b\u0011BA\u0003\u0003%I7o\u00117jK:$\b\u0005\u0003\u0004\u0016{\u0012\u0005\u0011\u0011\u0003\u000b\u0005\u0003'\t)\u0002\u0005\u0002\u000b{\"A\u0011\u0011AA\b\u0001\u0004\t)\u0001C\u0004\u0002\u001au$\t!a\u0007\u0002\u001b\u0019\u0014\u0018-\\3U_\n+hMZ3s)\u0011\ti\"a\b\u0011\u0007=a6\rC\u0004c\u0003/\u0001\r!!\t\u0011\t\u0005\r\u0012\u0011\u0006\b\u0004\u0015\u0005\u0015\u0012bAA\u0014\u0005\u0005iq+\u001a2t_\u000e\\W\r\u001e\"jiNLA!a\u000b\u0002.\tqq+\u001a2T_\u000e\\W\r\u001e$sC6,'bAA\u0014\u0005!9\u0011\u0011G?\u0005\u0002\u0005M\u0012!\u00042vM\u001a,'\u000fV8Ge\u0006lW\r\u0006\u0003\u0002\"\u0005U\u0002B\u00022\u00020\u0001\u00071\r")
public class FrameTranscoder {
    private final boolean isClient;

    public boolean isClient() {
        return this.isClient;
    }

    public ByteBuffer[] frameToBuffer(WebsocketBits.WebSocketFrame in) {
        ByteBuffer[] byteBufferArray;
        int size = 2;
        if (this.isClient()) {
            size += 4;
        }
        if (in.length() >= 126) {
            size = in.length() <= 65535 ? (size += 2) : (size += 8);
        }
        ByteBuffer buff = ByteBuffer.allocate(this.isClient() ? size + in.length() : size);
        int opcode = in.opcode();
        if (in.length() > 125 && (opcode == FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$PING() || opcode == FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$PONG() || opcode == FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$CLOSE())) {
            throw new TranscodeError("Invalid PING frame: frame too long: " + in.length());
        }
        byte b1 = in.last() ? (byte)((byte)opcode | FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$FINISHED()) : (byte)opcode;
        buff.put(Predef$.MODULE$.int2Integer((int)b1).byteValue());
        byte b2 = 0;
        if (this.isClient()) {
            b2 = (byte)FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$MASK();
        }
        b2 = in.length() < 126 ? (byte)(b2 | in.length()) : (in.length() <= 65535 ? (byte)(b2 | 0x7E) : (byte)(b2 | 0x7F));
        buff.put(Predef$.MODULE$.int2Integer((int)b2).byteValue());
        Object object = in.length() > 125 && in.length() <= 65535 ? buff.put((byte)(in.length() >>> 8 & 0xFF)).put((byte)(in.length() & 0xFF)) : (in.length() > 65535 ? buff.putLong(in.length()) : BoxedUnit.UNIT);
        if (this.isClient() && in.length() > 0) {
            int mask = (int)(Math.random() * (double)Integer.MAX_VALUE);
            byte[] maskBits = new byte[]{(byte)(mask >>> 24 & 0xFF), (byte)(mask >>> 16 & 0xFF), (byte)(mask >>> 8 & 0xFF), (byte)(mask >>> 0 & 0xFF)};
            buff.put(maskBits);
            byte[] data = in.data();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), in.length()).foreach((Function1 & java.io.Serializable & Serializable)i -> buff.put((byte)(data[BoxesRunTime.unboxToInt((Object)i)] ^ maskBits[BoxesRunTime.unboxToInt((Object)i) & 3])));
            buff.flip();
            byteBufferArray = (ByteBuffer[])((Object[])new ByteBuffer[]{buff});
        } else {
            buff.flip();
            byteBufferArray = (ByteBuffer[])((Object[])new ByteBuffer[]{buff, ByteBuffer.wrap(in.data())});
        }
        return byteBufferArray;
    }

    public WebsocketBits.WebSocketFrame bufferToFrame(ByteBuffer in) {
        WebsocketBits.WebSocketFrame webSocketFrame;
        if (in.remaining() < 2 || FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMsgLength(in) < 0) {
            webSocketFrame = null;
        } else {
            byte[] byArray;
            boolean masked;
            int opcode = in.get(0) & FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$OP_CODE();
            boolean finished = (in.get(0) & FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$FINISHED()) != 0;
            boolean bl = masked = (in.get(1) & FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$MASK()) != 0;
            if (masked && this.isClient()) {
                throw new TranscodeError("Client received a masked message");
            }
            int bodyOffset = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$lengthOffset(in);
            if (masked) {
                bodyOffset += 4;
                byArray = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMask(in);
            } else {
                byArray = null;
            }
            byte[] m = byArray;
            int oldLim = in.limit();
            int bodylen = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$bodyLength(in);
            in.position(bodyOffset);
            in.limit(in.position() + bodylen);
            ByteBuffer slice = in.slice();
            in.position(in.limit());
            in.limit(oldLim);
            webSocketFrame = WebsocketBits$.MODULE$.makeFrame(opcode, FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$decodeBinary(slice, m), finished);
        }
        return webSocketFrame;
    }

    public FrameTranscoder(boolean isClient) {
        this.isClient = isClient;
    }

    public static final class TranscodeError
    extends Exception {
        private final String message;

        public String message() {
            return this.message;
        }

        public TranscodeError(String message) {
            this.message = message;
            super(message);
        }
    }
}

