/*
 * Decompiled with CFR 0.152.
 */
package org.httpfeeds.server;

import com.github.f4b6a3.uuid.UuidCreator;
import java.time.Instant;
import org.httpfeeds.server.DataSerializer;
import org.httpfeeds.server.FeedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedAppender {
    private static final Logger log = LoggerFactory.getLogger(FeedAppender.class);
    private final FeedRepository feedRepository;

    public FeedAppender(FeedRepository feedRepository) {
        this.feedRepository = feedRepository;
    }

    public void append(String type, String source, Instant time, String subject, String method, Object data) {
        String id = UuidCreator.getTimeOrderedWithRandom().toString();
        String dataAsString = DataSerializer.toString(data);
        this.feedRepository.append(id, type, source, time, subject, method, dataAsString);
        log.debug("Appended event type={} id={}", (Object)type, (Object)id);
    }
}

