/*
 * Decompiled with CFR 0.152.
 */
package org.httpfeeds.server;

import org.httpfeeds.server.FeedAppender;
import org.httpfeeds.server.FeedFetcher;
import org.httpfeeds.server.FeedItemRowMapper;
import org.httpfeeds.server.FeedRepository;
import org.httpfeeds.server.HttpFeedController;
import org.httpfeeds.server.HttpFeedServerProperties;
import org.httpfeeds.server.JdbcFeedRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HttpFeedServerProperties.class})
public class HttpFeedServerAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"httpfeed.server.path"})
    HttpFeedController restFeedEndpointController(FeedFetcher feedFetcher) {
        return new HttpFeedController(feedFetcher);
    }

    @Bean
    @ConditionalOnMissingBean(value={FeedItemRowMapper.class})
    FeedItemRowMapper feedItemRowMapper() {
        return new FeedItemRowMapper();
    }

    @Bean
    @ConditionalOnClass(value={JdbcTemplate.class})
    @ConditionalOnMissingBean(value={FeedRepository.class})
    FeedRepository feedRepository(JdbcTemplate jdbcTemplate, FeedItemRowMapper feedItemRowMapper, HttpFeedServerProperties properties) {
        return new JdbcFeedRepository(jdbcTemplate, feedItemRowMapper, properties.getJdbc().getTable());
    }

    @Bean
    @ConditionalOnMissingBean(value={FeedFetcher.class})
    FeedFetcher feedFetcher(FeedRepository feedRepository, HttpFeedServerProperties properties) {
        return new FeedFetcher(feedRepository, properties.getPollInterval(), properties.getLimit());
    }

    @Bean
    @ConditionalOnMissingBean(value={FeedAppender.class})
    FeedAppender feedAppender(FeedRepository feedRepository) {
        return new FeedAppender(feedRepository);
    }
}

