/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.findbugs.FindBugsAnnotationsAggregator;
import hudson.plugins.findbugs.FindBugsDescriptor;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.parser.FindBugsParser;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class FindBugsPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = -5748362182226609649L;
    private static final String PLUGIN_NAME = "FINDBUGS";
    private static final String ANT_DEFAULT_PATTERN = "**/findbugs.xml";
    private static final String MAVEN_DEFAULT_PATTERN = "**/findbugsXml.xml";
    private final String pattern;
    private final boolean isRankActivated;

    @DataBoundConstructor
    public FindBugsPublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean useStableBuildAsReference, boolean shouldDetectModules, String pattern, boolean isRankActivated, boolean canComputeNew) {
        super(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, useStableBuildAsReference, shouldDetectModules, canComputeNew, false, PLUGIN_NAME);
        this.pattern = pattern;
        this.isRankActivated = isRankActivated;
    }

    public boolean isRankActivated() {
        return this.isRankActivated;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new FindBugsProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting findbugs analysis files...");
        String defaultPattern = this.isMavenBuild(build) ? MAVEN_DEFAULT_PATTERN : ANT_DEFAULT_PATTERN;
        FilesParser collector = new FilesParser(PLUGIN_NAME, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)defaultPattern), (AnnotationParser)new FindBugsParser(this.isRankActivated), this.shouldDetectModules(), this.isMavenBuild(build));
        ParserResult project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)collector);
        logger.logLines(project.getLogMessages());
        FindBugsResult result = new FindBugsResult(build, this.getDefaultEncoding(), project, this.useOnlyStableBuildsAsReference());
        build.getActions().add(new FindBugsResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public FindBugsDescriptor getDescriptor() {
        return (FindBugsDescriptor)super.getDescriptor();
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new FindBugsAnnotationsAggregator(build, launcher, listener, (HealthDescriptor)this, this.getDefaultEncoding(), this.useOnlyStableBuildsAsReference());
    }
}

