/*
 * Decompiled with CFR 0.152.
 */
package hudson.graph.jfreechart;

import hudson.Extension;
import hudson.graph.jfreechart.Utils;
import hudson.util.ColorPalette;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.eclipse.hudson.graph.ChartLabel;
import org.eclipse.hudson.graph.DataSet;
import org.eclipse.hudson.graph.GraphSupport;
import org.eclipse.hudson.graph.GraphSupportDescriptor;
import org.eclipse.hudson.graph.MultiStageTimeSeries;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFreeChartSupport
extends GraphSupport {
    private static final Logger LOGGER = Logger.getLogger(JFreeChartSupport.class.getName());
    private JFreeChart jFreeChart;
    private ChartRenderingInfo info = new ChartRenderingInfo();
    private DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private String chartTitle;
    private String xAxisLabel;
    private String yAxisLabel;
    public List<MultiStageTimeSeries> multiStageTimeSeries;
    private int chartType = 1;

    @DataBoundConstructor
    public JFreeChartSupport() {
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    public void setTitle(String title) {
        this.chartTitle = title;
    }

    public void setXAxisLabel(String xLabel) {
        this.xAxisLabel = xLabel;
    }

    public void setYAxisLabel(String yLabel) {
        this.yAxisLabel = yLabel;
    }

    public void setMultiStageTimeSeries(List<MultiStageTimeSeries> multiStageTimeSeries) {
        this.multiStageTimeSeries = multiStageTimeSeries;
    }

    public void createChart() {
        if (this.chartType == 1) {
            this.jFreeChart = ChartFactory.createStackedAreaChart(null, (String)this.chartTitle, (String)this.xAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        } else if (this.chartType == 2) {
            this.jFreeChart = ChartFactory.createLineChart(null, (String)this.chartTitle, (String)this.xAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        this.jFreeChart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = this.jFreeChart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        if (this.chartType == 2) {
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
            renderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
            if (this.multiStageTimeSeries != null) {
                for (int i = 0; i < this.multiStageTimeSeries.size(); ++i) {
                    renderer.setSeriesPaint(i, (Paint)this.multiStageTimeSeries.get((int)i).color);
                }
            }
        }
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        Utils.adjustChebyshev((CategoryDataset)this.dataset, rangeAxis);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (this.chartType == 1) {
            StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

                public Paint getItemPaint(int row, int column) {
                    ChartLabel key = (ChartLabel)JFreeChartSupport.this.dataset.getColumnKey(column);
                    return key.getColor(row, column);
                }

                public String generateURL(CategoryDataset dataset, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset.getColumnKey(column);
                    return label.getLink(row, column);
                }

                public String generateToolTip(CategoryDataset dataset, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset.getColumnKey(column);
                    return label.getToolTip(row, column);
                }
            };
            plot.setRenderer((CategoryItemRenderer)ar);
            ar.setSeriesPaint(0, ColorPalette.RED);
            ar.setSeriesPaint(1, ColorPalette.YELLOW);
            ar.setSeriesPaint(2, ColorPalette.BLUE);
        }
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
    }

    public BufferedImage render(int width, int height) {
        this.createChart();
        return this.jFreeChart.createBufferedImage(width, height, this.info);
    }

    public void setData(DataSet data) {
        TreeSet rowSet = new TreeSet(data.getRows());
        TreeSet colSet = new TreeSet(data.getColumns());
        Comparable[] _rows = rowSet.toArray(new Comparable[rowSet.size()]);
        Comparable[] _cols = colSet.toArray(new Comparable[colSet.size()]);
        for (Comparable r : _rows) {
            this.dataset.setValue(null, r, _cols[0]);
        }
        for (Comparable c : _cols) {
            this.dataset.setValue(null, _rows[0], c);
        }
        for (int i = 0; i < data.getValues().size(); ++i) {
            this.dataset.addValue((Number)data.getValues().get(i), (Comparable)data.getRows().get(i), (Comparable)data.getColumns().get(i));
        }
    }

    public String getImageMap(String id, int width, int height) {
        this.render(width, height);
        return ChartUtilities.getImageMap((String)id, (ChartRenderingInfo)this.info);
    }

    @Extension
    public static class DescriptorImpl
    extends GraphSupportDescriptor {
        public String getDisplayName() {
            return "JFreeChart";
        }
    }
}

