/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.xpath.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.hudsonci.xpath.XPathException;
import org.hudsonci.xpath.impl.Pair;
import org.hudsonci.xpath.impl.XDocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Dom2Dom {
    private static Map<Document, DocMapPair> cache = new WeakHashMap<Document, DocMapPair>();
    private ReverseMap reverseMap;
    private org.w3c.dom.Document wdoc;
    private boolean trimText;
    private Element currentElement;
    private Text lastText;
    StringBuilder textBuilder = new StringBuilder();

    private String getLocalName(String qualifiedName) {
        String localName = null;
        int colon = qualifiedName.indexOf(58);
        if (colon >= 0) {
            localName = qualifiedName.substring(colon + 1);
        }
        return localName;
    }

    private String getNamespaceURI(String namespaceURI) {
        if ("".equals(namespaceURI)) {
            return null;
        }
        return namespaceURI;
    }

    public Node getOriginalNode(org.w3c.dom.Node node) {
        Node d4jNode = (Node)this.reverseMap.get(node);
        if (d4jNode == null) {
            SimplePath path = this.getPathForNode(node, null);
            Document doc = this.getDom4jDocument(node);
            d4jNode = this.getNodeForPath(doc, path);
        }
        return d4jNode;
    }

    private Document getDom4jDocument(org.w3c.dom.Node node) {
        org.w3c.dom.Document doc = node.getOwnerDocument();
        Document document = (Document)this.reverseMap.get(doc);
        if (document == null) {
            throw new IllegalStateException("Document not found in reverse map");
        }
        return document;
    }

    private SimplePath getPathForNode(org.w3c.dom.Node node, SimplePath next) {
        if (node instanceof org.w3c.dom.Document) {
            return next;
        }
        org.w3c.dom.Node parent = node.getParentNode();
        int i = 0;
        for (org.w3c.dom.Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.equals(node)) {
                return this.getPathForNode(parent, new SimplePath(i, next));
            }
            ++i;
        }
        throw new IllegalStateException("Node not a child of its parent");
    }

    private Node getNodeForPath(Document doc, SimplePath path) {
        Document node = doc;
        SimplePath p = path;
        while (p != null) {
            if (!(node instanceof Branch)) {
                throw new IllegalStateException("Node with children not a Branch");
            }
            Branch parent = (Branch)node;
            node = parent.node(p.childNum);
            p = p.next;
        }
        return node;
    }

    public org.w3c.dom.Node dom2DomX(Node node, boolean trim) throws XPathException {
        DocumentBuilder builder;
        this.trimText = trim;
        Document ddoc = node.getDocument();
        this.reverseMap = new ReverseMap();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new XPathException(ex);
        }
        this.wdoc = builder.newDocument();
        this.createChildren((Branch)ddoc, this.wdoc);
        return this.findNode(this.wdoc, node);
    }

    public org.w3c.dom.Node dom2Dom(Node node, boolean trim) throws XPathException {
        this.trimText = trim;
        Document ddoc = node.getDocument();
        DocMapPair pair = cache.get(ddoc);
        if (pair == null) {
            DocumentBuilder builder;
            ReverseMap map = new ReverseMap();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new XPathException(ex);
            }
            org.w3c.dom.Document doc = builder.newDocument();
            map.put(doc, ddoc);
            pair = new DocMapPair(doc, map);
            cache.put(ddoc, pair);
        }
        this.wdoc = (org.w3c.dom.Document)pair.getLeft();
        this.reverseMap = (ReverseMap)pair.getRight();
        if (!this.wdoc.hasChildNodes()) {
            this.createChildren((Branch)ddoc, this.wdoc);
        }
        return this.findNode(this.wdoc, node);
    }

    private org.w3c.dom.Node findNode(org.w3c.dom.Node ancestor, Node node) {
        Node ancestorNode = (Node)this.reverseMap.get(ancestor);
        if (ancestorNode == node) {
            return ancestor;
        }
        NodeList list = ancestor.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node child = list.item(i);
            org.w3c.dom.Node found = this.findNode(child, node);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void createChildren(Branch dparent, org.w3c.dom.Node wparent) {
        Branch b = dparent;
        int n = b.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node child = b.node(i);
            org.w3c.dom.Node wchild = this.createChild(child, wparent);
            if (wchild == null) continue;
            this.createChildren((Branch)child, wchild);
        }
        this.endText(wparent);
    }

    private void endText(org.w3c.dom.Node wparent) {
        if (this.textBuilder.length() > 0) {
            String text = this.trimText ? this.textBuilder.toString().trim() : this.textBuilder.toString();
            org.w3c.dom.Text textNode = this.wdoc.createTextNode(text);
            wparent.appendChild(textNode);
            this.textBuilder.setLength(0);
            this.reverseMap.put(textNode, this.lastText);
        }
    }

    private org.w3c.dom.Node createChild(Node child, org.w3c.dom.Node wparent) {
        short type = child.getNodeType();
        if (type != 3) {
            this.endText(wparent);
        }
        org.w3c.dom.Node node = null;
        switch (type) {
            case 2: {
                break;
            }
            case 4: {
                CDATA cd = (CDATA)child;
                node = this.wdoc.createCDATASection(cd.getText());
                wparent.appendChild(node);
                break;
            }
            case 8: {
                Comment co = (Comment)child;
                node = this.wdoc.createComment(co.getText());
                wparent.appendChild(node);
                break;
            }
            case 10: {
                DocumentType dt = (DocumentType)child;
                wparent.appendChild(new XDocumentType(dt, wparent));
                break;
            }
            case 1: {
                org.dom4j.Element el = (org.dom4j.Element)child;
                Name name = new Name(el);
                Element e = name.namespaceURI == null ? this.wdoc.createElement(name.qualifiedName) : this.wdoc.createElementNS(name.namespaceURI, name.qualifiedName);
                wparent.appendChild(e);
                this.currentElement = e;
                node = this.currentElement;
                int n = el.attributeCount();
                for (int i = 0; i < n; ++i) {
                    Attribute at = el.attribute(i);
                    name = new Name(at);
                    if (name.namespaceURI == null) {
                        e.setAttribute(name.qualifiedName, at.getValue());
                        continue;
                    }
                    e.setAttributeNS(name.namespaceURI, name.qualifiedName, at.getValue());
                }
                return e;
            }
            case 5: {
                break;
            }
            case 7: {
                ProcessingInstruction p = (ProcessingInstruction)child;
                node = this.wdoc.createProcessingInstruction(p.getTarget(), p.getText());
                wparent.appendChild(node);
                break;
            }
            case 3: {
                this.textBuilder.append(child.getText());
                this.lastText = (Text)child;
                break;
            }
            case 13: {
                Namespace ns = (Namespace)child;
                Name name = new Name(ns);
                this.currentElement.setAttribute(name.qualifiedName, ns.getURI());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown node type");
            }
        }
        if (node != null) {
            this.reverseMap.put(node, child);
        }
        return null;
    }

    private static class SimplePath {
        int childNum;
        SimplePath next;

        SimplePath(int childNum, SimplePath next) {
            this.childNum = childNum;
            this.next = next;
        }
    }

    private class Name {
        String namespaceURI;
        String qualifiedName;

        Name(Node n) {
            this.qualifiedName = n.getName();
        }

        Name(org.dom4j.Element el) {
            this.qualifiedName = el.getQualifiedName();
            this.namespaceURI = Dom2Dom.this.getNamespaceURI(el.getNamespaceURI());
        }

        Name(Attribute el) {
            this.qualifiedName = el.getQualifiedName();
            this.namespaceURI = Dom2Dom.this.getNamespaceURI(el.getNamespaceURI());
        }

        Name(Namespace ns) {
            String prefix = ns.getPrefix();
            this.qualifiedName = "xmlns" + ("".equals(prefix) ? "" : ":" + prefix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocMapPair
    extends Pair<org.w3c.dom.Document, ReverseMap> {
        public DocMapPair(org.w3c.dom.Document doc, ReverseMap map) {
            super(doc, map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseMap
    extends HashMap<org.w3c.dom.Node, Node> {
        private ReverseMap() {
        }
    }
}

