/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.xpath.impl;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Node;
import org.hudsonci.xpath.XNamespaceContext;
import org.hudsonci.xpath.XPathException;
import org.hudsonci.xpath.XVariableContext;
import org.hudsonci.xpath.impl.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rewriter {
    XVariableContext varContext;
    XNamespaceContext nsContext;
    Expr first;
    Expr last;
    static boolean[] nonVar = new boolean[255];

    void addExpr(Expr e) {
        if (this.first == null) {
            this.first = this.last = e;
        } else {
            this.last.next = e;
            this.last = e;
        }
    }

    private boolean endOfVar(char c) {
        return c > '\u00ff' || nonVar[c];
    }

    private Node findDominantNode(List<Node> nodes) throws XPathException {
        Node dominant = null;
        for (Node node : nodes) {
            if (dominant == null) {
                dominant = node;
                continue;
            }
            dominant = this.findDominantNode(dominant, node);
        }
        if (dominant == null) {
            throw new XPathException("No dominant node found in expression");
        }
        return dominant;
    }

    private Node findDominantNode(Node node1, Node node2) {
        if (node1 == node2) {
            return node1;
        }
        Document doc = node1.getDocument();
        if (node1 == doc) {
            return node1;
        }
        if (node2 == doc) {
            return node2;
        }
        if (this.nodeContains(node1, node2)) {
            return node1;
        }
        if (this.nodeContains(node2, node1)) {
            return node2;
        }
        return null;
    }

    private boolean nodeContains(Node parent, Node node) {
        if (parent == node) {
            return true;
        }
        if (parent instanceof Branch) {
            Branch branch = (Branch)parent;
            List children = branch.content();
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                boolean contains = this.nodeContains((Node)children.get(i), node);
                if (!contains) continue;
                return true;
            }
        }
        return false;
    }

    public Pair<String, Node> rewriteExpression(String expr, XVariableContext varContext, XNamespaceContext nsContext) throws XPathException {
        this.varContext = varContext;
        this.nsContext = nsContext;
        String rewrittenExpression = expr;
        Node dominantNode = null;
        this.first = null;
        this.last = null;
        int start = 0;
        int n = expr.length();
        for (int i = 0; i < n; ++i) {
            char v;
            int j;
            char c = expr.charAt(i);
            if (c != '$') continue;
            if (i > start) {
                this.addExpr(new Str(expr.substring(start, i)));
            }
            for (j = start = i + 1; j < n && !this.endOfVar(v = expr.charAt(j)); ++j) {
            }
            this.addExpr(new Var(expr.substring(start, j)));
            start = j;
            i = j - 1;
        }
        if (start < expr.length()) {
            this.addExpr(new Str(expr.substring(start)));
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.first.collectNodes(nodes);
        if (nodes.size() > 0) {
            dominantNode = (Node)nodes.get(0);
            if (nodes.size() > 1) {
                dominantNode = this.findDominantNode(nodes);
            }
            this.first.replaceNodes(dominantNode);
            rewrittenExpression = this.first.toString();
        }
        if (rewrittenExpression == null) {
            throw new XPathException("Cannot rewrite expression to obtain a valid context node");
        }
        return new Pair<String, Node>(rewrittenExpression, dominantNode);
    }

    static {
        Rewriter.nonVar[13] = true;
        Rewriter.nonVar[10] = true;
        Rewriter.nonVar[9] = true;
        Rewriter.nonVar[32] = true;
        Rewriter.nonVar[93] = true;
        Rewriter.nonVar[91] = true;
        Rewriter.nonVar[41] = true;
        Rewriter.nonVar[40] = true;
        Rewriter.nonVar[124] = true;
        Rewriter.nonVar[42] = true;
        Rewriter.nonVar[45] = true;
        Rewriter.nonVar[43] = true;
        Rewriter.nonVar[60] = true;
        Rewriter.nonVar[62] = true;
        Rewriter.nonVar[33] = true;
        Rewriter.nonVar[61] = true;
        Rewriter.nonVar[63] = true;
        Rewriter.nonVar[36] = true;
        Rewriter.nonVar[47] = true;
        Rewriter.nonVar[44] = true;
        Rewriter.nonVar[46] = true;
    }

    private class Str
    extends Expr {
        String str;

        Str(String str) {
            this.str = str;
        }

        void collectString(StringBuilder sb) {
            sb.append(this.str);
            if (this.next != null) {
                this.next.collectString(sb);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Var
    extends Expr {
        String var;
        Object value;
        String replacement;

        Var(String var) {
            this.var = var;
        }

        @Override
        void collectNodes(List<Node> list) throws XPathException {
            int colon;
            String ns = "";
            String px = "";
            String ln = this.var;
            if (Rewriter.this.nsContext != null && (colon = this.var.indexOf(58)) >= 0) {
                px = this.var.substring(0, colon);
                ln = this.var.substring(colon + 1);
                ns = Rewriter.this.nsContext.getNamespaceURI(px);
            }
            try {
                this.value = Rewriter.this.varContext.getVariableValue(ns, px, ln);
                if (this.value instanceof Node) {
                    list.add((Node)this.value);
                }
                if (this.next != null) {
                    this.next.collectNodes(list);
                }
            }
            catch (Exception e) {
                throw new XPathException(e);
            }
        }

        @Override
        void collectString(StringBuilder sb) {
            sb.append(this.replacement);
            if (this.next != null) {
                this.next.collectString(sb);
            }
        }

        @Override
        void replaceNodes(Node dominant) {
            this.replacement = this.value == dominant ? "." : "$" + this.var;
            if (this.next != null) {
                this.next.replaceNodes(dominant);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Expr {
        Expr next;

        Expr() {
        }

        void collectNodes(List<Node> list) throws XPathException {
            if (this.next != null) {
                this.next.collectNodes(list);
            }
        }

        void replaceNodes(Node dominant) {
            if (this.next != null) {
                this.next.replaceNodes(dominant);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.collectString(sb);
            return sb.toString();
        }

        abstract void collectString(StringBuilder var1);
    }
}

